! f90 include file

!_______________________________________________________________________
!
   function mfSparse_mfArray( A ) result( out )

      type(mfArray) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: nnz, nrow, ncol

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( A%data_type == MF_DT_EMPTY ) then
         call PrintMessage( "mfSparse", "W",                            &
                            "arg. is empty." )
         ! another routine is intented to build a zero-size sparse
         ! matrix : cf. mfSparse_m_n
         go to 99
      end if

      if( A%data_type == MF_DT_DBLE .or. A%data_type == MF_DT_BOOL ) then

         if( A%data_type == MF_DT_DBLE ) then
            out%data_type = MF_DT_SP_DBLE
         else ! A%data_type == MF_DT_BOOL
            out%data_type = MF_DT_SP_BOOL
         end if
         out%shape = A%shape
         nrow = A%shape(1)
         ncol = A%shape(2)
         nnz = count( A%double /= 0.0d0 )
         if( nnz >= nrow*ncol/2 ) then
            call PrintMessage( "mfSparse", "I",                         &
                               "the number of non-zero elements of the matrix", &
                               "isn't small in comparison to its size. You will obtain", &
                               "few benefits in storing it in a sparse structure!" )
         end if
         allocate( out%a(nnz) )

         allocate( out%i(nnz) )

         allocate( out%j(ncol+1) )

         call dns2csc( nrow, ncol, A%double, out%a, out%i, out%j )
         out%row_sorted = TRUE

      else if( A%data_type == MF_DT_CMPLX ) then

         out%data_type = MF_DT_SP_CMPLX
         out%shape = A%shape
         nrow = A%shape(1)
         ncol = A%shape(2)
         nnz = count( A%cmplx /= (0.0d0,0.0d0) )
         if( nnz >= nrow*ncol/2 ) then
            call PrintMessage( "mfSparse", "I",                         &
                               "the number of non-zero elements of the matrix", &
                               "isn't small in comparison to its size. You will obtain", &
                               "few benefits in storing it in a sparse structure!" )
         end if
         allocate( out%z(nnz) )

         allocate( out%i(nnz) )

         allocate( out%j(ncol+1) )

         call dns2csc_cmplx( nrow, ncol, A%cmplx, out%z, out%i, out%j )
         out%row_sorted = TRUE

      else if( A%data_type == MF_DT_SP_DBLE ) then

         call PrintMessage( "mfSparse", "W",                            &
                            "arg. is already sparse." )

         out%data_type = MF_DT_SP_DBLE
         out%shape = A%shape
         ! copying data, except if A is tempo
         if( A%status_temporary .and. .not. A%status_restricted ) then
            out%a => A%a
            out%i => A%i
            out%j => A%j
            A%status_temporary = .false.
         else
            allocate( out%a( size(A%a) ) )

            out%a(:) = A%a(:)
            allocate( out%i( size(A%i) ) )

            out%i(:) = A%i(:)
            allocate( out%j( size(A%j) ) )

            ncol = A%shape(2)
            out%j(1:ncol+1) = A%j(1:ncol+1)
         end if
         out%row_sorted = A%row_sorted

      else if( A%data_type == MF_DT_SP_CMPLX ) then

         call PrintMessage( "mfSparse", "W",                            &
                            "arg. is already sparse." )

         out%data_type = MF_DT_SP_CMPLX
         out%shape = A%shape
         ! copying data, except if A is tempo
         if( A%status_temporary .and. .not. A%status_restricted ) then
            out%z => A%z
            out%i => A%i
            out%j => A%j
            A%status_temporary = .false.
         else
            allocate( out%z( size(A%z) ) )

            out%z(:) = A%z(:)
            allocate( out%i( size(A%i) ) )

            out%i(:) = A%i(:)
            allocate( out%j( size(A%j) ) )

            ncol = A%shape(2)
            out%j(1:ncol+1) = A%j(1:ncol+1)
         end if
         out%row_sorted = A%row_sorted

      else

         call PrintMessage( "mfSparse", "E",                            &
                            "unknown data type!" )
         go to 99

      end if

      out%prop = A%prop

      if( mf_phys_units ) then
         out%units(:) = a%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end function mfSparse_mfArray
