! f90 include file

!_______________________________________________________________________
!
   function mfSpOnes( A ) result( out )

      type(mfArray) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: ncol, nnz

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfSpOnes", "W",                            &
                            "arg. is empty." )
         go to 99
      end if

      if( mfIsPerm(A) ) then
         call PrintMessage( "mfSpOnes", "E",                            &
                            "arg. cannot be a permutation vector" )
         go to 99
      end if

      if( mfIsSparse(A) ) then

         out%data_type = MF_DT_SP_DBLE
         out%shape = A%shape

         ncol = A%shape(2)
         nnz = A%j(ncol+1) - 1

         if( A%data_type == MF_DT_SP_DBLE .and.                         &
             A%status_temporary .and. .not. A%status_restricted ) then
            out%i => A%i
            out%j => A%j
            out%a => A%a
            out%a(1:nnz) = 1.0d0
            A%status_temporary = .false.
         else
            allocate( out%i(nnz) )

            out%i(1:nnz) = A%i(1:nnz)
            allocate( out%j(ncol+1) )

            out%j(:) = A%j(:)
            allocate( out%a(nnz) )

            out%a(:) = 1.0d0
         end if

      else ! A is dense

         call msAssign( out, mfSparse(A) )

         if( mfIsComplex(A) ) then
            ! convert 'out' to real
            out%data_type = MF_DT_SP_DBLE
            deallocate( out%z )

            ncol = out%shape(2)
            nnz = out%j(ncol+1) - 1
            allocate( out%a(nnz) )

         end if
         out%a(:) = 1.0d0

      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function mfSpOnes
