! f90 include file

!_______________________________________________________________________
!
   function mfSpEye( m, n, kind ) result( out )

      integer, intent(in) :: m
      integer, intent(in), optional :: n
      character(len=*), intent(in), optional :: kind
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: nnz, nrow, ncol
      integer :: j
      character(len=7) :: kind0

   !------ end of declarations -- execution starts hereafter  ------

      if( present( kind ) ) then
         kind0 = to_lower(kind)
      else
         kind0 = "real"
      end if

      nrow = m
      if( present(n) ) then
         ncol = n
      else
         ncol = m
      end if
      out%shape = [ nrow, ncol ]

      nnz = min(nrow,ncol)
      if( kind0 == "real" ) then
         out%data_type = MF_DT_SP_DBLE
         allocate( out%a(nnz) )

         do j = 1, nnz
            out%a(j) = 1.0d0
         end do
      else if( kind0 == "complex" ) then
         out%data_type = MF_DT_SP_CMPLX
         allocate( out%z(nnz) )

         do j = 1, nnz
            out%z(j) = (1.0d0,0.0d0)
         end do
      else
         call PrintMessage( "mfSpEye", "E",                             &
                            "optional arg 'kind' must be equal",        &
                            "to 'real' or 'complex'!" )
         out%data_type = MF_DT_EMPTY
      end if
      allocate( out%i(nnz) )

      allocate( out%j(ncol+1) )

      ! particular case of 'dns2csc'
      out%j(1) = 1
      do j = 1, nnz
         out%i(j) = j
         out%j(j+1) = j + 1
      end do
      if( nrow < ncol ) then
         out%j(nnz+2:) = nnz + 1
      end if

      out%row_sorted = TRUE

      out%prop%tril = TRUE
      out%prop%triu = TRUE
      if( nrow == ncol ) then
         out%prop%symm = TRUE
         out%prop%posd = TRUE
      else
         out%prop%symm = FALSE
         out%prop%posd = UNKNOWN
      end if

      out%status_temporary = .true.

#endif
   end function mfSpEye
