! f90 include file

!_______________________________________________________________________
!
   subroutine msSpExport_real( A, i, j, d, format )

      type(mfArray) :: A
      integer,              intent(out)          :: i(:), j(:)
      real(kind=MF_DOUBLE), intent(out)          :: d(:)
      character(len=*),     intent(in), optional :: format
      !------ API end ------
#ifdef _DEVLP

      ! export a sparse structure to usual f90 arrays
      !
      ! supported format : COO : (i,j,val) [default]
      !                    CSC : Compact Sparse Column
      !                    CSR : Compact Sparse Row

      integer :: nnz, nrow, ncol, ii, jj, kk
      character(len=3) :: format0

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( A%data_type /= MF_DT_SP_DBLE ) then
         call PrintMessage( "msSpExport", "E",                          &
                            "mfArray should be real sparse!" )
         go to 99
      end if

      if( present(format) ) then
         format0 = to_upper(format)
      else
         format0 = "COO"
      end if

      nrow = A%shape(1)
      ncol = A%shape(2)
      nnz = A%j(ncol+1) - 1
      if( size(d) < nnz ) then
         call PrintMessage( "msSpExport", "E",                          &
                            "array 'd' has too few elements!" )
         return
      end if

      select case( format0 )

         case( "COO" )

            ! i : row index   [nnz]
            ! j : col index   [nnz]
            ! d : value       [nnz]
            if( size(i) < nnz ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'i' has too few elements!" )
               return
            end if
            if( size(j) < nnz ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'j' has too few elements!" )
               return
            end if

            kk = 0
            do jj = 1, ncol
               do ii = A%j(jj), A%j(jj+1)-1
                  kk = kk + 1
                  i(kk) = A%i(ii)
                  j(kk) = jj
                  d(kk) = A%a(ii)
               end do
            end do

         case( "CSC" ) ! Compact Sparse Column

            ! i : row index   [nnz]
            ! j : pointer     [ncol+1]       convention: j(1)=1
            ! d : value       [nnz]
            if( size(i) < nnz ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'i' has too few elements!" )
               return
            end if
            if( size(j) < ncol+1 ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'j' has too few elements!" )
               return
            end if

            i(1:nnz)    = A%i(1:nnz)
            j(1:ncol+1) = A%j(1:ncol+1)
            d(1:nnz)    = A%a(1:nnz)

         case( "CSR" ) ! Compact Sparse Row

            ! i : pointer     [nrow+1]       convention: i(1)=1
            ! j : col index   [nnz]
            ! d : value       [nnz]
            if( size(i) < nrow+1 ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'i' has too few elements!" )
               return
            end if
            if( size(j) < nnz ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'j' has too few elements!" )
               return
            end if

            call csc_transp( nrow, ncol, A%a, A%i, A%j, d, j, i )

         case default

            call PrintMessage( "msSpExport", "E",                       &
                               "unknown specified format!" )
            return

      end select

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end subroutine msSpExport_real
!_______________________________________________________________________
!
   subroutine msSpExport_cmplx( A, i, j, z, format )

      type(mfArray) :: A
      integer,                 intent(out)          :: i(:), j(:)
      complex(kind=MF_DOUBLE), intent(out)          :: z(:)
      character(len=*),        intent(in), optional :: format
      !------ API end ------
#ifdef _DEVLP

      ! export a sparse structure to usual f90 arrays
      !
      ! supported format : COO : (i,j,val) [default]
      !                    CSC : Compact Sparse Column
      !                    CSR : Compact Sparse Row

      integer :: nnz, nrow, ncol, ii, jj, kk
      character(len=3) :: format0

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( A%data_type /= MF_DT_SP_CMPLX ) then
         call PrintMessage( "msSpExport", "E",                          &
                            "mfArray should be complex sparse!" )
         go to 99
      end if

      if( present(format) ) then
         format0 = to_upper(format)
      else
         format0 = "COO"
      end if

      nrow = A%shape(1)
      ncol = A%shape(2)
      nnz = A%j(ncol+1) - 1
      if( size(z) < nnz ) then
         call PrintMessage( "msSpExport", "E",                          &
                            "array 'z' has too few elements!" )
         return
      end if

      select case( format0 )

         case( "COO" )

            ! i : row index   [nnz]
            ! j : col index   [nnz]
            ! z : value       [nnz]
            if( size(i) < nnz ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'i' has too few elements!" )
               return
            end if
            if( size(j) < nnz ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'j' has too few elements!" )
               return
            end if

            kk = 0
            do jj = 1, ncol
               do ii = A%j(jj), A%j(jj+1)-1
                  kk = kk + 1
                  i(kk) = A%i(ii)
                  j(kk) = jj
                  z(kk) = A%z(ii)
               end do
            end do

         case( "CSC" ) ! Compact Sparse Column

            ! i : row index   [nnz]
            ! j : pointer     [ncol+1]       convention: j(1)=1
            ! z : value       [nnz]
            if( size(i) < nnz ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'i' has too few elements!" )
               return
            end if
            if( size(j) < ncol+1 ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'j' has too few elements!" )
               return
            end if

            i(1:nnz)    = A%i(1:nnz)
            j(1:ncol+1) = A%j(1:ncol+1)
            z(1:nnz)    = A%z(1:nnz)

         case( "CSR" ) ! Compact Sparse Row

            ! i : pointer     [nrow+1]       convention: i(1)=1
            ! j : col index   [nnz]
            ! z : value       [nnz]
            if( size(i) < nrow+1 ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'i' has too few elements!" )
               return
            end if
            if( size(j) < nnz ) then
               call PrintMessage( "msSpExport", "E",                    &
                                  "array 'j' has too few elements!" )
               return
            end if

            call csc_transp_cmplx( nrow, ncol, A%z, A%i, A%j, z, j, i )

         case default

            call PrintMessage( "msSpExport", "E",                       &
                               "unknown specified format!" )
            return

      end select

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end subroutine msSpExport_cmplx
