! f90 include file

!_______________________________________________________________________
!
   subroutine validate_csc( nrow, ncol, irow, jptr, row_sorted )

      integer, intent(in) :: nrow, ncol, irow(:), jptr(:)
      logical, intent(in), optional :: row_sorted
      !------ API end ------
#ifdef _DEVLP

      ! this routine checks that the structure of a CSC storage,
      ! i.e. the vectors irow(:) and jptr(:) are valid.

      ! if the optional argument row_sorted is present and
      ! equal to .true., a further check is done about the sorting of
      ! the irow(:) array.

      ! However, a check for not duplicated entries is not yet done!

      ! As this routine should be called only during debugging, printing
      ! is done on STDOUT

      integer :: j, k, nnz
      logical :: valid

   !------ end of declarations -- execution starts hereafter  ------

      print "()"

      ! size of jptr(:) (pointers to columns) must be at least ncol+1
      if( size(jptr) < ncol+1 ) then
         print *, "     size(jptr) must be larger than or equal to ncol + 1"
         print *, "       found: ncol = ", ncol
         print *, "       while size(jptr) = ", size(jptr)
         print *, " *** validate_csc: check for size of jprt(:):             FAILED (see above)"
      else
         print *, " *** validate_csc: check for size of jprt(:):             OK"
      end if

      print "()"

      ! entries in jptr(:) must begin by 1 and must follow
      ! in increasing order
      if( jptr(1) /= 1 ) then
         print *, "     jptr(1) must be equal to 1"
         print *, "       found: jptr(1) = ", jptr(1)
         print *, " *** validate_csc: check for jprt(1):                     FAILED (see above)"
      else
         print *, " *** validate_csc: check for jprt(1):                     OK"
      end if

      print "()"

      valid = .true.
      do j = 2, ncol+1
         if( jptr(j) < jptr(j-1) ) then
            print *, "     at index j = ", j
            print *, "     jptr(j) is not greater than or equal to the previous value"
            print *, "     [this error is reported only once]"
            valid = .false.
            exit
         end if
      end do
      if( valid ) then
         print *, " *** validate_csc: check for increasing order in jprt(:): OK"
      else
         print *, " *** validate_csc: check for increasing order in jprt(:): FAILED (see above)"
      end if

      print "()"

      ! size of irow(:) must be at least nnz
      nnz = jptr(ncol+1) - 1
      if( size(irow) < nnz ) then
         print *, "     size(irow) must be larger than or equal to nnz"
         print *, "       found: nnz = ", nnz
         print *, "       while size(irow) = ", size(irow)
         print *, " *** validate_csc: check for size of irow(:):             FAILED (see above)"
      else
         print *, " *** validate_csc: check for size of irow(:):             OK"
      end if

      print "()"

      ! entries in irow(:) must be ranged in [1,nrow]
      valid = .true.
      do k = 1, nnz
         if( irow(k) < 1 .or. nrow < irow(k) ) then
            print *, "     at index k = ", k
            print *, "     irow(k) is ranged out of [1,nrow]"
            print *, "     [this error is reported only once]"
            valid = .false.
            exit
         end if
      end do
      if( valid ) then
         print *, " *** validate_csc: check for values in irow(:):           OK"
      else
         print *, " *** validate_csc: check for values in irow(:):           FAILED (see above)"
      end if

      print "()"

      ! if required, the last check concerns the row sorting
      if( present(row_sorted) ) then
         if( row_sorted ) then
         valid = .true.
loop_over_col: do j = 1, ncol
               do k = jptr(j)+1, jptr(j+1)-1
                  if( irow(k) < irow(k-1) ) then
                     print *, "     at column j = ", j
                     print *, "     at index k = ", k
                     print *, "       irow(k) is not greater than the previous value"
                     print *, "     [this error is reported only once]"
                     valid = .false.
                     exit loop_over_col
                  end if
               end do
            end do loop_over_col
            if( valid ) then
               print *, " *** validate_csc: check if cols are row sorted:          OK"
            else
               print *, " *** validate_csc: check if cols are row sorted:          FAILED (see above)"
            end if
         end if
      end if

#endif
   end subroutine validate_csc

