! f90 include file

! This declaration is stored apart, because it is included by two
! different files :
!   mod_polyfun.F90
!   mod_fileio.F90

!_______________________________________________________________________
!
   type :: mfTriConnect ! Triangular Connectivity
#ifndef _DEVLP
      private
#endif
      logical :: init = .false.
      ! 'tri_renumbering' becomes TRUE when triangles are renumbered
      ! to be contiguous
      logical :: tri_renumbering = .false.
      ! 'face_oriented' becomes TRUE when faces make a loop inside
      ! each triangle
      logical :: face_oriented = .false.
      ! Domain convexity: a priori not known (-1); determined on demand
      ! for searching in the triangles set. (1: convex; 0: non-convex)
      integer :: convex_domain = -1
      ! nn: nb of nodes
      ! n_xy(nn,2): nodes by 2D-coordinates
      real(kind=MF_DOUBLE), pointer :: n_xy(:,:) => null()
      ! nt: nb of triangles
      ! tri_n(nt,3): triangles by nodes -- direct orientation
      integer, pointer :: tri_n(:,:) => null()
      ! nf: nb of faces
      ! face_n(nf,2): faces by nodes
      integer, pointer :: face_n(:,:) => null()
      ! face_tri(nf,2): face common to 2 triangles
      ! For a face belonging to the boundary, the 2nd value <= 0,
      ! which means that the second triangle doesn't exist. When the
      ! connectivity is build, this value is 0. When required, the domain
      ! convexity is determined and some values are set to -1, which
      ! means concavity (either on the exterior boundary or on a internal
      ! hole). If the domain have holes, the negative value decreases by
      ! 1 for each different hole (1st hole: -2, 2nd hole: -3, etc.).
      integer, pointer :: face_tri(:,:) => null()
      ! tri_f(nt,3): triangles by faces -- direct orientation
      integer, pointer :: tri_f(:,:) => null()
      ! n_tri(nn): one triangle which contains a given node
      integer, pointer :: n_tri(:) => null()
      ! Lists of boundary faces. These arrays are allocated only if
      ! convex_domain /= -1. They are  initialized in 'check_tri_convexity'
      ! and used by 'tsearch' (in tri.inc), and by 'mfNodeSearch_double'
      ! and 'mfTriSearch_double' (in mod_polyfun.F90).
      ! - 'faces_boundary' contains all the faces' indices, grouped by
      !   independant boundaries (first the exterior boundary, then the
      !   holes); the ordering of the holes follows the smallest node
      !   value of each internal boundary.
      ! faces_boundary(nb_fb)
      integer, pointer :: faces_boundary(:) => null()
      ! - 'faces_boundary_ptr' contains the indices to delimitate the
      !   different holes in the previous array, the first index is the
      !   beginning of each hole, the second one is its end.
      ! faces_boundary(nb_boundaries,2)
      integer, pointer :: faces_boundary_ptr(:,:) => null()

      logical :: status_temporary = .false.

   end type mfTriConnect
