! f90 include file

!_______________________________________________________________________
!
   function mfPoly( v ) result( out )

      type(mfArray) :: v
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! Builds a polynomial from its roots.
      !
      ! Arg 'v' must be a vector, real or complex

      ! After Matlab.

      integer :: idim, n, j, status

      character(len=*), parameter :: ROUTINE_NAME = "mfPoly"

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( v )

      if( mfIsEmpty(v) ) then
         go to 99
      end if

      ! 'v' cannot be sparse
      if( mfIsSparse(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "first arg. cannot be sparse!" )
         go to 99
      end if

      ! 'v' must be numeric
      if( .not. mfIsNumeric(v) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "first arg. must be numeric!" )
         go to 99
      end if

      ! 'v' must be a vector
      if( v%shape(1) == 1 ) then
         idim = 2
      else if( v%shape(2) == 1 ) then
         idim = 1
      else
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "first arg. must be a vector mfArray!" )
         go to 99
      end if

      n = size(v)
      if( idim == 1 ) then
         if( v%data_type == MF_DT_DBLE ) then
            call msAssign( out, mfZeros(n+1,1) )
            out%double(1,1) = 1.0d0
            do j = 1, n
               out%double(2:j+1,1) = out%double(2:j+1,1) -              &
                                     v%double(j,1)*out%double(1:j,1)
            end do
         else if( v%data_type == MF_DT_CMPLX ) then
            call msAssign( out, mfZeros(n+1,1)*MF_I )
            out%cmplx(1,1) = (1.0d0,0.0d0)
            do j = 1, n
               out%cmplx(2:j+1,1) = out%cmplx(2:j+1,1) -                &
                                    v%cmplx(j,1)*out%cmplx(1:j,1)
            end do
            ! are the roots complex conjugates ?
            if( all(mfAbs(mfSort(mfGet(v,mfImag(v)>0.0d0)) -            &
                          mfSort(mfConj(mfGet(v,mfImag(v)<0.0d0)))) <   &
                10.0d0*MF_EPS) ) then
               call msAssign( out, mfReal(out) )
            end if
         end if
      else ! idim = 2
         if( v%data_type == MF_DT_DBLE ) then
            call msAssign( out, mfZeros(1,n+1) )
            out%double(1,1) = 1.0d0
            do j = 1, n
               out%double(1,2:j+1) = out%double(1,2:j+1) -              &
                                     v%double(1,j)*out%double(1,1:j)
            end do
         else if( v%data_type == MF_DT_CMPLX ) then
            call msAssign( out, mfZeros(1,n+1)*MF_I )
            out%cmplx(1,1) = (1.0d0,0.0d0)
            do j = 1, n
               out%cmplx(1,2:j+1) = out%cmplx(1,2:j+1) -                &
                                    v%cmplx(1,j)*out%cmplx(1,1:j)
            end do
            ! are the roots complex conjugates ?
            if( all(mfAbs(mfSort(mfGet(v,mfImag(v)>0.0d0)) -            &
                          mfSort(mfConj(mfGet(v,mfImag(v)<0.0d0)))) <   &
                10.0d0*MF_EPS) ) then
               call msAssign( out, mfReal(out) )
            end if
         end if
      end if


      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( v%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( v )

      call msAutoRelease( v )

#endif
   end function mfPoly
