! f90 include file

!_______________________________________________________________________
!
   function mfPPVal_real( x, y, p, xi, extrapol ) result( yi )

      type(mfArray)                              :: x, y, p, xi
      real(kind=MF_DOUBLE), intent(in), optional :: extrapol
      type(mfArray)                              :: yi
      !------ API end ------
#ifdef _DEVLP

      ! Natural cubic spline interpolation. Returns the function value.

      ! (15/06/2012) 'x', 'y', 'p' and 'xi' may now be tempo mfArrays

      real(kind=MF_DOUBLE), pointer :: x_ptr_vec(:), y_ptr_vec(:)
      real(kind=MF_DOUBLE), pointer :: p_ptr_vec(:),                   &
                                       xi_ptr_vec(:), yi_ptr_vec(:)
      integer :: nn, i, status

      integer :: xdim

      character(len=*), parameter :: ROUTINE_NAME = "mfPPVal"

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( x, y, p, xi )

      if( mfIsEmpty(x) .or. mfIsEmpty(y) .or.                           &
          mfIsEmpty(p) .or. mfIsEmpty(xi) ) then
         go to 99
      end if

      if( x%data_type /= MF_DT_DBLE .or. y%data_type /= MF_DT_DBLE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "real arrays required!" )
         go to 99
      end if

      if( p%data_type /= MF_DT_DBLE .or. xi%data_type /= MF_DT_DBLE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "real arrays required!" )
         go to 99
      end if

      if( x%shape(1) == 1 ) then
         xdim = 2
      else if( x%shape(2) == 1 ) then
         xdim = 1
      else
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'x' must be a vector!" )
         go to 99
      end if

      if( x%shape(1) /= y%shape(1) .or. x%shape(2) /= y%shape(2) .or.   &
          x%shape(1) /= p%shape(1) .or. x%shape(2) /= p%shape(2) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x', 'y' and 'p' must have the same shape!" )
         go to 99
      end if

      if( xdim == 1 ) then
         x_ptr_vec => x%double(:,1)
      else ! xdim = 2
         x_ptr_vec => x%double(1,:)
      end if
      if( xdim == 1 ) then
         y_ptr_vec => y%double(:,1)
      else ! ydim = 2
         y_ptr_vec => y%double(1,:)
      end if
      if( xdim == 1 ) then
         p_ptr_vec => p%double(:,1)
      else ! ydim = 2
         p_ptr_vec => p%double(1,:)
      end if

      nn = size( xi%double )
      xi_ptr_vec => rank_2_to_1_real8( xi%double, nn )

      yi%data_type = MF_DT_DBLE
      yi%shape = xi%shape
      allocate( yi%double(yi%shape(1),yi%shape(2)) )

      call msPointer( yi, yi_ptr_vec, no_crc=.true. )

      do i = 1, nn
         call int_spl( x_ptr_vec, y_ptr_vec, p_ptr_vec, any_t = .true., &
                       t = xi_ptr_vec(i), y_0 = yi_ptr_vec(i) )
      end do

      call msFreePointer( yi, yi_ptr_vec )

      if( mf_phys_units ) then
         ! 'yi' is the vector of interpolated values from 'y'
         yi%units(:) = y%units(:)
      end if

      yi%status_temporary = .true.

 99   continue

      call msFreeArgs( x, y, p, xi )
      call msAutoRelease( x, y, p, xi )

#endif
   end function mfPPVal_real
!_______________________________________________________________________
!
   function mfPPVal_bool( x, y, p, xi, extrapol ) result( yi )

      type(mfArray)             :: x, y, p, xi
      logical,       intent(in) :: extrapol
      type(mfArray)             :: yi
      !------ API end ------
#ifdef _DEVLP

      ! Natural cubic spline interpolation. Returns the function value.

      ! (15/06/2012) 'x', 'y', 'p' and 'xi' may now be tempo mfArrays

      real(kind=MF_DOUBLE), pointer :: x_ptr_vec(:), y_ptr_vec(:)
      real(kind=MF_DOUBLE), pointer :: p_ptr_vec(:),                   &
                                       xi_ptr_vec(:), yi_ptr_vec(:)
      integer :: nn, i, status

      integer :: xdim

      character(len=*), parameter :: ROUTINE_NAME = "mfPPVal"

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( x, y, p, xi )

      if( mfIsEmpty(x) .or. mfIsEmpty(y) .or.                           &
          mfIsEmpty(p) .or. mfIsEmpty(xi) ) then
         go to 99
      end if

      if( x%data_type /= MF_DT_DBLE .or. y%data_type /= MF_DT_DBLE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "real arrays required!" )
         go to 99
      end if

      if( p%data_type /= MF_DT_DBLE .or. xi%data_type /= MF_DT_DBLE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "real arrays required!" )
         go to 99
      end if

      if( x%shape(1) == 1 ) then
         xdim = 2
      else if( x%shape(2) == 1 ) then
         xdim = 1
      else
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'x' must be a vector!" )
         go to 99
      end if

      if( x%shape(1) /= y%shape(1) .or. x%shape(2) /= y%shape(2) .or.   &
          x%shape(1) /= p%shape(1) .or. x%shape(2) /= p%shape(2) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x', 'y' and 'p' must have the same shape!" )
         go to 99
      end if

      if( xdim == 1 ) then
         x_ptr_vec => x%double(:,1)
      else ! xdim = 2
         x_ptr_vec => x%double(1,:)
      end if
      if( xdim == 1 ) then
         y_ptr_vec => y%double(:,1)
      else ! ydim = 2
         y_ptr_vec => y%double(1,:)
      end if
      if( xdim == 1 ) then
         p_ptr_vec => p%double(:,1)
      else ! ydim = 2
         p_ptr_vec => p%double(1,:)
      end if

      nn = size( xi%double )
      xi_ptr_vec => rank_2_to_1_real8( xi%double, nn )

      yi%data_type = MF_DT_DBLE
      yi%shape = xi%shape
      allocate( yi%double(yi%shape(1),yi%shape(2)) )

      call msPointer( yi, yi_ptr_vec, no_crc=.true. )

      if( extrapol ) then
         do i = 1, nn
            call int_spl( x_ptr_vec, y_ptr_vec, p_ptr_vec, any_t = .true., &
                          t = xi_ptr_vec(i), y_0 = yi_ptr_vec(i) )
         end do
      else
         do i = 1, nn
            call int_spl( x_ptr_vec, y_ptr_vec, p_ptr_vec, any_t = .false., &
                          t = xi_ptr_vec(i), y_0 = yi_ptr_vec(i),       &
                          out_of_range=MF_NAN )
         end do
      end if

      call msFreePointer( yi, yi_ptr_vec )

      if( mf_phys_units ) then
         ! 'yi' is the vector of interpolated values from 'y'
         yi%units(:) = y%units(:)
      end if

      yi%status_temporary = .true.

 99   continue

      call msFreeArgs( x, y, p, xi )
      call msAutoRelease( x, y, p, xi )

#endif
   end function mfPPVal_bool
