! f90 include file

!_______________________________________________________________________
!
   function mfDelaunay3D_vec( x_in, y_in, z_in ) result( tetra )

      type(mfArray) :: x_in, y_in, z_in
      type(mfArray) :: tetra
      !------ API end ------

#ifdef _DEVLP
      real(kind=MF_DOUBLE), pointer :: x_ptr_vec(:), y_ptr_vec(:), z_ptr_vec(:)
      integer, allocatable :: tetra_n(:,:)
      integer :: status

      integer :: nb_pts, nb_tetra, i

      character(len=*), parameter :: ROUTINE_NAME = "mfDelaunay3D"

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( x_in, y_in, z_in )

      if( mfIsEmpty(x_in) .or. mfIsEmpty(y_in) .or. mfIsEmpty(z_in) ) then
         go to 99
      end if

      if( x_in%data_type /= MF_DT_DBLE .or. y_in%data_type /= MF_DT_DBLE &
                                       .or. z_in%data_type /= MF_DT_DBLE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "real arrays required!" )
         go to 99
      end if

      if( x_in%shape(1) /= 1 .and. x_in%shape(2) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'x_in' must be a vector!" )
         go to 99
      end if

      if( y_in%shape(1) /= 1 .and. y_in%shape(2) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'y_in' must be a vector!" )
         go to 99
      end if

      if( z_in%shape(1) /= 1 .and. z_in%shape(2) /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'z_in' must be a vector!" )
         go to 99
      end if

      if( x_in%shape(1) /= y_in%shape(1) .or.                           &
          x_in%shape(2) /= y_in%shape(2) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'x_in' and 'y_in' must have the same shape!" )
         go to 99
      end if

      if( x_in%shape(1) /= z_in%shape(1) .or.                           &
          x_in%shape(2) /= z_in%shape(2) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'x_in' and 'z_in' must have the same shape!" )
         go to 99
      end if

      if( x_in%status_temporary ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'x_in' cannot be tempo!" )
      end if

      if( y_in%status_temporary ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'y_in' cannot be tempo!" )
      end if

      if( z_in%status_temporary ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'z_in' cannot be tempo!" )
      end if

      call msPointer( x_in, x_ptr_vec, no_crc=.true. )
      call msPointer( y_in, y_ptr_vec, no_crc=.true. )
      call msPointer( z_in, z_ptr_vec, no_crc=.true. )

      nb_pts = size(x_ptr_vec)

      if( nb_pts < 4 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'x_in', 'y_in' and 'z_in' must have at least 4 values!" )
         go to 99
      end if

      call delaunay_3d_init( nb_pts,                                    &
                             x_ptr_vec(1), y_ptr_vec(1), z_ptr_vec(1),  &
                             delaunay3d_addr, nb_tetra )

      allocate( tetra_n(nb_tetra,4) )

      call delaunay_3d_get_tetra( delaunay3d_addr, tetra_n )

      tetra%data_type = MF_DT_DBLE
      tetra%shape = [ nb_tetra, 4 ]
      allocate( tetra%double(nb_tetra,4) )

      ! check that all tetrahedra have a direct orientation...
      call fix_tetra_orientation( nb_pts, x_ptr_vec, y_ptr_vec, z_ptr_vec, &
                                  nb_tetra, tetra_n )

      tetra%double(:,:) = tetra_n(:,:)
      deallocate( tetra_n )

      call msFreePointer( x_in, x_ptr_vec )
      call msFreePointer( y_in, y_ptr_vec )
      call msFreePointer( z_in, z_ptr_vec )

      if( mf_phys_units ) then
         ! 'x_in', 'y_in' and 'z_in' must have the same physical units
         ! verifying the physical dimension
         call verif_adim( x_in%units, y_in%units, status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "the physical dimensions of 'x_in' and 'y_in'",&
                               "are not consistent!" )
            go to 99
         end if
         call verif_adim( x_in%units, z_in%units, status )
         if( status /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "the physical dimensions of 'x_in' and 'z_in'",&
                               "are not consistent!" )
            go to 99
         end if
      end if

      tetra%status_temporary = .true.

 99   continue

      call msFreeArgs( x_in, y_in, z_in )
      call msAutoRelease( x_in, y_in, z_in )

#endif
   end function mfDelaunay3D_vec
!_______________________________________________________________________
!
   function mfDelaunay3D_mat( coords ) result( tetra )

      type(mfArray) :: coords
      type(mfArray) :: tetra
      !------ API end ------

#ifdef _DEVLP
      real(kind=MF_DOUBLE), pointer :: x_ptr_vec(:), y_ptr_vec(:), z_ptr_vec(:)
      integer, allocatable :: tetra_n(:,:)
      integer :: status

      integer :: nb_pts, nb_tetra, i

      character(len=*), parameter :: ROUTINE_NAME = "mfDelaunay3D"

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( coords )

      if( mfIsEmpty(coords) ) then
         go to 99
      end if

      if( coords%data_type /= MF_DT_DBLE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "real 'coords' required!" )
         go to 99
      end if

      nb_pts = coords%shape(1)

      if( nb_pts < 4 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'coords' must have at least 4 rows!" )
         go to 99
      end if

      if( coords%shape(2) /= 3 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'coords' must have 3 columns!" )
         go to 99
      end if

      if( coords%status_temporary ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "mfArray 'coords' cannot be tempo!" )
      end if

      x_ptr_vec => rank_2_to_1_real8( coords%double(:,1), nb_pts )
      y_ptr_vec => rank_2_to_1_real8( coords%double(:,2), nb_pts )
      z_ptr_vec => rank_2_to_1_real8( coords%double(:,3), nb_pts )

      call delaunay_3d_init( nb_pts,                                    &
                             x_ptr_vec(1), y_ptr_vec(1), z_ptr_vec(1),  &
                             delaunay3d_addr, nb_tetra )

      allocate( tetra_n(nb_tetra,4) )
      call delaunay_3d_get_tetra( delaunay3d_addr, tetra_n )

      tetra%data_type = MF_DT_DBLE
      tetra%shape = [ nb_tetra, 4 ]
      allocate( tetra%double(nb_tetra,4) )

      ! check that all tetrahedra have a direct orientation...
      call fix_tetra_orientation( nb_pts, x_ptr_vec, y_ptr_vec, z_ptr_vec, &
                                  nb_tetra, tetra_n )

      tetra%double(:,:) = tetra_n(:,:)
      deallocate( tetra_n )

      tetra%status_temporary = .true.

 99   continue

      call msFreeArgs( coords )
      call msAutoRelease( coords )

#endif
   end function mfDelaunay3D_mat
!_______________________________________________________________________
!
   subroutine msDelaunay3D_PLC3D( out, PL_domain_3D,                    &
                                  quality, vol_max )

      type(mfPLdomain3D), target, intent(in) :: PL_domain_3D
      real(kind=MF_DOUBLE), optional :: quality, vol_max
      type(mf_Out)                   :: out
      !------ API end ------
#ifdef _DEVLP

      integer, allocatable :: tetra_n(:,:)
      integer :: status
      character(len=20) :: quality_str, vol_max_str
      character(len=80) :: options

      integer :: nb_pts, nb_pts_new, nb_seg, nb_faces, nb_tetra,        &
                 i, j, k, nb_tot_nodes, n1, n2, n_last, n_seg, n_strt

      integer, allocatable :: ptr_beg(:), ptr_end(:), cont_list_nod(:)
      integer, pointer :: lst(:), edg(:,:)
      character(len=3) :: i_str ! no more 999 contours!

      type(mfArray), pointer :: x, y, z, tetra

      character(len=*), parameter :: ROUTINE_NAME = "msDelaunay3D"

   !------ end of declarations -- execution starts hereafter  ------

      ! Checks data presence in the PL_domain structure
      if( allocated(PL_domain_3D%n_xyz) ) then
         if( size(PL_domain_3D%n_xyz,2) /= 3 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad 2nd dimension of PL_domain_3D n_xyz array!" )
            go to 99
         end if
         nb_pts = size(PL_domain_3D%n_xyz,1)
         if( nb_pts < 4 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "too few nodes in PL_domain_3D!",        &
                               "(you must have at least 4 nodes)" )
            go to 99
         end if
      else
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "PL_domain_3D seems empty or corrupted! (no nodes)" )
         go to 99
      end if
      if( allocated(PL_domain_3D%edge_n) ) then
         if( size(PL_domain_3D%edge_n,2) /= 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "bad 2nd dimension of PL_domain_3D edge_n array!" )
            go to 99
         end if
         nb_seg = size(PL_domain_3D%edge_n,1)
         if( nb_seg < 6 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "too few edges in PL_domain_3D!",        &
                               "(you must have at least 6 edges)" )
            go to 99
         end if
      else
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "PL_domain_3D seems empty or corrupted! (no edges)" )
         go to 99
      end if
      if( .not. allocated(PL_domain_3D%face_e) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "PL_domain_3D%face_e is not allocated." )
         return
      else
         nb_faces = size(PL_domain_3D%face_e)
         if( nb_faces < 4 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Insufficient number of lines in PL_domain_3D%face_e.", &
                               "(the minimum 3D PL domain is a tetrahedron)" )
            return
         end if
      end if
      if( allocated(PL_domain_3D%holes_xyz) ) then
         if( size(PL_domain_3D%holes_xyz,1) > 1 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "holes in PL_domain_3D are NOT treated currently!",        &
                               "(they will be ignored)" )
         end if
      end if

      ! 4 out-args must be specified
      if( out%n /= 4 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "four output args required!",               &
                            "syntax is : call msDelaunay3D ( mfOut(x,y,z,tetra), PL_domain_3D, ... )" )
         go to 99
      end if

      x => out%ptr1
      y => out%ptr2
      z => out%ptr3
      tetra => out%ptr4
      call msSilentRelease( x, y, z, tetra )

      options = "Qn" ! Q: Quiet mode for Tetgen
                     ! n: Outputs tetrahedra neighbors

      if( present(quality) ) then
         ! 'quality' is actually the ratio R/l_min, always > 1
         !   1.1 to 1.3 : excellent quality (no degenerate tetrahedra)
         !   1.5 to 2.0 : good
         !   2.0 to 3.0 : just acceptable
         ! Below, we contraint the range of 'quality'
         if( quality <= 1.0d0 .or. 3.0d0 < quality  ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'quality' should be ranged in (1.0, 3.0]" )
            go to 99
         end if
         write(quality_str,"(F4.2)") quality
         call check_and_remove_trailing_zero( quality_str )
         options = trim(options) // "q" // trim(adjustl(quality_str))
      else
         if( .not. present(vol_max) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "among the two optional args 'quality' and 'vol_max'", &
                              "at least one is required." )
            go to 99
         end if
         options = trim(options) // "q"
      end if

      if( present(vol_max) ) then
         if( vol_max <= 0.0d0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'vol_max' must be strictly positive." )
            go to 99
         end if
         write(vol_max_str,"(ES10.3)") vol_max
         vol_max_str = clean_exp_format( vol_max_str )
         options = trim(options) // "a" // trim(adjustl(vol_max_str))
      end if
!!print *, 'Tetgen options (fixed): "' // trim(options) // '"'

      ! Builds the one-dimensional arrays for the Fortran->C++ wrapper
      ! First count the total number of nodes involved
      allocate( ptr_beg(nb_faces), ptr_end(nb_faces) )
      ptr_beg(1) = 1
      nb_tot_nodes = 0
      do i = 1, nb_faces ! loop over the faces
         lst => PL_domain_3D%face_e(i)%list
         ! in a closed contour, nb of nodes = nb of segments
         ptr_end(i) = ptr_beg(i) + (size(lst)-1)
         if( i < nb_faces ) then
            ptr_beg(i+1) = ptr_end(i) + 1
         end if
         nb_tot_nodes = nb_tot_nodes + size(lst)
      end do
      allocate( cont_list_nod(nb_tot_nodes) )

      edg => PL_domain_3D%edge_n
      k = 0
      do i = 1, nb_faces ! loop over the faces
         lst => PL_domain_3D%face_e(i)%list
         n_seg = size(lst)
         ! Let's suppose that the first edge doesn't need to be swapped...
         n_strt = edg( lst(1), 1 )
         n_last = edg( lst(1), 2 )
         n1 = edg( lst(2), 1 ) ; n2 = edg( lst(2), 2 )
         if( n_last /= n1 .and. n_last /= n2 ) then
            ! First edge must be swapped
            n_strt = edg( lst(1), 2 )
            n_last = edg( lst(1), 1 )
         endif
         k = k+1 ; cont_list_nod(k) = n_strt
         do j = 2, n_seg ! loop over the remaining edges
            k = k+1 ; cont_list_nod(k) = n_last
            n1 = edg( lst(j), 1 ) ; n2 = edg( lst(j), 2 )
            if( n_last == n1 ) then
               n_last = n2
            else if( n_last == n2 ) then
               n_last = n1
            else
               write( i_str, "(I0)" ) i
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "while processing the faces of PL_domain_3D:", &
                                  "-> face #" // trim(i_str) // " is not valid!" )
               go to 99
            end if
         end do
         if( n_last /= n_strt ) then
            write( i_str, "(I0)" ) i
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "while processing the faces of PL_domain_3D:", &
                               "-> face #" // trim(i_str) // " is not valid!" )
            go to 99
         end if
      end do

      call delaunay_3d_PLC( nb_pts, PL_domain_3D%n_xyz(:,1),            &
                      PL_domain_3D%n_xyz(:,2), PL_domain_3D%n_xyz(:,3), &
                      nb_faces, ptr_beg, ptr_end, cont_list_nod,        &
                      delaunay3d_addr, trim(options)//char(0),          &
                      nb_pts_new, nb_tetra )

      x%data_type = MF_DT_DBLE
      x%shape = [ nb_pts_new, 1 ]
      allocate( x%double(nb_pts_new,1) )
      y%data_type = MF_DT_DBLE
      y%shape = [ nb_pts_new, 1 ]
      allocate( y%double(nb_pts_new,1) )
      z%data_type = MF_DT_DBLE
      z%shape = [ nb_pts_new, 1 ]
      allocate( z%double(nb_pts_new,1) )
      call delaunay_3d_get_pts_coords( delaunay3d_addr,                 &
                         x%double(:,1), y%double(:,1), z%double(:,1) )

      allocate( tetra_n(nb_tetra,4) )
      call delaunay_3d_get_tetra( delaunay3d_addr, tetra_n )

      tetra%data_type = MF_DT_DBLE
      tetra%shape = [ nb_tetra, 4 ]
      allocate( tetra%double(nb_tetra,4) )

      ! check that all tetrahedra have a direct orientation...
      call fix_tetra_orientation( nb_pts_new,                           &
                           x%double(:,1), y%double(:,1), z%double(:,1), &
                                  nb_tetra, tetra_n )

      tetra%double(:,:) = tetra_n(:,:)
      deallocate( tetra_n )

 99   continue

#endif
   end subroutine msDelaunay3D_PLC3D
!_______________________________________________________________________
!
   subroutine msEndDelaunay3D( )

#ifdef _DEVLP
      call delaunay_3d_free( delaunay3d_addr )
      delaunay3d_addr = 0

#endif
   end subroutine msEndDelaunay3D
