! f90 include file

!_______________________________________________________________________
!
   subroutine find_unit_name_from_units( units, name )

      type(rational) :: units(num_base_units)
      character(len=*) :: name
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      if( units == u_kilogram%units ) then
         name = u_kilogram%abbrev

      else if( units == u_meter%units ) then
         name = u_meter%abbrev

      else if( units == u_second%units ) then
         name = u_second%abbrev

      else if( units == u_Kelvin%units ) then
         name = u_Kelvin%abbrev

      else if( units == u_Ampere%units ) then
         name = u_Ampere%abbrev

      else if( units == u_mole%units ) then
         name = u_mole%abbrev

      else if( units == u_candela%units ) then
         name = u_candela%abbrev

      !--------------

      else if( units == u_Hertz%units ) then
         name = u_Hertz%abbrev

      else if( units == u_Newton%units ) then
         name = u_Newton%abbrev

      else if( units == u_Pascal%units ) then
         name = u_Pascal%abbrev

      else if( units == u_Joule%units ) then
         name = u_Joule%abbrev

      else if( units == u_Watt%units ) then
         name = u_Watt%abbrev

      else if( units == u_Coulomb%units ) then
         name = u_Coulomb%abbrev

      else if( units == u_Volt%units ) then
         name = u_Volt%abbrev

      else if( units == u_Ohm%units ) then
         name = u_Ohm%abbrev

      else if( units == u_Poiseuille%units ) then
         name = u_Poiseuille%abbrev

      !--------------

      else if( units == [ RAT_0, RAT_2, RAT_0, RAT_0, RAT_0, RAT_0, RAT_0 ] ) then
         name = "m^2"

      else if( units == [ RAT_0, RAT_3, RAT_0, RAT_0, RAT_0, RAT_0, RAT_0 ] ) then
         name = "m^3"

      else if( units == [ RAT_0, RAT_1, RAT_M1, RAT_0, RAT_0, RAT_0, RAT_0 ] ) then
         name = "m/s"

      else if( units == [ RAT_0, RAT_1, RAT_M2, RAT_0, RAT_0, RAT_0, RAT_0 ] ) then
         name = "m/s^2"

      else if( units == [ RAT_0, RAT_2, RAT_M1, RAT_0, RAT_0, RAT_0, RAT_0 ] ) then
         name = "m^2/s"

      !--------------

      else
         name = "S.I."

      end if

      name = "(" // trim(name) // ")"

#endif
   end subroutine find_unit_name_from_units
