! f90 include file

!_______________________________________________________________________
!
   function vc_vec_real8_vec_real8( v1, v2 ) result( out )

      real(kind=MF_DOUBLE), intent(in) :: v1(:), v2(:)
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: n1, n2

   !------ end of declarations -- execution starts hereafter  ------

      if( size(v2) /= size(v1) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "horiz. dim. must agree!" )
         return
      end if

      out%data_type = MF_DT_DBLE
      n1 = 2
      n2 = size(v1)
      out%shape = [ n1, n2 ]
      allocate( out%double(n1,n2) )

      out%double(1,:) = v1(:)
      out%double(2,:) = v2(:)

      out%status_temporary = .true.

#endif
   end function vc_vec_real8_vec_real8
!_______________________________________________________________________
!
   function vc_mfArray_vec_real8( a, v2 ) result( out )

      type(mfArray),        intent(in) :: a
      real(kind=MF_DOUBLE), intent(in) :: v2(:)
      type(mfArray) ::  out
      !------ API end ------
#ifdef _DEVLP

      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( a )

      if( a%data_type == MF_DT_EMPTY ) then
         out = v2
         out%status_temporary = .true.
         go to 99
      end if

      if( mfIsSparse(a) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "cannot handled yet sparse matrices!" )
         go to 99
      end if

      if( mfIsPerm(a) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( size(v2) /= a%shape(2) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "horiz. dim. must agree!" )
         go to 99
      end if

      out%data_type = a%data_type
      n1 = a%shape(1)+1
      n2 = a%shape(2)
      out%shape = [ n1, n2 ]
      if( a%data_type == MF_DT_DBLE ) then
         allocate( out%double(n1,n2) )

         out%double(1:a%shape(1),:) = a%double
         out%double(a%shape(1)+1,:) = v2(:)
      else if( a%data_type == MF_DT_CMPLX ) then
         allocate( out%cmplx(n1,n2) )

         out%cmplx(1:a%shape(1),:) = a%cmplx
         out%cmplx(a%shape(1)+1,:) = v2(:)
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(.vc.)", "E",                   &
                               "the physical dimensions of the two mfArray's",&
                               "are not consistent!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a )

      call msAutoRelease(a)

#endif
   end function vc_mfArray_vec_real8
!_______________________________________________________________________
!
   function vc_vec_real8_mfArray( v1, a ) result( out )

      real(kind=MF_DOUBLE), intent(in) :: v1(:)
      type(mfArray),    intent(in) :: a
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( a )

      if( a%data_type == MF_DT_EMPTY ) then
         out = v1
         out%status_temporary = .true.
         go to 99
      end if

      if( mfIsSparse(a) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "cannot handled yet sparse matrices!" )
         go to 99
      end if

      if( mfIsPerm(a) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( size(v1) /= a%shape(2) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "horiz. dim. must agree!" )
         go to 99
      end if

      out%data_type = a%data_type
      n1 = 1+a%shape(1)
      n2 = a%shape(2)
      out%shape = [ n1, n2 ]
      if( a%data_type == MF_DT_DBLE ) then
         allocate( out%double(n1,n2) )

         out%double(1,:) = v1(:)
         out%double(2:1+a%shape(1),:) = a%double
      else if( a%data_type == MF_DT_CMPLX ) then
         allocate( out%cmplx(n1,n2) )

         out%cmplx(1,:) = v1(:)
         out%cmplx(2:1+a%shape(1),:) = a%cmplx
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(.vc.)", "E",                   &
                               "the physical dimensions of the two mfArray's",&
                               "are not consistent!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a )

      call msAutoRelease(a)

#endif
   end function vc_vec_real8_mfArray
!_______________________________________________________________________
!
   function vc_vec_cmplx8_vec_cmplx8( v1, v2 ) result( out )

      complex(kind=MF_DOUBLE), intent(in) :: v1(:), v2(:)
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: n1, n2

   !------ end of declarations -- execution starts hereafter  ------

      if( size(v2) /= size(v1) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "horiz. dim. must agree!" )
         return
      end if

      out%data_type = MF_DT_CMPLX
      n1 = 2
      n2 = size(v1)
      out%shape = [ n1, n2 ]
      allocate( out%cmplx(n1,n2) )

      out%cmplx(1,:) = v1(:)
      out%cmplx(2,:) = v2(:)

      out%status_temporary = .true.

#endif
   end function vc_vec_cmplx8_vec_cmplx8
!_______________________________________________________________________
!
   function vc_mfArray_vec_cmplx8( a, v2 ) result( out )

      type(mfArray),    intent(in) :: a
      complex(kind=MF_DOUBLE), intent(in) :: v2(:)
      type(mfArray) ::  out
      !------ API end ------
#ifdef _DEVLP

      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( a )

      if( a%data_type == MF_DT_EMPTY ) then
         out = v2
         out%status_temporary = .true.
         go to 99
      end if

      if( mfIsSparse(a) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "cannot handled yet sparse matrices!" )
         go to 99
      end if

      if( mfIsPerm(a) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( size(v2) /= a%shape(2) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "horiz. dim. must agree!" )
         go to 99
      end if

      out%data_type = MF_DT_CMPLX
      n1 = a%shape(1)+1
      n2 = a%shape(2)
      out%shape = [ n1, n2 ]
      allocate( out%cmplx(n1,n2) )

      if( a%data_type == MF_DT_DBLE ) then
         out%cmplx(1:a%shape(1),:) = a%double
      else if( a%data_type == MF_DT_CMPLX ) then
         out%cmplx(1:a%shape(1),:) = a%cmplx
      end if
      out%cmplx(a%shape(1)+1,:) = v2(:)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(.vc.)", "E",                   &
                               "the physical dimensions of the two mfArray's",&
                               "are not consistent!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a )

      call msAutoRelease(a)

#endif
   end function vc_mfArray_vec_cmplx8
!_______________________________________________________________________
!
   function vc_vec_cmplx8_mfArray( v1, a ) result( out )

      complex(kind=MF_DOUBLE), intent(in) :: v1(:)
      type(mfArray),    intent(in) :: a
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( a )

      if( a%data_type == MF_DT_EMPTY ) then
         out = v1
         out%status_temporary = .true.
         go to 99
      end if

      if( mfIsSparse(a) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "cannot handled yet sparse matrices!" )
         go to 99
      end if

      if( mfIsPerm(a) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( size(v1) /= a%shape(2) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "horiz. dim. must agree!" )
         go to 99
      end if

      out%data_type = MF_DT_CMPLX
      n1 = 1+a%shape(1)
      n2 = a%shape(2)
      out%shape = [ n1, n2 ]
      allocate( out%cmplx(n1,n2) )

      out%cmplx(1,:) = v1(:)
      if( a%data_type == MF_DT_DBLE ) then
         out%cmplx(2:1+a%shape(1),:) = a%double
      else  if( a%data_type == MF_DT_CMPLX ) then
         out%cmplx(2:1+a%shape(1),:) = a%cmplx
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(.vc.)", "E",                   &
                               "the physical dimensions of the two mfArray's",&
                               "are not consistent!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a )

      call msAutoRelease(a)

#endif
   end function vc_vec_cmplx8_mfArray
!_______________________________________________________________________
!
   function vc_mfArray_mfArray( a1, a2 ) result( out )

      type(mfArray), intent(in) :: a1, a2
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: n1, n2, nnz
      integer :: status
      type(mfArray) :: spa2 ! for sparse format of a2

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( a1, a2 )

      if( mfIsPerm(a1) .or. mfIsPerm(a2) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( a1%data_type == MF_DT_EMPTY ) then
         ! the following statement :
         ! out = a2
         ! is not valid (at least on FSF_G95), because the compiler
         ! don't set the flag 'status_temporary' (perhaps, it makes
         ! a copy of the RHS).
         if( a2%level_protected == 1 ) then
            call msAssign( out, a2 )
         else
            out = a2
         end if
         out%status_temporary = .true.
         go to 99
      end if

      if( a2%data_type == MF_DT_EMPTY ) then
         ! the following statement :
         ! out = a1
         ! is not valid (at least on FSF_G95), because the compiler
         ! don't set the flag 'status_temporary' (perhaps, it makes
         ! a copy of the RHS).
         if( a1%level_protected == 1 ) then
            call msAssign( out, a1 )
         else
            out = a1
         end if
         out%status_temporary = .true.
         go to 99
      end if

      if( a2%shape(2) /= a1%shape(2) ) then
         call PrintMessage( "operator(.vc.)", "E",                      &
                            "horiz. dim. must agree!" )
         go to 99
      end if

      n1 = a1%shape(1)+a2%shape(1)
      n2 = a1%shape(2)
      out%shape = [ n1, n2 ]

      if( a1%data_type == MF_DT_BOOL ) then
         if( a2%data_type/= MF_DT_BOOL ) then
            call PrintMessage( "operator(.vc.)", "E",                   &
                               "args must be both logical!" )
            go to 99
         end if
         out%data_type = MF_DT_BOOL
         allocate( out%double(n1,n2) )

         out%double(1:a1%shape(1),:) = a1%double
         out%double(a1%shape(1)+1:n1,:) = a2%double
         out%status_temporary = .true.
         go to 99
      end if

      if( a1%data_type == MF_DT_DBLE ) then
         if( a2%data_type == MF_DT_DBLE ) then
            out%data_type = MF_DT_DBLE
            allocate( out%double(n1,n2) )

            out%double(1:a1%shape(1),:) = a1%double
            out%double(a1%shape(1)+1:n1,:) = a2%double
         else if( a2%data_type == MF_DT_CMPLX ) then
            out%data_type = MF_DT_CMPLX
            allocate( out%cmplx(n1,n2) )

            out%cmplx(1:a1%shape(1),:) = a1%double
            out%cmplx(a1%shape(1)+1:n1,:) = a2%cmplx
         end if
      else if( a1%data_type == MF_DT_CMPLX ) then
         out%data_type = MF_DT_CMPLX
         allocate( out%cmplx(n1,n2) )

         out%cmplx(1:a1%shape(1),:) = a1%cmplx
         if( a2%data_type == MF_DT_DBLE ) then
            out%cmplx(a1%shape(1)+1:n1,:) = a2%double
         else if( a2%data_type == MF_DT_CMPLX ) then
            out%cmplx(a1%shape(1)+1:n1,:) = a2%cmplx
         end if
      else if( a1%data_type == MF_DT_SP_DBLE ) then
         if( a2%data_type == MF_DT_DBLE ) then
            ! convert vector 'a2' into sparse format
            call msAssign( spa2, mfSparse(a2))
            out%data_type = MF_DT_SP_DBLE
            allocate( out%j(a1%shape(2)+spa2%shape(2)+1) )

            nnz = mfNnz(a1) + mfNnz(spa2)
            allocate( out%i(nnz) )

            allocate( out%a(nnz) )

            call rowconcat( a1%shape(1), a1%shape(2), a1%a, a1%i, a1%j, &
                            spa2%a, spa2%i, spa2%j, out%a, out%i, out%j )
            call msSilentRelease(spa2)
            out%row_sorted = a1%row_sorted
         else if( a2%data_type == MF_DT_CMPLX ) then
            ! convert vector 'a2' into sparse format
            call msAssign( spa2, mfSparse(a2))
            out%data_type = MF_DT_SP_CMPLX
            allocate( out%j(a1%shape(2)+spa2%shape(2)+1) )

            nnz = mfNnz(a1) + mfNnz(spa2)
            allocate( out%i(nnz) )

            allocate( out%z(nnz) )

            call rowconcat_real_cmplx( a1%shape(1), a1%shape(2), a1%a, a1%i, a1%j, &
                                       spa2%z, spa2%i, spa2%j,          &
                                       out%z, out%i, out%j )
            call msSilentRelease(spa2)
            out%row_sorted = a1%row_sorted
         else if( a2%data_type == MF_DT_SP_DBLE ) then
            out%data_type = MF_DT_SP_DBLE
            allocate( out%j(a1%shape(2)+1) )

            nnz = mfNnz(a1) + mfNnz(a2)
            allocate( out%i(nnz) )

            allocate( out%a(nnz) )

            call rowconcat( a1%shape(1), a1%shape(2), a1%a, a1%i, a1%j, &
                            a2%a, a2%i, a2%j, out%a, out%i, out%j )
            if( a1%row_sorted == TRUE .and. a2%row_sorted == TRUE ) then
               out%row_sorted = TRUE
            else if( a1%row_sorted == FALSE .or. a2%row_sorted == FALSE ) then
               out%row_sorted = FALSE
            else ! unknown
               out%row_sorted = UNKNOWN
            end if
         else if( a2%data_type == MF_DT_SP_CMPLX ) then
            out%data_type = MF_DT_SP_CMPLX
            allocate( out%j(a1%shape(2)+a2%shape(2)+1) )

            nnz = mfNnz(a1) + mfNnz(a2)
            allocate( out%i(nnz) )

            allocate( out%z(nnz) )

            call rowconcat_real_cmplx( a1%shape(1), a1%shape(2), a1%a, a1%i, a1%j, &
                                       a2%z, a2%i, a2%j,                &
                                       out%z, out%i, out%j )
            if( a1%row_sorted == TRUE .and. a2%row_sorted == TRUE ) then
               out%row_sorted = TRUE
            else if( a1%row_sorted == FALSE .or. a2%row_sorted == FALSE ) then
               out%row_sorted = FALSE
            else ! unknown
               out%row_sorted = UNKNOWN
            end if
         end if
      else if( a1%data_type == MF_DT_SP_CMPLX ) then
         if( a2%data_type == MF_DT_DBLE ) then
            ! convert vector 'a2' into sparse format
            call msAssign( spa2, mfSparse(a2))
            out%data_type = MF_DT_SP_CMPLX
            allocate( out%j(a1%shape(2)+spa2%shape(2)+1) )

            nnz = mfNnz(a1) + mfNnz(spa2)
            allocate( out%i(nnz) )

            allocate( out%z(nnz) )

            call rowconcat_cmplx_real( a1%shape(1), a1%shape(2), a1%z, a1%i, a1%j, &
                                       spa2%a, spa2%i, spa2%j,          &
                                       out%z, out%i, out%j )
            call msSilentRelease(spa2)
            out%row_sorted = a1%row_sorted
         else if( a2%data_type == MF_DT_CMPLX ) then
            ! convert vector 'a2' into sparse format
            call msAssign( spa2, mfSparse(a2))
            out%data_type = MF_DT_SP_CMPLX
            allocate( out%j(a1%shape(2)+spa2%shape(2)+1) )

            nnz = mfNnz(a1) + mfNnz(spa2)
            allocate( out%i(nnz) )

            allocate( out%z(nnz) )

            call rowconcat_cmplx_cmplx( a1%shape(1), a1%shape(2), a1%z, a1%i, a1%j, &
                                        spa2%z, spa2%i, spa2%j,         &
                                        out%z, out%i, out%j )
            call msSilentRelease(spa2)
            out%row_sorted = a1%row_sorted
         else if( a2%data_type == MF_DT_SP_DBLE ) then
            out%data_type = MF_DT_SP_CMPLX
            allocate( out%j(a1%shape(2)+a2%shape(2)+1) )

            nnz = mfNnz(a1) + mfNnz(a2)
            allocate( out%i(nnz) )

            allocate( out%z(nnz) )

            call rowconcat_cmplx_real( a1%shape(1), a1%shape(2), a1%z, a1%i, a1%j,   &
                                       a2%a, a2%i, a2%j,                &
                                       out%z, out%i, out%j )
            if( a1%row_sorted == TRUE .and. a2%row_sorted == TRUE ) then
               out%row_sorted = TRUE
            else if( a1%row_sorted == FALSE .or. a2%row_sorted == FALSE ) then
               out%row_sorted = FALSE
            else ! unknown
               out%row_sorted = UNKNOWN
            end if
         else if( a2%data_type == MF_DT_SP_CMPLX ) then
            out%data_type = MF_DT_SP_CMPLX
            allocate( out%j(a1%shape(2)+a2%shape(2)+1) )

            nnz = mfNnz(a1) + mfNnz(a2)
            allocate( out%i(nnz) )

            allocate( out%z(nnz) )

            call rowconcat_cmplx_cmplx( a1%shape(1), a1%shape(2), a1%z, a1%i, a1%j, &
                                        a2%z, a2%i, a2%j,               &
                                        out%z, out%i, out%j )
            if( a1%row_sorted == TRUE .and. a2%row_sorted == TRUE ) then
               out%row_sorted = TRUE
            else if( a1%row_sorted == FALSE .or. a2%row_sorted == FALSE ) then
               out%row_sorted = FALSE
            else ! unknown
               out%row_sorted = UNKNOWN
            end if
         end if
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a1%units, a2%units, status )
         if( status /= 0 ) then
            call PrintMessage( "operator(.hc.)", "E",                   &
                               "the physical dimensions of the two mfArray's",&
                               "are not consistent!" )
            go to 99
         end if
         out%units(:) = a1%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a1, a2 )

      call msAutoRelease(a1,a2)

#endif
   end function vc_mfArray_mfArray
