! f90 include file

!_______________________________________________________________________
!
   function mfTranspose_mfArray( x ) result( out )

      type(mfArray), intent(in) :: x
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      if( x%data_type == MF_DT_EMPTY ) then
         call PrintMessage( "mfTranspose", "I",                         &
                            "empty arg.!" )
         go to 99
      end if

      if( x%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfTranspose", "E",                         &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      out%shape(1) = x%shape(2)
      out%shape(2) = x%shape(1)
      out%data_type = x%data_type
      if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
         allocate( out%double(out%shape(1),out%shape(2)) )

         if( x%prop%symm == TRUE ) then
            out%double = x%double
         else
            out%double = transpose( x%double )
         end if
      else if( x%data_type == MF_DT_CMPLX ) then
         allocate( out%cmplx(out%shape(1),out%shape(2)) )

         out%cmplx = transpose( x%cmplx )
         call PrintMessage( "mfTranspose", "W",                         &
                            "taking transpose of a complex array!",    &
                            "Did you thought .h. operator?" )
      else if( x%data_type == MF_DT_SP_DBLE ) then
         allocate( out%a(size(x%a)) )

         allocate( out%i(size(x%i)) )

         allocate( out%j(out%shape(2)+1) )

         if( x%prop%symm == TRUE ) then
            out%i = x%i
            out%j = x%j
            out%a = x%a
            out%row_sorted = x%row_sorted
         else
            call csc_transp( x%shape(1), x%shape(2), x%a, x%i, x%j,        &
                             out%a, out%i, out%j )
            out%row_sorted = TRUE
         end if
      else if( x%data_type == MF_DT_SP_CMPLX ) then
         allocate( out%z(size(x%z)) )

         allocate( out%i(size(x%i)) )

         allocate( out%j(out%shape(2)+1) )

         call csc_transp_cmplx( x%shape(1), x%shape(2), x%z, x%i, x%j,  &
                                out%z, out%i, out%j )
         out%row_sorted = TRUE
         call PrintMessage( "mfTranspose", "W",                         &
                            "taking transpose of a complex array!",    &
                            "Did you thought .h. operator?" )
      end if

      if( x%prop%tril == TRUE ) then
         out%prop%triu = TRUE
      end if
      if( x%prop%triu == TRUE ) then
         out%prop%tril = TRUE
      end if
      out%prop%symm = x%prop%symm
      out%prop%posd = x%prop%posd

      if( mf_phys_units ) then
         out%units(:) = x%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msAutoRelease(x)

#endif
   end function mfTranspose_mfArray
!_______________________________________________________________________
!
   function mfTranspose_vec_int( x ) result( out )

      integer, intent(in) :: x(:)
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      call msAssign( out, mfTranspose_mfArray( mf(x) ))

      out%prop%symm = FALSE

      out%status_temporary = .true.

#endif
   end function mfTranspose_vec_int
!_______________________________________________________________________
!
   function mfTranspose_vec_real8( x ) result( out )

      real(kind=MF_DOUBLE), intent(in) :: x(:)
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      call msAssign( out, mfTranspose_mfArray( mf(x) ))

      out%prop%symm = FALSE

      out%status_temporary = .true.

#endif
   end function mfTranspose_vec_real8
!_______________________________________________________________________
!
   function mfTranspose_array_int( x ) result( out )

      integer, intent(in) :: x(:,:)
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      call msAssign( out, mfTranspose_mfArray( mf(x) ))

      out%status_temporary = .true.

#endif
   end function mfTranspose_array_int
!_______________________________________________________________________
!
   function mfTranspose_array_real8( x ) result( out )

      real(kind=MF_DOUBLE), intent(in) :: x(:,:)
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      call msAssign( out, mfTranspose_mfArray( mf(x) ))

      out%status_temporary = .true.

#endif
   end function mfTranspose_array_real8
