! f90 include file

!_______________________________________________________________________
!
   function mfSub_mfArray_mfArray( a, b ) result( out )

      type(mfArray), intent(in) :: a, b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: nrow, ncol, nzmax, jerr, nzaplb
      logical :: sorted_version
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( a, b )

      if( mfIsEmpty(a) ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsEmpty(b) ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "mfArray 'B' is not allocated!" )
         go to 99
      end if

      if( a%data_type == MF_DT_BOOL .or. a%data_type == MF_DT_SP_BOOL .or. &
          b%data_type == MF_DT_BOOL .or. b%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( a%data_type == MF_DT_PERM_VEC .or. b%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a permutation!" )
         go to 99
      end if

      if( all(a%shape == b%shape) ) then

         out%shape = a%shape

         if( a%data_type == MF_DT_SP_DBLE .and.                         &
             b%data_type == MF_DT_SP_DBLE       ) then

            nrow = a%shape(1)
            ncol = a%shape(2)
            ! nzmax choice: at least nnzaplb, but preserve extra rooms
            ! from initial sparse arrays.
            call nnzaplb( nrow, ncol, a%i, a%j, b%i, b%j, nzaplb )
            nzmax = max( max(mfNzmax(a),mfNzmax(b)), nzaplb )
            call msAssign( out, mfSpAlloc(nrow,ncol,nzmax) )
            ! check row_sorted strategy
            if( mfIsRowSorted( A ) .and. mfIsRowSorted( B ) ) then
               sorted_version = .true.
            else
               if( MF_SP_AUTO_ROW_SORTED ) then
                  if( .not. A%status_temporary ) then
                     if( .not. mfIsRowSorted( A ) ) then
                        call msRowSort( A )
                        call PrintMessage( "operator(-)", "I",          &
                                           "sparse matrix 'A' have been sorted!",&
                                           "(If you don't want that MUESLI sort itself,",&
                                           "you can use the 'msSetAutoRowSorted' routine to",&
                                           "change this behavior.)" )
                     end if
                  end if
                  if( .not. B%status_temporary ) then
                     if( .not. mfIsRowSorted( B ) ) then
                        call msRowSort( B )
                        call PrintMessage( "operator(-)", "I",          &
                                           "sparse matrix 'B' have been sorted!",&
                                           "(If you don't want that MUESLI sort itself,",&
                                           "you can use the 'msSetAutoRowSorted' routine to",&
                                           "change this behavior.)" )
                     end if
                  end if
                  if( mfIsRowSorted( A ) .and. mfIsRowSorted( B ) ) then
                     sorted_version = .true.
                  else
! it seems that this case occurs rarely: at least one of the two
! mfArrays should be both tempo and not row_sorted, together with
! AUTO_ROW_SORTED true.
                     sorted_version = .false.
                  end if
               else ! row sorted under the user control
                  sorted_version = .false.
                  call PrintMessage( "operator(-)", "W",                &
                                     "at least one sparse matrix is not row sorted!",&
                                     "(sorting it permits to use a better algo.)" )
               end if
            end if
            if( sorted_version ) then
               call amib1( nrow, ncol, A%a, A%i, A%j, B%a, B%i, B%j,    &
                           out%a, out%i, out%j, nzmax, jerr )
            else
               call amib( nrow, ncol, A%a, A%i, A%j, B%a, B%i, B%j,     &
                          out%a, out%i, out%j, nzmax, jerr )
            end if
            if( jerr /= 0 ) then
               write(STDERR,*) "(MUESLI operator(-):) internal error: amib fails!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            end if
            if( sorted_version ) then
               out%row_sorted = TRUE
            else
               out%row_sorted = UNKNOWN
            end if

         else if( a%data_type == MF_DT_SP_CMPLX .and.                   &
                  b%data_type == MF_DT_SP_CMPLX       ) then

            nrow = a%shape(1)
            ncol = a%shape(2)
            ! nzmax choice: at least nnzaplb, but preserve extra rooms
            ! from initial sparse arrays.
            call nnzaplb( nrow, ncol, a%i, a%j, b%i, b%j, nzaplb )
            nzmax = max( max(mfNzmax(a),mfNzmax(b)), nzaplb )
            call msAssign( out, mfSpAlloc(nrow,ncol,nzmax,kind='complex'))
            ! check row_sorted strategy
            if( mfIsRowSorted( A ) .and. mfIsRowSorted( B ) ) then
               sorted_version = .true.
            else
               if( MF_SP_AUTO_ROW_SORTED ) then
                  if( .not. A%status_temporary ) then
                     if( .not. mfIsRowSorted( A ) ) then
                        call msRowSort( A )
                        call PrintMessage( "operator(-)", "I",          &
                                           "sparse matrix 'A' have been sorted!",&
                                           "(If you don't want that MUESLI sort itself,",&
                                           "you can use the 'msSetAutoRowSorted' routine to",&
                                           "change this behavior.)" )
                     end if
                  end if
                  if( .not. B%status_temporary ) then
                     if( .not. mfIsRowSorted( B ) ) then
                        call msRowSort( B )
                        call PrintMessage( "operator(-)", "I",          &
                                           "sparse matrix 'B' have been sorted!",&
                                           "(If you don't want that MUESLI sort itself,",&
                                           "you can use the 'msSetAutoRowSorted' routine to",&
                                           "change this behavior.)" )
                     end if
                  end if
                  if( mfIsRowSorted( A ) .and. mfIsRowSorted( B ) ) then
                     sorted_version = .true.
                  else
! it seems that this case occurs rarely: at least one of the two
! mfArrays should be both tempo and not row_sorted, together with
! AUTO_ROW_SORTED true.
                     sorted_version = .false.
                  end if
               else ! row sorted under the user control
                  sorted_version = .false.
                  call PrintMessage( "operator(-)", "W",                &
                                     "at least one sparse matrix is not row sorted!",&
                                     "(sorting it permits to use a better algo.)" )
               end if
            end if
            if( sorted_version ) then
               call amib1_cmplx_cmplx( nrow, ncol,                      &
                                       A%z, A%i, A%j, B%z, B%i, B%j,    &
                                       out%z, out%i, out%j, nzmax, jerr )
            else
               call amib_cmplx_cmplx( nrow, ncol,                       &
                                      A%z, A%i, A%j, B%z, B%i, B%j,     &
                                      out%z, out%i, out%j, nzmax, jerr )
            end if
            if( jerr /= 0 ) then
               write(STDERR,*) "(MUESLI operator(-):) internal error: amib fails!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            end if
            if( sorted_version ) then
               out%row_sorted = TRUE
            else
               out%row_sorted = UNKNOWN
            end if

         else if( a%data_type == MF_DT_SP_DBLE .and.                    &
                  b%data_type == MF_DT_SP_CMPLX       ) then

            nrow = a%shape(1)
            ncol = a%shape(2)
            ! nzmax choice: at least nnzaplb, but preserve extra rooms
            ! from initial sparse arrays.
            call nnzaplb( nrow, ncol, a%i, a%j, b%i, b%j, nzaplb )
            nzmax = max( max(mfNzmax(a),mfNzmax(b)), nzaplb )
            call msAssign( out, mfSpAlloc(nrow,ncol,nzmax,kind='complex'))
            ! check row_sorted strategy
            if( mfIsRowSorted( A ) .and. mfIsRowSorted( B ) ) then
               sorted_version = .true.
            else
               if( MF_SP_AUTO_ROW_SORTED ) then
                  if( .not. A%status_temporary ) then
                     if( .not. mfIsRowSorted( A ) ) then
                        call msRowSort( A )
                        call PrintMessage( "operator(-)", "I",          &
                                           "sparse matrix 'A' have been sorted!",&
                                           "(If you don't want that MUESLI sort itself,",&
                                           "you can use the 'msSetAutoRowSorted' routine to",&
                                           "change this behavior.)" )
                     end if
                  end if
                  if( .not. B%status_temporary ) then
                     if( .not. mfIsRowSorted( B ) ) then
                        call msRowSort( B )
                        call PrintMessage( "operator(-)", "I",          &
                                           "sparse matrix 'B' have been sorted!",&
                                           "(If you don't want that MUESLI sort itself,",&
                                           "you can use the 'msSetAutoRowSorted' routine to",&
                                           "change this behavior.)" )
                     end if
                  end if
                  if( mfIsRowSorted( A ) .and. mfIsRowSorted( B ) ) then
                     sorted_version = .true.
                  else
! it seems that this case occurs rarely: at least one of the two
! mfArrays should be both tempo and not row_sorted, together with
! AUTO_ROW_SORTED true.
                     sorted_version = .false.
                  end if
               else ! row sorted under the user control
                  sorted_version = .false.
                  call PrintMessage( "operator(-)", "W",                &
                                     "at least one sparse matrix is not row sorted!",&
                                     "(sorting it permits to use a better algo.)" )
               end if
            end if
            if( sorted_version ) then
               call amib1_real_cmplx( nrow, ncol,                       &
                                      A%a, A%i, A%j, B%z, B%i, B%j,     &
                                      out%z, out%i, out%j, nzmax, jerr )
            else
               call amib_real_cmplx( nrow, ncol,                        &
                                     A%a, A%i, A%j, B%z, B%i, B%j,      &
                                     out%z, out%i, out%j, nzmax, jerr )
            end if
            if( jerr /= 0 ) then
               write(STDERR,*) "(MUESLI operator(-):) internal error: amib fails!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            end if
            if( sorted_version ) then
               out%row_sorted = TRUE
            else
               out%row_sorted = UNKNOWN
            end if

         else if( a%data_type == MF_DT_SP_CMPLX .and.                   &
                  b%data_type == MF_DT_SP_DBLE       ) then

            nrow = a%shape(1)
            ncol = a%shape(2)
            ! nzmax choice: at least nnzaplb, but preserve extra rooms
            ! from initial sparse arrays.
            call nnzaplb( nrow, ncol, a%i, a%j, b%i, b%j, nzaplb )
            nzmax = max( max(mfNzmax(a),mfNzmax(b)), nzaplb )
            call msAssign( out, mfSpAlloc(nrow,ncol,nzmax,kind='complex'))
            ! check row_sorted strategy
            if( mfIsRowSorted( A ) .and. mfIsRowSorted( B ) ) then
               sorted_version = .true.
            else
               if( MF_SP_AUTO_ROW_SORTED ) then
                  if( .not. A%status_temporary ) then
                     if( .not. mfIsRowSorted( A ) ) then
                        call msRowSort( A )
                        call PrintMessage( "operator(-)", "I",          &
                                           "sparse matrix 'A' have been sorted!",&
                                           "(If you don't want that MUESLI sort itself,",&
                                           "you can use the 'msSetAutoRowSorted' routine to",&
                                           "change this behavior.)" )
                     end if
                  end if
                  if( .not. B%status_temporary ) then
                     if( .not. mfIsRowSorted( B ) ) then
                        call msRowSort( B )
                        call PrintMessage( "operator(-)", "I",          &
                                           "sparse matrix 'B' have been sorted!",&
                                           "(If you don't want that MUESLI sort itself,",&
                                           "you can use the 'msSetAutoRowSorted' routine to",&
                                           "change this behavior.)" )
                     end if
                  end if
                  if( mfIsRowSorted( A ) .and. mfIsRowSorted( B ) ) then
                     sorted_version = .true.
                  else
! it seems that this case occurs rarely: at least one of the two
! mfArrays should be both tempo and not row_sorted, together with
! AUTO_ROW_SORTED true.
                     sorted_version = .false.
                  end if
               else ! row sorted under the user control
                  sorted_version = .false.
                  call PrintMessage( "operator(-)", "W",                &
                                     "at least one sparse matrix is not row sorted!",&
                                     "(sorting it permits to use a better algo.)" )
               end if
            end if
            if( sorted_version ) then
               call amib1_cmplx_real( nrow, ncol,                       &
                                      A%z, A%i, A%j, B%a, B%i, B%j,     &
                                      out%z, out%i, out%j, nzmax, jerr )
            else
               call amib_cmplx_real( nrow, ncol,                        &
                                     A%z, A%i, A%j, B%a, B%i, B%j,      &
                                     out%z, out%i, out%j, nzmax, jerr )
            end if
            if( jerr /= 0 ) then
               write(STDERR,*) "(MUESLI operator(-):) internal error: amib fails!"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            end if
            if( sorted_version ) then
               out%row_sorted = TRUE
            else
               out%row_sorted = UNKNOWN
            end if

         else if( a%data_type == MF_DT_DBLE ) then
            if( b%data_type == MF_DT_DBLE ) then
               out%data_type = MF_DT_DBLE

               ! if one of the mfArrays is tempo and not protected,
               ! processing is done 'in place' (avoid an allocation).
               if( can_use_memory(A) ) then
                  out%double => a%double
                  call set_status_tempo_to_false( a )
               else if( can_use_memory(B) ) then
                  out%double => b%double
                  call set_status_tempo_to_false( b )
               else
                  allocate( out%double(out%shape(1),out%shape(2)) )
               end if
!### TODO: here and in other places, replace intrinsic '-' by a BLAS-2 call ?
! (but the operation will not be done 'in place' !)
               out%double = a%double - b%double
            else if( b%data_type == MF_DT_CMPLX ) then
               out%data_type = MF_DT_CMPLX
               allocate( out%cmplx(out%shape(1),out%shape(2)) )

               out%cmplx = a%double - b%cmplx
            else
               call PrintMessage( "operator(-)", "E",                   &
                                  "case not handled",                   &
                                  "(A numeric dense => B must be numeric dense)" )
               go to 99
            end if
         else if( a%data_type == MF_DT_CMPLX ) then
            out%data_type = MF_DT_CMPLX
            if( b%data_type == MF_DT_DBLE ) then
               allocate( out%cmplx(out%shape(1),out%shape(2)) )

               out%cmplx = a%cmplx - b%double
            else if( b%data_type == MF_DT_CMPLX ) then

               ! if one of the mfArrays is tempo and not protected,
               ! processing is done 'in place' (avoid an allocation).
               if( can_use_memory(A) ) then
                  out%cmplx => a%cmplx
                  call set_status_tempo_to_false( a )
               else if( can_use_memory(B) ) then
                  out%cmplx => b%cmplx
                  call set_status_tempo_to_false( b )
               else
                  allocate( out%cmplx(out%shape(1),out%shape(2)) )

               end if
               out%cmplx = a%cmplx - b%cmplx

            end if
         else
            call PrintMessage( "operator(-)", "E",                      &
                               "case not handled",                      &
                               "(A numeric dense => B must be numeric dense)" )
            go to 99
         end if

      else if( all(a%shape == 1) ) then ! 'a' is scalar

         if( a%data_type == MF_DT_DBLE ) then
            ! avoid to call mfHasNoPhysDim, which is a user routine
            if( mf_phys_units ) then
               call verif_adim( b%units, status=status )
            else
               status = 0
            end if
            if( status == 0 ) then ! 'b' has No Phys. Dim. (or Phys. Dim. not activated)
               call msAssign( out, mfSub_real8_mfArray( a%double(1,1), b ))
            else
               ! special case when 'b' has a physical unit
               discard_phys_unit = .true.
               call msAssign( out, mfSub_real8_mfArray( a%double(1,1), b ))
               discard_phys_unit = .false.
            end if
         else if( a%data_type == MF_DT_CMPLX ) then
            call msAssign( out, mfSub_cmplx8_mfArray( a%cmplx(1,1), b ))
         else
            call PrintMessage( "operator(-)", "E",                      &
                               "case not handled",                      &
                               "(A is a scalar => it must be numeric dense)" )
            go to 99
         end if

      else if( all(b%shape == 1) ) then ! 'b' is scalar

         if( b%data_type == MF_DT_DBLE ) then
            ! avoid to call mfHasNoPhysDim, which is a user routine
            if( mf_phys_units ) then
               call verif_adim( a%units, status=status )
            else
               status = 0
            end if
            if( status == 0 ) then ! 'a' has No Phys. Dim. (or Phys. Dim. not activated)
               call msAssign( out, mfSub_mfArray_real8( a, b%double(1,1) ))
            else
               ! special case when 'a' has a physical unit
               discard_phys_unit = .true.
               call msAssign( out, mfSub_mfArray_real8( a, b%double(1,1) ))
               discard_phys_unit = .false.
            end if
         else if( b%data_type == MF_DT_CMPLX ) then
            call msAssign( out, mfSub_mfArray_cmplx8( a, b%cmplx(1,1) ))
         else
            call PrintMessage( "operator(-)", "E",                      &
                               "case not handled",                      &
                               "(B is a scalar => it must be numeric dense)" )
            go to 99
         end if

      else

         call PrintMessage( "operator(-)", "E",                         &
                            "A and B must have the same shape" )
         go to 99

      end if

      out%prop = op2_pattern_prop( A%prop, B%prop )
      if( A%prop%symm == TRUE .and. B%prop%symm == TRUE ) then
         out%prop%symm = TRUE
      end if
      out%prop%posd = UNKNOWN

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, b%units, status )
         if( status /= 0 ) then
            call PrintMessage( "operator(-)", "E",                      &
                               "the physical dimensions of the two mfArray's",&
                               "are not consistent!" )
            go to 99
         end if
         out%units(:) = a%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a, b )
      call msAutoRelease( a, b )

      call mf_restore_fpe( )

#endif
   end function mfSub_mfArray_mfArray
!_______________________________________________________________________
!
   function mfSub_mfArray_int( a, b ) result( out )

      type(mfArray), intent(in) :: a
      integer, intent(in) :: b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! converts the 2nd arg in double and calls 'mfSub_mfArray_real8'
      !
      ! not very efficient (2 calls instead of one, and some tests are
      ! made twice) : an information message is therefore emitted

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( a )

      ! Special case of MF_END: this routine is the one of the rare
      ! specific cases to be used for such an operation... (+ and - only)
      ! Cannot use mfIsEqual(a,MF_END) in the test because a previous
      ! operation on MF_END has perhaps already occured (crc modified!).
      if( all(a%shape == MF_END%shape) ) then
         call msAssign( out, a )
         out%crc = out%crc - b
         go to 89
      end if

      call PrintMessage( "operator(-)", "I",                            &
                         "you are using an operator which involves an integer",&
                         "argument. Converting this argument in double",&
                         "precision will lead to a slightly more efficient",&
                         "computation!" )

      call msAssign( out, mfSub_mfArray_real8( a, dble(b) ) )

 89   continue

      out%status_temporary = .true.

      call msFreeArgs( a )
      call msAutoRelease( a )

      call mf_restore_fpe( )

#endif
   end function mfSub_mfArray_int
!_______________________________________________________________________
!
   function mfSub_int_mfArray( a, b ) result( out )

      integer, intent(in) :: a
      type(mfArray), intent(in) :: b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! converts the 2nd arg in double and calls 'mfSub_mfArray_real8'
      !
      ! not very efficient (2 calls instead of one, and some tests are
      ! made twice) : an information message is therefore emitted

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( b )

      ! Special case of MF_END: this routine is the one of the rare
      ! specific cases to be used for such an operation... (+ and - only)
      ! Cannot use mfIsEqual(b,MF_END) in the test because a previous
      ! operation on MF_END has perhaps already occured (crc modified!).
      if( all(b%shape == MF_END%shape) ) then
         call msAssign( out, b )
         out%crc = out%crc - a
         go to 89
      end if

      call PrintMessage( "operator(-)", "I",                            &
                         "you are using an operator which involves an integer",&
                         "argument. Converting this argument in double",&
                         "precision will lead to a slightly more efficient",&
                         "computation!" )

      call msAssign( out, mfSub_real8_mfArray( dble(a), b ) )

 89   continue

      out%status_temporary = .true.

      call msFreeArgs( b )
      call msAutoRelease( b )

      call mf_restore_fpe( )

#endif
   end function mfSub_int_mfArray
!_______________________________________________________________________
!
   function mfSub_mfArray_real4( a, b ) result( out )

      type(mfArray), intent(in) :: a
      real, intent(in) :: b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! converts the 2nd arg in double and calls 'mfSub_mfArray_real8'
      !
      ! not very efficient (2 calls instead of one, and some tests are
      ! made twice) : an information message is therefore emitted

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( a )

      call PrintMessage( "operator(-)", "I",                            &
                         "you are using an operator which involves a single",&
                         "precision argument. Converting this argument in double",&
                         "precision will lead to a slightly more efficient",&
                         "computation! Moreover, be aware of precision loss..." )

      call msAssign( out, mfSub_mfArray_real8( a, dble(b) ) )

      out%status_temporary = .true.

      call msFreeArgs( a )
      call msAutoRelease( a )

      call mf_restore_fpe( )

#endif
   end function mfSub_mfArray_real4
!_______________________________________________________________________
!
   function mfSub_real4_mfArray( a, b ) result( out )

      real, intent(in) :: a
      type(mfArray), intent(in) :: b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! converts the 2nd arg in double and calls 'mfSub_mfArray_real8'
      !
      ! not very efficient (2 calls instead of one, and some tests are
      ! made twice) : an information message is therefore emitted

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( b )

      call PrintMessage( "operator(-)", "I",                            &
                         "you are using an operator which involves a single",&
                         "precision argument. Converting this argument in double",&
                         "precision will lead to a slightly more efficient",&
                         "computation! Moreover, be aware of precision loss..." )

      call msAssign( out, mfSub_real8_mfArray( dble(a), b ) )

      out%status_temporary = .true.

      call msFreeArgs( b )
      call msAutoRelease( b )

      call mf_restore_fpe( )

#endif
   end function mfSub_real4_mfArray
!_______________________________________________________________________
!
   function mfSub_mfArray_real8( a, b ) result( out )

      type(mfArray),        intent(in) :: a
      real(kind=MF_DOUBLE), intent(in) :: b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: ncol, nnz
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( a )

      if( mfIsEmpty(a) ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "mfArray 'a' cannot be empty" )
         go to 99
      end if

      if( a%data_type == MF_DT_BOOL .or. a%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( a%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a permutation!" )
         go to 99
      end if

      out%data_type = a%data_type
      out%shape = a%shape
      if( a%data_type == MF_DT_DBLE ) then
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%double => a%double
            call set_status_tempo_to_false( a )
         else
            allocate( out%double(a%shape(1),a%shape(2)) )

         end if
         out%double = a%double - b
      else if( a%data_type == MF_DT_CMPLX ) then
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%cmplx => a%cmplx
            call set_status_tempo_to_false( a )
         else
            allocate( out%cmplx(a%shape(1),a%shape(2)) )

         end if
         out%cmplx = a%cmplx - b
      else if( a%data_type == MF_DT_SP_DBLE ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "Note that your sparse matrix would become full of non-zero elements;", &
                            "if you really want to use this kind of operation, you must first convert", &
                            "the matrix A into a dense structure (mfFull(A)).", &
                            "In the case you want to apply your operation only to non-zero elements of A,", &
                            "you can write:  A - b*mfSpOnes(A)." )
         go to 99
      else if( a%data_type == MF_DT_SP_CMPLX ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "Note that your sparse matrix would become full of non-zero elements;", &
                            "if you really want to use this kind of operation, you must first convert", &
                            "the matrix A into a dense structure (mfFull(A)).", &
                            "In the case you want to apply your operation only to non-zero elements of A,", &
                            "you can write:  A - b*mfSpOnes(A)." )
         go to 99
      else
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "(B is f90 scalar real => A must be numeric)" )
         go to 99
      end if

      out%prop%symm = A%prop%symm

      if( mf_phys_units .and. .not. discard_phys_unit ) then
         ! verifying the physical dimension
         call verif_adim( a%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(-)", "E",                      &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a )
      call msAutoRelease(a)

      call mf_restore_fpe( )

#endif
   end function mfSub_mfArray_real8
!_______________________________________________________________________
!
   function mfSub_real8_mfArray( a, b ) result( out )

      real(kind=MF_DOUBLE), intent(in) :: a
      type(mfArray),        intent(in) :: b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: ncol, nnz
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( b )

      if( mfIsEmpty(b) ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "mfArray 'b' cannot be empty" )
         go to 99
      end if

      if( b%data_type == MF_DT_BOOL .or. b%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( b%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a permutation!" )
         go to 99
      end if

      out%data_type = b%data_type
      out%shape = b%shape
      if( b%data_type == MF_DT_DBLE ) then
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(B) ) then
            out%double => b%double
            call set_status_tempo_to_false( b )
         else
            allocate( out%double(b%shape(1),b%shape(2)) )

         end if
         out%double = a - b%double
      else if( b%data_type == MF_DT_CMPLX ) then
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(B) ) then
            out%cmplx => b%cmplx
            call set_status_tempo_to_false( b )
         else
            allocate( out%cmplx(b%shape(1),b%shape(2)) )

         end if
         out%cmplx = a - b%cmplx
      else if( b%data_type == MF_DT_SP_DBLE ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "Note that your sparse matrix would become full of non-zero elements;", &
                            "if you really want to use this kind of operation, you must first convert", &
                            "the matrix B into a dense structure (mfFull(B)).", &
                            "In the case you want to apply your operation only to non-zero elements of B,", &
                            "you can write:  a*mfSpOnes(B) - B." )
         go to 99
      else if( b%data_type == MF_DT_SP_CMPLX ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "Note that your sparse matrix would become full of non-zero elements;", &
                            "if you really want to use this kind of operation, you must first convert", &
                            "the matrix B into a dense structure (mfFull(B)).", &
                            "In the case you want to apply your operation only to non-zero elements of B,", &
                            "you can write:  a*mfSpOnes(B) - B." )
         go to 99
      else
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "(A is f90 scalar real => B must be numeric)" )
         go to 99
      end if

      out%prop%symm = B%prop%symm

      if( mf_phys_units .and. .not. discard_phys_unit ) then
         ! verifying the physical dimension
         call verif_adim( b%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(-)", "E",                      &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( b )
      call msAutoRelease(b)

      call mf_restore_fpe( )

#endif
   end function mfSub_real8_mfArray
!_______________________________________________________________________
!
   function mfSub_mfArray_cmplx4( a, b ) result( out )

      type(mfArray), intent(in) :: a
      complex, intent(in) :: b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! converts the 2nd arg in double and calls 'mfSub_mfArray_cmplx8'
      !
      ! not very efficient (2 calls instead of one, and some tests are
      ! made twice) : an information message is therefore emitted

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( a )

      call PrintMessage( "operator(-)", "I",                            &
                         "you are using an operator which involves a single",&
                         "precision argument. Converting this argument in double",&
                         "precision will lead to a slightly more efficient",&
                         "computation! Moreover, be aware of precision loss..." )

      call msAssign( out, mfSub_mfArray_cmplx8( a, cmplx(b,kind=MF_DOUBLE) ) )

      out%status_temporary = .true.

      call msFreeArgs( a )
      call msAutoRelease( a )

      call mf_restore_fpe( )

#endif
   end function mfSub_mfArray_cmplx4
!_______________________________________________________________________
!
   function mfSub_cmplx4_mfArray( a, b ) result( out )

      complex, intent(in) :: a
      type(mfArray), intent(in) :: b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! converts the 2nd arg in double and calls 'mfSub_mfArray_cmplx8'
      !
      ! not very efficient (2 calls instead of one, and some tests are
      ! made twice) : an information message is therefore emitted

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( b )

      call PrintMessage( "operator(-)", "I",                            &
                         "you are using an operator which involves a single",&
                         "precision argument. Converting this argument in double",&
                         "precision will lead to a slightly more efficient",&
                         "computation! Moreover, be aware of precision loss..." )

      call msAssign( out, mfSub_cmplx8_mfArray( cmplx(a,kind=MF_DOUBLE), b ) )

      out%status_temporary = .true.

      call msFreeArgs( b )
      call msAutoRelease( b )

      call mf_restore_fpe( )

#endif
   end function mfSub_cmplx4_mfArray
!_______________________________________________________________________
!
   function mfSub_mfArray_cmplx8( a, b ) result( out )

      type(mfArray),           intent(in) :: a
      complex(kind=MF_DOUBLE), intent(in) :: b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: ncol, nnz
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( a )

      if( mfIsEmpty(a) ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "mfArray 'a' cannot be empty" )
         go to 99
      end if

      if( a%data_type == MF_DT_BOOL .or. A%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( a%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a permutation!" )
         go to 99
      end if

      out%shape = a%shape
      if( a%data_type == MF_DT_DBLE ) then
         out%data_type = MF_DT_CMPLX
         allocate( out%cmplx(a%shape(1),a%shape(2)) )

         out%cmplx = a%double - b
      else if( a%data_type == MF_DT_CMPLX ) then
         out%data_type = MF_DT_CMPLX
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%cmplx => a%cmplx
            call set_status_tempo_to_false( a )
         else
            allocate( out%cmplx(a%shape(1),a%shape(2)) )

         end if
         out%cmplx = a%cmplx - b
      else if( a%data_type == MF_DT_SP_DBLE ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "Note that your sparse matrix would become full of non-zero elements;", &
                            "if you really want to use this kind of operation, you must first convert", &
                            "the matrix A into a dense structure (mfFull(A)).", &
                            "In the case you want to apply your operation only to non-zero elements of A,", &
                            "you can write:  A - b*mfSpOnes(A)." )
         go to 99
      else if( a%data_type == MF_DT_SP_CMPLX ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "Note that your sparse matrix would become full of non-zero elements;", &
                            "if you really want to use this kind of operation, you must first convert", &
                            "the matrix A into a dense structure (mfFull(A)).", &
                            "In the case you want to apply your operation only to non-zero elements of A,", &
                            "you can write:  A - b*mfSpOnes(A)." )
         go to 99
      else
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "(B is f90 scalar cmplx => A must be numeric)" )
         go to 99
      end if

      out%prop%symm = UNKNOWN

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(-)", "E",                      &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a )
      call msAutoRelease(a)

      call mf_restore_fpe( )

#endif
   end function mfSub_mfArray_cmplx8
!_______________________________________________________________________
!
   function mfSub_cmplx8_mfArray( a, b ) result( out )

      complex(kind=MF_DOUBLE), intent(in) :: a
      type(mfArray),           intent(in) :: b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: ncol, nnz
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( b )

      if( mfIsEmpty(b) ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "mfArray 'b' cannot be empty" )
         go to 99
      end if

      if( b%data_type == MF_DT_BOOL .or. b%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( b%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a permutation!" )
         go to 99
      end if

      out%shape = b%shape
      if( b%data_type == MF_DT_DBLE ) then
         out%data_type = MF_DT_CMPLX
         allocate( out%cmplx(b%shape(1),b%shape(2)) )

         out%cmplx = a - b%double
      else if( b%data_type == MF_DT_CMPLX ) then
         out%data_type = MF_DT_CMPLX
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(B) ) then
            out%cmplx => b%cmplx
            call set_status_tempo_to_false( b )
         else
            allocate( out%cmplx(b%shape(1),b%shape(2)) )

         end if
         out%cmplx = a - b%cmplx
      else if( b%data_type == MF_DT_SP_DBLE ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "Note that your sparse matrix would become full of non-zero elements;", &
                            "if you really want to use this kind of operation, you must first convert", &
                            "the matrix B into a dense structure (mfFull(B)).", &
                            "In the case you want to apply your operation only to non-zero elements of B,", &
                            "you can write:  a*mfSpOnes(B) - B." )
         go to 99
      else if( b%data_type == MF_DT_SP_CMPLX ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "Note that your sparse matrix would become full of non-zero elements;", &
                            "if you really want to use this kind of operation, you must first convert", &
                            "the matrix B into a dense structure (mfFull(B)).", &
                            "In the case you want to apply your operation only to non-zero elements of B,", &
                            "you can write:  a*mfSpOnes(B) - B." )
         go to 99
      else
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "(A is f90 scalar cmplx => B must be numeric)" )
         go to 99
      end if

      out%prop%symm = UNKNOWN

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( b%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(-)", "E",                      &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( b )
      call msAutoRelease(b)

      call mf_restore_fpe( )

#endif
   end function mfSub_cmplx8_mfArray
!_______________________________________________________________________
!
   function mfSub_mfArray_mfUnit( A, u ) result( out )

      type(mfArray), intent(in) :: A
      type(mfUnit),  intent(in) :: u
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! in order to be coherent, 'mf_phys_units' must be set!

      integer :: status, ncol, nnz

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "mfArray 'A' cannot be empty" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL .or. A%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a permutation!" )
         go to 99
      end if

      out%data_type = A%data_type
      out%shape = A%shape
      if( A%data_type == MF_DT_DBLE ) then
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%double => A%double
            call set_status_tempo_to_false( A )
         else
            allocate( out%double(A%shape(1),A%shape(2)) )

         end if
         out%double = A%double - u%value
      else if( A%data_type == MF_DT_CMPLX ) then
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%cmplx => A%cmplx
            call set_status_tempo_to_false( A )
         else
            allocate( out%cmplx(A%shape(1),A%shape(2)) )

         end if
         out%cmplx = A%cmplx - u%value
      else if( A%data_type == MF_DT_SP_DBLE ) then
         ncol = A%shape(2)
         nnz = A%j(ncol+1)-1
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%a => A%a
            out%i => A%i
            out%j => A%j
            call set_status_tempo_to_false( A )
         else
            allocate( out%a(size(A%a)) )

            allocate( out%i(size(A%i)) )

            allocate( out%j(size(A%j)) )

            out%i(1:nnz) = A%i(1:nnz)
            out%j = A%j
         end if
         out%a(1:nnz) = A%a(1:nnz) - u%value
      else if( A%data_type == MF_DT_SP_CMPLX ) then
         ncol = A%shape(2)
         nnz = A%j(ncol+1)-1
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%z => A%z
            out%i => A%i
            out%j => A%j
            call set_status_tempo_to_false( A )
         else
            allocate( out%z(size(A%z)) )

            allocate( out%i(size(A%i)) )

            allocate( out%j(size(A%j)) )

            out%i(1:nnz) = A%i(1:nnz)
            out%j = A%j
         end if
         out%z(1:nnz) = A%z(1:nnz) - u%value
      else
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "[B is a phys. unit (real) => A must be numeric]" )
         go to 99
      end if

      out%prop%symm = A%prop%symm

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( A%units, u%units, status )
         if( status /= 0 ) then
            call PrintMessage( "operator(-)", "E",                      &
                               "the physical dimensions of the two operands",&
                               "are not consistent!" )
            go to 99
         end if
         out%units(:) = A%units(:)
      else
         call PrintMessage( "operator(-)", "W",                         &
                            "this operation involves a type(mfUnit) object:",&
                            "you should activate physical units via the", &
                            "'msUsePhysUnits' routine!" )
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease(A)

      call mf_restore_fpe( )

#endif
   end function mfSub_mfArray_mfUnit
!_______________________________________________________________________
!
   function mfSub_mfUnit_mfArray( u, A ) result( out )

      type(mfUnit),  intent(in) :: u
      type(mfArray), intent(in) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: status, ncol, nnz

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "mfArray 'A' cannot be empty" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL .or. A%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(-)", "E",                         &
                            "this function cannot be applied to a permutation!" )
         go to 99
      end if

      out%data_type = A%data_type
      out%shape = A%shape
      if( A%data_type == MF_DT_DBLE ) then
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%double => A%double
            call set_status_tempo_to_false( A )
         else
            allocate( out%double(A%shape(1),A%shape(2)) )

         end if
         out%double = u%value - A%double
      else if( A%data_type == MF_DT_CMPLX ) then
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%cmplx => A%cmplx
            call set_status_tempo_to_false( A )
         else
            allocate( out%cmplx(A%shape(1),A%shape(2)) )

         end if
         out%cmplx = u%value - A%cmplx
      else if( A%data_type == MF_DT_SP_DBLE ) then
         ncol = A%shape(2)
         nnz = A%j(ncol+1)-1
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%a => A%a
            out%i => A%i
            out%j => A%j
            call set_status_tempo_to_false( A )
         else
            allocate( out%a(size(A%a)) )

            allocate( out%i(size(A%i)) )

            allocate( out%j(size(A%j)) )

            out%i(1:nnz) = A%i(1:nnz)
            out%j = A%j
         end if
         out%a(1:nnz) = u%value - A%a(1:nnz)
      else if( A%data_type == MF_DT_SP_CMPLX ) then
         ncol = A%shape(2)
         nnz = A%j(ncol+1)-1
         ! if the mfArray is tempo and not protected,
         ! processing is done 'in place' (avoid an allocation).
         if( can_use_memory(A) ) then
            out%z => A%z
            out%i => A%i
            out%j => A%j
            call set_status_tempo_to_false( A )
         else
            allocate( out%z(size(A%z)) )

            allocate( out%i(size(A%i)) )

            allocate( out%j(size(A%j)) )

            out%i(1:nnz) = A%i(1:nnz)
            out%j = A%j
         end if
         out%z(1:nnz) = u%value - A%z(1:nnz)
      else
         call PrintMessage( "operator(-)", "E",                         &
                            "case not handled",                         &
                            "[A is a phys. unit (real) => B must be numeric]" )
         go to 99
      end if

      out%prop%symm = A%prop%symm

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( A%units, u%units, status )
         if( status /= 0 ) then
            call PrintMessage( "operator(-)", "E",                      &
                               "the physical dimensions of the two operands",&
                               "are not consistent!" )
            go to 99
         end if
         out%units(:) = A%units(:)
      else
         call PrintMessage( "operator(-)", "W",                         &
                            "this operation involves a type(mfUnit) object:",&
                            "you should activate physical units via the", &
                            "'msUsePhysUnits' routine!" )
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease(A)

      call mf_restore_fpe( )

#endif
   end function mfSub_mfUnit_mfArray
