! f90 include file

!_______________________________________________________________________
!
   function mfPow_mfArray_int( A, n ) result( out )

      type(mfArray), intent(in) :: A
      integer,       intent(in) :: n
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! power (element-wise)

      integer :: i, status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      ! Special case of MF_END: only addition and substraction are allowed
      ! when doing arithmetic about MF_END.
      ! Cannot use mfIsEqual(A,MF_END) in the test because a previous
      ! operation on MF_END has perhaps already occured (crc modified!).
      if( all(A%shape == MF_END%shape) ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "this operator cannot be used with MF_END!" )
         return
      end if

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         ! result will be empty
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "sparse matrices cannot be handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL .or. A%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      out%shape = A%shape
      if( A%data_type == MF_DT_DBLE ) then
         out%data_type = MF_DT_DBLE
         allocate( out%double(A%shape(1),A%shape(2)) )

         out%double = A%double ** n
      else ! A is complex
         out%data_type = MF_DT_CMPLX
         allocate( out%cmplx(A%shape(1),A%shape(2)) )

         out%cmplx = A%cmplx ** n
      end if

      out%prop%tril = A%prop%tril
      out%prop%triu = A%prop%triu
      out%prop%symm = A%prop%symm

      if( mf_phys_units ) then
         do i = 1, num_base_units
            call rational_mul( A%units(i), n,                           &
                               out%units(i), status )
            if( status == 1 ) then
               call PrintMessage( "operator(**)", "E",                  &
                                  "in processing physical units:",      &
                                  "integer overflow!" )
               go to 99
            else if( status == -1 ) then
               call PrintMessage( "operator(**)", "E",                  &
                                  "in processing physical units:",      &
                                  "Please report this bug to: Edouard.Canot@univ-rennes.fr" )
               go to 99
            end if
         end do
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease(A)

      call mf_restore_fpe( )

#endif
   end function mfPow_mfArray_int
!_______________________________________________________________________
!
   function mfPow_int_mfArray( n, A ) result( out )

      integer,       intent(in) :: n
      type(mfArray), intent(in) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! power (element-wise)

      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      ! Special case of MF_END: only addition and substraction are allowed
      ! when doing arithmetic about MF_END.
      ! Cannot use mfIsEqual(A,MF_END) in the test because a previous
      ! operation on MF_END has perhaps already occured (crc modified!).
      if( all(A%shape == MF_END%shape) ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "this operator cannot be used with MF_END!" )
         return
      end if

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         ! result will be empty
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "sparse matrices cannot be handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL .or. A%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      out%shape = A%shape
      if( A%data_type == MF_DT_DBLE ) then
         if( n >= 0 ) then
            out%data_type = MF_DT_DBLE
            allocate( out%double(A%shape(1),A%shape(2)) )

            out%double = n ** A%double
         else
            out%data_type = MF_DT_CMPLX
            allocate( out%cmplx(A%shape(1),A%shape(2)) )

            out%cmplx = n ** cmplx(A%double(:,:),kind=MF_DOUBLE)
         end if
      else ! A is complex
         out%data_type = MF_DT_CMPLX
         allocate( out%cmplx(A%shape(1),A%shape(2)) )

         out%cmplx = n ** A%cmplx
      end if

      out%prop%tril = A%prop%tril
      out%prop%triu = A%prop%triu
      out%prop%symm = A%prop%symm

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( A%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(**)", "E",                     &
                               "when using the '**' operator,",         &
                               "the physical unit of the mfArray must be dimensionless!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease(A)

      call mf_restore_fpe( )

#endif
   end function mfPow_int_mfArray
!_______________________________________________________________________
!
   function mfPow_mfArray_real8( A, x ) result( out )

      type(mfArray),        intent(in) :: A
      real(kind=MF_DOUBLE), intent(in) :: x
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         ! result will be empty
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "sparse matrices cannot be handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL .or. A%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      out%shape = A%shape
      if( A%data_type == MF_DT_DBLE ) then
         if( all( A%double(:,:) >= 0.0d0 ) ) then
            out%data_type = MF_DT_DBLE
            allocate( out%double(A%shape(1),A%shape(2)) )

            out%double = A%double ** x
         else
            out%data_type = MF_DT_CMPLX
            allocate( out%cmplx(A%shape(1),A%shape(2)) )

            out%cmplx = cmplx(A%double(:,:),kind=MF_DOUBLE) ** x
         end if
      else ! A is complex
         out%data_type = MF_DT_CMPLX
         allocate( out%cmplx(A%shape(1),A%shape(2)) )

         out%cmplx = A%cmplx ** x
      end if

      out%prop%tril = A%prop%tril
      out%prop%triu = A%prop%triu
      out%prop%symm = A%prop%symm

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( A%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(**)", "E",                     &
                               "when using real power with for '**' operator,", &
                               "the physical unit of the mfArray must be dimensionless!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease(A)

      call mf_restore_fpe( )

#endif
   end function mfPow_mfArray_real8
!_______________________________________________________________________
!
   function mfPow_real8_mfArray( x, A ) result( out )

      real(kind=MF_DOUBLE), intent(in) :: x
      type(mfArray),        intent(in) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         ! result will be empty
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "sparse matrices cannot be handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL .or. A%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      out%shape = A%shape
      if( A%data_type == MF_DT_DBLE ) then
         if( x >= 0.0d0 ) then
            out%data_type = MF_DT_DBLE
            allocate( out%double(A%shape(1),A%shape(2)) )

            out%double = x ** A%double
         else
            out%data_type = MF_DT_CMPLX
            allocate( out%cmplx(A%shape(1),A%shape(2)) )

            out%cmplx = x ** cmplx(A%double(:,:),kind=MF_DOUBLE)
         end if
      else ! A is complex
         out%data_type = MF_DT_CMPLX
         allocate( out%cmplx(A%shape(1),A%shape(2)) )

         out%cmplx = x ** A%cmplx
      end if

      out%prop%tril = A%prop%tril
      out%prop%triu = A%prop%triu
      out%prop%symm = A%prop%symm

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( A%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(**)", "E",                     &
                               "when using the '**' operator,",         &
                               "the physical unit of the mfArray must be dimensionless!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease(A)

      call mf_restore_fpe( )

#endif
   end function mfPow_real8_mfArray
!_______________________________________________________________________
!
   function mfPow_mfArray_mfArray( A, B ) result( out )

      type(mfArray),        intent(in) :: A, B
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( A, B )

      if( mfIsEmpty(A) .or. mfIsEmpty(B) ) then
         ! result will be empty
         go to 99
      end if

      if( mfIsSparse(A) .or. mfIsSparse(B) ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "sparse matrices cannot be handled!" )
         go to 99
      end if

      if( a%data_type == MF_DT_BOOL .or. a%data_type == MF_DT_SP_BOOL .or. &
          b%data_type == MF_DT_BOOL .or. b%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "this function cannot be applied to a logical!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC .or. B%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      ! A and B must have the same shape
      if( any(A%shape /= B%shape) ) then
         call PrintMessage( "operator(**)", "E",                        &
                            "A and B must have the same shape!" )
         go to 99
      end if

      out%shape = A%shape
      if( A%data_type == MF_DT_DBLE ) then
         if( B%data_type == MF_DT_DBLE ) then
            if( all(A%double >= 0.0d0) ) then
               out%data_type = MF_DT_DBLE
               allocate( out%double(A%shape(1),A%shape(2)) )

               out%double = A%double ** B%double
            else
               out%data_type = MF_DT_CMPLX
               allocate( out%cmplx(A%shape(1),A%shape(2)) )

               out%cmplx = cmplx(A%double,kind=MF_DOUBLE) ** B%double
            end if
         else ! B is complex
            out%data_type = MF_DT_CMPLX
            allocate( out%cmplx(A%shape(1),A%shape(2)) )

            out%cmplx = A%double ** B%cmplx
         end if
      else ! A is complex
         out%data_type = MF_DT_CMPLX
         allocate( out%cmplx(A%shape(1),A%shape(2)) )

         if( B%data_type == MF_DT_DBLE ) then
            out%cmplx = A%cmplx ** B%double
         else ! B is complex
            out%cmplx = A%cmplx ** B%cmplx
         end if
      end if

      if( A%prop%symm == TRUE .and. B%prop%symm == TRUE ) then
         out%prop%symm = TRUE
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( A%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(**)", "E",                     &
                               "when using the '**' operator,",         &
                               "the physical unit of the mfArray must be dimensionless!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A, B )
      call msAutoRelease( A, B )

      call mf_restore_fpe( )

#endif
   end function mfPow_mfArray_mfArray
