! f90 include file

!_______________________________________________________________________
!
   function mfLess_mfArray_mfArray( a, b ) result( out )

      type(mfArray), intent(in) :: a, b
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( a, b )

      if( mfIsEmpty(a) ) then
         call PrintMessage( "operator(<=)", "W",                        &
                            "left arg is an empty mfArray!" )
         go to 99
      end if

      if( mfIsEmpty(b) ) then
         call PrintMessage( "operator(<=)", "W",                        &
                            "right arg is an empty mfArray!" )
         go to 99
      end if

      if( a%data_type == MF_DT_BOOL .or. a%data_type == MF_DT_SP_BOOL .or. &
          b%data_type == MF_DT_BOOL .or. b%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(<=)", "E",                        &
                            "this operator cannot be applied to logical!" )
         go to 99
      end if

      if( a%data_type == MF_DT_PERM_VEC .or. b%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(<=)", "E",                        &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( mfIsSparse(a) .or. mfIsSparse(b) ) then
         call PrintMessage( "<=", "E",                                  &
                            "sparse matrices not yet supported!" )
         go to 99
      end if

      if( any( a%shape /= b%shape ) ) then
         call PrintMessage( "operator(<=)", "E",                        &
                            "args must have the same shape!" )
         go to 99
      end if

      if( a%data_type == MF_DT_CMPLX .or. b%data_type == MF_DT_CMPLX ) then
         call PrintMessage( "operator(<=)", "W",                        &
                            "at least one arg is of complex type!",     &
                            "Result will be an mfArray with false values." )
         out%shape = a%shape
         allocate( out%double(out%shape(1),out%shape(2)) )

         out%double = FALSE
         out%data_type = MF_DT_BOOL
         out%status_temporary = .true.
         go to 99
      end if

      out%data_type = MF_DT_BOOL
      out%shape = a%shape
      allocate( out%double(out%shape(1),out%shape(2)) )

      where( a%double <= b%double )
         out%double = TRUE
      elsewhere
         out%double = FALSE
      end where

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, b%units, status )
         if( status /= 0 ) then
            call PrintMessage( "operator(<=)", "E",                     &
                               "the physical dimensions of the two mfArray's",&
                               "are not consistent!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a, b )

      call msAutoRelease( a, b )

#endif
   end function mfLess_mfArray_mfArray
!_______________________________________________________________________
!
   function mfLess_mfArray_real8( a, x ) result( out )

      type(mfArray),        intent(in) :: a
      real(kind=MF_DOUBLE), intent(in) :: x
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( a )

      if( mfIsEmpty(a) ) then
         call PrintMessage( "operator(<=)", "W",                        &
                            "left arg is an empty mfArray!" )
         go to 99
      end if

      if( a%data_type == MF_DT_BOOL .or. a%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(<=)", "E",                        &
                            "this operator cannot be applied to logical!" )
         go to 99
      end if

      if( a%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(<=)", "E",                        &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( a%data_type == MF_DT_CMPLX ) then
         call PrintMessage( "operator(<=)", "W",                        &
                            "first arg is of complex type!",            &
                            "Result will be an mfArray with false values." )
         out%shape = a%shape
         allocate( out%double(out%shape(1),out%shape(2)) )

         out%double = FALSE
         out%data_type = MF_DT_BOOL
         out%status_temporary = .true.
         go to 99
      end if

      if( a%data_type == MF_DT_DBLE ) then
         out%data_type = MF_DT_BOOL
         out%shape = a%shape
         allocate( out%double(out%shape(1),out%shape(2)) )

         where( a%double <= x )
            out%double = TRUE
         elsewhere
            out%double = FALSE
         end where
      else if( a%data_type == MF_DT_SP_DBLE ) then
         out%data_type = MF_DT_SP_BOOL
         out%shape = a%shape
         !### sorting is required before calling 'apply_bin_ops_to_sp_dble'
         call msRowSort( A )
         call apply_bin_ops_to_sp_dble( A%shape(1), A%shape(2),         &
                                        A%a, A%i, A%j,                  &
                                        ".le.", x, out%a, out%i, out%j )
      else if( a%data_type == MF_DT_SP_CMPLX ) then
         out%data_type = MF_DT_SP_BOOL
         out%shape = a%shape
!!         call apply_log_ops_to_sp_cmplx( ... )
stop "[DBG FML] Less.inc: line 163: mfLess_mfArray_real8 not finished for data type MF_DT_SP_CMPLX"
      end if

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(<=)", "E",                     &
                               "the physical dimensions of the two mfArray's",&
                               "are not consistent!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a )

      call msAutoRelease( a )

#endif
   end function mfLess_mfArray_real8
!_______________________________________________________________________
!
   function mfLess_mfArray_int( a, x ) result( out )

      type(mfArray), intent(in) :: a
      integer,       intent(in) :: x
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( a )

      if( mfIsEmpty(a) ) then
         call PrintMessage( "operator(<=)", "W",                        &
                            "left arg is an empty mfArray!" )
         go to 99
      end if

      if( a%data_type == MF_DT_BOOL .or. a%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "operator(<=)", "E",                        &
                            "this operator cannot be applied to logical!" )
         go to 99
      end if

      if( a%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "operator(<=)", "E",                        &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( mfIsSparse(a)  ) then
         call PrintMessage( "<=", "E",                                  &
                            "sparse matrices not yet supported!" )
         go to 99
      end if

      if( a%data_type == MF_DT_CMPLX ) then
         call PrintMessage( "operator(<=)", "W",                        &
                            "first arg is of complex type!",            &
                            "Result will be an mfArray with false values." )
         out%shape = a%shape
         allocate( out%double(out%shape(1),out%shape(2)) )

         out%double = FALSE
         out%data_type = MF_DT_BOOL
         out%status_temporary = .true.
         go to 99
      end if

      out%data_type = MF_DT_BOOL
      out%shape = a%shape
      allocate( out%double(out%shape(1),out%shape(2)) )

      where( a%double <= dble(x) )
         out%double = TRUE
      elsewhere
         out%double = FALSE
      end where

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "operator(<=)", "E",                     &
                               "the physical dimensions of the two mfArray's",&
                               "are not consistent!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a )

      call msAutoRelease( a )

#endif
   end function mfLess_mfArray_int
