! f90 include file

!_______________________________________________________________________
!
   function mfColon_int( start, end, step ) result( out )

      integer, intent(in)           :: start, end
      integer, intent(in), optional :: step

      type(mfArray)                 :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: h_size, i
      integer :: step0

   !------ end of declarations -- execution starts hereafter  ------

      if( present(step) ) then

         if( step == 0 ) then
            call PrintMessage( "mfColon", "W",                          &
                               "'step' cannot be equal to zero!",       &
                               "-> result will be an empty mfArray." )
            return
         end if

         if( (start > end) .and. step > 0 ) then
            call PrintMessage( "mfColon", "W",                          &
                               "sign of 'step' must be the same as those of 'end-start'!", &
                               "-> result will be an empty mfArray." )
            return
         end if

         step0 = step

      else

         if( start > end ) then
            call PrintMessage( "mfColon", "W",                          &
                               "'start' is greater than 'end'!",        &
                               "-> result will be an empty mfArray." )
            return
         end if

         step0 = 1

      end if

      ! size of returned array
      h_size = int( dble(end - start)/dble(step0) )
      h_size = h_size + 1

      out%data_type = MF_DT_DBLE
      out%shape = [ 1, h_size ]
      allocate( out%double(1,h_size) )

      do i = 1, h_size
         out%double(1,i) = start + step0*(i-1)
      end do

      out%status_temporary = .true.

#endif
   end function mfColon_int
!_______________________________________________________________________
!
   function mfColon_single( start, end, step, tol ) result( out )

      real, intent(in)           :: start, end
      real, intent(in), optional :: step, tol

      type(mfArray)              :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: h_size, i
      real :: step0, raw_h_size

   !------ end of declarations -- execution starts hereafter  ------

      if( present(step) ) then

         if( start < end ) then

            if( step <= 0.0 ) then
               call PrintMessage( "mfColon", "W",                       &
                                  "bad value for 'step'!",              &
                                  "-> result will be an empty mfArray." )
               return
            end if

         else ! end <= start

            if( 0.0 <= step ) then
               call PrintMessage( "mfColon", "W",                       &
                                  "bad value for 'step'!",              &
                                  "-> result will be an empty mfArray." )
               return
            end if

         end if

         step0 = step

      else

         if( start > end ) then
            call PrintMessage( "mfColon", "W",                          &
                               "'start' is greater than 'end'!",        &
                               "-> result will be an empty mfArray." )
            return
         end if

         step0 = 1.0

      end if

      ! size of returned array
      if( present(tol) ) then
         if( tol <= 0. ) then
            call PrintMessage( "mfColon", "W",                          &
                               "'tol' must be strictly positive!",      &
                               "-> it will be ignored." )
         end if
         if( tol <= 1.0e-6 ) then
            call PrintMessage( "mfColon", "W",                          &
                               "'tol' appears to be too much stringent w.r.t. the", &
                               "numerical precision of the arguments!",           &
                               "-> try to use double precision args." )
         end if
         raw_h_size = (end - start)/step0
         if( abs(raw_h_size-nint(raw_h_size)) <= tol ) then
            h_size = nint(raw_h_size) + 1
         else
            h_size = int( (end - start)/step0 ) + 1
         end if
      else
         h_size = int( (end - start)/step0 ) + 1
      end if

      out%data_type = MF_DT_DBLE
      out%shape = [ 1, h_size ]
      allocate( out%double(1,h_size) )

      do i = 1, h_size
         out%double(1,i) = start + step0*(i-1)
      end do

      if( present(tol) ) then
         call digit_round( out%double(1,:), dble(tol) )
      end if

      out%status_temporary = .true.

#endif
   end function mfColon_single
!_______________________________________________________________________
!
   function mfColon_double( start, end, step, tol ) result( out )

      real(kind=MF_DOUBLE), intent(in)           :: start, end
      real(kind=MF_DOUBLE), intent(in), optional :: step, tol

      type(mfArray)                              :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: h_size, i
      real(kind=MF_DOUBLE) :: step0, raw_h_size

   !------ end of declarations -- execution starts hereafter  ------

      if( present(step) ) then

         if( start < end ) then

            if( step <= 0.0d0 ) then
               call PrintMessage( "mfColon", "W",                       &
                                  "bad value for 'step'!",              &
                                  "-> result will be an empty mfArray." )
               return
            end if

         else ! end <= start

            if( 0.0d0 <= step ) then
               call PrintMessage( "mfColon", "W",                       &
                                  "bad value for 'step'!",              &
                                  "-> result will be an empty mfArray." )
               return
            end if

         end if

         step0 = step

      else

         if( start > end ) then
            call PrintMessage( "mfColon", "W",                          &
                               "'start' is greater than 'end'!",        &
                               "-> result will be an empty mfArray." )
            return
         end if

         step0 = 1.0d0

      end if

      ! size of returned array
      if( present(tol) ) then
         if( tol <= 0. ) then
            call PrintMessage( "mfColon", "W",                          &
                               "'tol' must be strictly positive!",      &
                               "-> it will be ignored." )
         end if
         raw_h_size = (end - start)/step0
         if( abs(raw_h_size-nint(raw_h_size)) <= tol ) then
            h_size = nint(raw_h_size) + 1
         else
            h_size = int( (end - start)/step0 ) + 1
         end if
      else
         h_size = int( (end - start)/step0 ) + 1
      end if

      out%data_type = MF_DT_DBLE
      out%shape = [ 1, h_size ]
      allocate( out%double(1,h_size) )

      do i = 1, h_size
         out%double(1,i) = start + step0*(i-1)
      end do

      if( present(tol) ) then
         call digit_round( out%double(1,:), tol )
      end if

      out%status_temporary = .true.

#endif
   end function mfColon_double
