! f90 include file

!_______________________________________________________________________
!
   function mfCTranspose_mfArray( x ) result( out )

      type(mfArray), intent(in) :: x
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      if( x%data_type == MF_DT_EMPTY ) then
         call PrintMessage( "mfCTranspose", "E",                        &
                            "unallocated array arg.!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL .or. x%data_type == MF_DT_SP_BOOL ) then
         call PrintMessage( "mfCTranspose", "E",                        &
                            "cannot take conjugate transpose",          &
                            "of a logical array!" )
         go to 99
      end if

      if( x%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfCTranspose", "E",                        &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( x%data_type == MF_DT_DBLE ) then
         out%shape(1) = x%shape(2)
         out%shape(2) = x%shape(1)
         out%data_type = MF_DT_DBLE
         allocate( out%double(out%shape(1),out%shape(2)) )

         out%double = transpose( x%double )
      else if( x%data_type == MF_DT_CMPLX ) then
         if( x%prop%symm == TRUE ) then
            out = x
            out%status_temporary = .true.
            go to 99
         else
            call msAssign( out, mfConj( mf(transpose( x%cmplx )) ) )
         end if
      else if( x%data_type == MF_DT_SP_DBLE ) then
         call PrintMessage( "mfCTranspose", "E",                        &
                            "taking conjugate transpose of a real array!",&
                            "Did you thought .t. operator?" )
         go to 99
      else if( x%data_type == MF_DT_SP_CMPLX ) then
         out%shape(1) = x%shape(2)
         out%shape(2) = x%shape(1)
         out%data_type = MF_DT_SP_CMPLX
         allocate( out%z(size(x%z)) )

         allocate( out%i(size(x%i)) )

         allocate( out%j(out%shape(2)+1) )

         if( x%prop%symm == TRUE ) then
            out%i = x%i
            out%j = x%j
            out%z = x%z
            out%row_sorted = x%row_sorted
         else
            call csc_ctransp_cmplx( x%shape(1), x%shape(2), x%z, x%i, x%j, &
                                    out%z, out%i, out%j )
            out%row_sorted = TRUE
         end if
      else
         write(STDERR,*) "(MUESLI mfCTranspose:) internal error: unknown data type!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( x%prop%tril == TRUE ) then
         out%prop%triu = TRUE
      end if
      if( x%prop%triu == TRUE ) then
         out%prop%tril = TRUE
      end if
      out%prop%symm = x%prop%symm
      out%prop%posd = x%prop%posd

      if( mf_phys_units ) then
         out%units(:) = x%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msAutoRelease(x)

#endif
   end function mfCTranspose_mfArray
!_______________________________________________________________________
!
   function mfCTranspose_vec_cmplx8( x ) result( out )

      complex(kind=MF_DOUBLE), intent(in) :: x(:)
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      call msAssign( out, mfCTranspose_mfArray( mf(x) ))

      out%prop%symm = FALSE

      out%status_temporary = .true.

#endif
   end function mfCTranspose_vec_cmplx8
!_______________________________________________________________________
!
   function mfCTranspose_array_cmplx8( x ) result( out )

      complex(kind=MF_DOUBLE), intent(in) :: x(:,:)
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      call msAssign( out, mfCTranspose_mfArray( mf(x) ))

      out%status_temporary = .true.

#endif
   end function mfCTranspose_array_cmplx8
