! f90 include file

!_______________________________________________________________________
!
   subroutine msSvd( out, A, economy_size )

      type(mfArray) :: A
      logical, intent(in), optional :: economy_size
      type(mf_Out) :: out
      !------ API end ------
#ifdef _DEVLP

      type(mfArray), pointer :: U, S, V

      character(len=1) :: ljobu, ljobvt
      integer :: i, m, n, info, lwork
      real(kind=MF_DOUBLE), allocatable :: work(:), ss(:), rwork(:)
      complex(kind=MF_DOUBLE), allocatable :: cwork(:)
      type(mfArray) :: A_copy
      character(len=3) :: info_char

      logical :: eco


   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( A )

      ! 3 out-args must be specified
      if( out%n /= 3 ) then
         call PrintMessage( "msSvd", "E",                               &
                            "three output args required!",             &
                            "syntax is : call msSvd ( mfOut(U,S,V), A )" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, a ) ) then
         call PrintMessage( "msSvd", "E",                               &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if

      U => out%ptr1
      S => out%ptr2
      V => out%ptr3
      call msSilentRelease( U, S, V )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "msSvd", "E",                               &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "msSvd", "E",                               &
                            "sparse matrices not yet handled!" )
         go to 99
      end if

      if( .not. all(mfIsFinite(A)) ) then
         call PrintMessage( "msSvd", "E",                               &
                            "mfArray 'A' must not contain Inf or NaN values!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSvd", "E",                               &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "msSvd", "E",                               &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%shape(1) <= 1 .or. A%shape(2) <= 1 ) then
         call PrintMessage( "msSvd", "E",                               &
                            "mfArray 'A' should be a matrix!" )
         go to 99
      end if

      if( present(economy_size) ) then
         eco = economy_size
      else
         eco = .false.
      end if

      m = A%shape(1)
      n = A%shape(2)

      if( eco ) then ! economy size
         U%shape = [ m, min(m,n) ]
         V%shape = [ min(m,n), n ]
      else
         U%shape = [ m, m ]
         V%shape = [ n, n ]
      end if

      ! making copies because LAPACK overwrites A
      call msAssign( A_copy, A )

      if( A%data_type == MF_DT_DBLE ) then
         ! General system -- real matrix : DGESVD
         U%data_type = MF_DT_DBLE
         V%data_type = MF_DT_DBLE

         if( eco ) then ! economy size
            ljobu = "S" ! first min(m,n) columns of U are stored
            allocate( U%double( m, min(m,n) ) )

            ljobvt = "S" ! first min(m,n) rows of Vt are stored
            allocate( V%double( min(m,n), n ) )

         else
            ljobu = "A" ! all columns of U are computed
            allocate( U%double( m, m ) )

            ljobvt = "A" ! all rows of Vt are computed
            allocate( V%double( n, n ) )

         end if
         lwork = max(3*min(m,n)+max(m,n),5*min(m,n)) ! minimum required
         lwork = 2*lwork                        ! for good performances
         allocate( work(lwork) )

         allocate( ss(min(m,n)) )

         if( eco ) then ! economy size
            call dgesvd( ljobu, ljobvt, m, n, A_copy%double(1,1), m,    &
                         ss(1), u%double(1,1), m, v%double(1,1), min(m,n), &
                         work(1), lwork, info )
         else
            call dgesvd( ljobu, ljobvt, m, n, A_copy%double(1,1), m,    &
                         ss(1), u%double(1,1), m, v%double(1,1), n,     &
                         work(1), lwork, info )
         end if
         if( info /= 0 ) then
            ! solution is not ok -- light warning
            write(info_char,"(I0)") info
            call PrintMessage( "msSvd", "W",                            &
                               "in SVD-factorizing matrix A by LAPACK:",  &
                               "info = " // info_char,                  &
                               "(as a side effect, U, S and V will be empty)" )
            call msSilentRelease( U, V )
         else
            call msAssign( V, .t. V )
            if( eco ) then ! economy size
               call msAssign( S, mfZeros(min(m,n),min(m,n)) )
            else
               call msAssign( S, mfZeros(m,n) )
            end if
            do i = 1, min(m,n)
               S%double(i,i) = ss(i)
            end do
         end if

      else if( A%data_type == MF_DT_CMPLX ) then
         ! General system -- complex matrix : ZGESVD
         U%data_type = MF_DT_CMPLX
         V%data_type = MF_DT_CMPLX

         if( eco ) then ! economy size
            ljobu = "S" ! first min(m,n) columns of U are stored
            allocate( U%cmplx( m, min(m,n) ) )

            ljobvt = "S" ! first min(m,n) rows of Vt are stored
            allocate( V%cmplx( min(m,n), n ) )

         else
            ljobu = "A" ! all columns of U are computed
            allocate( U%cmplx( m, m ) )

            ljobvt = "A" ! all rows of Vt are computed
            allocate( V%cmplx( n, n ) )

         end if
         lwork = 2*min(m,n)+max(m,n) ! minimum required
         lwork = 4*lwork             ! for good performances
                 ! warning: the '4' factor above is necessary
         allocate( cwork(lwork) )

         allocate( ss(min(m,n)) )

         allocate( rwork(5*min(m,n)) )

         if( eco ) then ! economy size
            call zgesvd( ljobu, ljobvt, m, n, A_copy%cmplx(1,1), m,     &
                         ss(1), u%cmplx(1,1), m, v%cmplx(1,1), min(m,n), &
                         cwork(1), lwork, rwork(1), info )
         else
            call zgesvd( ljobu, ljobvt, m, n, A_copy%cmplx(1,1), m,     &
                         ss(1), u%cmplx(1,1), m, v%cmplx(1,1), n,       &
                         cwork(1), lwork, rwork(1), info )
         end if
         if( info /= 0 ) then
            ! solution is not ok -- light warning
            write(info_char,"(I0)") info
            call PrintMessage( "msSvd", "W",                            &
                               "in SVD-factorizing matrix A by LAPACK:", &
                               "info = " // info_char,                  &
                               "(as a side effect, U, S and V will be empty)" )
            call msSilentRelease( U, V )
            call msSilentRelease( A_copy )
            go to 99
         else
            call msAssign( V, .h. V)
            if( eco ) then ! economy size
               call msAssign( S, mfZeros(min(m,n),min(m,n)) )
            else
               call msAssign( S, mfZeros(m,n) )
            end if
            do i = 1, min(m,n)
               S%double(i,i) = ss(i)
            end do
         end if

      else if( mfIsSparse(A) ) then

         call PrintMessage( "msSvd", "E",                               &
                            "for sparse matrices, please use 'msSVDs'!" )
         go to 99

      else

         call PrintMessage( "msSvd", "E",                               &
                            "unknown data type for 'A'!" )
         go to 99

      end if

      call msSilentRelease( A_copy )

      S%prop%tril = TRUE
      S%prop%triu = TRUE

      if( mf_phys_units ) then
         S%units(:) = A%units(:)
      end if

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

      call mf_restore_fpe( )

#endif
   end subroutine msSvd
!_______________________________________________________________________
!
   function mfSvd( A ) result( S )

      type(mfArray) :: A
      type(mfArray) :: S
      !------ API end ------
#ifdef _DEVLP

      real(kind=MF_DOUBLE) :: u_dum_r(1,1), v_dum_r(1,1)
      complex(kind=MF_DOUBLE) :: u_dum_c(1,1), v_dum_c(1,1)

      character(len=1) :: ljobu, ljobvt
      integer :: i, k, m, n, info, lwork
      real(kind=MF_DOUBLE), allocatable :: work(:), ss(:), rwork(:)
      complex(kind=MF_DOUBLE), allocatable :: cwork(:)
      type(mfArray) :: A_copy
      character(len=3) :: info_char
      integer :: mf_message_level_save

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfSvd", "E",                               &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfSvd", "E",                               &
                            "sparse matrices not yet handled!" )
         go to 99
      end if

      if( .not. all(mfIsFinite(A)) ) then
         call PrintMessage( "mfSvd", "E",                               &
                            "mfArray 'A' must not contain Inf or NaN values!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfSvd", "E",                               &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfSvd", "E",                               &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%shape(1) <= 1 .or. A%shape(2) <= 1 ) then
         call PrintMessage( "mfSvd", "E",                               &
                            "mfArray 'A' should be a matrix!" )
         go to 99
      end if

      m = A%shape(1)
      n = A%shape(2)

      ! making copies because LAPACK overwrites A
      mf_message_level_save = mf_message_level
      mf_message_level = 0
      A_copy = A
      mf_message_level = mf_message_level_save

      if( A%data_type == MF_DT_DBLE ) then

         ! General system -- real matrix : DGESVD
         ljobu = "N" ! no columns of U are computed
         ljobvt = "N" ! no rows of Vt are computed
         lwork = max(3*min(m,n)+max(m,n),5*min(m,n)) ! minimum required
         lwork = 2*lwork                        ! for good performances
         allocate( work(lwork) )

         allocate( ss(min(m,n)) )

         call dgesvd( ljobu, ljobvt, m, n, A_copy%double(1,1), m,       &
                      ss(1), u_dum_r(1,1), 1, v_dum_r(1,1), 1,          &
                      work(1), lwork, info )
         if( info /= 0 ) then
            ! solution is not ok -- light warning
            write(info_char,"(I0)") info
            call PrintMessage( "mfSvd", "W",                            &
                               "in SVD-factorizing matrix A by LAPACK:", &
                               "info = " // info_char,                  &
                               "(as a side effect, S will be empty)" )
         else
            k = min(m,n)
            call msAssign( S, mfZeros(k,1))
            do i = 1, k
               S%double(i,1) = ss(i)
            end do
         end if

      else if( A%data_type == MF_DT_CMPLX ) then

         ! General system -- complex matrix : ZGESVD
         ljobu = "N" ! no columns of U are computed
         ljobvt = "N" ! no rows of Vt are computed
         lwork = 2*min(m,n)+max(m,n) ! minimum required
         lwork = 2*lwork             ! for good performances
         allocate( cwork(lwork) )

         allocate( ss(min(m,n)) )

         allocate( rwork(5*min(m,n)) )

         call zgesvd( ljobu, ljobvt, m, n, A_copy%cmplx(1,1), m,        &
                      ss(1), u_dum_c(1,1), 1, v_dum_c(1,1), 1,          &
                      cwork(1), lwork, rwork(1), info )
         if( info /= 0 ) then
            ! solution is not ok -- light warning
            write(info_char,"(I0)") info
            call PrintMessage( "mfSvd", "W",                            &
                               "in SVD-factorizing matrix A by LAPACK:", &
                               "info = " // info_char,                  &
                               "(as a side effect, S will be empty)" )
            call msSilentRelease( S )
            call msSilentRelease( A_copy )
            go to 99
         else
            k = min(m,n)
            call msAssign( S, mfZeros(k,1))
            do i = 1, k
               S%double(i,1) = ss(i)
            end do
         end if

      else if( mfIsSparse(A) ) then

         call PrintMessage( "mfSvd", "E",                               &
                            "for sparse matrices, please use 'mfSVDs'!" )
         go to 99

      else

         call PrintMessage( "mfSvd", "E",                               &
                            "unknown data type for 'A'!" )
         go to 99

      end if

      call msSilentRelease( A_copy )

      if( mf_phys_units ) then
         S%units(:) = A%units(:)
      end if

      S%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

      call mf_restore_fpe( )

#endif
   end function mfSvd
