! f90 include file

!_______________________________________________________________________
!
   function mfSqrtm( A ) result( out )

      type(mfArray) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! principal square root of the matrix A,
      ! i.e. find X such that X*X = A
      ! (from Matlab-6.5.2 : sqrtm.m)

      type(mfArray) :: Q, T, R
      real(kind=MF_DOUBLE) :: s
      integer :: i, j, k, n
      logical :: bool

      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfSqrtm", "E",                             &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfSqrtm", "E",                             &
                            "sparse matrices not yet handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfSqrtm", "E",                             &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfSqrtm", "E",                             &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%shape(1) <= 1 .or. A%shape(2) <= 1 ) then
         call PrintMessage( "mfSqrtm", "E",                             &
                            "mfArray 'A' should be a matrix!" )
         go to 99
      end if

      ! square matrix ?
      if( A%shape(1) /= A%shape(2) ) then
         call PrintMessage( "mfSqrtm", "E",                             &
                            "'A' must be a square matrix!" )
         go to 99
      end if

      n = size(A,1)
      call msSchur( mfOut(Q,T), A )
      call rsf2csf(Q,T)
!### TODO 2: bizarre: pourquoi cette seconde forme est plus lente ?
!!call msSchur( mfOut(Q,T), A, form="complex" )

      ! Check if T is diagonal.
      if( mfIsDiag(T) ) then

         ! Square root always exists.
         call msAssign( R, mfDiag( mfSqrt( mfDiag(T) ) ) )

      else

         ! Compute upper triangular square root R of T,
         ! one column at a time.
         call msAssign( R, mfComplex( mfZeros(n,n) ))
         do j = 1, n
            R%cmplx(j,j) = sqrt( T%cmplx(j,j) )
            do i = j-1, 1, -1
               s = 0.0d0
               do k = i+1, j-1
                  s = s + R%cmplx(i,k)*R%cmplx(k,j)
               end do
               R%cmplx(i,j) = (T%cmplx(i,j)-s)/(R%cmplx(i,i)+R%cmplx(j,j))
            end do
         end do

      end if

      call msAssign( out, mfMul( Q, mfMul(R,.h.Q) ))

      ! If imaginary part is very small, convert matrix into real one
!NEW: attention, pas le même test que matlab-R2014b !
      bool = mfDble(mfNorm(mfImag(out),1)) <=                           &
             1000.0d0*MF_EPS*mfDble(mfNorm(out,1))
      if( bool ) then
         call msAssign( out, mfReal(out))
      end if

      if( mf_phys_units ) then
         do i = 1, num_base_units
            call rational_div( a%units(i), 2,                           &
                               out%units(i), status )
            if( status == 1 ) then
               call PrintMessage( "mfSqrtm", "E",                       &
                                  "in processing physical units:",      &
                                  "integer overflow!" )
               go to 99
            else if( status == -1 ) then
               call PrintMessage( "mfSqrtm", "E",                       &
                                  "in processing physical units:",      &
                                  "Please report this bug to: Edouard.Canot@univ-rennes.fr" )
               go to 99
            end if
         end do
      end if

      out%prop%tril = A%prop%tril
      out%prop%triu = A%prop%triu
      out%status_temporary = .true.

      call msSilentRelease( Q, T, R )

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end function mfSqrtm
