! f90 include file

!_______________________________________________________________________
!
   subroutine msRref( out, A, tol )

      type(mfArray)                  :: A
      real(kind=MF_DOUBLE), optional :: tol
      type(mf_Out)                   :: out
      !------ API end ------
#ifdef _DEVLP

      ! RREF   Reduced row echelon form.
      ! (from MATLAB-7.4: rref.m)

      type(mfArray), pointer :: R, jpiv

      type(mfArray) :: p, k, num, den
      real(kind=MF_DOUBLE) :: tolerance
      integer :: i, j, m, n, kk
      logical :: rats

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      ! 2 out-args must be specified
      if( out%n /= 2 ) then
         call PrintMessage( "msRref", "E",                              &
                            "two output args required!",               &
                            "syntax is : call msRref ( mfOut(R,jpiv), A )" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, a ) ) then
         call PrintMessage( "msRref", "E",                              &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if

      R => out%ptr1
      jpiv => out%ptr2
      call msSilentRelease( R, jpiv )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "msRref", "E",                              &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "msRref", "E",                              &
                            "sparse matrices not yet handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msRref", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "msRref", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%shape(1) <= 1 .or. A%shape(2) <= 1 ) then
         call PrintMessage( "msRref", "E",                              &
                            "mfArray 'A' should be a matrix!" )
         go to 99
      end if

      m = A%shape(1)
      n = A%shape(2)

      if( present(tol) ) then
         ! Be aware that tolerance cannot be too small
         tolerance = max( tol, MF_EPS )
         tolerance = max(m,n) * tolerance * mfDble(mfNorm(A,'inf'))
      else
         tolerance = max(m,n) * MF_EPS * mfDble(mfNorm(A,'inf'))
      end if

      ! Does it appear that elements of A are ratios of small integers?
      call msRat( mfOut(num,den), A )
      rats = mfIsEqual( A, num/den )

      call msAssign( R, A )

      ! Loop over the entire matrix.
      i = 1
      j = 1
      do while( i <= m .and. j <= n )
         ! Find value and index of largest element in the remainder
         ! of column j.
         call msMax( mfOut(p,k), mfAbs(mfGet( R, i .to. m, j )) )
         kk = mfInt(k)
         kk = kk + i - 1
         if( mfDble(p) <= tolerance ) then
            ! The column is negligible, zero it out.
            R%double(i:m,j) = 0.0d0
            j = j + 1
         else
            ! Remember column index
            call msAssign( jpiv, jpiv .hc. mf(j))
            ! Swap i-th and k-th rows.
            R%double( [i,kk], j:n ) = R%double( [kk,i], j:n )
            ! Divide the pivot row by the pivot element.
            R%double(i,j:n) = R%double(i,j:n)/R%double(i,j)
            ! Subtract multiples of the pivot row from all the other rows.
            do kk = 1, i-1
               R%double(kk,j:n) = R%double(kk,j:n) - R%double(kk,j)*R%double(i,j:n)
            end do
            do kk = i+1, m
               R%double(kk,j:n) = R%double(kk,j:n) - R%double(kk,j)*R%double(i,j:n)
            end do
            i = i + 1
            j = j + 1
         end if

      end do

      if( rats ) then
         call msRat( mfOut(num,den), R )
         call msAssign( R, num/den )
      end if

      call msSilentRelease( p, k, num, den )

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end subroutine msRref
