! f90 include file

!_______________________________________________________________________
!
   function mfRank( A, tol ) result( out )

      type(mfArray)                  :: A
      real(kind=MF_DOUBLE), optional :: tol
      type(mfArray)                  :: out
      !------ API end ------
#ifdef _DEVLP

      type(mfArray) :: S
      integer :: m, n, i
      real(kind=MF_DOUBLE) :: etol

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfRank", "E",                              &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfRank", "E",                              &
                            "sparse matrices not handled!",            &
                            "use mfSVDS() and examine singular values." )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfRank", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfRank", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%shape(1) <= 1 .or. A%shape(2) <= 1 ) then
         ! for a scalar or a vector, rank is always 1
         out = 1
         out%prop%symm = TRUE
         out%status_temporary = .true.
         go to 99
      end if

      m = a%shape(1)
      n = a%shape(2)

      call msAssign( S, mfSvd( A ))

      if( present(tol) ) then
         etol = tol
      else
         ! sigma_1(A) is equal to norm(A,2)
         etol = max(m,n) * S%double(1,1) * MF_EPS
      end if

      ! find number of singular values that are greater than 'tol'
      out = 0.0d0
      do i = 1, min(m,n)
         if( S%double(i,1) > etol ) then
            call msAssign( out, out + 1.0d0)
         end if
      end do

      out%prop%symm = TRUE

      out%status_temporary = .true.

      call msSilentRelease( S )

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end function mfRank
