! f90 include file

!_______________________________________________________________________
!
   function mfOrth( A ) result( out )

      type(mfArray) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! Orthonormal basis for the range
      ! (from Matlab-6.5.2 : orth.m)

      type(mfArray) :: U, S, V, D
      real(kind=MF_DOUBLE) :: tol
      integer :: i, m, n, r

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfOrth", "E",                              &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfOrth", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfOrth", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      m = A%shape(1)
      n = A%shape(2)

      call msSVD( mfOut(U,S,V), A )
      if( m >= 1 ) then
         call msAssign( D, mfDiag(S))
      else
         D = 0.0d0
      end if
      tol = max(m,n) * MF_EPS * mfDble(mfMax(D))
      r = mfInt( mfCount( D > tol ) )
      if( r >= 1 ) then
         call msAssign( out, mfGet( U, MF_COLON, [(i,i=1,r)] ))
         out%status_temporary = .true.
      end if

      call msSilentRelease( U, S, V, D )

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end function mfOrth
