! f90 include file

!_______________________________________________________________________
!
   function mfNull( A, rational, tol ) result( out )

      type(mfArray)                  :: A
      logical,              optional :: rational
      real(kind=MF_DOUBLE), optional :: tol
      type(mfArray)                  :: out
      !------ API end ------
#ifdef _DEVLP

      ! Orthonormal basis for the null space
      ! (from Matlab-6.5.2: null.m)

      ! extended to the Rational basis (from Matlab-8.4.0: null.m)

      type(mfArray) :: U, S, V, D
      real(kind=MF_DOUBLE) :: tolerance
      integer :: i, m, n, r

      logical :: rat
      type(mfArray) :: RR, jpiv, nopiv
!### TODO 2: workaround (see below)
integer, allocatable :: i_nopiv(:), i_jpiv(:)

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfNull", "E",                              &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfNull", "E",                              &
                            "sparse matrices not yet handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfNull", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfNull", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( present(rational) ) then
         rat = rational
      else
         rat = .false.
      end if

      m = A%shape(1)
      n = A%shape(2)

      if( rat ) then

         if( present(tol) ) then
            call msRref( mfOut(RR,jpiv), A, tol )
         else
            call msRref( mfOut(RR,jpiv), A )
         end if
         r = size(jpiv)
         if( r == 0 ) then
            ! for a zero matrix, the null space is the identity matrix
            call msAssign( out, mfEye(n,n) )
         else
            call msAssign( out, mfZeros(n,n-r) )
            if( n > r ) then
!### TODO 2: msSet should be extended to other combination of argument types
!          (see below)
allocate( i_jpiv(r) )
i_jpiv(:) = jpiv
               call msAssign( nopiv, mfColon(1,n) )
               call msSet( MF_EMPTY, nopiv, jpiv )
allocate( i_nopiv(n-r) )
i_nopiv(:) = nopiv
!!call msSet( mfEye(n-r,n-r), out, nopiv, MF_COLON ) ! don't work
!!call msSet( mfEye(n-r,n-r), out, nopiv, [(i,i=1,n-r)] ) ! don't work
!!call msSet( mfEye(n-r,n-r), out, nopiv, 1.to.n-r ) ! don't work
               call msSet( mfEye(n-r,n-r), out, i_nopiv, MF_COLON )
               if( r > 0 ) then
!!call msSet( -mfGet(RR,1.to.r,nopiv), out, jpiv, MF_COLON ) ! don't work
                  call msSet( -mfGet(RR,1.to.r,nopiv), out, i_jpiv, MF_COLON )
               end if
            end if
         end if

         call msSilentRelease( RR, jpiv, nopiv )

      else

         call msSVD( mfOut(U,S,V), A )
         if( m >= 1 ) then
            call msAssign( D, mfDiag(S) )
         else
            D = 0.0d0
         end if
         if( present(tol) ) then
            tolerance = tol
         else
            tolerance = max(m,n) * MF_EPS * mfDble(mfMax(D))
         end if
         r = mfInt( mfCount( D > tolerance ) )

         if( r+1 <= n ) then
            call msAssign( out, mfGet( V, MF_COLON, [(i,i=r+1,n)] ) )
         end if

         call msSilentRelease( U, S, V, D )

      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function mfNull
