! f90 include file

!_______________________________________________________________________
!
   function mfNormEst1( A ) result( est )

      type(mfArray) :: A
      type(mfArray) :: est
      !------ API end ------
#ifdef _DEVLP

      ! based on the Matlab-7.5 script 'normest1.m'
      !
      ! the matrix A must be square (dense or sparse)

      ! restrictions for a first easy MUESLI implementation:
      !
      !   t = 2

      ! modification of Matlab version :
      !   if, after resolution, Y matrix contains NaN values,
      !   they are replaced by zero, so that 'normest1' is more
      !   consistent with norm(A,1).
      !   (generally, Y contains both NaN and Inf values)

      type(mfArray) :: X, Y, ind, vals, Zvals, S, S_old
      type(mfArray) :: SS, est_old, temp, m, vals_ind, Z, ind_hist
      integer :: n, t, rpt_S, rpt_e, itmax, it, nmv, i, j
      integer :: i_dummy, np, r, est_j, imax, rep

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfNormEst1", "E",                          &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfNormEst1", "E",                          &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%shape(1) /= A%shape(2) ) then
         call PrintMessage( "mfNormEst1", "E",                          &
                            "mfArray 'A' must be square!" )
         go to 99
      end if

      n = size(A,1)
      t = 2

      if( t == n .or. n <= 4 ) then
         call msAssign( est, mfSort( mfSum(mfAbs(A)) ) )
         call msAssign( est, mfGet( est, n ) )
         if( any(mfIsNaN(est)) ) then
            if( any(mfIsInf(A)) ) then
               call PrintMessage( "mfNormEst1", "I",                    &
                                  "First estimation of normest1 is NaN, but", &
                                  "the inversion process involves Inf value(s),", &
                                  "so NaN result is replaced by Inf." )
               est = MF_INF
            end if
         end if
         est%status_temporary = .true.
         go to 99
      end if

      rpt_S = 0
      rpt_e = 0

      call msAssign( X, mfOnes(n,t) )
      call msAssign( Y, 2.0d0*mfRand(n,t-1) - mfOnes(n,t-1) )
      call msAssign( Y, mysign( Y ) )
      X%double(:,2:t) = Y%double(:,:)
      call undupli( X, MF_EMPTY, i_dummy )
      call msAssign( X, X / dble(n) )

      itmax = 5
      it = 0
      nmv = 0

      call msAssign( ind, mfZeros(t,1) )
      call msAssign( vals, mfZeros(t,1) )
      call msAssign( Zvals, mfZeros(n,1) )
      call msAssign( S, mfZeros(n,t) )
      est_old = 0.0d0

      do
         it = it + 1
         call msAssign( Y, mfMul(A,X) )
         nmv = nmv + 1
         call msAssign( vals, mfSum( mfAbs(Y) ) )
         call msSort( mfOut(temp,m), vals )
         call msAssign( m, mfGet( m, t .to. 1 .by. -1 ) )
         call msAssign( vals, mfGet( vals, m ) )
         call msAssign( vals_ind, mfGet( ind, m ) )
         call msAssign( est, mfGet( vals, 1 ) )
         if( mfDble(est) > mfDble(est_old) .or. it == 2 ) then
            est_j = mfGet( vals_ind, 1 )
         end if
         if( it >= 2 .and. mfDble(est) <= mfDble(est_old) ) then
            est = est_old
            exit
         end if
         est_old = est
         if( it > itmax ) then
            it = itmax
            exit
         end if
         S_old = S
         call msAssign( S, mysign(Y) )

         if( mfIsReal(A) ) then
            call msAssign( SS, mfMul(S_old,S,transp=1) )
            np = mfCount( mfMax(mfAbs(SS)) == dble(n) )
            if( np == t ) exit
            call undupli( S, S_old, r )
            rpt_S = rpt_S + r
            call msAssign( Z, mfMul(.t.A,S) )
         else ! Complex
            call msAssign( Z, mfMul(.h.A,S) )
         end if

         nmv = nmv + 1
         call msAssign( Zvals, mfMax( mfAbs(Z), 2 ) )
         if( it >= 2 ) then
            if( mfDble(mfMax(Zvals)) == mfDble(mfGet(Zvals,est_j) ) ) then
               exit
            end if
         end if
         call msSort( mfOut(temp,m), Zvals )
         call msAssign( m, mfGet( m, n .to. 1 .by. -1 ) )
         imax = t
         if( it == 1 ) then
            call msAssign( ind, mfGet( m, 1 .to. t ) )
            ind_hist = ind
         else
            rep = mfCount( mfIsMember(mfGet(m,1.to.t),ind_hist) )
            rpt_e = rpt_e + rep
            if( rep == t ) exit
            j = 1
            do i = 1, t
               if( j > n ) then
                  imax = i - 1
                  exit
               end if
               do while( any(ind_hist == mfDble(mfGet(m,j))) )
                  j = j + 1
                  if( j > n ) then
                     imax = i - 1
                     exit
                  end if
               end do
               if( j > n ) exit
               call msSet(mfGet(m,j),ind,i)
               j = j + 1
            end do
            call msAssign( ind_hist, ind_hist .hc. mfGet( ind, 1 .to. imax ) )
         end if
         call msAssign( X, mfZeros(n,t) )
         do j = 1, imax
            i = mfGet(ind,j)
            call msSet( 1.0d0, X, i, j )
         end do
      end do

      est%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

      call msSilentRelease( X, Y, ind, vals, Zvals, S, S_old )
      call msSilentRelease( SS, est_old, temp, m, vals_ind, Z, ind_hist )

#endif
   end function mfNormEst1
!_______________________________________________________________________
!
   function mfNormEst1_inv_L_U_P( L, U, p ) result( est )

      type(mfArray) :: L, U, p
      type(mfArray) :: est
      !------ API end ------
#ifdef _DEVLP

      ! based on the Matlab-7.5 script 'normest1.m'
      !
      ! the matrix A = p*L*U must be square (dense only)

      ! restrictions for a first easy MUESLI implementation:
      !
      !   t = 2
      !   only L, U factors and permutation p are passed as arguments,
      !   so the norm_1 of A^-1 is computed

      ! modification of Matlab version :
      !   if, after resolution, Y matrix contains NaN values,
      !   they are replaced by zero, so that 'normest1_inv' is more
      !   consistent with norm(inv(A),1).
      !   (generally, Y contains both NaN and Inf values)

      type(mfArray) :: X, Y, ind, vals, Zvals, S, S_old
      type(mfArray) :: SS, est_old, temp, m, vals_ind, Z, ind_hist
      integer :: n, t, rpt_S, rpt_e, itmax, it, nmv, i, j
      integer :: i_dummy, np, r, est_j, imax, rep

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( L, U, p )

      if( mfIsEmpty(L) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_L_U_P:) internal ERROR:"
         write(STDERR,*) "                               mfArray 'L' is not allocated!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( mfIsSparse(L) .or. mfIsSparse(U) .or. mfIsSparse(P) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_L_U_P:) internal ERROR:"
         write(STDERR,*) "                               with the current calling syntax, mfArray args must be dense!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( mfIsEmpty(U) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_L_U_P:) internal ERROR:"
         write(STDERR,*) "                               mfArray 'U' is not allocated!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( mfIsEmpty(p) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_L_U_P:) internal ERROR:"
         write(STDERR,*) "                               permutation 'p' is not allocated!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( L%shape(1) /= L%shape(2) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_L_U_P:) internal ERROR:"
         write(STDERR,*) "                               mfArray 'L' must be square!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( U%shape(1) /= U%shape(2) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_L_U_P:) internal ERROR:"
         write(STDERR,*) "                               mfArray 'U' must be square!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( L%shape(1) /= U%shape(1) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_L_U_P:) internal ERROR:"
         write(STDERR,*) "                               'L' and 'U' must have the same shape!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( L%data_type /= U%data_type ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_L_U_P:) internal ERROR:"
         write(STDERR,*) "                               mfArray 'L' and 'U' must have the same data type!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( p%shape(1) /= L%shape(1) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_L_U_P:) internal ERROR:"
         write(STDERR,*) "                               permutation 'p' must have the same size as 'L'!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( p%data_type /= MF_DT_PERM_VEC ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_L_U_P:) internal ERROR:"
         write(STDERR,*) "                               permutation 'p' have a bad data type!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      n = size(L,1)
      t = 2

      if( t == n .or. n <= 4 ) then
         call msAssign( X, mfEye(n,n) )
         call msAssign( Y, mfLDiv(L,U,P,X) )
         call msAssign( est, mfSort( mfSum(mfAbs(Y)) ) )
         call msAssign( est, mfGet( est, n ) )
         if( any(mfIsNaN(est)) ) then
            if( any(mfIsInf(Y)) ) then
               call PrintMessage( "mfNormEst1_inv_L_U_P", "I",          &
                                  "First estimation of normest1 is NaN, but", &
                                  "the inversion process involves Inf value(s),", &
                                  "so NaN result is replaced by Inf." )
               est = MF_INF
            end if
         end if
         est%status_temporary = .true.
         go to 99
      end if

      rpt_S = 0
      rpt_e = 0

      call msAssign( X, mfOnes(n,t) )
      call msAssign( Y, 2.0d0*mfRand(n,t-1) - mfOnes(n,t-1) )
      call msAssign( Y, mysign( Y ) )
      X%double(:,2:t) = Y%double(:,:)
      call undupli( X, MF_EMPTY, i_dummy )
      call msAssign( X, X / dble(n) )

      itmax = 5
      it = 0
      nmv = 0

      call msAssign( ind, mfZeros(t,1) )
      call msAssign( vals, mfZeros(t,1) )
      call msAssign( Zvals, mfZeros(n,1) )
      call msAssign( S, mfZeros(n,t) )
      est_old = 0.0d0

      do
         it = it + 1
         call msAssign( Y, mfLDiv(L,U,P,X) )
         nmv = nmv + 1
         call msAssign( vals, mfSum( mfAbs(Y) ) )
         call msSort( mfOut(temp,m), vals )
         call msAssign( m, mfGet( m, t .to. 1 .by. -1 ) )
         call msAssign( vals, mfGet( vals, m ) )
         call msAssign( vals_ind, mfGet( ind, m ) )
         call msAssign( est, mfGet( vals, 1 ) )
         if( mfDble(est) > mfDble(est_old) .or. it == 2 ) then
            est_j = mfGet( vals_ind, 1 )
         end if
         if( it >= 2 .and. mfDble(est) <= mfDble(est_old) ) then
            est = est_old
            exit
         end if
         est_old = est
         if( it > itmax ) then
            it = itmax
            exit
         end if
         S_old = S
         call msAssign( S, mysign(Y) )

         if( mfIsReal(L) ) then
            call msAssign( SS, mfMul(S_old,S,transp=1) )
            np = mfCount( mfMax(mfAbs(SS)) == dble(n) )
            if( np == t ) exit
            call undupli( S, S_old, r )
            rpt_S = rpt_S + r
         end if

         call msAssign( Z, mfLDiv(L,U,P,S,"transp") )

         nmv = nmv + 1
         call msAssign( Zvals, mfMax( mfAbs(Z), 2 ) )
         if( it >= 2 ) then
            if( mfDble(mfMax(Zvals)) == mfDble(mfGet(Zvals,est_j) ) ) then
               exit
            end if
         end if
         call msSort( mfOut(temp,m), Zvals )
         call msAssign( m, mfGet( m, n .to. 1 .by. -1 ) )
         imax = t
         if( it == 1 ) then
            call msAssign( ind, mfGet( m, 1 .to. t ) )
            ind_hist = ind
         else
            rep = mfCount( mfIsMember(mfGet(m,1.to.t),ind_hist) )
            rpt_e = rpt_e + rep
            if( rep == t ) exit
            j = 1
            do i = 1, t
               if( j > n ) then
                  imax = i - 1
                  exit
               end if
               do while( any(ind_hist == mfDble(mfGet(m,j)) ) )
                  j = j + 1
                  if( j > n ) then
                     imax = i - 1
                     exit
                  end if
               end do
               if( j > n ) exit
               call msSet(mfGet(m,j),ind,i)
               j = j + 1
            end do
            call msAssign( ind_hist, ind_hist .hc. mfGet( ind, 1 .to. imax ) )
         end if
         call msAssign( X, mfZeros(n,t) )
         do j = 1, imax
            i = mfGet(ind,j)
            call msSet( 1.0d0, X, i, j )
         end do
      end do

      est%status_temporary = .true.

 99   continue

      call msFreeArgs( L, U, P )
      call msAutoRelease( L, U, P )

      call msSilentRelease( X, Y, ind, vals, Zvals, S, S_old )
      call msSilentRelease( SS, est_old, temp, m, vals_ind, Z, ind_hist )

#endif
   end function mfNormEst1_inv_L_U_P
!_______________________________________________________________________
!
   function mfNormEst1_inv_U( U ) result( est )

      type(mfArray) :: U
      type(mfArray) :: est
      !------ API end ------
#ifdef _DEVLP

      ! based on the Matlab-7.5 script 'normest1.m'
      !
      ! the matrix A = U'*U must be square (dense only)
      ! (when A is symmetric, positive definite; U comes
      !  from the Cholesky factorization)

      ! restrictions for a first easy MUESLI implementation:
      !
      !   t = 2
      !   only U factor is passed as arguments,
      !   so the norm_1 of A^-1 is computed

      ! modification of Matlab version :
      !   if, after resolution, Y matrix contains NaN values,
      !   they are replaced by zero, so that 'normest1_inv' is more
      !   consistent with norm(inv(A),1).
      !   (generally, Y contains both NaN and Inf values)

      type(mfArray) :: X, Y, ind, vals, Zvals, S, S_old
      type(mfArray) :: SS, est_old, temp, m, vals_ind, Z, ind_hist
      integer :: n, t, rpt_S, rpt_e, itmax, it, nmv, i, j
      integer :: i_dummy, np, r, est_j, imax, rep

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( U )

      if( mfIsEmpty(U) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_U:) internal ERROR:"
         write(STDERR,*) "                           mfArray 'U' is not allocated!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( mfIsSparse(U) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_U:) internal ERROR:"
         write(STDERR,*) "                           with the current calling syntax, mfArray arg must be dense!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      if( U%shape(1) /= U%shape(2) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_U:) internal ERROR:"
         write(STDERR,*) "                           mfArray 'U' must be square!"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      n = size(U,1)
      t = 2

      if( t == n .or. n <= 4 ) then
         call msAssign( X, mfEye(n,n) )
         call msAssign( Y, mfLDiv(U,X,form="cholesky") )
         call msAssign( est, mfSort( mfSum(mfAbs(Y)) ) )
         call msAssign( est, mfGet( est, n ) )
         if( any(mfIsNaN(est)) ) then
            if( any(mfIsInf(Y)) ) then
               call PrintMessage( "mfNormEst1_inv_U", "I",              &
                                  "First estimation of normest1 is NaN, but", &
                                  "the inversion process involves Inf value(s),", &
                                  "so NaN result is replaced by Inf." )
               est = MF_INF
            end if
         end if
         est%status_temporary = .true.
         go to 99
      end if

      rpt_S = 0
      rpt_e = 0

      call msAssign( X, mfOnes(n,t) )
      call msAssign( Y, 2.0d0*mfRand(n,t-1) - mfOnes(n,t-1) )
      call msAssign( Y, mysign( Y ) )
      X%double(:,2:t) = Y%double(:,:)
      call undupli( X, MF_EMPTY, i_dummy )
      call msAssign( X, X / dble(n) )

      itmax = 5
      it = 0
      nmv = 0

      call msAssign( ind, mfZeros(t,1) )
      call msAssign( vals, mfZeros(t,1) )
      call msAssign( Zvals, mfZeros(n,1) )
      call msAssign( S, mfZeros(n,t) )
      est_old = 0.0d0

      do
         it = it + 1
         call msAssign( Y, mfLDiv(U,X,form="cholesky") )
         nmv = nmv + 1
         call msAssign( vals, mfSum( mfAbs(Y) ) )
         call msSort( mfOut(temp,m), vals )
         call msAssign( m, mfGet( m, t .to. 1 .by. -1 ) )
         call msAssign( vals, mfGet( vals, m ) )
         call msAssign( vals_ind, mfGet( ind, m ) )
         call msAssign( est, mfGet( vals, 1 ) )
         if( mfDble(est) > mfDble(est_old) .or. it == 2 ) then
            est_j = mfGet( vals_ind, 1 )
         end if
         if( it >= 2 .and. mfDble(est) <= mfDble(est_old) ) then
            est = est_old
            exit
         end if
         est_old = est
         if( it > itmax ) then
            it = itmax
            exit
         end if
         S_old = S
         call msAssign( S, mysign(Y) )

         if( mfIsReal(U) ) then
            call msAssign( SS, mfMul(S_old,S,transp=1) )
            np = mfCount( mfMax(mfAbs(SS)) == dble(n) )
            if( np == t ) exit
            call undupli( S, S_old, r )
            rpt_S = rpt_S + r
         end if

         call msAssign( Z, mfLDiv(U,S,form="cholesky") )

         nmv = nmv + 1
         call msAssign( Zvals, mfMax( mfAbs(Z), 2 ) )
         if( it >= 2 ) then
            if( mfDble(mfMax(Zvals)) == mfDble(mfGet(Zvals,est_j) ) ) then
               exit
            end if
         end if
         call msSort( mfOut(temp,m), Zvals )
         call msAssign( m, mfGet( m, n .to. 1 .by. -1 ) )
         imax = t
         if( it == 1 ) then
            call msAssign( ind, mfGet( m, 1 .to. t ) )
            ind_hist = ind
         else
            rep = mfCount( mfIsMember(mfGet(m,1.to.t),ind_hist) )
            rpt_e = rpt_e + rep
            if( rep == t ) exit
            j = 1
            do i = 1, t
               if( j > n ) then
                  imax = i - 1
                  exit
               end if
               do while( any(ind_hist == mfDble(mfGet(m,j)) ) )
                  j = j + 1
                  if( j > n ) then
                     imax = i - 1
                     exit
                  end if
               end do
               if( j > n ) exit
               call msSet(mfGet(m,j),ind,i)
               j = j + 1
            end do
            call msAssign( ind_hist, ind_hist .hc. mfGet( ind, 1 .to. imax ) )
         end if
         call msAssign( X, mfZeros(n,t) )
         do j = 1, imax
            i = mfGet(ind,j)
            call msSet( 1.0d0, X, i, j )
         end do
      end do

      est%status_temporary = .true.

 99   continue

      call msFreeArgs( U )
      call msAutoRelease( U )

      call msSilentRelease( X, Y, ind, vals, Zvals, S, S_old )
      call msSilentRelease( SS, est_old, temp, m, vals_ind, Z, ind_hist )

#endif
   end function mfNormEst1_inv_U
!_______________________________________________________________________
!
   function mfNormEst1_inv_factor( factor ) result( est )

      type(mfMatFactor) :: factor
      type(mfArray) :: est
      !------ API end ------
#ifdef _DEVLP

      ! based on the Matlab-7.5 script 'normest1.m'
      !
      ! the matrix A has been factorized by a suitable routine of
      ! the SuiteSparse package

      ! restrictions for a first easy MUESLI implementation:
      !
      !   t = 2
      !   only the 'factor' is passed as argument (sparse case),
      !   so the norm_1 of A^-1 is computed

      ! modification of Matlab version :
      !   if, after resolution, Y matrix contains NaN values,
      !   they are replaced by zero, so that 'normest1_inv' is more
      !   consistent with norm(inv(A),1).
      !   (generally, Y contains both NaN and Inf values)

      type(mfArray) :: X, Y, ind, vals, Zvals, S, S_old
      type(mfArray) :: SS, est_old, temp, m, vals_ind, Z, ind_hist
      integer :: n, t, rpt_S, rpt_e, itmax, it, nmv, i, j
      integer :: i_dummy, np, r, est_j, imax, rep

   !------ end of declarations -- execution starts hereafter  ------

      ! verifications...
      if( .not. associated(factor%ptr_1) ) then
         write(STDERR,*) "(MUESLI mfNormEst1_inv_factor:) internal ERROR:"
         write(STDERR,*) "                                'factor' is not allocated!"
         write(STDERR,*) "   (this factor must have been obtained via the 'mfLU' routine !)"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      n = factor%order
      t = 2

      if( t == n .or. n <= 4 ) then
         call msAssign( X, mfEye(n,n) )
         call msAssign( Y, mfLDiv(factor,X) )
         call msAssign( est, mfSort( mfSum(mfAbs(Y)) ) )
         call msAssign( est, mfGet( est, n ) )
         if( any(mfIsNaN(est)) ) then
            if( any(mfIsInf(Y)) ) then
               call PrintMessage( "mfNormEst1_inv_factor", "I",         &
                                  "First estimation of normest1 is NaN, but", &
                                  "the inversion process involves Inf value(s),", &
                                  "so NaN result is replaced by Inf." )
               est = MF_INF
            end if
         end if
         est%status_temporary = .true.
         go to 99
      end if

      rpt_S = 0
      rpt_e = 0

      call msAssign( X, mfOnes(n,t) )
      call msAssign( Y, 2.0d0*mfRand(n,t-1) - mfOnes(n,t-1) )
      call msAssign( Y, mysign( Y ) )
      X%double(:,2:t) = Y%double(:,:)
      call undupli( X, MF_EMPTY, i_dummy )
      call msAssign( X, X / dble(n) )

      itmax = 5
      it = 0
      nmv = 0

      call msAssign( ind, mfZeros(t,1) )
      call msAssign( vals, mfZeros(t,1) )
      call msAssign( Zvals, mfZeros(n,1) )
      call msAssign( S, mfZeros(n,t) )
      est_old = 0.0d0

      do
         it = it + 1
         call msAssign( Y, mfLDiv(factor,X) )
         nmv = nmv + 1
         call msAssign( vals, mfSum( mfAbs(Y) ) )
         call msSort( mfOut(temp,m), vals )
         call msAssign( m, mfGet( m, t .to. 1 .by. -1 ) )
         call msAssign( vals, mfGet( vals, m ) )
         call msAssign( vals_ind, mfGet( ind, m ) )
         call msAssign( est, mfGet( vals, 1 ) )
         if( mfDble(est) > mfDble(est_old) .or. it == 2 ) then
            est_j = mfGet( vals_ind, 1 )
         end if
         if( it >= 2 .and. mfDble(est) <= mfDble(est_old) ) then
            est = est_old
            exit
         end if
         est_old = est
         if( it > itmax ) then
            it = itmax
            exit
         end if
         S_old = S
         call msAssign( S, mysign(Y) )

         if( factor%data_type == MF_DT_SP_DBLE ) then
            call msAssign( SS, mfMul(S_old,S,transp=1) )
            np = mfCount( mfMax(mfAbs(SS)) == dble(n) )
            if( np == t ) exit
            call undupli( S, S_old, r )
            rpt_S = rpt_S + r
         end if

         call msAssign( Z, mfLDiv(factor,S,"transp") )
         nmv = nmv + 1
         call msAssign( Zvals, mfMax( mfAbs(Z), 2 ) )
         if( it >= 2 ) then
            if( mfDble(mfMax(Zvals)) == mfDble(mfGet(Zvals,est_j) ) ) then
               exit
            end if
         end if
         call msSort( mfOut(temp,m), Zvals )
         call msAssign( m, mfGet( m, n .to. 1 .by. -1 ) )
         imax = t
         if( it == 1 ) then
            call msAssign( ind, mfGet( m, 1 .to. t ) )
            ind_hist = ind
         else
            rep = mfCount( mfIsMember(mfGet(m,1.to.t),ind_hist) )
            rpt_e = rpt_e + rep
            if( rep == t ) exit
            j = 1
            do i = 1, t
               if( j > n ) then
                  imax = i - 1
                  exit
               end if
               do while( any(ind_hist == mfDble(mfGet(m,j)) ) )
                  j = j + 1
                  if( j > n ) then
                     imax = i - 1
                     exit
                  end if
               end do
               if( j > n ) exit
               call msSet(mfGet(m,j),ind,i)
               j = j + 1
            end do
            call msAssign( ind_hist, ind_hist .hc. mfGet( ind, 1 .to. imax ) )
         end if
         call msAssign( X, mfZeros(n,t) )
         do j = 1, imax
            i = mfGet(ind,j)
            call msSet( 1.0d0, X, i, j )
         end do
      end do

      est%status_temporary = .true.

 99   continue

      call msSilentRelease( X, Y, ind, vals, Zvals, S, S_old )
      call msSilentRelease( SS, est_old, temp, m, vals_ind, Z, ind_hist )

#endif
   end function mfNormEst1_inv_factor
!_______________________________________________________________________
!
   subroutine undupli( S, S_old, r )

      type(mfArray) :: S, S_old
      integer :: r
      !------ API end ------
#ifdef _DEVLP

      ! S and S_old cannot be tempo
      !
      ! returns in 'r' the number of replacement made

      integer :: n, t, jstart, last_col, j, rpt
      type(mfArray) :: W, temp

   !------ end of declarations -- execution starts hereafter  ------

      if( S%status_temporary ) then
         write(STDERR,*) "(MUESLI NormEst1:) undupli: internal error:"
         write(STDERR,*) "                   arg 'S' cannot be tempo"
         mf_message_displayed = .true.
         call muesli_trace( pause ="yes" )
         stop
      end if

      if( S_old%status_temporary ) then
         write(STDERR,*) "(MUESLI NormEst1:) undupli: internal error:"
         write(STDERR,*) "                   arg 'S_old' cannot be tempo"
         mf_message_displayed = .true.
         call muesli_trace( pause ="yes" )
         stop
      end if

      n = size(S,1)
      t = size(S,2)
      r = 0

      if( t == 1 ) then
         return
      end if

      if( mfIsEmpty(S_old) ) then
         call msAssign( W, mfGet( S, MF_COLON, 1 ) .hc. mfZeros(n,t-1) )
         jstart = 2
         last_col = 1
      else
         call msAssign( W, S_old .hc. mfZeros(n,t-1) )
         jstart = 1
         last_col = t
      end if

      do j = jstart, t
         rpt = 0
         do while(                                                      &
            all( mfMax( mfMax(                                          &
            mfMul( (.t.mfGet(S,MF_COLON,j)), mfGet(W,MF_COLON,1 .to. last_col) ) &
                 ) ) == dble(n) )                                       &
                 )
            rpt = rpt + 1
            call msAssign( temp, mysign(2.0d0*mfRand(n,1) - mfOnes(n,1)) )
            S%double(:,j) = temp%double(:,1)
            if( dble(rpt) > dble(n)/t ) exit
         end do
         r = r + rpt
         if( j < t ) then
            last_col = last_col + 1
            W%double(:,last_col) = S%double(:,j)
         end if
      end do

      call msSilentRelease( W, temp )

#endif
   end subroutine undupli
!_______________________________________________________________________
!
   function mysign( A ) result ( out )

      type(mfArray) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      call msAssign( out, mfSign( A ) )

      where( out%double == 0.0d0 )
         out%double = 1.0d0
      end where

      out%status_temporary = .true.

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function mysign
