! f90 include file

!_______________________________________________________________________
!
   function mfNormEst( A, tol ) result( est )

      type(mfArray)                  :: A
      real(kind=MF_DOUBLE), optional :: tol

      type(mfArray) :: est
      !------ API end ------
#ifdef _DEVLP

      ! based on the Matlab-7.5 script 'normest.m' (2007?)
      !
      ! the matrix A may be dense or sparse, real or complex,
      ! square or non-square

      real(kind=MF_DOUBLE) :: tolerance
      type(mfArray) :: x, e0, Ax, normx

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfNormEst", "E",                           &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfNormEst", "E",                           &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( present(tol) ) then
         if( tol <= 0.0d0 ) then
            call PrintMessage( "mfNormEst", "E",                        &
                               "tol cannot be negative or null!" )
            go to 99
         end if
         tolerance = tol
      else
         tolerance = 1.0d-6
      end if

      call msAssign( x, .t. mfSum( mfAbs(A), 1 ) )
      call msAssign( est, mfNorm(x) )

      if( mfDble(est) == 0.0d0 ) then
         est%status_temporary = .true.
         go to 98
      end if

      call msAssign( x, x/est )
      e0 = 0.0d0
      do while( mfDble(mfAbs(est-e0)) > tolerance*mfDble(est) )
         e0 = est
         call msAssign( Ax, mfMul(A,x) )
         if( mfNnz(Ax) == 0 ) then
            Ax = mfRand(size(Ax))
         end if
         if( mfIsReal(A) ) then
            call msAssign( x, mfMul(.t.A,Ax) )
         else ! complex case
            call msAssign( x, mfMul(.h.A,Ax) )
         end if
         call msAssign( normx, mfNorm(x) )
         call msAssign( est, normx/mfNorm(Ax) )
         call msAssign( x, x/normx )
      end do

 98   continue

      est%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

      call msSilentRelease( x, e0, Ax, normx )

#endif
   end function mfNormEst
