! f90 include file

!_______________________________________________________________________
!
   recursive function mfNorm_int( A, p, symm, A_minus_t_A ) result( out )

      type(mfArray), target :: A
      integer, optional :: p

      ! for internal usage: following are returned variables for mfCheckSymm
      logical, optional :: symm
      type(mfArray), optional :: A_minus_t_A

      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      type(mfArray), pointer :: A_ptr
      type(mfArray) :: mf_ind
      integer, allocatable :: ind(:)
      real(kind=MF_DOUBLE), pointer :: vec_tmp(:)
      character(len=1) :: lnorm
      real(kind=MF_DOUBLE), allocatable :: work(:)
      integer :: m, n, lda, lp, nb_NaN, nnz
      type(mfArray) :: S
      integer :: is_symm, mf_message_level_save

      real(kind=MF_DOUBLE), external :: dlange, dlansy, zlange, zlansy


   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfNorm", "E",                              &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfNorm", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfNorm", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( present(p) ) then
         lp = p
      else
         lp = 2
      end if

      if( .not. present(symm) .eqv. present(A_minus_t_A) ) then
         ! these two optional args must be paired !
         write(STDERR,*) "(MUESLI mfNorm_int:) internal error:"
         write(STDERR,*) "                     the two optional args 'symm' and"
         write(STDERR,*) "                     'A_minus_t_A' must be paired!"
         write(STDERR,*) "                     Please report this bug to: Edouard.Canot@univ-rennes.fr"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      is_symm = A%prop%symm

      ! shape ?
      if( A%shape(1) == 1 .and. A%shape(2) == 1 ) then

         ! scalar case

         out%data_type = MF_DT_DBLE ! norm is a real number
         out%shape = [ 1, 1 ]
         allocate( out%double(1,1) )

         if( A%data_type == MF_DT_DBLE ) then
            out%double(1,1) = abs(A%double(1,1))
            is_symm = TRUE
         else if( A%data_type == MF_DT_CMPLX ) then
            out%double(1,1) = abs(A%cmplx(1,1))
            if( imag(A%cmplx(1,1)) == 0.0d0 ) then
               is_symm = TRUE
            else
               is_symm = FALSE
            end if
         else if( A%data_type == MF_DT_SP_DBLE ) then
            n = A%shape(2)
            nnz = A%j(n+1) - 1
            if( nnz == 0 ) then
               out%double(1,1) = 0.0d0
            else
               out%double(1,1) = abs(A%a(1))
            end if
            is_symm = TRUE
         else if( A%data_type == MF_DT_SP_CMPLX ) then
            n = A%shape(2)
            nnz = A%j(n+1) - 1
            if( nnz == 0 ) then
               out%double(1,1) = 0.0d0
            else
               out%double(1,1) = abs(A%z(1))
            end if
            if( imag(A%z(1)) == 0.0d0 ) then
               is_symm = TRUE
            else
               is_symm = FALSE
            end if
         else
            call PrintMessage( "mfNorm", "E",                           &
                               "taking the norm of a scalar :",         &
                               "unknown data type!" )
            go to 99
         end if

      else if( A%shape(1) == 1 .or. A%shape(2) == 1 ) then

         ! vector case (not a scalar)

         is_symm = FALSE

         ! verification
         if( lp <= 0 ) then
            call PrintMessage( "mfNorm", "E",                           &
                               "only P>0 and 'inf' norms are supported for vectors." )
            go to 99
         end if

         out%data_type = MF_DT_DBLE ! norm is a real number
         out%shape = [ 1, 1 ]
         allocate( out%double(1,1) )

         if( A%data_type == MF_DT_DBLE ) then
            out%double(1,1) = sum( abs(A%double)**lp ) ** (1.0d0/lp)
         else if( A%data_type == MF_DT_CMPLX ) then
            out%double(1,1) = sum( abs(A%cmplx)**lp ) ** (1.0d0/lp)
         else if( A%data_type == MF_DT_SP_DBLE ) then
            n = A%shape(2)
            nnz = A%j(n+1) - 1
            out%double(1,1) = sum( abs(A%a(1:nnz))**lp ) ** (1.0d0/lp)
         else if( A%data_type == MF_DT_SP_CMPLX ) then
            n = A%shape(2)
            nnz = A%j(n+1) - 1
            out%double(1,1) = sum( abs(A%z(1:nnz))**lp ) ** (1.0d0/lp)
         else
            call PrintMessage( "mfNorm", "E",                           &
                               "taking the norm of a vector :",         &
                               "unknown data type!" )
            go to 99
         end if

      else

         ! matrix case

         out%data_type = MF_DT_DBLE ! norm is a real number
         out%shape = [ 1, 1 ]
         allocate( out%double(1,1) )

         if( lp == 1 ) then

            m = A%shape(1)
            n = A%shape(2)
            if( A%data_type == MF_DT_DBLE ) then
               ! detecting if A contains NaN values
               ! de-activating warning (if return is empty)
               mf_message_level_save = mf_message_level
               mf_message_level = 0
               call msAssign( mf_ind, mfFind( mfIsNaN(A) ) )
               mf_message_level = mf_message_level_save
               nb_NaN = mfSize(mf_ind)
               if( nb_NaN /= 0 ) then
                  allocate( A_ptr ) ! no_mem_trace !
                  A_ptr = A ! true copy
                  allocate( ind(nb_NaN) )
                  ind = mf_ind
                  call msSilentRelease( mf_ind )
                  call msPointer( A_ptr, vec_tmp, no_crc=.true. )
                  vec_tmp( ind ) = 0.0d0
                  call msFreePointer( A_ptr, vec_tmp )
                  deallocate( ind )
               else
                  A_ptr => A
               end if
               lda = m
               allocate( work(m) )
               lnorm = "1"
               ! cannot call 'mfIsSymm' : infinite recursive loop !
               ! (tolerance for computing A-A' is restricted)
               if( is_symm == UNKNOWN ) then
                 if( present(symm) ) then
                    call msAssign( A_minus_t_A, A_ptr-(.t.A_ptr) )
                    if( all(A_minus_t_A == 0.0d0) ) then
                       is_symm = TRUE
                    else
                       is_symm = FALSE
                    end if
                 else
                    if( m == n ) then
                       if( all(A_ptr-(.t.A_ptr) == 0.0d0) ) then
                          is_symm = TRUE
                       else
                          is_symm = FALSE
                       end if
                    else
                       is_symm = FALSE
                    end if
                 end if
               end if
               if( is_symm == TRUE ) then
                  out%double(1,1) = dlansy( lnorm, 'U', n, A_ptr%double(1,1), lda, work(1) )
               else
                  out%double(1,1) = dlange( lnorm, m, n, A_ptr%double(1,1), lda, work(1) )
               end if
               if( nb_NaN /= 0 ) then
                  call msSilentRelease( A_ptr )
                  deallocate( A_ptr ) ! no_mem_trace !
               else
                  A_ptr => null()
               end if
            else if( A%data_type == MF_DT_CMPLX ) then
               lda = m
               allocate( work(m) )
               lnorm = "1"
               ! cannot call 'mfIsSymm' : infinite recursive loop !
               ! we use a more constrained test for symmetry
               if( present(symm) ) then
                  call msAssign( A_minus_t_A, A-(.h.A) )
                  if( all(A_minus_t_A == (0.0d0,0.0d0)) ) then
                     is_symm = TRUE
                  else
                     is_symm = FALSE
                  end if
               else
                  if( m == n ) then
                     if( all(A-(.h.A) == (0.0d0,0.0d0)) ) then
                        is_symm = TRUE
                     else
                        is_symm = FALSE
                     end if
                  else
                     is_symm = FALSE
                  end if
               end if
               if( is_symm == TRUE ) then
                  out%double(1,1) = zlansy( lnorm, 'U', n, A%cmplx(1,1), lda, work(1) )
               else
                  out%double(1,1) = zlange( lnorm, m, n, A%cmplx(1,1), lda, work(1) )
               end if
            else if( A%data_type == MF_DT_SP_DBLE ) then
               out%double(1,1) = norm1_real( n, A%a, A%i, A%j )
            else if( A%data_type == MF_DT_SP_CMPLX ) then
               out%double(1,1) = norm1_cmplx( n, A%z, A%i, A%j )
            else
               call PrintMessage( "mfNorm", "E",                        &
                                  "taking the norm of a matrix :",      &
                                  "unknown data type!" )
               go to 99
            end if

         else if( lp == 2 ) then

            if( mfIsSparse(A) ) then
               ! avoid a fail for small matrices
               if( A%shape(1) == 2 .and. A%shape(2) == 2 ) then
                  S = mfFull(A)
                  S = mfNorm(S,2)
               else
                  ! by default : the largest one
                  call msAssign( S, mfSVDS(A,1) )
               end if
            else
               call msAssign( S, mfSvd(A) )
            end if
            out%double(1,1) = S%double(1,1) ! largest singular value
            call msSilentRelease( S )

         else

            call PrintMessage( "mfNorm", "E",                           &
                               "only 1-, 2-, 'inf'- or 'fro'-norms are supported for matrices." )
            go to 99

         end if

      end if

      if( present(symm) ) then
         if( is_symm == TRUE ) then
            symm = .true.
         else if( is_symm == FALSE ) then
            symm = .false.
         else
            write(STDERR,*) "(MUESLI mfNorm_int:) internal error:"
            write(STDERR,*) "                     cannot determine 'is_symm'"
            write(STDERR,*) "                     (optional arg. symm is left in an unspecified state)"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

      call mf_restore_fpe( )

#endif
   end function mfNorm_int
!_______________________________________________________________________
!
   function mfNorm_char( A, norm ) result( out )

      type(mfArray) :: A
      character(len=*) :: norm
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! inf-norm

      character(len=1) :: lnorm
      real(kind=MF_DOUBLE), allocatable :: work(:)
      integer :: m, n, lda

      real(kind=MF_DOUBLE), external :: dlange, dlansy, zlange, zlansy


   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfNorm", "E",                              &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfNorm", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfNorm", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      ! matrix or vector ?
      if( A%shape(1) == 1 .or. A%shape(2) == 1 ) then

         ! vector case
         if( to_lower(norm) /="inf" ) then
            call PrintMessage( "mfNorm", "E",                           &
                               "only P>0 and 'inf' norms are supported for vectors." )
            go to 99
         end if

         out%data_type = MF_DT_DBLE ! norm is a real number
         out%shape = [ 1, 1 ]
         allocate( out%double(1,1) )

         if( A%data_type == MF_DT_DBLE ) then
            out%double(1,1) = maxval( abs(A%double) )
         else if( A%data_type == MF_DT_CMPLX ) then
            out%double(1,1) = maxval( abs(A%cmplx) )
         else
            call PrintMessage( "mfNorm", "E",                           &
                               "taking the norm of a vector :",         &
                               "unknown data type!" )
            go to 99
         end if

      else

         ! matrix case

         ! verification
         if( to_lower(norm) /= "inf" .and. to_lower(norm) /= "fro" ) then
            call PrintMessage( "mfNorm", "E",                           &
                               "only 1-, 2-, 'inf'- or 'fro'-norms are supported for matrices." )
            go to 99
         end if

         if( to_lower(norm) == "inf" ) then
            lnorm = "I"
         else if( to_lower(norm) == "fro" ) then
            lnorm = "F"
         end if
         m = A%shape(1)
         n = A%shape(2)

         out%data_type = MF_DT_DBLE ! norm is a real number
         out%shape = [ 1, 1 ]
         allocate( out%double(1,1) )

         if( A%data_type == MF_DT_DBLE ) then
            lda = m
            allocate( work(m) )
            ! cannot call 'mfIsSymm' : infinite recursive loop !
            ! we use a more constrained test for symmetry
            if( m == n ) then
               if( all(A-(.t.A) == 0.0d0) ) then
                  out%double(1,1) = dlansy( lnorm, 'U', n, A%double(1,1), lda, work(1) )
               else
                  out%double(1,1) = dlange( lnorm, m, n, A%double(1,1), lda, work(1) )
               end if
            else
               out%double(1,1) = dlange( lnorm, m, n, A%double(1,1), lda, work(1) )
            end if
         else if( A%data_type == MF_DT_CMPLX ) then
            lda = m
            allocate( work(m) )
            ! cannot call 'mfIsSymm' : infinite recursive loop !
            ! we use a more constrained test for symmetry
            if( m == n ) then
               if( all(A-(.h.A) == (0.0d0,0.0d0)) ) then
                  out%double(1,1) = zlansy( lnorm, 'U', n, A%cmplx(1,1), lda, work(1) )
               else
                  out%double(1,1) = zlange( lnorm, m, n, A%cmplx(1,1), lda, work(1) )
               end if
            else
               out%double(1,1) = zlange( lnorm, m, n, A%cmplx(1,1), lda, work(1) )
            end if
         else if( A%data_type == MF_DT_SP_DBLE ) then
            if( lnorm == "I" ) then
               ! inf-norm
               out%double(1,1) = norminf_real( m, n, A%a, A%i, A%j )
            else
               ! frobenius-norm
               out%double(1,1) = sqrt( mfDble(                          &
                                 mfSum( mfDiag( mfMul(.t.A,A) ) ) ) )
            end if
         else if( A%data_type == MF_DT_SP_CMPLX ) then
            if( lnorm == "I" ) then
               ! inf-norm
               out%double(1,1) = norminf_cmplx( m, n, A%z, A%i, A%j )
            else
               ! frobenius-norm
               out%double(1,1) = sqrt( mfDble(                          &
                                 mfSum( mfReal( mfDiag( mfMul(.h.A,A) ) ) ) ) )
            end if
         else
            call PrintMessage( "mfNorm", "E",                           &
                               "taking the norm of a matrix :",         &
                               "unknown data type!" )
            go to 99
         end if

      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

      call mf_restore_fpe( )

#endif
   end function mfNorm_char
