! f90 include file

!_______________________________________________________________________
!
   function mfLogm( A ) result( out )

      type(mfArray) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! Matrix logarithm
      ! (from Matlab-6.5.2 : logm.m)

      type(mfArray) :: L, E, I, J, K, vec, R, ignore
      real(kind=MF_DOUBLE) :: tol
      integer :: n, ii
      logical :: bool

      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfLogm", "E",                              &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfLogm", "E",                              &
                            "sparse matrices not yet handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfLogm", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfLogm", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%shape(1) <= 1 .or. A%shape(2) <= 1 ) then
         call PrintMessage( "mfLogm", "E",                              &
                            "mfArray 'A' should be a matrix!" )
         go to 99
      end if

      ! square matrix ?
      if( A%shape(1) /= A%shape(2) ) then
         call PrintMessage( "mfLogm", "E",                              &
                            "'A' must be a square matrix!" )
         go to 99
      end if

      ! First try Parlett's method directly.
      call msFunm( mfOut(L,E), A, 'log' )
      tol = 1000.0d0*MF_EPS

      ! If funm's error estimate is small, accept the result.
      if( mfDble(E) >= tol ) then
         ! Use norm of residual instead of funm's crude error estimate.
         E = mfNorm(mfExpm(L)-A,1) / mfNorm(A,1)
         if( mfDble(E) >= tol .or. All(.not. mfIsFinite(E)) ) then
            n = size(A,1)
            I = mfEye(n,n)
            ! Try again with a not-quite-random rotation.
            vec = [ (ii,ii=1,n) ]
            call msMeshGrid( mfOut(J,K), vec, .t. vec )
            R = mfOrth(I+J+K)
            call msFunm( mfOut(L,ignore), mfMul(R,mfMul(A,.t.R)), 'log' )
            L = mfMul(R,mfMul(L,R),transp=1)
            bool = mfDble(mfNorm(mfImag(L),1)) <=                       &
                   1000.0d0*tol*mfDble(mfNorm(L,1))
            if( bool ) then
               L = mfReal(L)
            end if
            ! One step of improvement.
            E = mfExpm(L)
            L = L - mfRDiv( (E-A), E )
            E = mfNorm(mfExpm(L)-A,1) / mfNorm(A,1)
         end if
      end if

      if( mfDble(E) >= tol .or. All(.not. mfIsFinite(E)) ) then
         call PrintMessage( "mfLogm", "W",                              &
                            "LOGM appears inaccurate!" )
      end if

      out = L

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "mfLogm", "E",                           &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

      out%prop%tril = A%prop%tril
      out%prop%triu = A%prop%triu
      out%status_temporary = .true.

      call msSilentRelease( L, E, I, J, K, vec, R )
      call msSilentRelease( ignore )

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end function mfLogm
