! f90 include file

!_______________________________________________________________________
!
   subroutine msLDLT( out, A )

      type(mfArray) :: A
      type(mf_Out) :: out
      !------ API end ------
#ifdef _DEVLP

      ! * for dense matrices, 'dsytrf' from Lapack is called.
      !
      ! * for sparse matrices, it uses CHOLMOD_LDLT which is very efficient.
      !                    L*D*L' = P'*A*P
      !
      !   WARNING : L*D*L' factorization can fail for some symmetric sparse
      !   matrices. A must be non-singular but it is not a sufficient
      !   condition. The official CHOLMOD documentation says clearly that
      !   the D matrix mut be diagonal.

      ! REAL only

      type(mfArray), pointer :: L, D, P
      integer :: i, j, k, n, lda, info, i_tmp, lwork, begin
      character(len=3) :: info_char
      integer, allocatable :: ipiv(:), ipiv_new(:)
      logical :: in_bloc_2x2
      logical, allocatable :: block_begin(:)
      real(kind=MF_DOUBLE), allocatable :: work(:)
      real(kind=MF_DOUBLE) :: r_tmp
      type(mfArray) :: A_copy

      ! CHOLMOD declaration
      integer(kind=MF_ADDRESS) :: c_addr, LL_addr, S_addr
      integer :: nnz2, lnz

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsComplex(A) ) then
         call PrintMessage( "msLDLT", "E",                              &
                            "complex matrix 'A' : case not handled!" )
         go to 99
      end if

      ! 3 out-args must be specified
      if( out%n /= 3 ) then
         call PrintMessage( "msLDLT", "E",                              &
                            "three output args required!",              &
                            "syntax is : call msLDLT ( mfOut(L,D,P), A )" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, A ) ) then
         call PrintMessage( "msLDLT", "E",                              &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if

      ! check symmetry
      if( .not. mfIsSymm(A) ) then
         call PrintMessage( "msLDLT", "E",                              &
                            "A is not symmetric!" )
         go to 99
      end if

      ! if A is Symm. Pos. Def.,
      ! 'Cholesky' method should be more appropriate !
      if( A%prop%posd == TRUE ) then
         call PrintMessage( "msLDLT", "W",                              &
                            "A is Symm. and Pos. Def.",                 &
                            "'Cholesky' method should be more appropriate!" )
      end if

      L => out%ptr1
      D => out%ptr2
      P => out%ptr3
      call msSilentRelease( L, D, P )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "msLDLT", "E",                              &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msLDLT", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "msLDLT", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      n = A%shape(1)

      if( A%data_type == MF_DT_DBLE ) then

         call msAssign( A_copy, mfTril(A) )
         lda = n
         ! workspace query
         lwork = -1
         allocate( work(1) )
         allocate( ipiv(n) )
         call dsytrf( "Lower", n, A_copy%double, lda, IPIV,             &
                      work, lwork, info )
         lwork = int( work(1) )
         deallocate( work )
         allocate( work(lwork) )

         ! symmetric factorization
         call dsytrf( "Lower", n, A_copy%double, lda, IPIV,             &
                      work, lwork, info )

         if( info < 0 ) then
            ! call was not ok -- the i-th argument had an illegal value
            write(STDERR,*) "(MUESLI msLDLT:) internal error:"
            write(STDERR,*) "                 arg number: ", info
            write(STDERR,*) "                 had an illegal value"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
         else if( info > 0 ) then
            ! solution is ok -- but info is written because matrix
            !                   may be singular
            write(info_char,"(I0)") info
            call PrintMessage( "msLDLT", "I",                            &
                               "in LDLT-factorizing matrix A by LAPACK:", &
                               "The element D(i,i), with i = " // info_char // " is exactly zero.", &
                               "(The factorization has been completed, but the factor D is exactly singular, ", &
                               " and division by zero will occur if it is used to solve a system  of equations.)" )
         end if

         L%data_type = A%data_type
         D%data_type = A%data_type
         P%data_type = A%data_type
         L%shape = [ n, n ]
         D%shape = [ n, n ]
         P%shape = [ n, n ]

         allocate( L%double(n,n) )

         allocate( D%double(n,n) )

         allocate( P%double(n,n) )

         ! getting L from A_copy
         L%double(:,:) = A_copy%double(:,:)
         do i = 1, N
            L%double(i,i) = 1.0d0
            L%double(i,i+1:N) = 0.0d0
         end do

         ! getting D from A_copy and modifying L
         D%double(:,:) = 0.0d0
         in_bloc_2x2 = .false.
         do i = 1, N
            D%double(i,i) = A_copy%double(i,i)
            if( ipiv(i) < 0 ) then
               if( in_bloc_2x2 ) then
                  in_bloc_2x2 = .false.
               else
                  in_bloc_2x2 = .true.
                  D%double(i+1,i) = A_copy%double(i+1,i)
                  D%double(i,i+1) = A_copy%double(i+1,i)
                  L%double(i+1,i) = 0.0d0
               end if
            end if
         end do

         call msSilentRelease( A_copy )

         allocate( block_begin(n), ipiv_new(n) )
         ! definition of block begin (only N-2 first values are used)
         ! and ipiv_new(:)
         block_begin(:) = .false.
         in_bloc_2x2 = .false.
         do i = 1, N
            if( ipiv(i) < 0 ) then
               if( in_bloc_2x2 ) then
                  in_bloc_2x2 = .false.
               else
                  block_begin(i) = .true.
                  in_bloc_2x2 = .true.
               end if
            end if
            if( ipiv(i) < 0 .and. block_begin(i) ) then
               ipiv_new(i) = i
            else
               ipiv_new(i) = abs( ipiv(i) )
            end if
         end do

         ! permuting elements in col 1 to N-2 of L (multiple swap)
         in_bloc_2x2 = .false.
         do j = 1, N-2
            if( block_begin(j) ) then
               begin = j + 2
            else
               begin = j + 1
            end if
            do i = begin, N
               if( ipiv_new(i) /= i ) then ! permuting only if necessary
                  r_tmp = L%double(i,j)
                  L%double(i,j) = L%double(ipiv_new(i),j)
                  L%double(ipiv_new(i),j) = r_tmp
               end if
            end do
         end do

         ! IPIV :
         ! The pivot indexes that define the permutation matrix P;
         ! row i of the matrix was interchanged with row IPIV(i).
         ! (but different behavior for negative values...)
         ipiv_new = [ (i, i=1,N) ]
         in_bloc_2x2 = .false.
         ! transformed sequence
         do i = 1, N
            j = ipiv(i)
            if( j < 0 ) then
               if( in_bloc_2x2 ) then
                  j = -j
                  if( j /= i ) then
                     ! exchange indexes (i,j) in ipiv_new
                     i_tmp = ipiv_new(i)
                     ipiv_new(i) = ipiv_new(j)
                     ipiv_new(j) = i_tmp
                  end if
                  in_bloc_2x2 = .false.
               else
                  in_bloc_2x2 = .true.
               end if
            else
               if( j /= i ) then
                  ! exchange indexes (i,j) in ipiv_new
                  i_tmp = ipiv_new(i)
                  ipiv_new(i) = ipiv_new(j)
                  ipiv_new(j) = i_tmp
               end if
            end if
         end do

         ! fill the permutation matrix
         P%double(:,:) = 0.0d0
         do j = 1, N
            i = ipiv_new(j)
            P%double(i,j) = 1.0d0
         end do

      else if( A%data_type == MF_DT_SP_DBLE ) then

         call msAssign( A_copy, mfTriu(A) )
         nnz2 = mfNnz(A_copy)
         call cholmod_ldlt_prep( n, nnz2, A_copy%j, A_copy%i, A_copy%a, &
                                 c_addr, LL_addr, S_addr, lnz )

         call msSilentRelease( A_copy )

         ! check result : LDLT can fail when the matrix has zeros on
         ! its main diagonal
         if( lnz == 0 ) then
            call PrintMessage( "msLDLT", "E",                           &
                               "L*D*L' factorization failed for the matrix 'A'!", &
                               "please use the L*U factorization instead." )
            go to 99
         else

            call msAssign( L, mfSpAlloc( n, n, nzmax=lnz ) )

            call msAssign( P, mfSpAlloc( n, n, nzmax=n ) )
            P%j(:) = [ (i,i=1,n+1) ]
            P%a(:) = [ (1.0d0,i=1,n) ]

            ! getting the lower factor L and the permutation applied to
            ! the columns of A
            call cholmod_get_factor( c_addr, LL_addr, S_addr, n, lnz,   &
                                     L%j, L%i, L%a, P%i )

            call msAssign( D, mfSpAlloc( n, n, nzmax=n ) )
            D%j(:) = [ (i,i=1,n+1) ]
            D%i(:) = [ (i,i=1,n) ]
            do j = 1, n
               do k = L%j(j), L%j(j+1)-1
                  if( j == L%i(k) ) then
                     D%a(j) = L%a(k)
                     L%a(k) = 1.0d0
                  end if
               end do
            end do

         end if

      end if

      L%prop%tril = TRUE
      D%prop%tril = TRUE
      D%prop%triu = TRUE

      if( mf_phys_units ) then
         D%units(:) = A%units(:)
      end if

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end subroutine msLDLT
