! f90 include file

! the four routines present here make many tests in order to
! determine (as quickly as possible) if a symmetric matrix is
! positive definite or not.

! from: http://mathworld.wolfram.com/PositiveDefiniteMatrix.html,
! for unsymmetric matrices, it is sufficient that the symmetric part: A+A'
! is pos. definite.
! (but this is disputed by the wikipedia article at:
!  http://en.wikipedia.org/wiki/Positive-definite_matrix)

!### TODO 2: optimiser ! Je pense qu'il est inutile de garder trois tests
!          en O(N^2). Le plus fort suffit (strictly diagonally dominant)
!          mais introduire une variante de mfIsStrictDiagDomCol() pour les
!          matrices symétriques. Voir aussi le cas complexe...

!_______________________________________________________________________
!
   function is_pos_def_real( A ) result( bool )

      type(mfArray), target :: A
      logical :: bool
      !------ API end ------
#ifdef _DEVLP

      ! internal routine of MUESLI
      !
      ! the argument must be a square matrix, real, symmetric
      ! (dense storage)
      ! no test is done here. (must be called only by mfCheckPosDef)

      integer :: i, j, n, max_loc(2), info, lda
      type(mfArray), pointer :: A_copy
      character :: luplo
      logical :: A_copy_is_allocated

   !------ end of declarations -- execution starts hereafter  ------

      bool = .false.

      call msInitArgs( A )

      n = A%shape(1)

      ! first discriminant test: cost is ~ N flops
      !   a_i_i > 0 for all i
      do i = 1, n
         if( A%double(i,i) <= 0.0d0 ) then
            return
         end if
      end do

      ! second discriminant test: cost is ~ 3/2 N^2
      !   a_i_i + a_j_j > 2*a_i_j for all i /= j
      do j = 2, n
         do i = 1, j-1
            if( A%double(i,i)+A%double(j,j) <= 2.0d0*A%double(i,j) ) then
               return
            end if
         end do
      end do

      ! third discriminant test: cost is ~ N^2 (pourrait être 1/2 N^2)
      ! the element with largest modulus lies on the main diagonal
      max_loc = maxloc( abs(A%double) )
      if( max_loc(1) /= max_loc(2) ) then
         return
      end if

      ! fourth test: cost is O(N^2)
      ! if the matrix is strictly diagonally dominant (it is already
      ! symmetric and has positive diagonal entries) then it is
      ! pos. def.
      if( mfIsStrictDiagDomCol(A) ) then
         bool = .true.
         return
      end if

      ! last test: cost is O(N^3)
      ! a Cholesky factorization must not fails
      ! (we don't make a call to 'mfChol' because this routine waits
      !  in the case where it fails; this also avoids many checks)
      if( A%status_temporary .and. (A%level_protected==1) ) then
         A_copy => A
         A_copy_is_allocated = .false.
      else
         allocate( A_copy ) ! no_mem_trace !
         A_copy = A
         A_copy_is_allocated = .true.
      end if
      luplo = "U"
      lda = A_copy%shape(1)
      call dpotrf( luplo, n, A_copy%double(1,1), lda, info )
      if( info == 0 ) then
         bool = .true.
      end if

      if( A_copy_is_allocated ) then
         call msSilentRelease( A_copy )
         deallocate( A_copy ) ! no_mem_trace !
      end if

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function is_pos_def_real
!_______________________________________________________________________
!
   function is_pos_def_complex( A ) result( bool )

      type(mfArray), target :: A
      logical :: bool
      !------ API end ------
#ifdef _DEVLP

      ! internal routine of MUESLI
      !
      ! the argument must be a square matrix, complex, hermitian
      ! (dense storage)
      ! no test is done here. (must be called only by mfCheckPosDef)

      integer :: i, j, n, max_loc(2), info, lda
      type(mfArray), pointer :: A_copy
      character :: luplo
      logical :: A_copy_is_allocated

   !------ end of declarations -- execution starts hereafter  ------

      bool = .false.

      call msInitArgs( A )

      n = A%shape(1)

      ! first discriminant test :
      !   a_i_i > 0 for all i   (taking real part)
      do i = 1, n
         if( real(A%cmplx(i,i)) <= 0.0d0 ) then
            return
         end if
      end do

      ! second discriminant test:
      !   a_i_i + a_j_j > 2*a_i_j for all i /= j   (taking real part)
      do j = 2, n
         do i = 1, j-1
            if( real(A%cmplx(i,i))+real(A%cmplx(j,j))                   &
                <= 2.0d0*real(A%cmplx(i,j)) ) then
               return
            end if
         end do
      end do

      ! third discriminant test:
      ! the element with largest modulus lies on the main diagonal
      max_loc = maxloc( abs(A%cmplx) )
      if( max_loc(1) /= max_loc(2) ) then
         return
      end if

      ! last test:
      ! a Cholesky factorization must not fails
      ! (we don't make a call to 'mfChol' because this routine waits
      !  in the case where it fails; this also avoids many checks)
      if( A%status_temporary .and. (A%level_protected==1) ) then
         A_copy => A
         A_copy_is_allocated = .false.
      else
         allocate( A_copy ) ! no_mem_trace !
         A_copy = A
         A_copy_is_allocated = .true.
      end if
      luplo = "U"
      lda = A_copy%shape(1)
      call zpotrf( luplo, n, A_copy%cmplx(1,1), lda, info )
      if( info == 0 ) then
         bool = .true.
      end if

      if( A_copy_is_allocated ) then
         call msSilentRelease( A_copy )
         deallocate( A_copy ) ! no_mem_trace !
      end if

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function is_pos_def_complex
!_______________________________________________________________________
!
   function is_pos_def_sp_real( A ) result( bool )

      type(mfArray) :: A
      logical :: bool
      !------ API end ------
#ifdef _DEVLP

      ! internal routine of MUESLI
      !
      ! the argument must be a square matrix, real, symmetric
      ! (dense storage)
      ! no test is done here. (must be called only by mfCheckPosDef)

      integer :: i, j, k, n, nnz, nnz2
      real(kind=MF_DOUBLE), allocatable :: diag(:)
      real(kind=MF_DOUBLE) :: max_all, max_diag

      ! CHOLMOD declaration
      type(mfArray) :: A_copy
      integer :: pos_def

   !------ end of declarations -- execution starts hereafter  ------

      bool = .false.

      call msInitArgs( A )

      n = A%shape(1)

      allocate( diag(n) )
      ! extract main diag of A
      call getdia( n, n, A%a, A%i, A%j, diag, 0 )

      ! first discriminant test:
      !   a_i_i > 0 for all i
      do i = 1, n
         if( diag(i) <= 0.0d0 ) then
            return
         end if
      end do

      ! second discriminant test:
      !   a_i_i + a_j_j > 2*a_i_j for all i /= j
      do j = 2, n
         do k = A%j(j), A%j(j+1)-1
            i = A%i(k)
            if( i < j ) then
               if( diag(i)+diag(j) <= 2.0d0*A%a(k) ) then
                  return
               end if
            end if
         end do
      end do

      ! third discriminant test:
      ! the element with largest modulus lies on the main diagonal
      max_diag = maxval( abs(diag) )
      nnz = A%j(n+1) - 1
      max_all = maxval( abs(A%a(1:nnz) ) )
      if( max_all > max_diag ) then
         return
      end if

      ! fourth test:
      ! if the matrix is strictly diagonally dominant (it is already
      ! symmetric and has positive diagonal entries) then it is
      ! pos. def.
      if( mfIsStrictDiagDomCol(A) ) then
         bool = .true.
         return
      end if

      ! last test:
      ! a Cholesky factorization (Sparse Cholesky) must not fails
      ! (we don't make a call to 'mfChol' because this latter routine
      !  waits in the case where it fails; moreover this also avoids
      !  many checks)
      call msAssign( A_copy, mfTriu(A) )
      nnz2 = mfNnz(A_copy)
      call cholmod_pos_def( n, nnz2, A_copy%j, A_copy%i, A_copy%a,      &
                            pos_def )
      if( pos_def == 1 ) then
         bool = .true.
      end if
      call msSilentRelease( A_copy )

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function is_pos_def_sp_real
!_______________________________________________________________________
!
   function is_pos_def_sp_complex( A ) result( bool )

      type(mfArray) :: A
      logical :: bool
      !------ API end ------
#ifdef _DEVLP

      ! internal routine of MUESLI
      !
      ! the argument must be a square matrix, complex, hermitian
      ! (dense storage)
      ! no test is done here. (must be called only by mfCheckPosDef)

      integer :: i, j, k, n, nnz, nnz2
      complex(kind=MF_DOUBLE), allocatable :: diag(:)
      real(kind=MF_DOUBLE) :: max_all, max_diag

      ! CHOLMOD declaration
      type(mfArray) :: A_copy
      integer :: pos_def

   !------ end of declarations -- execution starts hereafter  ------

      bool = .false.

      call msInitArgs( A )

      n = A%shape(1)

      allocate( diag(n) )
      ! extract main diag of A
      call getdia_cmplx( n, n, A%z, A%i, A%j, diag, 0 )

      ! first discriminant test:
      !   a_i_i > 0 for all i   (taking real part)
      do i = 1, n
         if( real(diag(i)) <= 0.0d0 ) then
            return
         end if
      end do

      ! second discriminant test:
      !   a_i_i + a_j_j > 2*a_i_j for all i /= j   (taking real part)
      do j = 2, n
         do k = A%j(j), A%j(j+1)-1
            i = A%i(k)
            if( i < j ) then
               if( real(diag(i))+real(diag(j)) <= 2.0d0*real(A%z(k)) ) then
                  return
               end if
            end if
         end do
      end do

      ! third discriminant test:
      ! the element with largest modulus lies on the main diagonal
      max_diag = maxval( abs(diag) )
      nnz = A%j(n+1) - 1
      max_all = maxval( abs(A%z(1:nnz) ) )
      if( max_all > max_diag ) then
         return
      end if

      ! last test:
      ! a Cholesky factorization (Sparse Cholesky) must not fails
      ! (we don't make a call to 'mfChol' because this latter routine
      !  waits in the case where it fails; moreover this also avoids
      !  many checks)
      call msAssign( A_copy, mfTriu(A) )
      nnz2 = mfNnz(A_copy)
      call cholmod_cmplx_pos_def( n, nnz2, A_copy%j, A_copy%i, A_copy%z, &
                                  pos_def )
      if( pos_def == 1 ) then
         bool = .true.
      end if
      call msSilentRelease( A_copy )

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function is_pos_def_sp_complex
