! f90 include file

!_______________________________________________________________________
!
   subroutine msHess( out, A )

      type(mfArray), target :: A
      type(mf_Out) :: out
      !------ API end ------
#ifdef _DEVLP

      type(mfArray), pointer :: P, H
      integer :: i, j, n, lda, info, lwork, nb
      integer :: ilo, ihi
      real(kind=MF_DOUBLE), allocatable :: tau(:), work(:)
      complex(kind=MF_DOUBLE), allocatable :: ctau(:), cwork(:)
      type(mfArray), pointer :: A_copy
      character(len=3) :: info_char
      logical :: A_copy_is_allocated

      integer, external :: ilaenv

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      ! 2 out-args must be specified
      if( out%n /= 2 ) then
         call PrintMessage( "msHess", "E",                              &
                            "two output args required!",               &
                            "syntax is : call msHess ( mfOut(P,H), A )" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, a ) ) then
         call PrintMessage( "msHess", "E",                              &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if

      P => out%ptr1
      H => out%ptr2
      call msSilentRelease( P, H )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "msHess", "E",                              &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "msHess", "E",                              &
                            "sparse matrices not yet handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msHess", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "msHess", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%shape(1) <= 1 .or. A%shape(2) <= 1 ) then
         call PrintMessage( "msHess", "E",                              &
                            "mfArray 'A' should be a matrix!" )
         go to 99
      end if

      n = A%shape(1)
      if( A%shape(2) /= n ) then
         call PrintMessage( "msHess", "E",                              &
                            "'A' must be a square matrix!" )
         go to 99
      end if

      P%shape = [ n, n ]
      H%shape = [ n, n ]

      ! making copies because LAPACK overwrites A
      if( A%status_temporary .and. (A%level_protected==1) ) then
         A_copy => A
         A_copy_is_allocated = .false.
      else
         allocate( A_copy ) ! no_mem_trace !
         A_copy = A
         A_copy_is_allocated = .true.
      end if

      if( a%data_type == MF_DT_DBLE ) then

         allocate( P%double( P%shape(1), P%shape(2) ) )

         allocate( H%double( H%shape(1), H%shape(2) ) )

         ! A is not already triangular, even partially
         ilo = 1
         ihi = n

         lda = n
         allocate( tau(n) )

         ! optimal blocksize for DGEHRD (from ILAENV)
         nb = 32
         lwork = n*nb
         allocate( work(lwork) )

         ! General system -- real general matrix : DGEHRD
         call dgehrd( n, ilo, ihi, A_copy%double(1,1), lda, tau(1), work(1), lwork, info )
         if( info /= 0 ) then
            ! solution is not ok -- light warning
            write(info_char,"(I0)") info
            call PrintMessage( "msHess", "W",                           &
                               "in computing Hessenberg form of matrix A by LAPACK:", &
                               "info = " // info_char,                  &
                               "(as a side effect, P and H will be empty)" )
            call msSilentRelease( P, H )
         else
            H%data_type = MF_DT_DBLE
            H%double(:,:) = A_copy%double(:,:)
            do j = 1, n-2
               do i = j+2, n
                  H%double(i,j) = 0.0d0
               end do
            end do

            call dorghr( n, ilo, ihi, A_copy%double(1,1), lda, tau(1), work(1), lwork, info )
            if( info /= 0 ) then
               ! solution is not ok -- light warning
            write(info_char,"(I0)") info
            call PrintMessage( "msHess", "W",                           &
                               "in computing Hessenberg form of matrix A by LAPACK:", &
                               "info = " // info_char,                  &
                               "(as a side effect, P and H will be empty)" )
               call msSilentRelease( P )
            else
               P%data_type = MF_DT_DBLE
               P%double(:,:) = A_copy%double(:,:)
            end if
         end if

      else if( a%data_type == MF_DT_CMPLX ) then

         allocate( P%cmplx( P%shape(1), P%shape(2) ) )

         allocate( H%cmplx( H%shape(1), H%shape(2) ) )

         ! A is not already triangular, even partially
         ilo = 1
         ihi = n

         lda = n
         allocate( ctau(n) )

         ! optimal blocksize for ZGEHRD (from ILAENV)
         nb = 32
         lwork = n*nb
         allocate( cwork(lwork) )

         ! General system -- complex general matrix : ZGEHRD
         call zgehrd( n, ilo, ihi, A_copy%cmplx(1,1), lda, ctau(1), cwork(1), lwork, info )
         if( info /= 0 ) then
            ! solution is not ok -- light warning
            write(info_char,"(I0)") info
            call PrintMessage( "msHess", "W",                           &
                               "in computing Hessenberg form of matrix A by LAPACK:", &
                               "info = " // info_char,                  &
                               "(as a side effect, P and H will be empty)" )
            call msSilentRelease( P, H )
         else
            H%data_type = MF_DT_CMPLX
            H%cmplx(:,:) = A_copy%cmplx(:,:)
            do j = 1, n-2
               do i = j+2, n
                  H%cmplx(i,j) = (0.0d0,0.0d0)
               end do
            end do

            call zunghr( n, ilo, ihi, A_copy%cmplx(1,1), lda, ctau(1), cwork(1), lwork, info )
            if( info /= 0 ) then
               ! solution is not ok -- light warning
            write(info_char,"(I0)") info
            call PrintMessage( "msHess", "W",                           &
                               "in computing Hessenberg form of matrix A by LAPACK:", &
                               "info = " // info_char,                  &
                               "(as a side effect, P and H will be empty)" )
               call msSilentRelease( P )
            else
               P%data_type = MF_DT_CMPLX
               P%cmplx(:,:) = A_copy%cmplx(:,:)
            end if
         end if

      end if

      if( A_copy_is_allocated ) then
         call msSilentRelease( A_copy )
         deallocate( A_copy ) ! no_mem_trace !
      end if

      if( mf_phys_units ) then
         H%units(:) = A%units(:)
      end if

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end subroutine msHess
!_______________________________________________________________________
!
   function mfHess( A ) result( out )

      type(mfArray), target :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: i, j, n, lda, info, lwork, nb
      integer :: ilo, ihi
      real(kind=MF_DOUBLE), allocatable :: tau(:), work(:)
      complex(kind=MF_DOUBLE), allocatable :: ctau(:), cwork(:)
      type(mfArray), pointer :: A_copy
      character(len=3) :: info_char
      logical :: A_copy_is_allocated

      integer, external :: ilaenv

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfHess", "E",                              &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfHess", "E",                              &
                            "sparse matrices not yet handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfHess", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfHess", "E",                              &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%shape(1) <= 1 .or. A%shape(2) <= 1 ) then
         call PrintMessage( "mfHess", "E",                              &
                            "mfArray 'A' should be a matrix!" )
         go to 99
      end if

      n = A%shape(1)
      ! square matrix ?
      if( A%shape(2) /= n ) then
         call PrintMessage( "mfHess", "E",                              &
                            "'A' must be a square matrix!" )
         go to 99
      end if

      out%shape = [ n, n ]

      ! making copies because LAPACK overwrites A
      if( A%status_temporary .and. (A%level_protected==1) ) then
         A_copy => A
         A_copy_is_allocated = .false.
      else
         allocate( A_copy ) ! no_mem_trace !
         A_copy = A
         A_copy_is_allocated = .true.
      end if

      if( a%data_type == MF_DT_DBLE ) then

         allocate( out%double( out%shape(1), out%shape(2) ) )

         ! A is not already triangular, even partially
         ilo = 1
         ihi = n

         lda = n
         allocate( tau(n) )

         nb = 32 ! optimal blocksize for DGEHRD (from ILAENV)
         lwork = n*nb
         allocate( work(lwork) )

         ! General system -- real general matrix : DGEHRD
         call dgehrd( n, ilo, ihi, A_copy%double(1,1), lda, tau(1), work(1), lwork, info )
         if( info /= 0 ) then
            ! solution is not ok -- light warning
            write(info_char,"(I0)") info
            call PrintMessage( "mfHess", "W",                           &
                               "in computing Hessenberg form of matrix A by LAPACK:", &
                               "info = " // info_char,                  &
                               "(as a side effect, output will be empty)" )
            call msSilentRelease( out )
         else
            out%data_type = MF_DT_DBLE
            out%double(:,:) = A_copy%double(:,:)
            do j = 1, n-2
               do i = j+2, n
                  out%double(i,j) = 0.0d0
               end do
            end do
         end if

      else if( a%data_type == MF_DT_CMPLX ) then

         allocate( out%cmplx( out%shape(1), out%shape(2) ) )

         ! A is not already triangular, even partially
         ilo = 1
         ihi = n

         lda = n
         allocate( ctau(n) )

         nb = 32 ! optimal blocksize for ZGEHRD (from ILAENV)
         lwork = n*nb
         allocate( cwork(lwork) )

         ! General system -- complex general matrix : ZGEHRD
         call zgehrd( n, ilo, ihi, A_copy%cmplx(1,1), lda, ctau(1), cwork(1), lwork, info )
         if( info /= 0 ) then
            ! solution is not ok -- light warning
            write(info_char,"(I0)") info
            call PrintMessage( "mfHess", "W",                           &
                               "in computing Hessenberg form of matrix A by LAPACK:", &
                               "info = " // info_char,                  &
                               "(as a side effect, output will be empty)" )
            call msSilentRelease( out )
         else
            out%data_type = MF_DT_CMPLX
            out%cmplx(:,:) = A_copy%cmplx(:,:)
            do j = 1, n-2
               do i = j+2, n
                  out%cmplx(i,j) = (0.0d0,0.0d0)
               end do
            end do
         end if

      end if

      if( A_copy_is_allocated ) then
         call msSilentRelease( A_copy )
         deallocate( A_copy ) ! no_mem_trace !
      end if

      if( mf_phys_units ) then
         out%units(:) = A%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end function mfHess
