! f90 include file

!_______________________________________________________________________
!
   subroutine msEig( out, A )

      type(mfArray), target :: A
      type(mf_Out) :: out
      !------ API end ------
#ifdef _DEVLP

      type(mfArray), pointer :: V, D
      character(len=1) :: jobz, uplo
      character(len=1) :: jobvl, jobvr
      real(kind=MF_DOUBLE), allocatable :: eig_re(:), eig_im(:)
      real(kind=MF_DOUBLE), allocatable :: work(:), rwork(:)
      complex(kind=MF_DOUBLE), allocatable :: cwork(:)
      complex(kind=MF_DOUBLE), allocatable :: c_eig(:)
      real(kind=MF_DOUBLE) :: vl(1,1)
      real(kind=MF_DOUBLE), allocatable :: vr(:,:)
      complex(kind=MF_DOUBLE), allocatable :: c_vr(:,:)
      complex(kind=MF_DOUBLE) :: cvl(1,1)
      integer :: n, lwork, lda, info, ldvl, ldvr, i
      type(mfArray), pointer :: A_copy
      character(len=3) :: info_char
      logical :: A_copy_is_allocated

      ! sorting of eigenvalues
      type(mfArray) :: mf_dummy, mf_ind
      integer, allocatable :: ind(:), cjg(:)
      integer :: j, j_shift, pair_count
      logical :: found

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      ! 2 out-args must be specified
      if( out%n /= 2 ) then
         call PrintMessage( "msEig", "E",                               &
                            "two output args required!",               &
                            "syntax is: call msEig ( mfOut(V,D), A )" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, A ) ) then
         call PrintMessage( "msEig", "E",                               &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if

      V => out%ptr1
      D => out%ptr2
      call msSilentRelease( V, D )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "msEig", "E",                               &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "msEig", "E",                               &
                            "for sparse matrices use 'msEigs' instead!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msEig", "E",                               &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "msEig", "E",                               &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( a%shape(1) <= 1 .or. a%shape(2) <= 1 ) then
         call PrintMessage( "msEig", "E",                               &
                            "mfArray 'A' should be a matrix!" )
         go to 99
      end if

      ! square matrix ?
      if( A%shape(1) /= A%shape(2) ) then
         call PrintMessage( "msEig", "E",                               &
                            "'A' must be a square matrix!" )
         go to 99
      end if

      n = A%shape(1)

      ! making copies because LAPACK overwrites A
      if( A%status_temporary .and. (A%level_protected==1) ) then
         A_copy => A
         A_copy_is_allocated = .false.
      else
         allocate( A_copy ) ! no_mem_trace !
         A_copy = A
         A_copy_is_allocated = .true.
      end if

      if( A%data_type == MF_DT_DBLE ) then

         ! Is A symmetric ?
         if( mfIsSymm(A) ) then
            ! use DSYEV
            jobz = "V" ! compute eigenvectors
            uplo = "U"
            lda = n
            lwork = 3*n - 1
            allocate( work(lwork) )

            allocate( eig_re(n) )

            call dsyev( jobz, uplo, n, A_copy%double(1,1), lda, eig_re(1), &
                        work(1), lwork, info )
            if( info /= 0 ) then
               ! solution is not ok -- light warning
               write(info_char,"(I0)") info
               call PrintMessage( "msEig", "W",                         &
                                  "in searching eigs by LAPACK:",       &
                                  "info = " // info_char,               &
                                  "(as a side effect, V and D will be empty)" )
            else
               ! eigenvalues are already sorted in ascending order
               V = A_copy
               ! erasing matrix properties !
               call reset_prop(V%prop)
               call msAssign( D, mfZeros(n,n) )
               do i = 1, n
                  D%double(i,i) = eig_re(i)
               end do
               D%prop%tril = TRUE
               D%prop%triu = TRUE
               D%prop%symm = TRUE
               D%prop%posd = UNKNOWN
            end if
         else
            ! use DGEEV
            jobvl = "N"
            jobvr = "V" ! compute right eigenvectors
            ldvl = 1
            ldvr = n
            lda = n
            lwork = 4*n
            allocate( work(lwork) )

            allocate( eig_re(n) )

            allocate( eig_im(n) )

            allocate( vr(n,n) )

            call dgeev( jobvl, jobvr, n, A_copy%double(1,1), lda, eig_re(1), eig_im(1), &
                        vl, ldvl, vr(1,1), ldvr, work(1), lwork, info )
            if( info /= 0 ) then
               ! solution is not ok -- light warning
               write(info_char,"(I0)") info
               call PrintMessage( "msEig", "W",                         &
                                  "in searching eigs by LAPACK:",       &
                                  "info = " // info_char,               &
                                  "(as a side effect, V and D will be empty)" )
            else
               call msAssign( D, mfZeros(n,n)*MF_I )
               V%data_type = MF_DT_CMPLX
               V%shape = [ n, n ]
               allocate( V%cmplx(n,n) )

               ! sorting eigenvalues by ascending module
               call msSort( mfOut(mf_dummy,mf_ind), mf(eig_re)+MF_I*mf(eig_im) )
               allocate( ind(n), cjg(n) )
               ind = mf_ind
               ! construct a table for indicating how are stored the eigenvects
               !    0 : is purely real
               !   +k : is the real part of the k-th eigenvects pair
               !   -k : is the imag  "            "      "       "
               i = 1
               pair_count = 0
               do while( i <= n )
                  if( eig_im(i) == 0.0d0 ) then
                     ! real eigenvalue
                     cjg(i) = 0
                     i = i + 1
                  else
                     ! complex eigenvalue (conjugate by pair)
                     pair_count = pair_count + 1
                     cjg(i)   = +pair_count
                     cjg(i+1) = -pair_count
                     i = i + 2
                  end if
               end do
               do i = 1, n
                  j = ind(i)
                  D%cmplx(i,i) = cmplx( eig_re(j), eig_im(j), kind=MF_DOUBLE )
                  ! Warning: not so easy to get the eigenvectors, which have
                  !          been stored in a compact way (both real and imag)
                  !          in the real array VR...
                  if( cjg(j) == 0 ) then
                     V%cmplx(:,i) = vr(:,j)
                  else
                     ! in the {eig_re(:), eig_im(:)} arrays, where is the
                     ! conjugate of the eigenvalue ( eig_re(j), eig_im(j) )?
                     ! -> is it just before or just after?
                     found = .false.
                     if( j == 1 ) then
                        if( cjg(j) == -cjg(j+1) ) then
                           j_shift = +1
                           found = .true.
                        end if
                     else if( j == n ) then
                        if( cjg(j) == -cjg(j-1) ) then
                           j_shift = -1
                           found = .true.
                        end if
                     else ! 1 < j < n
                        if( cjg(j) == -cjg(j+1) ) then
                           j_shift = +1
                           found = .true.
                        else if( cjg(j) == -cjg(j-1) ) then
                           j_shift = -1
                           found = .true.
                        end if
                     end if
                     if( .not. found ) then
                        write(STDERR,*) "(MUESLI msEig:) internal error:"
                        write(STDERR,*) "                cannot find an eigenvalues pair!"
                        mf_message_displayed = .true.
                        call muesli_trace( pause ="yes" )
                        stop
                     end if
                     if( cjg(j) > 0 ) then
                        V%cmplx(:,i) = cmplx( vr(:,j), vr(:,j+j_shift), &
                                              kind=MF_DOUBLE )
                     else
                        V%cmplx(:,i) = cmplx( vr(:,j+j_shift), -vr(:,j), &
                                              kind=MF_DOUBLE )
                     end if
                  end if
               end do
               D%prop%tril = TRUE
               D%prop%triu = TRUE
               D%prop%symm = UNKNOWN
               D%prop%posd = UNKNOWN
            end if
         end if

      else if( A%data_type == MF_DT_CMPLX ) then

         ! A hermitienne ?
         if( mfIsSymm(A) ) then
            ! use ZHEEV
            jobz = "V" ! compute eigenvectors
            uplo = "U"
            lda = n
            lwork = 2*n - 1
            allocate( cwork(lwork) )

            allocate( rwork(3*n-2) )

            allocate( eig_re(n) )

            call zheev( jobz, uplo, n, A_copy%cmplx(1,1), lda, eig_re(1), &
                        cwork(1), lwork, rwork(1), info )
            if( info /= 0 ) then
               ! solution is not ok -- light warning
               write(info_char,"(I0)") info
               call PrintMessage( "msEig", "W",                         &
                                  "in searching eigs by LAPACK:",       &
                                  "info = " // info_char,               &
                                  "(as a side effect, V and D will be empty)" )
            else
               ! eigenvalues are already sorted in ascending order
               V = A_copy
               ! erasing matrix properties !
               call reset_prop(V%prop)
               call msAssign( D, mfZeros(n,n) )
               do i = 1, n
                  D%double(i,i) = eig_re(i)
               end do
               D%prop%tril = TRUE
               D%prop%triu = TRUE
               D%prop%symm = TRUE
               D%prop%posd = UNKNOWN
            end if
         else
            ! use ZGEEV
            jobvl = "N"
            jobvr = "V" ! compute right eigenvectors
            ldvl = 1
            ldvr = n
            lda = n
            lwork = 2*n
            allocate( cwork(lwork) )

            allocate( rwork(2*n) )

            allocate( c_eig(n) )

            allocate( c_vr(n,n) )

            call zgeev( jobvl, jobvr, n, A_copy%cmplx(1,1), lda, c_eig(1), &
                        cvl, ldvl, c_vr(1,1), ldvr, cwork(1), lwork, rwork(1), info )
            if( info /= 0 ) then
               ! solution is not ok -- light warning
               write(info_char,"(I0)") info
               call PrintMessage( "msEig", "W",                         &
                                  "in searching eigs by LAPACK:",       &
                                  "info = " // info_char,               &
                                  "(as a side effect, V and D will be empty)" )
            else
               call msAssign( D, mfZeros(n,n)*MF_I )
               V%data_type = MF_DT_CMPLX
               V%shape = [ n, n ]
               allocate( V%cmplx(n,n) )

               ! sorting eigenvalues in ascending order
               call msSort( mfOut(mf_dummy,mf_ind), mf(c_eig) )
               allocate( ind(n) )
               ind = mf_ind

               do i = 1, n
                  D%cmplx(i,i) = c_eig(ind(i))
                  V%cmplx(:,i) = c_vr(:,ind(i))
               end do

               D%prop%tril = TRUE
               D%prop%triu = TRUE
               D%prop%symm = UNKNOWN
               D%prop%posd = UNKNOWN
            end if
         end if

      end if

      call msSilentRelease( mf_dummy, mf_ind )

      if( A_copy_is_allocated ) then
         call msSilentRelease( A_copy )
         deallocate( A_copy ) ! no_mem_trace !
      end if

      if( mf_phys_units ) then
         D%units(:) = A%units(:)
      end if

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end subroutine msEig
!_______________________________________________________________________
!
   function mfEig( A ) result( out )

      type(mfArray), target :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      type(mfArray), pointer :: A_copy
      character(len=1) :: jobz, uplo
      character(len=1) :: jobvl, jobvr
      real(kind=MF_DOUBLE), allocatable :: eig_re(:), eig_im(:)
      real(kind=MF_DOUBLE), allocatable :: work(:), rwork(:)
      complex(kind=MF_DOUBLE), allocatable :: cwork(:)
      complex(kind=MF_DOUBLE), allocatable :: c_eig(:)
      real(kind=MF_DOUBLE) :: vl(1,1), vr(1,1)
      complex(kind=MF_DOUBLE) :: cvl(1,1), cvr(1,1)
      integer :: n, lwork, lda, info, ldvl, ldvr
      character(len=3) :: info_char
      logical :: A_copy_is_allocated

      ! sorting of eigenvalues
      type(mfArray) :: mf_dummy, mf_ind
      integer, allocatable :: ind(:)

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfEig", "E",                               &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfEig", "E",                               &
                            "sparse matrices not yet handled!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfEig", "E",                               &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfEig", "E",                               &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( a%shape(1) <= 1 .or. a%shape(2) <= 1 ) then
         call PrintMessage( "mfEig", "E",                               &
                            "mfArray 'A' should be a matrix!" )
         go to 99
      end if

      ! square matrix ?
      if( A%shape(1) /= A%shape(2) ) then
         call PrintMessage( "mfEig", "E",                               &
                            "'A' must be a square matrix!" )
         go to 99
      end if

      n = A%shape(1)

      ! making copies because LAPACK overwrites A
      if( A%status_temporary .and. (A%level_protected==1) ) then
         A_copy => A
         A_copy_is_allocated = .false.
      else
         allocate( A_copy ) ! no_mem_trace !
         A_copy = A
         A_copy_is_allocated = .true.
      end if

      if( A%data_type == MF_DT_DBLE ) then

         ! Is A symmetric ?
         if( mfIsSymm(A) ) then
            ! use DSYEV
            jobz = "N" ! compute eigenvalues only
            uplo = "U"
            lda = n
            lwork = 3*n - 1
            allocate( work(lwork) )

            allocate( eig_re(n) )

            call dsyev( jobz, uplo, n, A_copy%double(1,1), lda, eig_re(1), &
                        work(1), lwork, info )
            if( info /= 0 ) then
               ! solution is not ok -- light warning
               write(info_char,"(I0)") info
               call PrintMessage( "mfEig", "W",                         &
                                  "in searching eigs by LAPACK:",       &
                                  "info = " // info_char,               &
                                  "(as a side effect, output will be empty)" )
            else
               ! eigenvalues are already sorted in ascending order
               call msAssign( out, mf( eig_re(:), transpose=.true. ))
            end if
         else
            ! use DGEEV
            jobvl = "N" ! compute eigenvalues only
            jobvr = "N" ! compute eigenvalues only
            ldvl = 1
            ldvr = 1
            lda = n
            lwork = 3*n
            allocate( work(lwork) )

            allocate( eig_re(n) )

            allocate( eig_im(n) )

            call dgeev( jobvl, jobvr, n, A_copy%double(1,1), lda, eig_re(1), eig_im(1), &
                        vl, ldvl, vr(1,1), ldvr, work(1), lwork, info )
            if( info /= 0 ) then
               ! solution is not ok -- light warning
               write(info_char,"(I0)") info
               call PrintMessage( "mfEig", "W",                         &
                                  "in searching eigs by LAPACK:",       &
                                  "info = " // info_char,               &
                                  "(as a side effect, output will be empty)" )
            else
               ! sorting eigenvalues in ascending order
               call msSort( mfOut(mf_dummy,mf_ind), mf(eig_re+MF_I*eig_im) )
               allocate( ind(n) )
               ind = mf_ind
               out%data_type = MF_DT_CMPLX
               out%shape = [ n, 1 ]
               allocate( out%cmplx(n,1) )
               out%cmplx(:,1) = cmplx( eig_re(ind(:)), eig_im(ind(:)),  &
                                       kind=MF_DOUBLE )
            end if
         end if

      else if( A%data_type == MF_DT_CMPLX ) then

         ! A hermitienne ?
         if( mfIsSymm(A) ) then
            ! use ZHEEV
            jobz = "N" ! compute eigenvalues only
            uplo = "U"
            lda = n
            lwork = 2*n - 1
            allocate( cwork(lwork) )

            allocate( rwork(3*n-2) )

            allocate( eig_re(n) )

            call zheev( jobz, uplo, n, A_copy%cmplx(1,1), lda, eig_re(1), &
                        cwork(1), lwork, rwork(1), info )
            if( info /= 0 ) then
               ! solution is not ok -- light warning
               write(info_char,"(I0)") info
               call PrintMessage( "mfEig", "W",                         &
                                  "in searching eigs by LAPACK:",       &
                                  "info = " // info_char,               &
                                  "(as a side effect, output will be empty)" )
            else
               ! eigenvalues are already sorted in ascending order
               call msAssign( out, mf( eig_re(:), transpose=.true. ) )
            end if
         else
            ! use ZGEEV
            jobvl = "N" ! compute eigenvalues only
            jobvr = "N" ! compute eigenvalues only
            ldvl = 1
            ldvr = 1
            lda = n
            lwork = 2*n
            allocate( cwork(lwork) )

            allocate( rwork(2*n) )

            allocate( c_eig(n) )

            call zgeev( jobvl, jobvr, n, A_copy%cmplx(1,1), lda, c_eig(1), &
                        cvl, ldvl, cvr(1,1), ldvr, cwork(1), lwork, rwork(1), info )
            if( info /= 0 ) then
               ! solution is not ok -- light warning
               write(info_char,"(I0)") info
               call PrintMessage( "mfEig", "W",                         &
                                  "in searching eigs by LAPACK:",       &
                                  "info = " // info_char,               &
                                  "(as a side effect, output will be empty)" )
            else
               ! sorting eigenvalues in ascending order
               call msSort( mfOut(mf_dummy,mf_ind), mf(c_eig) )
               allocate( ind(n) )
               ind = mf_ind
               out%data_type = MF_DT_CMPLX
               out%shape = [ n, 1 ]
               allocate( out%cmplx(n,1) )
               out%cmplx(:,1) = c_eig(ind(:))
            end if
         end if

      end if

      call msSilentRelease( mf_dummy, mf_ind )

      if( A_copy_is_allocated ) then
         call msSilentRelease( A_copy )
         deallocate( A_copy ) ! no_mem_trace !
      end if

      if( mf_phys_units ) then
         out%units(:) = A%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )

      call msAutoRelease( A )

#endif
   end function mfEig
