! f90 include file

!_______________________________________________________________________
!
   function mfCondEst( A ) result( out )

      type(mfArray) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! based on the Matlab-7.5 script 'condest.m'
      !
      ! the matrix A must be square

      ! restrictions for a first easy MUESLI implementation:
      !
      !   t = 2

      type(mfArray) :: L, U, p
      type(mfMatFactor) :: factor

      integer :: n, nnz
      logical :: A_is_SPD

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         call PrintMessage( "mfCondEst", "E",                           &
                            "mfArray 'A' is not allocated!" )
         go to 99
      end if

      if( A%data_type == MF_DT_BOOL ) then
         call PrintMessage( "mfCondEst", "E",                           &
                            "cannot be applied to a boolean!" )
         go to 99
      end if

      if( A%data_type == MF_DT_PERM_VEC ) then
         call PrintMessage( "mfCondEst", "E",                           &
                            "cannot be applied to a permutation vector!" )
         go to 99
      end if

      if( A%shape(1) /= A%shape(2) ) then
         call PrintMessage( "mfCondEst", "E",                           &
                            "mfArray 'A' must be square!" )
         go to 99
      end if

      if( mfIsSparse(A) ) then
         n = A%shape(2)
         nnz = A%j(n+1) - 1
         if( nnz == 0 ) then
            out = MF_INF
            out%status_temporary = .true.
            go to 99
         end if
      end if

      if( mfIsSymm(A) ) then
         if( mfIsPosDef(A) ) then
            A_is_SPD = .true.
         else
            A_is_SPD = .false.
         end if
      else
         A_is_SPD = .false.
      end if

      if( mfIsSparse(A) ) then

         if( A_is_SPD ) then
            call msChol_mfMatFactor( A, factor )
         else
            call msLU_mfMatFactor( A, factor )
            if( UMF4NUM_SINGULAR_MATRIX == 1 ) then
               out = MF_INF
               ! here, no need to compute Norm(A,1)
               out%status_temporary = .true.
               go to 99
            end if
         end if
         call msAssign( out, mfNormEst1_inv_factor( factor ) )
         call msFreeMatFactor( factor )
         call msAssign( out, mfMul(out,mfNorm(A,1)) )

      else ! dense matrix

         if( A_is_SPD ) then
            call msAssign( U, mfChol(A) )
            call msAssign( out, mfNormEst1_inv_U( U ) )
            call msAssign( out, mfMul(out,mfNorm(A,1)) )
         else
            call msLU( mfOut(L,U,p), A )
            if( .not. mfIsEmpty( mfFind(mfDiag(U)==0.0d0) ) ) then
               out = MF_INF
               ! here, no need to compute Norm(A,1)
               out%status_temporary = .true.
               go to 99
            else
               call msAssign( out, mfNormEst1_inv_L_U_P( L, U, p ) )
               call msAssign( out, mfMul(out,mfNorm(A,1)) )
            end if
         end if

      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

      call msSilentRelease( L, U, p )

#endif
   end function mfCondEst

