! f90 include file

! Internally, routine 'DDEBDF' of the SLATEC library is used.

!_______________________________________________________________________
!
   function mfOdeSolve_JacUser( deriv, t_span, y_0,                     &
                                options, jac )                          &
   result( out )

      ! subroutine deriv( t, y, yprime, flag )
      ! subroutine jac( t, y, jacobian, nrow )
      type(mfArray) :: t_span, y_0
      type(mf_DE_Options), target, optional, intent(in) :: options

      type(mfArray) :: out

      interface
         subroutine deriv( t, y, yprime, flag )
            import :: MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in)     :: t, y(*)
            real(kind=MF_DOUBLE), intent(out)    :: yprime(*)
            integer,              intent(in out) :: flag
         end subroutine deriv
      end interface

      interface
         subroutine jac( t, y, jacobian, nrow )
            import :: MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in)  :: t, y(*)
            integer,              intent(in)  :: nrow
            real(kind=MF_DOUBLE), intent(out) :: jacobian(nrow,*)
         end subroutine jac
      end interface
      !------ API end ------
#ifdef _DEVLP

      ! method = "B" : Backward Differentiation Formula [3]
      !                (with Jacobian provided by the user)
      !
      ! here: the Jacobian matrix is either dense, either banded

      character(len=3) :: method
      type(mfArray), pointer :: tol, y_ind_out, band
      type(mfArray), target  :: empty
      integer                :: check_jac, print_check_jac

      real(kind=MF_DOUBLE) :: t_0, t_end, t, tout

      ! The following ones are declared in the mod_ddebd2 module:
      !   yy(:), rwork(:), iwork(:)

      integer :: neq, info(15), lrw, liw, idid, n_t_out, i, ml, mu
      real(kind=MF_DOUBLE), allocatable :: rtol(:), atol(:)
      integer, allocatable :: yindout(:)
      logical :: interval_mode, whole_y_out, new_value,                 &
                 continuation, first_call
      integer :: stat, n_y_out

      ! other global variables are stored in the MOD_DDEBD2 module
      type(mfArray), pointer :: monitor_y_ind, monitor_yp_ind
      integer :: n_monitor_y = -1, n_monitor_yp = -1
      logical :: monitor_y, monitor_yp
      integer :: recl
      character(len=20) :: n_monitor_y_str, n_monitor_yp_str
      character(len=80) :: format
      real(kind=MF_DOUBLE), allocatable :: yyp(:) ! retrieve y' at t=0
      integer :: flag

      integer, parameter :: lr1 = len_dbl_ddebd1, li1 = len_int_ddebd1
      double precision :: real_sto(lr1)
      integer :: int_sto(li1)
      common /DDEBD1/ real_sto, int_sto

      ! internal print progression
      logical :: print_progress, disp_times
      character(len=80) :: string
      real(kind=MF_DOUBLE) :: pc_fact, left_time
      integer :: clock_rate, clock_init, clock,                         &
                 hrs_1, min_1, sec_1
      common /slatec_odesolve_progress/ print_progress, disp_times,     &
             t_0, t_end, pc_fact, clock_rate, clock_init

      character(len=*), parameter :: ROUTINE_NAME = "mfOdeSolve"
      integer :: istat

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      call msInitArgs( t_span, y_0 )

      if( present(options) ) then
         continuation   = options%continuation
         method         = options%method
         tol           => options%tol
         y_ind_out     => options%y_ind_out
         band          => options%band
         print_progress = options%print_progress
         disp_times     = options%disp_times
         monitor_y_ind   => options%monitor_y_ind
         monitor_yp_ind  => options%monitor_yp_ind
         monitor_pause    = options%monitor_pause
         check_jac        = options%check_jac
         print_check_jac  = options%print_check_jac
         if( allocated(options%named_eqn) ) then
            call check_named_groups( options%named_eqn, istat )
            if( istat == 0 ) then
               NAMED_EQN_PRESENCE = .true.
               NAMED_EQN_PTR => options%named_eqn
            else
               NAMED_EQN_PRESENCE = .false.
               call PrintMessage( ROUTINE_NAME, "W",                    &
                                  "named groups of equations are not valid!", &
                                  " (overlap of indices)",              &
                                  "-> this feature is deactivated." )
            end if
         end if
         if( allocated(options%named_var) ) then
            call check_named_groups( options%named_var, istat )
            if( istat == 0 ) then
               NAMED_VAR_PRESENCE = .true.
               NAMED_VAR_PTR => options%named_var
            else
               NAMED_VAR_PRESENCE = .false.
               call PrintMessage( ROUTINE_NAME, "W",                    &
                                  "named groups of variables are not valid!", &
                                  " (overlap of indices)",              &
                                  "-> this feature is deactivated." )
            end if
         end if
         jac_symm_pos_def   = options%jac_symm_pos_def ! in 'MOD_DDEBD2' module
      else
         ! the following value must match those declared by default
         ! in mod_funfun.F90
         continuation   = .false.
         method         = ""
         tol           => empty
         y_ind_out     => empty
         band          => empty
         print_progress = .false.
         disp_times     = .false.
         monitor_y_ind   => empty
         monitor_yp_ind  => empty
         monitor_pause    = .false.
         check_jac        = 0
         print_check_jac  = 0
         jac_symm_pos_def   = .false. ! in 'MOD_DDEBD2' module
      end if

      first_call = .not. continuation

      if( .not. MF_NUMERICAL_CHECK ) then
         if( check_jac > 0 ) then
            call PrintMessage( ROUTINE_NAME, "W",                       &
                               "jacobian check cannot be done in the release mode!", &
                               "(it has been disabled)" )
         end if

         if( print_check_jac > 0 ) then
            call PrintMessage( ROUTINE_NAME, "W",                       &
                               "jacobian check cannot be done in the release mode!", &
                               "(printing of the result of check has been disabled)" )
         end if
      end if

      if( first_call ) then
         if( y_0%data_type /= MF_DT_DBLE ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "'y_0' must be real!" )
            go to 99
         end if

         if( y_0%shape(1) /= 1 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "'y_0' must be a row vector!" )
            go to 99
         end if

         neq = y_0%shape(2)
      else
         neq = int_sto(28)
      end if

      if( method /= "" ) then
         if( to_lower(method) == "bdf" ) then
            rtol_min = BDF_rtol_min
         else
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "when using a Jacobian routine, 'method' must be equal to 'BDF'!" )
            go to 99
         end if
      else
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "when using a Jacobian routine, 'method' must be equal to 'BDF'!" )
         go to 99
      end if

      if( .not. mfIsEmpty(y_ind_out) ) then

         if( y_ind_out%shape(1) /= 1 .and. y_ind_out%shape(2) /= 1 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "optional arg 'y_ind_out' must be a vector mfArray!" )
            go to 99
         end if
         whole_y_out = .false.
         n_y_out = size(y_ind_out)
         if( n_y_out == neq ) then
            whole_y_out = .true.
         else if( n_y_out > neq ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "size of arg 'y_ind_out' cannot be greater than", &
                               "the number of equations!" )
            go to 99
         end if
         allocate( yindout(n_y_out) )
         yindout(:) = y_ind_out
         if( any(yindout(:)<1) .or. any(neq<yindout(:)) ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "all values in 'y_ind_out' must be ranged in [1,NEQ]!" )
            go to 99
         end if

      else
         whole_y_out = .true.
         n_y_out = neq
      end if

      if( .not. mfIsEmpty(monitor_y_ind) ) then

         if( monitor_y_ind%shape(1) /= 1 .and. monitor_y_ind%shape(2) /= 1 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "optional arg 'monitor_y_ind' must be a vector mfArray!" )
            go to 99
         end if
         n_monitor_y = size(monitor_y_ind)
         allocate( monitoryind(n_monitor_y) )
         monitoryind(:) = monitor_y_ind
         if( any(monitoryind(:)<1) .or. any(neq<monitoryind(:)) ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "all values in 'monitor_y_ind' must be ranged in [1,NEQ]!", &
                               "(NEQ is the number of equations)" )
            go to 99
         end if
         monitor_y = .true.
         call find_unit( unit_monitor_y )
         ! define RECL (important for large number of columns).
         ! 30 is chosen because it seems that Fortran use at most 30 chars
         ! to write a double precision real number in the case where no format
         ! is specified.
#if defined _INTEL_IFC
! BUG: INTEL-ifort (release 10.1 and other versions...)
!      See also the first use of this in the 'msSaveAscii()' routine.
         recl = (30 + 1)* (n_monitor_y+1) ! (+1 for INTEL-ifort, bug)
#else
         recl = 30 * (n_monitor_y+1)
#endif
         ! when n_monitor_y is small, take care that we have to write
         ! some comments at the beginning of the file (see below)
         recl = max( recl, 80 )
         open( unit_monitor_y, recl=recl, file="odesolve_y.out" )
         write( unit_monitor_y, "(A)" )                                 &
            "% output of OdeSolve at internal time steps"
         write( unit_monitor_y, "(A)" )                                 &
            "%   first column contains the time t"
         write( unit_monitor_y, "(A)" )                                 &
            "%   other columns contain values of y(:) at the following indexes:"
         write( n_monitor_y_str, "(I0)" ) n_monitor_y
         format = "( '%', 4X, " // trim(n_monitor_y_str) // "(1X,I0) )"
         write( unit_monitor_y, format )                                &
            monitoryind(:)
         format_monitor_y = "(ES14.7, " // trim(n_monitor_y_str) // "(2X,ES14.7) )"

      else
         monitor_y = .false.
      end if

      if( .not. mfIsEmpty(monitor_yp_ind) ) then

         if( monitor_yp_ind%shape(1) /= 1 .and. monitor_yp_ind%shape(2) /= 1 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "optional arg 'monitor_yp_ind' must be a vector mfArray!" )
            go to 99
         end if
         n_monitor_yp = size(monitor_yp_ind)
         allocate( monitorypind(n_monitor_yp) )
         monitorypind(:) = monitor_yp_ind
         if( any(monitorypind(:)<1) .or. any(neq<monitorypind(:)) ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "all values in 'monitor_yp_ind' must be ranged in [1,NEQ]!", &
                               "(NEQ is the number of equations)" )
            go to 99
         end if
         monitor_yp = .true.
         call find_unit( unit_monitor_yp )
         ! define RECL (important for large number of columns).
         ! 30 is chosen because it seems that Fortran use at most 30 chars
         ! to write a double precision real number in the case where no format
         ! is specified.
#if defined _INTEL_IFC
! BUG: INTEL-ifort (release 10.1 and other versions...)
!      See also the first use of this in the 'msSaveAscii()' routine.
         recl = (30 + 1)* (n_monitor_yp+1) ! (+1 for INTEL-ifort, bug)
#else
         recl = 30 * (n_monitor_yp+1)
#endif
         ! when n_monitor_y is small, take care that we have to write
         ! some comments at the beginning of the file (see below)
         recl = max( recl, 80 )
         open( unit_monitor_yp, recl=recl, file="odesolve_yp.out" )
         write( unit_monitor_yp, "(A)" )                                &
            "% output of OdeSolve at internal time steps"
         write( unit_monitor_yp, "(A)" )                                &
            "%   first column contains the time t"
         write( unit_monitor_yp, "(A)" )                                &
            "%   other columns contain values of yp(:) at the following indexes:"
         write( n_monitor_yp_str, "(I0)" ) n_monitor_yp
         format = "( '%', 4X, " // trim(n_monitor_yp_str) // "(1X,I0) )"
         write( unit_monitor_yp, format )                               &
            monitorypind(:)
         format_monitor_yp = "(ES14.7, " // trim(n_monitor_yp_str) // "(2X,ES14.7) )"

      else
         monitor_yp = .false.
      end if

      ! Integrator options: all-zero is the default.
      info(:) = 0

      if( .not. mfIsEmpty(tol) ) then
         ! info(2) may be modified here
         call process_tol_for_odesolve( tol, rtol, atol, info, neq,     &
                                        ROUTINE_NAME, stat )
         if( stat /= 0 ) go to 99
      else
         allocate( rtol(1), atol(1) )
         rtol(1) = ODE_rtol_def
         atol(1) = ODE_atol_def
      end if

      if( t_span%data_type /= MF_DT_DBLE ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "'t_span' must be real!" )
         go to 99
      end if

      if( t_span%shape(2) /= 1 ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "'t_span' must be a column vector!" )
         go to 99
      end if

      n_t_out = size(t_span)
      t_end = mfGet( t_span, n_t_out )
      if( first_call ) then
         t_0 = mfGet( t_span, 1 )
         if( n_t_out == 2 ) then
            interval_mode = .false.
         else if( n_t_out > 2 ) then
            interval_mode = .true.
         else
            call PrintMessage( ROUTINE_NAME, "E",                          &
                              "'t_span' vector must have at least two components!" )
            go to 99
         end if
      else ! continuation
         ! in this case t_0 is the final time of the last integration
         t_0 = real_sto(1)
         if( n_t_out == 1 ) then
            interval_mode = .false.
         else if( n_t_out > 1 ) then
            interval_mode = .true.
         end if
      end if

      if( first_call ) then
         ! first call for this problem: the integrator will be completely
         ! initialized
         info(1) = 0
         t = t_0
         if( allocated(yy) ) then
            if( size(yy) /= neq ) then
               deallocate( yy )
               allocate( yy(neq) )
            end if
         else
            allocate( yy(neq) )
         end if
         yy(:) = y_0%double(1,:)
      else
         info(1) = 1
         ! when integration continue, 't' and 'y' should not be altered
         t = t_0
         if( .not. allocated(yy) ) then
            allocate( yy(neq) )
         end if
      end if

      ! info(2) = 0 ! 'rtol' and 'atol' are both scalars
      ! info(3) = 0 ! no need to get intermediate results
      ! info(4) = 0 ! integration can be carried out beyond the end
      liw = 56 + neq
      info(5) = 1 ! jacobian computed by a user routine
      if( .not. mfIsEmpty(band) ) then
         if( .not. ( mfIsReal(band) .and. mfIsVector(band) .and.        &
                     size(band) == 2 ) ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "'band' must be a real vector of size 2!" )
            go to 99
         end if
         ml = mfGet( band, 1 )
         mu = mfGet( band, 2 )
         lrw = 24 + 10*neq + (2*ml+mu+1)*neq
         info(6) = 1 ! jacobian matrix has a banded structure
      else
         lrw = 24 + 10*neq + neq**2
         ! info(6) = 0 ! full jacobian matrix (not banded)
      end if

      if( first_call ) then
         if( allocated(rwork) ) then
            if( size(rwork) /= lrw ) then
               deallocate( rwork )
               allocate( rwork(lrw) )
            end if
         else
            allocate( rwork(lrw) )
         end if
         if( allocated(iwork) ) then
            if( size(iwork) /= liw ) then
               deallocate( iwork )
               allocate( iwork(liw) )
            end if
         else
            allocate( iwork(liw) )
         end if
#ifdef _DEVLP
         ! Avoid unitialized values in Valgrind...
         ! (because not all values are used)
         rwork(:) = 0.0d0
         iwork(:) = 0
#endif
         iwork(1) = ml
         iwork(2) = mu
      end if
      ! info(7) = 0 ! jacobian matrix is not sparse

      out%data_type = MF_DT_DBLE
      if( print_progress ) then
         ! initialize progression (comes from 'msPrepProgress')
         pc_fact = 100.0d0/( t_end - t_0 ) ! should be finite
         if( disp_times ) then
            write(STDOUT,"(A)")                                         &
            "................... [Progress status from OdeSolve] ...................."
            call system_clock( count_rate=clock_rate, count=clock_init )
            string = "  0.0 % (time left =   0h  0m  0s -- estim. remain. time =    h   m   s)"
#if defined _INTEL_IFC
! BUG: write is done via C because of a bug in 'flush'
            call put_string_on_term_no_adv( trim(string) // char(0) )
#else
            write(STDOUT,"(A)",advance="no") trim(string)
            call msFlush(STDOUT)
#endif
         else
            write(STDOUT,"(A)")                                         &
            "... [Progress status from OdeSolve] ..."
            string = "  0.0 %"
#if defined _INTEL_IFC
! BUG: write is done via C because of a bug in 'flush'
            call put_string_on_term_no_adv( trim(string) // char(0) )
#else
            write(STDOUT,"(A)",advance="no") trim(string)
            call msFlush(STDOUT)
#endif
         end if
      end if

      if( monitor_y ) then
         write( unit_monitor_y, format_monitor_y ) 0.0d0, yy(monitoryind)
         call flush( unit_monitor_y )
      end if
      if( monitor_yp ) then
         allocate( yyp(neq) )
         call deriv( 0.0d0, yy, yyp, flag )
         write( unit_monitor_yp, format_monitor_yp ) 0.0d0, yyp(monitoryind)
         deallocate( yyp )
         call flush( unit_monitor_yp )
      end if
      if( monitor_pause ) then
         print *
         call msPause( "[MUESLI] ODE solver: monitoring pause" )
      end if

      if( interval_mode ) then

         out%shape = [ n_t_out, n_y_out ]
         allocate( out%double(out%shape(1),out%shape(2)) )

         out%double(:,:) = MF_NAN
         if( first_call ) then
            if( whole_y_out ) then
               out%double(1,:) = y_0
            else
               out%double(1,:) = y_0%double(1,yindout)
            end if
         end if

         if( first_call ) then
            i = 2
         else
            i = 1
         end if
         tout = mfGet( t_span, i )
         idid = -1 ! integration is not yet finished, of course
         do ! possible 'cycle'

            if( idid > 1 ) then
               tout = mfGet( t_span, i )
            end if

            call ddebdf( deriv, neq, t, yy(1), tout, info(1), rtol, atol, idid, &
                         rwork(1), lrw, iwork(1), liw, jac, dummy_ode_spjac, &
                         check_jac, print_check_jac )

            new_value = .true.
            if( idid < 0 ) then
               ! abnormal return
               if( idid == -33 ) then
                  write(STDERR,*)
                  write(STDERR,*) "(MUESLI mfOdeSolve:) internal error:"
                  write(STDERR,*) "                     invalid input for a SLATEC routine"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               else if( idid == -1 ) then
                  if( mf_message_level >= 2 ) then
                     write(STDERR,*)
                  end if
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "A large amount of work has been expended (about 500 steps)" )
                  ! let's continue, this was not an error
                  info(1) = 1
                  cycle
               else if( idid == -10 ) then
                  ! flag set to -1 in 'deriv' (illegal condition)
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "Illegal condition in the 'deriv' user subroutine.", &
                                     "(the t_span vector may have been modified!)" )
                  ! must check that t_span is not tempo
                  if( t_span%status_temporary ) then
                     call PrintMessage( ROUTINE_NAME, "E",              &
                                        "t_span cannot be a temporary mfArray, because it must be modified now!", &
                                        "'Illegal condition' found in the 'deriv'" )
                  end if
!### TODO ?: pb avec ? (RKFS n'est pas appelé ici)...
                  ! most of times (always?) the two values are duplicated,
                  ! so we must check that...
                  if( i > 1 ) then
                     if( t == mfDble(mfGet(t_span,i-1)) ) then
                        new_value = .false.
                     end if
                  end if
                  if( new_value ) then
                     call msSet( t, t_span, i )
                     call msSet( MF_NAN, t_span, i+1 .to. MF_END )
                  else
                     call msSet( MF_NAN, t_span, i .to. MF_END )
                  end if
                  ! no cycle, return to the calling routine...
               else if( idid == -11 ) then
                  ! flag set to -2 in 'deriv' (emergency exit!)
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "Emergency exit in the 'deriv' user subroutine.", &
                                     "(the t_span vector may have been modified!)" )
                  ! must check that t_span is not tempo
                  if( t_span%status_temporary ) then
                     call PrintMessage( ROUTINE_NAME, "E",              &
                                        "t_span cannot be a temporary mfArray, because it must be modified now!", &
                                        "'Emergency exit' found in the 'deriv'" )
                  end if
!### TODO ?: pb avec ? (RKFS n'est pas appelé ici)...
                  ! most of times (always?) the two values are duplicated,
                  ! so we must check that...
                  if( i > 1 ) then
                     if( t == mfDble(mfGet(t_span,i-1)) ) then
                        new_value = .false.
                     end if
                  end if
                  if( new_value ) then
                     call msSet( t, t_span, i )
                     call msSet( MF_NAN, t_span, i+1 .to. MF_END )
                  else
                     call msSet( MF_NAN, t_span, i .to. MF_END )
                  end if
                  ! no cycle, return to the calling routine...
               else
                  write(STDERR,*)
                  write(STDERR,*) "(MUESLI mfOdeSolve:) error status: ", idid
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "'BDF' method encountered some problem!", &
                                     "[please examine the status value and the ref. manual]" )
                  go to 99
               end if
            else
               !### case actually never reached, because info(3) is always
               ! equal to 0: no results at internal steps.
               ! (but the test is kept, if we wish change info(3) in future)
               if( idid == 1 ) cycle
            end if

            if( new_value ) then
               if( whole_y_out ) then
                  out%double(i,:) = yy(:)
               else
                  out%double(i,:) = yy(yindout)
               end if
            end if

            if( -12 <= idid .and. idid <= -10 ) exit

            i = i + 1
            if( i > n_t_out ) exit

            info(1) = 1

         end do

      else ! .not. interval_mode

         out%shape = [ 1, n_y_out ]
         allocate( out%double(out%shape(1),out%shape(2)) )

         out%double(:,:) = MF_NAN

         tout = t_end
         do ! possible 'cycle'

            call ddebdf( deriv, neq, t, yy(1), tout, info(1), rtol, atol, idid, &
                         rwork(1), lrw, iwork(1), liw, jac, dummy_ode_spjac, &
                         check_jac, print_check_jac )

            if( idid < 0 ) then
               ! abnormal return
               if( idid == -33 ) then
                  write(STDERR,*)
                  write(STDERR,*) "(MUESLI mfOdeSolve:) internal error:"
                  write(STDERR,*) "                     invalid input for a SLATEC routine"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               else if( idid == -1 ) then
                  if( mf_message_level >= 2 ) then
                     write(STDERR,*)
                  end if
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "A large amount of work has been expended (about 500 steps)" )
                  ! let's continue, this was not an error
                  info(1) = 1
                  cycle
               else if( idid == -10 ) then
                  ! flag set to -1 in 'deriv' (illegal condition)
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "Illegal condition in the 'deriv' user subroutine.", &
                                     "(the t_span vector may have been modified!)" )
                  ! must check that t_span is not tempo
                  if( t_span%status_temporary ) then
                     call PrintMessage( ROUTINE_NAME, "E",              &
                                        "t_span cannot be a temporary mfArray, because it must be modified now!", &
                                        "'Illegal condition' found in the 'deriv'" )
                  end if
                  call msSet( t, t_span, 2 )
                  ! no cycle, return to the calling routine...
               else if( idid == -11 ) then
                  ! flag set to -2 in 'deriv' (emergency exit!)
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "Emergency exit in the 'deriv' user subroutine.", &
                                     "(the t_span vector may have been modified!)" )
                  ! must check that t_span is not tempo
                  if( t_span%status_temporary ) then
                     call PrintMessage( ROUTINE_NAME, "E",              &
                                        "t_span cannot be a temporary mfArray, because it must be modified now!", &
                                        "'Emergency exit' found in the 'deriv'" )
                  end if
                  call msSet( t, t_span, 2 )
                  ! no cycle, return to the calling routine...
               else if( idid == -12 ) then
                  ! flag set to 3 in 'deriv' (emergency exit!)
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "End condition in the 'deriv' user subroutine.", &
                                     "(the t_span vector may have been modified!)" )
                  ! must check that t_span is not tempo
                  if( t_span%status_temporary ) then
                     call PrintMessage( ROUTINE_NAME, "E",              &
                                        "t_span cannot be a temporary mfArray, because it must be modified now!", &
                                        "'End condition' found in the 'deriv'" )
                  end if
                  call msSet( t, t_span, 2 )
                  ! no cycle, return to the calling routine...
               else
                  write(STDERR,*)
                  write(STDERR,*) "(MUESLI mfOdeSolve:) error status: ", idid
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "'BDF' method encountered some problem!", &
                                     "[please examine the status value and the ref. manual]" )
                  go to 99
               end if
            else
               !### case actually never reached, because info(3) is always
               ! equal to 0: no results at internal steps.
               ! (but the test is kept, if we wish change info(3) in future)
               if( idid == 1 ) cycle
            end if

            exit

         end do

         if( whole_y_out ) then
            out%double(1,:) = yy(:)
         else
            out%double(1,:) = yy(yindout)
         end if

      end if

      if( monitor_y ) then
         close( unit_monitor_y )
         unit_monitor_y = -1
         deallocate( monitoryind )
         n_monitor_y = -1
         format_monitor_y = ""
      end if
      if( monitor_yp ) then
         close( unit_monitor_yp )
         unit_monitor_yp = -1
         deallocate( monitorypind )
         n_monitor_yp = -1
         format_monitor_yp = ""
      end if

      if( print_progress ) then
         ! summarize progression (comes from 'msPostProgress')
         if( disp_times ) then
            call system_clock( count=clock )
            left_time = dble(clock-clock_init)/clock_rate
            call sec_2_hms( left_time, hrs_1, min_1, sec_1 )
            write(string,"(A,I3,A,2(I2,A),A40)") "done. (time left = ", &
                  hrs_1, "h ", min_1, "m ", sec_1, "s)", " "
#if defined _INTEL_IFC
! BUG: write is done via C because of a bug in 'flush'
            call put_string_back_on_term( string(1:72) // char(0) )
#else
            call go_home_on_term()
            write(STDOUT,"(A)") string(1:72)
#endif
            write(STDOUT,"(A)")                                         &
            "........................................................................"
         else
            string = "done.  "
#if defined _INTEL_IFC
! BUG: write is done via C because of a bug in 'flush'
            call put_string_back_on_term( string(1:7) // char(0) )
#else
            call go_home_on_term()
            write(STDOUT,"(A)") string(1:7)
#endif
            write(STDOUT,"(A)") "......................................."
         end if
      end if

 99   continue

      if( MF_NUMERICAL_CHECK ) then
         call ddebd2_free2()
      end if

      out%status_temporary = .true.

      call msFreeArgs( t_span, y_0 )
      call msAutoRelease( t_span, y_0 )

      call mf_restore_fpe( )

#endif
   end function mfOdeSolve_JacUser
