! f90 include file

!_______________________________________________________________________
!
   subroutine dummy_ode_jac( t, y, jacobian, nrow )
      real(kind=MF_DOUBLE), intent(in) :: t, y(*)
      integer,              intent(in) :: nrow
      real(kind=MF_DOUBLE)             :: jacobian(nrow,*)
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

#endif
   end subroutine dummy_ode_jac
!_______________________________________________________________________
!
   subroutine dummy_ode_spjac( t, y, nrow, pd, ipd, jpd, nnz )
      real(kind=MF_DOUBLE), intent(in) :: t, y(*)
      integer,              intent(in) :: nrow
      real(kind=MF_DOUBLE)             :: pd(*)
      integer                          :: ipd(*), jpd(*), nnz
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

#endif
   end subroutine dummy_ode_spjac
!_______________________________________________________________________
!
   subroutine process_tol_for_odesolve( tol, rtol, atol, info, neq,     &
                                        routinename, stat )

      type(mfArray) :: tol
      real(kind=MF_DOUBLE), allocatable :: rtol(:), atol(:)
      integer :: info(15)
      integer, intent(in) :: neq
      character(len=*), intent(in) :: routinename
      integer :: stat
      !------ API end ------
#ifdef _DEVLP

      character(len=20) :: rtol_min_char

   !------ end of declarations -- execution starts hereafter  ------

      stat = 0

      if( Any(mfIsNan(tol)) ) then
         call PrintMessage( routinename, "E",                           &
                            "'tol' argument cannot contain NaN value(s)!" )
         stat = 1
         return
      else if( mfIsScalar(tol) ) then
         allocate( rtol(1), atol(1) )
         rtol(1) = tol
         if( rtol(1) < 0.0d0 ) then
            call PrintMessage( routinename, "E",                        &
                               "'tol' argument cannot be negative!" )
            stat = 1
            return
         end if
         if( rtol(1) < rtol_min ) then
            rtol(1) = rtol_min
            write(rtol_min_char,"(ES11.2)") rtol_min
            call PrintMessage( routinename, "W",                        &
                               "for the method used, rel. tolerance is too small!", &
                               "it has been reset to: " // trim(adjustl(rtol_min_char)) )
         end if
         atol(1) = ODE_atol_def
         ! info(2) = 0 ! 'rtol' and 'atol' are both scalars
      else if( mfIsVector(tol) ) then
         if( tol%shape(1) == 1 ) then
            if( tol%shape(2) /= 2 ) then
               call PrintMessage( trim(routinename), "E",               &
                                  "when 'tol' is a vector, it must have two components!" )
               stat = 1
               return
            end if
         else
            if( tol%shape(1) /= 2 ) then
               call PrintMessage( trim(routinename), "E",               &
                                  "when 'tol' is a vector, it must have two components!" )
               stat = 1
               return
            end if
         end if
         allocate( rtol(1), atol(1) )
         rtol(1) = mfGet( tol, 1 )
         if( rtol(1) < 0.0d0 ) then
            call PrintMessage( routinename, "E",                        &
                               "'tol' argument must be positive!" )
            stat = 1
            return
         end if
         if( rtol(1) < rtol_min ) then
            rtol(1) = rtol_min
            write(rtol_min_char,"(ES11.2)") rtol_min
            call PrintMessage( routinename, "W",                        &
                               "for the method used, rel. tolerance is too small!", &
                               "it has been reset to: " // trim(adjustl(rtol_min_char)) )
         end if
         atol(1) = mfGet( tol, 2 )
         if( atol(1) <= 0.0d0 ) then
            call PrintMessage( routinename, "E",                        &
                               "'tol' argument must be positive!" )
            stat = 1
            return
         end if
         ! info(2) = 0 ! 'rtol' and 'atol' are both scalars
      else
         if( tol%shape(1) /= neq ) then
            call PrintMessage( routinename, "E",                        &
                               "when 'tol' is a matrix,",               &
                               "its row number must be equal to the number of equations!" )
            stat = 1
            return
         end if
         if( tol%shape(2) /= 2 ) then
            call PrintMessage( routinename, "E",                        &
                               "when 'tol' is a matrix,",               &
                               "its col number must be equal 2!" )
            stat = 1
            return
         end if
         allocate( rtol(neq), atol(neq) )
         rtol(:) = mfGet( tol, MF_COLON, 1 )
         if( any(rtol(:) < 0.0d0) ) then
            call PrintMessage( routinename, "E",                        &
                               "'tol' argument must be strictly positive!" )
            stat = 1
            return
         end if
         if( any(rtol(:) < rtol_min) ) then
            where( rtol < rtol_min )
               rtol = rtol_min
            end where
            write(rtol_min_char,"(ES11.2)") rtol_min
            call PrintMessage( routinename, "W",                        &
                               "for the method used, rel. tolerance is too small!", &
                               "some values of rtol(:) has been reset to: " // trim(adjustl(rtol_min_char)) )
         end if
         atol(:) = mfGet( tol, MF_COLON, 2 )
         if( any(atol(:) <= 0.0d0) ) then
            call PrintMessage( routinename, "E",                        &
                               "'tol' argument must be strictly positive!" )
            stat = 1
            return
         end if
         info(2) = 1 ! 'rtol' and 'atol' are both vectors
      end if

#endif
   end subroutine process_tol_for_odesolve
!_______________________________________________________________________
!
   subroutine msOdeSolve_SaveRest_full( A, action )

      type(mfArray) :: A
      character(len=*), intent(in) :: action
      !------ API end ------
#ifdef _DEVLP

      ! Case of a non-sparse jacobian

      ! Save and restore internal data from DDEBDF integrator.
      integer, parameter :: lr1 = len_dbl_ddebd1, li1 = len_int_ddebd1
      double precision :: real_sto(lr1)
      integer :: int_sto(li1)
      common /DDEBD1/ real_sto, int_sto

      ! The following ones are declared in the MOD_DDEBD2 module:
      !   rwork(:), iwork(:)

      !-----------------------

      character(len=7) :: string0
      integer :: neq, lr2, li2
      integer :: lr, li, k, lrw, liw
      integer :: jac_struct, ml, mu

   !------ end of declarations -- execution starts hereafter  ------

      if( A%status_temporary ) then
         call PrintMessage( "msOdeSolve", "E",                          &
                            "mfArray 'A' cannot be temporary!" )
         return
      end if

      string0 = to_lower(action)

      if( string0 == "save" ) then
         jac_struct = iwork(3)
         neq        = iwork(4)
         if( jac_struct == 2 ) then
            ml  = iwork(1)
            mu  = iwork(2)
         end if
      else if( string0 == "restore" ) then
         jac_struct = A%double(3,1)
         neq        = A%double(4,1)
         if( jac_struct == 2 ) then
            ml = A%double(1,1)
            mu = A%double(2,1)
         end if
      else
         call PrintMessage( "msOdeSolve", "E",                          &
                            'bad argument: did you thought "save" or "restore"?' )
         return
      end if

      select case( jac_struct )
         case( 1 )
            ! dense jacobian
            lrw = 24 + 10*neq + neq**2 ! full size of RWORK
         case( 2 )
            ! banded jacobian
            lrw = 24 + 10*neq + (2*ml+mu+1)*neq
         case( 3 )
            call PrintMessage( "msOdeSolve", "E",                       &
                               "When using a sparse jacobian, add an argument", &
                               "specifying the name of the routine which compute this jacobian." )
            return
         case default
            call PrintMessage( "msOdeSolve", "E",                       &
                               "When restoring internal data, jac_struct must", &
                               "be equal to 1, 2 or 3." )
            return
      end select

      lr2 = lrw - 16 ! size for partial copy

      liw = 56 + neq ! full size of IWORK
      li2 = neq + 6  ! size for partial copy

      lr = lr1 + lr2
      li = li1 + li2

      if( string0 == "save" ) then

         A = MF_EMPTY
         ! prepare user storage
         A%data_type = MF_DT_DBLE
         A%shape = [ lr+li, 1 ]
         allocate( A%double(lr+li,1) )

         ! copy parts of working arrays in module MOD_DDEBD2
         if( jac_struct == 2 ) then
            A%double(1:2,1) = iwork(1:2) ! ML, MU
         else
            ! avoid warning in Valgrind
            A%double(1:2,1) = [ 0, 0 ] ! ML, MU
         end if
         A%double(3:4,1) = iwork(3:4) ! Jacobian structure, NEQ
         k = 4
         A%double(k+1:k+neq+1,1) = iwork(21:21+neq) ! IPVT(neq), INTOUT
         k = k + neq + 1
         A%double(k+1,1) = iwork(liw) ! nb of unsuccess steps?
         k = k + 1

         A%double(k+1,1) = rwork(1) ! TSTOP
         k = k + 1
         A%double(k+1:k+3,1) = rwork(11:13) ! H, fact_tol, T
         k = k + 3
         A%double(k+1:k+(lrw-21+1),1) = rwork(21:lrw) ! remaining
         k = k + (lrw-21+1)

         ! copy of common DDEBD1
         A%double(k+1:k+lr1,1) = real_sto(1:lr1)
         k = k + lr1
         A%double(k+1:k+li1,1) = int_sto(1:li1)

      else if( string0 == "restore" ) then

         ! check storage
         if( A%shape(1) /= lr+li ) then
            call PrintMessage( "msOdeSolve", "E",                       &
                               "during user restore: bad size for first dimension of 'A'!" )
            return
         end if
         if( A%shape(2) /= 1 ) then
            call PrintMessage( "msOdeSolve", "E",                       &
                               "during user restore: bad size for second dimension of 'A'!" )
            return
         end if

         ! copy to working arrays in module MOD_DDEBD2
         if( allocated(rwork) ) then
            if( size(rwork) /= lrw ) then
               deallocate( rwork )
               allocate( rwork(lrw) )
            end if
         else
            allocate( rwork(lrw) )
         end if
         if( allocated(iwork) ) then
            if( size(iwork) /= liw ) then
               deallocate( iwork )
               allocate( iwork(liw) )
            end if
         else
            allocate( iwork(liw) )
         end if

         iwork(1:4) = A%double(1:4,1)
         k = 4
         iwork(21:21+neq) = A%double(k+1:k+neq+1,1)
         k = k + neq + 1
         iwork(liw) = A%double(k+1,1)
         k = k + 1

         rwork(1) = A%double(k+1,1)
         k = k + 1
         rwork(11:13) = A%double(k+1:k+3,1)
         k = k + 3
         rwork(21:lrw) = A%double(k+1:k+(lrw-21+1),1)
         k = k + (lrw-21+1)

         ! copy to common DDEBD1
         real_sto(1:lr1) = A%double(k+1:k+lr1,1)
         k = k + lr1
         int_sto(1:li1) = A%double(k+1:k+li1,1)

      end if

#endif
   end subroutine msOdeSolve_SaveRest_full
!_______________________________________________________________________
!
   subroutine msOdeSolve_SaveRest_SP( A, action, jac_sparse )

      type(mfArray) :: A
      character(len=*), intent(in) :: action

      interface
         subroutine jac_sparse( t, y, nrow, job, pd, ipd, jpd, nnz )
            import :: MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in)     :: t, y(*)
            integer,              intent(in)     :: nrow, job
            real(kind=MF_DOUBLE), intent(out)    :: pd(*)
            integer,              intent(out)    :: ipd(*), jpd(*)
            integer,              intent(in out) :: nnz
            ! the CSC representation of the matrix is as follows:
            !   pd(1:nnz)    : values of the matrix entries
            !  ipd(1:nnz)    : contains the row indexes
            !  jpd(1:ncol+1) : the pointer to the beginning of the
            !                  columns, in arrays pd,ipd.
            !                (here, the matrix is square, the ncol=nrow)
            !
            ! when job=0, only the value of nnz must be returned
            !
            ! {pd,ipd} must contain all diagonal terms, even if they
            ! are null. (a test is made in SLATEC/DLSOD.F)
            !
            ! moreover, row indexes must be sorted in ascending order
            ! (constraint from UMFPACK)
         end subroutine jac_sparse
      end interface
      !------ API end ------
#ifdef _DEVLP

      ! Case of a sparse jacobian

      ! Save and restore internal data from DDEBDF integrator.
      integer, parameter :: lr1 = len_dbl_ddebd1, li1 = len_int_ddebd1
      double precision :: real_sto(lr1)
      integer :: int_sto(li1)
      common /DDEBD1/ real_sto, int_sto

      ! The following ones are declared in the MOD_DDEBD2 module:
      !   rwork(:), iwork(:), nnz, pd(:), ipd(:), jpd(:),
      !   ipd_c(:), jpd_c(:)

      !-----------------------

      character(len=7) :: string0
      integer :: neq, lr2, li2
      integer :: lr, li, k, lrw, liw
      integer :: jac_struct, job, ivec(1)
      double precision :: rvec(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( A%status_temporary ) then
         call PrintMessage( "msOdeSolve", "E",                          &
                            "mfArray 'A' cannot be temporary!" )
         return
      end if

      string0 = to_lower(action)

      if( string0 == "save" ) then
         jac_struct = iwork(3)
         neq        = iwork(4)
      else if( string0 == "restore" ) then
         jac_struct = A%double(3,1)
         neq        = A%double(4,1)
      else
         call PrintMessage( "msOdeSolve", "E",                          &
                            'bad argument: did you thought "save" or "restore"?' )
         return
      end if

      if( jac_struct == 3 ) then
         ! sparse jacobian
         lrw = 24 + 10*neq
      else
         call PrintMessage( "msOdeSolve", "E",                          &
                            "When using this interface, the jacobian must be sparse" )
         return
      end if

      lr2 = lrw - 16 ! size for partial copy

      liw = 56 + neq ! full size of IWORK
      li2 = 6  ! size for partial copy

      lr = lr1 + lr2
      li = li1 + li2

      if( string0 == "save" ) then

         A = MF_EMPTY
         ! prepare user storage
         A%data_type = MF_DT_DBLE
         A%shape = [ lr+li, 1 ]
         allocate( A%double(lr+li,1) )

         ! copy parts of working arrays in module MOD_DDEBD2
         A%double(1:4,1) = iwork(1:4) ! ML, MU, Jacobian structure, NEQ
         A%double(5,1)   = iwork(20+neq+1) ! INTOUT
         A%double(6,1)   = iwork(liw) ! nb of unsuccessful steps (?)
         k = 6

         A%double(k+1,1) = rwork(1) ! TSTOP
         k = k + 1
         A%double(k+1:k+3,1) = rwork(11:13) ! H, fact_tol, T
         k = k + 3
         A%double(k+1:k+(lrw-21+1),1) = rwork(21:lrw) ! remaining
         k = k + (lrw-21+1)

         ! copy of common DDEBD1
         A%double(k+1:k+lr1,1) = real_sto(1:lr1)
         k = k + lr1
         A%double(k+1:k+li1,1) = int_sto(1:li1)

      else if( string0 == "restore" ) then

         ! check storage
         if( A%shape(1) /= lr+li ) then
            call PrintMessage( "msOdeSolve", "E",                       &
                               "during user restore: bad size for first dimension of 'A'!" )
            return
         end if
         if( A%shape(2) /= 1 ) then
            call PrintMessage( "msOdeSolve", "E",                       &
                               "during user restore: bad size for second dimension of 'A'!" )
            return
         end if

         ! copy to working arrays in module MOD_DDEBD2
         if( allocated(rwork) ) then
            if( size(rwork) /= lrw ) then
               deallocate( rwork )
               allocate( rwork(lrw) )
            end if
         else
            allocate( rwork(lrw) )
         end if
         if( allocated(iwork) ) then
            if( size(iwork) /= liw ) then
               deallocate( iwork )
               allocate( iwork(liw) )
            end if
         else
            allocate( iwork(liw) )
         end if
#ifdef _DEVLP
         ! Avoid unitialized values in Valgrind...
         ! (because not all values are used)
         rwork(:) = 0.0d0
         iwork(:) = 0
#endif

         iwork(1:4)      = A%double(1:4,1)
         iwork(20+neq+1) = A%double(5,1)
         iwork(liw)      = A%double(6,1)
         k = 6

         rwork(1) = A%double(k+1,1)
         k = k + 1
         rwork(11:13) = A%double(k+1:k+3,1)
         k = k + 3
         rwork(21:lrw) = A%double(k+1:k+(lrw-21+1),1)
         k = k + (lrw-21+1)

         ! copy to common DDEBD1
         real_sto(1:lr1) = A%double(k+1:k+lr1,1)
         k = k + lr1
         int_sto(1:li1) = A%double(k+1:k+li1,1)

         ! just to initialize the routine computing the sparse jacobian
         ! (get nnz)
         job = 0
         call jac_sparse( 0.0d0, rvec, neq, job, rvec, ivec, ivec, nnz )

         ! allocation of 1D arrays (integer and real) for the sparse
         ! jacobian
         allocate( jpd(neq+1), jpd_c(neq+1) )
         allocate( pd(nnz), ipd(nnz), ipd_c(nnz) )

      end if

#endif
   end subroutine msOdeSolve_SaveRest_SP
!_______________________________________________________________________
!
   subroutine msOdeSolve_Finalize( action )

      character(len=*), intent(in) :: action
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      if( to_lower(action) /= "finalize" ) then
         call PrintMessage( "msOdeSolve", "E",                          &
                            'bad argument: did you thought "finalize"?' )
         return
      end if

      if( allocated(yy) ) then
         deallocate( yy )
      end if
      if( allocated(rwork) ) then
         deallocate( rwork )
      end if
      if( allocated(iwork) ) then
         deallocate( iwork )
      end if

      call ddebd2_free()

#endif
   end subroutine msOdeSolve_Finalize
