! f90 include file

!_______________________________________________________________________
!
   subroutine dummy_dae_jac( t, y, yp, jacobian, cj, nrow )

      real(kind=MF_DOUBLE), intent(in) :: t, y(*), yp(*), cj
      integer,              intent(in) :: nrow
      real(kind=MF_DOUBLE)             :: jacobian(nrow,*)
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

#endif
   end subroutine dummy_dae_jac
!_______________________________________________________________________
!
   subroutine dummy_dae_spjac( t, y, yp, cj, nrow, pd, ipd, jpd, nnz )

      real(kind=MF_DOUBLE), intent(in) :: t, y(*), yp(*), cj
      integer,              intent(in) :: nrow
      real(kind=MF_DOUBLE)             :: pd(*)
      integer                          :: ipd(*), jpd(*), nnz
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

#endif
   end subroutine dummy_dae_spjac
!_______________________________________________________________________
!
   subroutine process_tol_for_daesolve( tol, rtol, atol, info, neq,     &
                                        routinename, stat )

      type(mfArray) :: tol
      real(kind=MF_DOUBLE), allocatable :: rtol(:), atol(:)
      integer :: info(15)
      integer, intent(in) :: neq
      character(len=*), intent(in) :: routinename
      integer :: stat
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      stat = 0

      ! for the current routine called (DDASSL), RTOL and ATOL
      ! cannot be both zero.
      if( Any(mfIsNan(tol)) ) then
         call PrintMessage( routinename, "E",                           &
                            "'tol' argument cannot contain NaN value(s)!" )
         stat = 1
         return
      else if( mfIsScalar(tol) ) then
         allocate( rtol(1), atol(1) )
         rtol(1) = tol
         if( rtol(1) <= 0.0d0 ) then
            call PrintMessage( routinename, "E",                        &
                               "'tol' argument must be strictly positive!" )
            stat = 1
            return
         end if
         atol(1) = DAE_atol_def
         ! info(2) = 0 ! 'rtol' and 'atol' are both scalars
      else if( mfIsVector(tol) ) then
         if( tol%shape(1) == 1 ) then
            if( tol%shape(2) /= 2 ) then
               call PrintMessage( routinename, "E",                     &
                                  "when 'tol' is a vector, it must have two components!" )
               stat = 1
               return
            end if
         else
            if( tol%shape(1) /= 2 ) then
               call PrintMessage( routinename, "E",                     &
                                  "when 'tol' is a vector, it must have two components!" )
               stat = 1
               return
            end if
         end if
         allocate( rtol(1), atol(1) )
         rtol(1) = mfGet( tol, 1 )
         if( rtol(1) < 0.0d0 ) then
            call PrintMessage( routinename, "E",                        &
                               "'tol' argument must be positive!" )
            stat = 1
            return
         end if
         atol(1) = mfGet( tol, 2 )
         if( atol(1) < 0.0d0 ) then
            call PrintMessage( routinename, "E",                        &
                               "'tol' argument must be positive!" )
            stat = 1
            return
         end if
         if( rtol(1) == 0.0d0 .and. atol(1) == 0.0d0 ) then
            call PrintMessage( routinename, "E",                        &
                               "relative and absolute tol cannot be both zero!" )
            stat = 1
            return
         end if
         ! info(2) = 0 ! 'rtol' and 'atol' are both scalars
      else
         if( tol%shape(1) /= neq ) then
            call PrintMessage( routinename, "E",                        &
                               "when 'tol' is a matrix,",               &
                               "its row number must be equal to the number of equations!" )
            stat = 1
            return
         end if
         if( tol%shape(2) /= 2 ) then
            call PrintMessage( routinename, "E",                        &
                               "when 'tol' is a matrix,",               &
                               "its col number must be equal 2!" )
            stat = 1
            return
         end if
         allocate( rtol(neq), atol(neq) )
         rtol(:) = mfGet( tol, MF_COLON, 1 )
         if( any(rtol(:) < 0.0d0) ) then
            call PrintMessage( routinename, "E",                        &
                               "'tol' argument must be strictly positive!" )
            stat = 1
            return
         end if
         atol(:) = mfGet( tol, MF_COLON, 2 )
         if( any(atol(:) < 0.0d0) ) then
            call PrintMessage( routinename, "E",                        &
                               "'tol' argument must be strictly positive!" )
            stat = 1
            return
         end if
         if( all(rtol(:) == 0.0d0 .and. atol(:) == 0.0d0) ) then
            call PrintMessage( routinename, "E",                        &
                               "all components of relative and absolute tol cannot be zero!" )
            stat = 1
            return
         end if
         info(2) = 1 ! 'rtol' and 'atol' are both vectors
      end if

#endif
   end subroutine process_tol_for_daesolve
!_______________________________________________________________________
!
   subroutine process_singular_jacobian( routinename )

      use mod_ddebd2, only: transp_Jac,                                 &
                            ddajac_failed, ddajac_must_quit

      character(len=*), intent(in) :: routinename
      !------ API end ------
#ifdef _DEVLP

      integer :: N
      type(mfArray) :: jacob_transp, nullspace

      real(kind=MF_DOUBLE) :: ddajac_rcond_min, tol2
      logical :: save_sing_jac, ddajac_investig, ddajac_rat_basis
      common /slatec_ddajac_status/ ddajac_rcond_min, save_sing_jac,    &
                                    ddajac_investig, ddajac_rat_basis

      integer ddaini_info
      common /slatec_ddaini_status/ ddaini_info

   !------ end of declarations -- execution starts hereafter  ------

   if( MF_NUMERICAL_CHECK ) then
      write(STDERR,*) "(MUESLI:) processing the Jacobian matrix..."
      if( allocated(transp_Jac) ) then
         N = size(transp_Jac,1)
         ! saving Jacobian (before ... call !)
         call msAssign( jacob_transp, mf(transp_Jac) )
         if( save_sing_jac ) then
            call msSaveAscii( "jacobian.dat", .t. jacob_transp )
            write(STDERR,*)
            write(STDERR,*) "Jacobian matrix has been saved in 'jacobian.dat'."
         end if

         ! finding the nullspace (rational basis)
         ! Very important: the tolerance for computing the nullspace cannot
         ! be too small, so we check that it is at least the machine epsilon.
         tol2 = max( ddajac_rcond_min, epsilon(1.0d0) )
!NEW: (13 nov 2015)
! moreover, this tolerance must be scaled? not sure!
!!print *, "[process_singular_jacobian] old tol2 = ", tol2
!!print *, "[process_singular_jacobian] N = ", N
!!call msDisplay( mfNorm(jacob_transp,'inf'), "mfNorm(jacob_transp,'inf')" )
!!call msSaveAscii( "jacob_transp.dat", jacob_transp )
!!tol2 = N*tol2*mfDble(mfNorm(jacob_transp,'inf'))
!!print *, "[process_singular_jacobian] new tol2 = ", tol2
         if( ddajac_rat_basis ) then
            call msAssign( nullspace, mfNull( jacob_transp,             &
                                              rational=.true.,          &
                                              tol=tol2 ) )
            call msDisplay( nullspace, "rational basis of the null space" )
         else
            call msAssign( nullspace, mfNull( jacob_transp,             &
                                              rational=.false.,         &
                                              tol=tol2 ) )
            call msDisplay( nullspace, "basis of the null space" )
         end if
         call msDisplay( mfSize(nullspace,2),"dim(nullspace)" )
         ! 80-char guide "12345678901234567890123456789012345678901234567890123456789012345678901234567890"
         write(STDERR,*)
         write(STDERR,*) " Above can be found an approximation of the null space. It may help you"
         write(STDERR,*) " detecting wrong equations in your system. Each column is a null vector of the"
         write(STDERR,*) " linear application and it shows, via its components, the dependencies between"
         write(STDERR,*) " the current equations coded in the 'resid()' routine."
         write(STDERR,*) " (note 1: the transpose of the jacobian matrix has been processed)"
         write(STDERR,*) " (note 2: if the nullspace appears as empty, try another smaller value for"
         write(STDERR,*) "          'rcond_jac_min')"
         if( save_sing_jac ) then
            call msSaveAscii( "nullspace.dat", nullspace )
            write(STDERR,*)
            write(STDERR,*) "A rational basis of the null space has been saved in 'nullspace.dat'."
         else
            write(STDERR,*)
            write(STDERR,*) "(MUESLI:) Information: by using the option 'save_sing_jac=.true.'"
            write(STDERR,*) "          you will be able to store it in a file."
         end if
         call msRelease( jacob_transp, nullspace )
      else
         write(STDERR,*) "(MUESLI:) Unable to process Jacobian matrix:"
         if( ddaini_info == -1 ) then
            write(STDERR,*) "          -> Got non-zero value of 'flag' from the RESID user-routine"
         else if( ddaini_info == -2 ) then
            write(STDERR,*) "          -> Jacobian matrix was not completed"
         else
            write(STDERR,*) "          -> Jacobian matrix not allocated"
!NEW: le message suivant s'apparente plus à une erreur interne
!          qui risque de dérouter l'utilisateur.
!          J'ai préféré remplacer par un message concernant un oubli.
!!            write(STDERR,*) "          -> only one call to DGECO in DDAJAC?"
            write(STDERR,*) "          -> did you set the 'jac_investig' option to TRUE?"
         end if
      end if
      ! important: reset of singular flags (many calls of Ode/Dae solvers
      !            may occur in the same program)
      ddajac_failed = .false.
      ddajac_must_quit = .false.
   else
      write(STDERR,*) "With the variable MF_NUMERICAL_CHECK set to '.true.', additional info would"
      write(STDERR,*) "be available about structure of the singular Jacobian matrix."
      write(STDERR,*) "[only for the dense case]"
   endif
      write(STDERR,*)

#endif
   end subroutine process_singular_jacobian
!_______________________________________________________________________
!
   subroutine msDaeSolve_SaveRest_mf( A, action )

      type(mfArray) :: A
      character(len=*), intent(in) :: action
      !------ API end ------
#ifdef _DEVLP

      ! Case of a non-sparse jacobian

      ! The following ones are declared in the MOD_DDEBD2 module:
      !   yy(:), yyp(:), rwork(:), iwork(:)

      !-----------------------

      character(len=7) :: string0
      integer :: neq, lrw, liw
      integer :: lr, li, k
      integer :: jac_struct, ml, mu

   !------ end of declarations -- execution starts hereafter  ------

      if( A%status_temporary ) then
         call PrintMessage( "msDaeSolve", "E",                          &
                            "mfArray 'A' cannot be temporary!" )
         return
      end if

      string0 = to_lower(action)

      if( string0 == "save" ) then
         ml         = iwork(1)
         mu         = iwork(2)
         jac_struct = iwork(17)
         neq        = iwork(18)
      else if( string0 == "restore" ) then
         ml         = A%double(1,1)
         mu         = A%double(2,1)
         jac_struct = A%double(17,1)
         neq        = A%double(18,1)
      else
         call PrintMessage( "msDaeSolve", "E",                          &
                            'bad argument: did you thought "save" or "restore"?' )
         return
      end if

      select case( jac_struct )
         case( 1 )
            ! Dense jacobian
            lrw = 40 + 9*neq + neq**2 ! full size of RWORK
         case( 2 )
            ! Banded jacobian provided by a user-defined routine
            lrw = 40 + 9*neq + (2*ml+mu+1)*neq
         case( 3 )
            ! Banded jacobian generated by Finite-Difference
            lrw = 40 + 9*neq + (2*ml+mu+1)*neq + 2*(neq/(ml+mu+1)+1)
         case( 4 )
            call PrintMessage( "msDaeSolve", "E",                       &
                               "When using a sparse jacobian, add an argument", &
                               "specifying the name of the routine which compute this jacobian." )
            return
         case default
            call PrintMessage( "msDaeSolve", "E",                       &
                               "When restoring internal data, jac_struct must", &
                               "be equal to 1, 2, 3 or 4." )
            return
      end select

      liw = 20 + neq ! full size of IWORK

      if( string0 == "save" ) then

         A = MF_EMPTY
         ! prepare user storage
         A%data_type = MF_DT_DBLE
         A%shape = [ lrw+liw, 1 ]
         allocate( A%double(lrw+liw,1) )

         ! copy parts of working arrays in module MOD_DDEBD2
         A%double(1:liw,1) = iwork(1:liw)
         k = liw

         A%double(k+1:k+lrw,1) = rwork(1:lrw)

      else if( string0 == "restore" ) then

         ! check storage
         if( A%shape(1) /= lrw+liw ) then
            call PrintMessage( "msDaeSolve", "E",                       &
                               "during user restore: bad size for first dimension of 'A'!" )
            return
         end if
         if( A%shape(2) /= 1 ) then
            call PrintMessage( "msDaeSolve", "E",                       &
                               "during user restore: bad size for second dimension of 'A'!" )
            return
         end if

         ! copy to working arrays in module MOD_DDEBD2
         if( allocated(rwork) ) then
            if( size(rwork) /= lrw ) then
               deallocate( rwork )
               allocate( rwork(lrw) )
            end if
         else
            allocate( rwork(lrw) )
         end if
         if( allocated(iwork) ) then
            if( size(iwork) /= liw ) then
               deallocate( iwork )
               allocate( iwork(liw) )
            end if
         else
            allocate( iwork(liw) )
         end if

         iwork(1:liw) = A%double(1:liw,1)
         k = liw

         rwork(1:lrw) = A%double(k+1:k+lrw,1)

      end if

#endif
   end subroutine msDaeSolve_SaveRest_mf
!_______________________________________________________________________
!
   subroutine msDaeSolve_SaveRest_SP_mf( A, action, jac_sparse )

      type(mfArray) :: A
      character(len=*), intent(in) :: action

      interface
         subroutine jac_sparse( t, y, yprime, cj, nrow, job, pd, ipd, jpd, nnz )
            import :: MF_DOUBLE
            real(kind=MF_DOUBLE), intent(in)     :: t, y(*), yprime(*), cj
            integer,              intent(in)     :: nrow, job
            real(kind=MF_DOUBLE), intent(out)    :: pd(*)
            integer,              intent(out)    :: ipd(*), jpd(*)
            integer,              intent(in out) :: nnz
            ! the CSC representation of the matrix is as follows:
            !   pd(1:nnz)    : values of the matrix entries
            !  ipd(1:nnz)    : contains the row indexes
            !  jpd(1:ncol+1) : the pointer to the beginning of the
            !                  columns, in arrays pd,ipd.
            !                (here, the matrix is square, the ncol=nrow)
            !
            ! when job=0, only the value of nnz must be returned
            !
            ! {pd,ipd} must contain all diagonal terms, even if they
            ! are null. (a test is made in SLATEC/DLSOD.F)
            !
            ! moreover, row indexes must be sorted in ascending order
            ! (constraint from UMFPACK)
         end subroutine jac_sparse
      end interface
      !------ API end ------
#ifdef _DEVLP

      ! Case of a sparse jacobian

      ! The following ones are declared in the MOD_DDEBD2 module:
      !   rwork(:), iwork(:), nnz, pd(:), ipd(:), jpd(:),
      !   ipd_c(:), jpd_c(:)

      !-----------------------

      character(len=7) :: string0
      integer :: neq, lrw, liw
      integer :: lr, li, k, li2
      integer :: jac_struct, job, nnz0, ivec(1)
      double precision :: rvec(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( A%status_temporary ) then
         call PrintMessage( "msDaeSolve", "E",                          &
                            "mfArray 'A' cannot be temporary!" )
         return
      end if

      string0 = to_lower(action)

      if( string0 == "save" ) then
         jac_struct = iwork(17)
         neq        = iwork(18)
      else if( string0 == "restore" ) then
         jac_struct = A%double(17,1)
         neq        = A%double(18,1)
      else
         call PrintMessage( "msDaeSolve", "E",                          &
                            'bad argument: did you thought "save" or "restore"?' )
         return
      end if

      select case( jac_struct )
         case( 4 )
            lrw = 40 + 9*neq
         case default
            call PrintMessage( "msDaeSolve", "E",                       &
                               "When using this interface, the jacobian must be sparse" )
            return
      end select

      liw = 20 + neq ! full size of IWORK
      li2 = 20  ! size for partial copy

      if( string0 == "save" ) then

         A = MF_EMPTY
         ! prepare user storage
         A%data_type = MF_DT_DBLE
         A%shape = [ li2+1+lrw, 1 ]
         allocate( A%double(li2+1+lrw,1) )

         ! copy parts of working arrays in module MOD_DDEBD2
         A%double(1:li2,1) = iwork(1:li2)
         k = li2

         A%double(k+1,1) = nnz
         k = k + 1

         A%double(k+1:k+lrw,1) = rwork(1:lrw)

      else if( string0 == "restore" ) then

         ! check storage
         if( A%shape(1) /= li2+1+lrw ) then
            call PrintMessage( "msDaeSolve", "E",                       &
                               "during user restore: bad size for first dimension of 'A'!" )
            return
         end if
         if( A%shape(2) /= 1 ) then
            call PrintMessage( "msDaeSolve", "E",                       &
                               "during user restore: bad size for second dimension of 'A'!" )
            return
         end if

         ! copy to working arrays in module MOD_DDEBD2
         if( allocated(rwork) ) then
            if( size(rwork) /= lrw ) then
               deallocate( rwork )
               allocate( rwork(lrw) )
            end if
         else
            allocate( rwork(lrw) )
         end if
         if( allocated(iwork) ) then
            if( size(iwork) /= liw ) then
               deallocate( iwork )
               allocate( iwork(liw) )
            end if
         else
            allocate( iwork(liw) )
         end if
#ifdef _DEVLP
         ! Avoid unitialized values in Valgrind...
         ! (because not all values are used)
         iwork(:) = 0
#endif

         iwork(1:li2) = A%double(1:li2,1)
         k = li2

         nnz = A%double(k+1,1)
         k = k + 1

         rwork(1:lrw) = A%double(k+1:k+lrw,1)

         ! allocation of 1D arrays (integer and real) for the sparse
         ! jacobian
         allocate( jpd(neq+1), jpd_c(neq+1) )
         allocate( pd(nnz), ipd(nnz), ipd_c(nnz) )
         ! just to initialize the routine computing the sparse jacobian
         job = 0
         call jac_sparse( 0.0d0, rvec, rvec, rvec(1), neq, job,         &
                          rvec, ivec, ivec, nnz0 )
         if( nnz0 /= nnz ) then
            call PrintMessage( "msDaeSolve", "E",                       &
                               "Cannot initialize jac_sparse routine!" )
            return
         end if

      end if

#endif
   end subroutine msDaeSolve_SaveRest_SP_mf
!_______________________________________________________________________
!
   subroutine msDaeSolve_Finalize( action )

      character(len=*), intent(in) :: action
      !------ API end ------
#ifdef _DEVLP

   !------ end of declarations -- execution starts hereafter  ------

      if( to_lower(action) /= "finalize" ) then
         call PrintMessage( "msDaeSolve", "E",                          &
                            'bad argument: did you thought "finalize"?' )
         return
      end if

      if( allocated(yy) ) then
         deallocate( yy )
      end if
      if( allocated(yyp) ) then
         deallocate( yyp )
      end if
      if( allocated(rwork) ) then
         deallocate( rwork )
      end if
      if( allocated(iwork) ) then
         deallocate( iwork )
      end if

      call ddebd2_free()

#endif
   end subroutine msDaeSolve_Finalize
