! f90 include file

!_______________________________________________________________________
!
   subroutine msSave_mfTriConnect( filename, x, compressed )

      character(len=*),  intent(in) :: filename
      type(mfTriConnect)            :: x
      logical, optional, intent(in) :: compressed
      !------ API end ------
#ifdef _DEVLP

      logical :: gzipped
      type(gz_filedes) :: gz_file

      integer :: unit, l, itmp
      integer :: nn, nt, nf, n_bnd, n_bnd_fac
      integer(kind=kind_1) :: byte(4)
      character(len=80) :: filenew
      character(len=*), parameter :: ROUTINE_NAME = "msSave"

   !------ end of declarations -- execution starts hereafter  ------

      if( len_trim(filename) == 0 ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "'filename' argument is an empty string!" )
         return
      end if

      if( .not. x%init ) then
         call PrintMessage( ROUTINE_NAME, "W",                          &
                            "your mfTriConnect structure is not initialized", &
                            "-> there is nothing to save.",             &
                            "[Exit]" )
         return
      end if

      call find_unit( unit )
      ! check if the file can be created (it may be a broken link not
      ! writable, because a folder is missing...)
      open( unit=unit, file=trim(adjustl(filename)), err=10 )
      go to 30 ! open is ok
 10   continue
      call PrintMessage( ROUTINE_NAME, "W",                             &
                         "file cannot be written! (broken link?)",      &
                         "file: " // trim(adjustl(filename)) )
      call msPause("As a last chance, you can try to fix the problem.")
      open( unit=unit, file=trim(adjustl(filename)), err=20 )
      go to 30 ! open is ok
 20   continue
      call PrintMessage( ROUTINE_NAME, "E",                             &
                         "file cannot be written!",                     &
                         "file: " // trim(adjustl(filename)) )
 30   continue
      close(unit)

      filenew = filename

      if( present(compressed) ) then
         if( compressed ) then
            gzipped = .true.
            l = len_trim(filenew)
            if( filenew(l-2:l) /= ".gz" ) then
               filenew = trim(filenew) // ".gz"
            end if
         else
            gzipped = .false.
         end if
      else
         ! trying to detect compress mode from filename suffix
         l = len_trim(filename)
         gzipped = .false.
         if( l > 3 ) then
            if( filename(l-2:l) == ".gz" ) then
               gzipped = .true.
            end if
         end if
      end if

      if( gzipped ) then

         gz_file = gzopen( trim(filenew), "wb" )

         if( filedes_is_null( gz_file ) ) then
            go to 99
         end if

         ! remark : in sequential-unformatted write, each record
         !          are preceeded and followed by the record size.

         ! signature :  bytes = 4+20+4 = 28
         l = len(MF_BIN_SIGN_25)
         call gzwrite( gz_file, l )
         call gzwrite( gz_file, MF_BIN_SIGN_25 )
         call gzwrite( gz_file, l )

         ! endianness : bytes = 4+4+4 = 12
         call gzwrite( gz_file, 4 )
         call gzwrite( gz_file, MF_ENDIAN_NATIVE )
         call gzwrite( gz_file, 4 )

         ! tag : bytes = 4+4+4 = 12
         call gzwrite( gz_file, 4 )
         ! For an mfTriConnect structure, the special "-1" tag is used
         itmp = -1
         call gzwrite( gz_file, itmp )
         call gzwrite( gz_file, 4 )

         ! init : bytes = 4+4+4 = 12
         call gzwrite( gz_file, 4 )
         if( x%init ) then
            call gzwrite( gz_file, 1 )
         else
            call gzwrite( gz_file, 0 )
            call gzwrite( gz_file, 4 )
            ! No need to write further data.
            call gzclose( gz_file )
            go to 99
         end if
         call gzwrite( gz_file, 4 )

         ! tri_renumbering : bytes = 4+4+4 = 12
         call gzwrite( gz_file, 4 )
         if( x%tri_renumbering ) then
            call gzwrite( gz_file, 1 )
         else
            call gzwrite( gz_file, 0 )
         end if
         call gzwrite( gz_file, 4 )

         ! face_oriented : bytes = 4+4+4 = 12
         call gzwrite( gz_file, 4 )
         if( x%face_oriented ) then
            call gzwrite( gz_file, 1 )
         else
            call gzwrite( gz_file, 0 )
         end if
         call gzwrite( gz_file, 4 )

         ! convex_domain : bytes = 4+4+4 = 12
         call gzwrite( gz_file, 4 )
         call gzwrite( gz_file, x%convex_domain )
         call gzwrite( gz_file, 4 )

         ! stored size so far: 28+6*12=100
         ! adding 4 for next: 100+4=104 <---- must be a multiple of 8 !

         nn = size(x%n_xy,1)
         nt = size(x%tri_n,1)
         nf = size(x%face_n,1)

         ! stored size: 4 + 4*4 + 4  (again a multiple of 8)
         call gzwrite( gz_file, 16 )
         call gzwrite( gz_file, [ nn, nt, nf, 0 ] )
         call gzwrite( gz_file, 16 )

         ! n_xy array
         if( .not. associated(x%n_xy) ) then
            print *, "msSave_mfTriConnect: line 159: internal error."
            print *, "    'n_xy' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         l = 8*nn*2
         call gzwrite( gz_file, l )
         call gzwrite( gz_file, x%n_xy )
         call gzwrite( gz_file, l )

         ! Hereafter, no needs to check the number of bytes written,
         ! because it will be always a multiple of 4 (last arrays all
         ! contain single precision integers)

         ! tri_n array
         if( .not. associated(x%tri_n) ) then
            print *, "msSave_mfTriConnect: line 175: internal error."
            print *, "    'tri_n' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         l = 4*nt*3
         call gzwrite( gz_file, l )
         call gzwrite( gz_file, x%tri_n )
         call gzwrite( gz_file, l )

         ! face_n array
         if( .not. associated(x%face_n) ) then
            print *, "msSave_mfTriConnect: line 187: internal error."
            print *, "    'face_n' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         l = 4*nf*2
         call gzwrite( gz_file, l )
         call gzwrite( gz_file, x%face_n )
         call gzwrite( gz_file, l )

         ! face_tri array
         if( .not. associated(x%face_tri) ) then
            print *, "msSave_mfTriConnect: line 199: internal error."
            print *, "    'face_tri' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         l = 4*nf*2
         call gzwrite( gz_file, l )
         call gzwrite( gz_file, x%face_tri )
         call gzwrite( gz_file, l )

         ! tri_f array
         if( .not. associated(x%tri_f) ) then
            print *, "msSave_mfTriConnect: line 211: internal error."
            print *, "    'tri_f' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         l = 4*nt*3
         call gzwrite( gz_file, l )
         call gzwrite( gz_file, x%tri_f )
         call gzwrite( gz_file, l )

         ! n_tri array
         if( .not. associated(x%n_tri) ) then
            print *, "msSave_mfTriConnect: line 223: internal error."
            print *, "    'n_tri' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         l = 4*nn
         call gzwrite( gz_file, l )
         call gzwrite( gz_file, x%n_tri )
         call gzwrite( gz_file, l )

         if( x%convex_domain /= -1 ) then

            ! Convexity is known and boundary faces have been determined.
            n_bnd = size(x%faces_boundary_ptr,1)
            n_bnd_fac = size(x%faces_boundary,1)

            ! stored size: 4 + 4*2 + 4  (again a multiple of 8)
            call gzwrite( gz_file, 8 )
            call gzwrite( gz_file, [ n_bnd, n_bnd_fac ] )
            call gzwrite( gz_file, 8 )

            ! faces_boundary array
            if( .not. associated(x%faces_boundary) ) then
               print *, "msSave_mfTriConnect: line 245: internal error."
               print *, "    'faces_boundary' array should be associated when 'convex_domain' is KNOWN!"
               pause "for debugging purpose only..."
               stop
            end if
            l = 4*n_bnd_fac
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%faces_boundary )
            call gzwrite( gz_file, l )

            ! faces_boundary_ptr array
            if( .not. associated(x%faces_boundary_ptr) ) then
               print *, "msSave_mfTriConnect: line 257: internal error."
               print *, "    'faces_boundary_ptr' array should be associated when 'convex_domain' is KNOWN!"
               pause "for debugging purpose only..."
               stop
            end if
            l = 4*n_bnd*2
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%faces_boundary_ptr )
            call gzwrite( gz_file, l )

         end if

         call gzclose( gz_file )

      else ! not gzipped

         call find_unit( unit )

         open( unit=unit, file=trim(adjustl(filename)),                 &
               form="unformatted" )

         ! signature :  bytes = 4+20+4 = 28
         write(unit) MF_BIN_SIGN_25

         ! endianness : bytes = 4+4+4 = 12
         write(unit) MF_ENDIAN_NATIVE

         ! tag : bytes = 4+4+4 = 12
         ! For an mfTriConnect structure, the special "-1" tag is used
         itmp = -1
         write(unit) itmp

         ! init : bytes = 4+4+4 = 12
         write(unit) x%init
         if( .not. x%init ) then
            ! No need to write further data.
            close(unit)
            go to 99
         end if

         ! tri_renumbering : bytes = 4+4+4 = 12
         write(unit) x%tri_renumbering

         ! face_oriented : bytes = 4+4+4 = 12
         write(unit) x%face_oriented

         ! convex_domain : bytes = 4+4+4 = 12
         write(unit) x%convex_domain

         ! stored size so far: 28+6*12=100
         ! adding 4 for next: 100+4=104 <---- must be a multiple of 8 !

         nn = size(x%n_xy,1)
         nt = size(x%tri_n,1)
         nf = size(x%face_n,1)

         ! stored size: 4 + 4*4 + 4  (again a multiple of 8)
         write(unit) nn, nt, nf, 0

         ! n_xy array
         if( .not. associated(x%n_xy) ) then
            print *, "msSave_mfTriConnect: line 319: internal error."
            print *, "    'n_xy' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         write(unit) x%n_xy

         ! Hereafter, no needs to check the number of bytes written,
         ! because it will be always a multiple of 4 (last arrays all
         ! contain single precision integers)

         ! tri_n array
         if( .not. associated(x%tri_n) ) then
            print *, "msSave_mfTriConnect: line 332: internal error."
            print *, "    'tri_n' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         write(unit) x%tri_n

         ! face_n array
         if( .not. associated(x%face_n) ) then
            print *, "msSave_mfTriConnect: line 341: internal error."
            print *, "    'face_n' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         write(unit) x%face_n

         ! face_tri array
         if( .not. associated(x%face_tri) ) then
            print *, "msSave_mfTriConnect: line 350: internal error."
            print *, "    'face_tri' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         write(unit) x%face_tri

         ! tri_f array
         if( .not. associated(x%tri_f) ) then
            print *, "msSave_mfTriConnect: line 359: internal error."
            print *, "    'tri_f' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         write(unit) x%tri_f

         ! n_tri array
         if( .not. associated(x%n_tri) ) then
            print *, "msSave_mfTriConnect: line 368: internal error."
            print *, "    'n_tri' array should be associated when 'init' is TRUE!"
            pause "for debugging purpose only..."
            stop
         end if
         write(unit) x%n_tri

         if( x%convex_domain /= -1 ) then

            ! Convexity is known and boundary faces have been determined.
            n_bnd = size(x%faces_boundary_ptr,1)
            n_bnd_fac = size(x%faces_boundary,1)

            ! stored size: 4 + 4*2 + 4  (again a multiple of 8)
            write(unit) n_bnd, n_bnd_fac

            ! faces_boundary array
            if( .not. associated(x%faces_boundary) ) then
               print *, "msSave_mfTriConnect: line 386: internal error."
               print *, "    'faces_boundary' array should be associated when 'convex_domain' is KNOWN!"
               pause "for debugging purpose only..."
               stop
            end if
            write(unit) x%faces_boundary

            ! faces_boundary_ptr array
            if( .not. associated(x%faces_boundary_ptr) ) then
               print *, "msSave_mfTriConnect: line 395: internal error."
               print *, "    'faces_boundary_ptr' array should be associated when 'convex_domain' is KNOWN!"
               pause "for debugging purpose only..."
               stop
            end if
            write(unit) x%faces_boundary_ptr

         end if

         close(unit)

      end if

 99   continue

#endif
   end subroutine msSave_mfTriConnect
