! f90 include file

!_______________________________________________________________________
!
   subroutine msSave_mfArray( filename, x, compressed )

      character(len=*),  intent(in) :: filename
      type(mfArray)                 :: x
      logical, optional, intent(in) :: compressed
      !------ API end ------
#ifdef _DEVLP

      logical :: gzipped
      type(gz_filedes) :: gz_file

      integer :: unit, l, bytes_written, itmp
      integer :: nrow, ncol, nnz
      integer(kind=kind_1) :: byte(4)
      character(len=80) :: filenew
      character(len=*), parameter :: ROUTINE_NAME = "msSave"

   !------ end of declarations -- execution starts hereafter  ------

      if( len_trim(filename) == 0 ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "'filename' argument is an empty string!" )
         return
      end if

      call msInitArgs( x )

      if( x%prop%tril < UNKNOWN ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "mfArray cannot be stored in MBF because its 'tril' property", &
                            "is currently hidden! [use of msPointer]" )
         go to 99
      end if

      if( x%prop%triu < UNKNOWN ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "mfArray cannot be stored in MBF because its 'triu' property", &
                            "is currently hidden! [use of msPointer]" )
         go to 99
      end if

      if( x%prop%symm < UNKNOWN ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "mfArray cannot be stored in MBF because its 'symm' property", &
                            "is currently hidden! [use of msPointer]" )
         go to 99
      end if

      if( x%prop%posd < UNKNOWN ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "mfArray cannot be stored in MBF because its 'pos_def' property", &
                            "is currently hidden! [use of msPointer]" )
         go to 99
      end if

      call find_unit( unit )
      ! check if the file can be created (it may be a broken link not
      ! writable, because a folder is missing...)
      open( unit=unit, file=trim(adjustl(filename)), err=10 )
      go to 30 ! open is ok
 10   continue
      call PrintMessage( ROUTINE_NAME, "W",                             &
                         "file cannot be written! (broken link?)",      &
                         "file: " // trim(adjustl(filename)) )
      call msPause("As a last chance, you can try to fix the problem.")
      open( unit=unit, file=trim(adjustl(filename)), err=20 )
      go to 30 ! open is ok
 20   continue
      call PrintMessage( ROUTINE_NAME, "E",                             &
                         "file cannot be written!",                     &
                         "file: " // trim(adjustl(filename)) )
 30   continue
      close(unit)

      filenew = filename

      if( present(compressed) ) then
         if( compressed ) then
            gzipped = .true.
            l = len_trim(filenew)
            if( filenew(l-2:l) /= ".gz" ) then
               filenew = trim(filenew) // ".gz"
            end if
         else
            gzipped = .false.
         end if
      else
         ! trying to detect compress mode from filename suffix
         l = len_trim(filename)
         gzipped = .false.
         if( l > 3 ) then
            if( filename(l-2:l) == ".gz" ) then
               gzipped = .true.
            end if
         end if
      end if

      if( gzipped ) then

         gz_file = gzopen( trim(filenew), "wb" )

         if( filedes_is_null( gz_file ) ) then
            go to 99
         end if

         bytes_written = 0

         ! remark : in sequential-unformatted write, each record
         !          are preceeded and followed by the record size.

         ! signature :  bytes = 4+20+4 = 28
         bytes_written = bytes_written + 28
         l = len(MF_BIN_SIGN_25)
         call gzwrite( gz_file, l )
         call gzwrite( gz_file, MF_BIN_SIGN_25 )
         call gzwrite( gz_file, l )

         ! endianness : bytes = 4+4+4 = 12
         bytes_written = bytes_written + 12
         call gzwrite( gz_file, 4 )
         call gzwrite( gz_file, MF_ENDIAN_NATIVE )
         call gzwrite( gz_file, 4 )

         ! data_type : bytes = 4+4+4 = 12
         bytes_written = bytes_written + 12
         call gzwrite( gz_file, 4 )
         itmp = x%data_type
         call gzwrite( gz_file, itmp )
         call gzwrite( gz_file, 4 )
         if( x%data_type == MF_DT_EMPTY ) then ! MF_EMPTY
            call gzclose( gz_file )
            go to 99
         end if

         ! array shape : bytes = 4+8+4 = 16
         bytes_written = bytes_written + 16
         call gzwrite( gz_file, 8 )
         call gzwrite( gz_file, x%shape )
         call gzwrite( gz_file, 8 )

         nrow = x%shape(1)
         ncol = x%shape(2)

         ! stored size so far: 28+12+12+16=68
         ! adding 4 for next: 68+4=72 <---- must be a multiple of 8 !

         ! array data (column-wise in Fortran, if 2D array)
         if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then ! real or boolean case
            l = 8*nrow*ncol
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%double )
            call gzwrite( gz_file, l )
         else if( x%data_type == MF_DT_CMPLX ) then
            l = 16*nrow*ncol
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%cmplx )
            call gzwrite( gz_file, l )
         else if( x%data_type == MF_DT_SP_DBLE ) then
            ! nnz : bytes = 4+4+4 = 12
            bytes_written = bytes_written + 12
            nnz = x%j(ncol+1) - 1
            l = 4
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, nnz )
            call gzwrite( gz_file, l )
            ! x%j : bytes = 4 + 4*(ncol+1) + 4
            bytes_written = bytes_written + 4 + 4*(ncol+1) + 4
            l = 4*(ncol+1)
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%j(1:ncol+1) )
            call gzwrite( gz_file, l )
            ! x%i : bytes = 4 + 4*(nnz) + 4
            bytes_written = bytes_written + 4 + 4*(nnz) + 4
            ! for reading 'x%a' (in direct access and swap_bytes case)
            ! by 'mfLoad', bytes_written+4 must be a multiple of 8.
            if( mod(bytes_written+4,8) /= 0 ) then
               l = 4*nnz + 4
            else
               l = 4*nnz
            end if
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%i(1:nnz) )
            if( mod(bytes_written+4,8) /= 0 ) then
               call gzwrite( gz_file, 0 )
            end if
            call gzwrite( gz_file, l )
            l = 8*nnz
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%a(1:nnz) )
            call gzwrite( gz_file, l )
         else if( x%data_type == MF_DT_SP_CMPLX ) then
            ! nnz : bytes = 4+4+4 = 12
            bytes_written = bytes_written + 12
            nnz = x%j(ncol+1) - 1
            l = 4
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, nnz )
            call gzwrite( gz_file, l )
            ! x%j : bytes = 4 + 4*(ncol+1) + 4
            bytes_written = bytes_written + 4 + 4*(ncol+1) + 4
            l = 4*(ncol+1)
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%j(1:ncol+1) )
            call gzwrite( gz_file, l )
            ! x%i : bytes = 4 + 4*(nnz) + 4
            bytes_written = bytes_written + 4 + 4*(nnz) + 4
            ! for reading 'x%a' (in direct access and swap_bytes case)
            ! by 'mfLoad', bytes_written+4 must be a multiple of 8.
            if( mod(bytes_written+4,8) /= 0 ) then
               l = 4*nnz + 4
            else
               l = 4*nnz
            end if
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%i(1:nnz) )
            if( mod(bytes_written+4,8) /= 0 ) then
               call gzwrite( gz_file, 0 )
            end if
            call gzwrite( gz_file, l )
            l = 16*nnz
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%z(1:nnz) )
            call gzwrite( gz_file, l )
         else if( x%data_type == MF_DT_PERM_VEC ) then
            l = 4*nrow
            call gzwrite( gz_file, l )
            call gzwrite( gz_file, x%i )
            call gzwrite( gz_file, l )
         else
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "unknown data type" )
            go to 99
         end if

         l = (4*1)
         call gzwrite( gz_file, l )
         call gzwrite( gz_file, x%prop%tril )
         call gzwrite( gz_file, x%prop%triu )
         call gzwrite( gz_file, x%prop%symm )
         call gzwrite( gz_file, x%prop%posd )
         call gzwrite( gz_file, l )

         l = (2*2)*size(x%units)
         call gzwrite( gz_file, l )
         call gzwrite( gz_file, x%units )
         call gzwrite( gz_file, l )

         call gzclose( gz_file )

      else ! not gzipped

         call find_unit( unit )

         open( unit=unit, file=trim(adjustl(filename)),                 &
               form="unformatted" )

         bytes_written = 0

         ! signature :  bytes = 4+20+4 = 28
         bytes_written = bytes_written + 28
         write(unit) MF_BIN_SIGN_25

         ! endianness : bytes = 4+4+4 = 12
         bytes_written = bytes_written + 12
         write(unit) MF_ENDIAN_NATIVE

         ! data_type : bytes = 4+4+4 = 12
         bytes_written = bytes_written + 12
         itmp = x%data_type
         write(unit) itmp
         if( x%data_type == MF_DT_EMPTY ) then ! MF_EMPTY
            close(unit)
            go to 99
         end if

         ! array shape : bytes = 4+8+4 = 16
         bytes_written = bytes_written + 16
         nrow = x%shape(1)
         ncol = x%shape(2)
         write(unit) nrow, ncol

         ! stored size so far: 28+12+12+16=68
         ! adding 4 for next: 68+4=72 <---- must be a multiple of 8 !

         ! array data (column-wise in Fortran, if 2D array)
         if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then ! real or boolean case
            write(unit) x%double(:,:)
         else if( x%data_type == MF_DT_CMPLX ) then
            write(unit) x%cmplx(:,:)
         else if( x%data_type == MF_DT_SP_DBLE ) then
            ! nnz : bytes = 4+4+4 = 12
            bytes_written = bytes_written + 12
            nnz = x%j(ncol+1) - 1
            write(unit) nnz
            ! x%j : bytes = 4 + 4*(ncol+1) + 4
            bytes_written = bytes_written + 4 + 4*(ncol+1) + 4
            write(unit) x%j(1:ncol+1)
            ! x%i : bytes = 4 + 4*(nnz) + 4
            bytes_written = bytes_written + 4 + 4*(nnz) + 4
            ! for reading 'x%a' (in direct access and swap_bytes case) by 'mfLoad',
            ! bytes_written+4 must be a multiple of 8.
            if( mod(bytes_written+4,8) == 0 ) then
               write(unit) x%i(1:nnz)
            else
               write(unit) x%i(1:nnz), 0
               bytes_written = bytes_written + 4
            end if
            write(unit) x%a(1:nnz)
         else if( x%data_type == MF_DT_SP_CMPLX ) then
            ! nnz : bytes = 4+4+4 = 12
            bytes_written = bytes_written + 12
            nnz = x%j(ncol+1) - 1
            write(unit) nnz
            ! x%j : bytes = 4 + 4*(ncol+1) + 4
            bytes_written = bytes_written + 4 + 4*(ncol+1) + 4
            write(unit) x%j(1:ncol+1)
            ! x%i : bytes = 4 + 4*(nnz) + 4
            bytes_written = bytes_written + 4 + 4*(nnz) + 4
            ! for reading 'x%z' (in direct access and swap_bytes case) by 'mfLoad',
            ! bytes_written+4 must be a multiple of 8.
            if( mod(bytes_written+4,8) == 0 ) then
               write(unit) x%i(1:nnz)
            else
               write(unit) x%i(1:nnz), 0
               bytes_written = bytes_written + 4
            end if
            write(unit) x%z(1:nnz)
         else if( x%data_type == MF_DT_PERM_VEC ) then
            write(unit) x%i(:)
         else
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "unknown data type" )
            close(unit)
            go to 99
         end if

         ! matrix pattern and properties
         ! we want to write 4 different bytes as only one 4-bytes_written
         ! (reading will be easier, especially in a different endianness)
         byte(1:4) = [ x%prop%tril, x%prop%triu, x%prop%symm, x%prop%posd ]
         write(unit) transfer(byte,0)

         ! physical unit
         write(unit) x%units(1:num_base_units)

         close(unit)

      end if

 99   continue

      call msFreeArgs( x )

      call msAutoRelease( x )

#endif
   end subroutine msSave_mfArray
