! f90 include file

!_______________________________________________________________________
!
   subroutine msSaveSparse( filename, A, format )

      character(len=*), intent(in) :: filename
      type(mfArray) :: A
      character(len=3), intent(in), optional :: format
      !------ API end ------
#ifdef _DEVLP

      ! stored in order : pointer, indexes, values
      integer :: nrow, ncol, nnz, ifmt
      integer :: unit
      ! formatting is from SMLIB-1.1
      integer :: field_len, rec_len, num_recs
      character(len=80) :: form
      character(len=3) :: format0
      character(len=72) :: title
      ! work arrays
      integer,                 allocatable :: wk_i(:), wk_j(:)
      real(kind=MF_DOUBLE),    allocatable :: wk_a(:)
      complex(kind=MF_DOUBLE), allocatable :: wk_z(:)
      ! rhs : dummy vector -- should not be referenced inside 'prtmt'
      real(kind=MF_DOUBLE) :: rhs(1)
      integer :: i, j, k, nb_entries, record
      character(len=*), parameter :: ROUTINE_NAME = "msSaveSparse"

   !------ end of declarations -- execution starts hereafter  ------

      if( len_trim(filename) == 0 ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "'filename' argument is an empty string!" )
         return
      end if

      call msInitArgs( A )

      if( .not. mfIsSparse(A) ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "mfArray is not sparse!" )
         go to 99
      end if

      if( present(format) ) then
         format0 = to_lower(format)
      else
         format0 = "csc"
      end if

      call find_unit( unit )
      open( unit=unit, file=trim(adjustl(filename)) )

      nrow = A%shape(1)
      ncol = A%shape(2)
      nnz  = A%j(ncol+1) - 1

      select case( format0 )
      case( "csc" )

         if( A%row_sorted < -1 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "mfArray cannot be stored in CSC because its 'row_sorted'", &
                               "property is currently hidden!",        &
                               "[use of msPointer]" )
            go to 99
         end if

         ! dynamic format : we suppose that the default Record_Length of
         ! the compiler is at least : 80
         if( A%data_type == MF_DT_SP_DBLE ) then
            write(unit,"(I0,1X,I0,1X,I0,1X,A)")                         &
                       A%shape, A%row_sorted, "csc real"
         else if( A%data_type == MF_DT_SP_CMPLX ) then
            write(unit,"(I0,1X,I0,1X,I0,1X,A)")                         &
                       A%shape, A%row_sorted, "csc complex"
         end if

         field_len = 2 + int(log10(real(nnz+1))+epsilon(1.0e0))
         rec_len   = 80/field_len
         num_recs  = ceiling(real(ncol)/real(rec_len)) + 1
         write(form,"(A,I0,A,I0,A,I0,A)")                               &
               "(", num_recs, "(", rec_len, "i", field_len, ",/))"
         write(unit,form) A%j(1:ncol+1)

         if( nnz /= 0 ) then

            field_len = 2 + int(log10(real(ncol))+epsilon(1.0e0))
            rec_len   = 80/field_len
            num_recs  = ceiling(real(nnz)/real(rec_len)) + 1
            write(form,"(A,I0,A,I0,A,I0,A)")                            &
                  "(", num_recs, "(", rec_len, "i", field_len, ",/))"
            write(unit,form) A%i(1:nnz)

            field_len = 8 + precision(1.0_MF_DOUBLE)
            rec_len   = 80/field_len
            num_recs  = ceiling(real(nnz)/real(rec_len)) + 1
            if( A%data_type == MF_DT_SP_DBLE ) then
               write(form,"(A,I0,A,I0,A,I0,A,I0,A)")                    &
                     "(", num_recs, "(", rec_len, "es", field_len,      &
                     ".", precision (1.0_MF_DOUBLE), "e2,/))"
               write(unit,form) A%a(1:nnz)
            else if( A%data_type == MF_DT_SP_CMPLX ) then
               write(form,"(A,I0,A,I0,A,I0,A,I0,A)")                    &
                     "(", 2*num_recs, "(", rec_len, "es", field_len,    &
                     ".", precision (1.0_MF_DOUBLE), "e2,/))"
               write(unit,form) A%z(1:nnz)
            end if

         end if

      case( "csr" )

         allocate( wk_i(nrow+1), wk_j(nnz) )

         ! dynamic format : we suppose that the default Record_Length of
         ! the compiler is at least : 80
         ! note: after transposition, matrix is col sorted, whatever
         !       its row_sorted property
         if( A%data_type == MF_DT_SP_DBLE ) then
            write(unit,"(I0,1X,I0,1X,I0,1X,A)")                         &
                       A%shape, TRUE, "csr real"
            allocate( wk_a(nnz) )
            call csc_transp( nrow, ncol, A%a, A%i, A%j, wk_a, wk_j, wk_i )
         else if( A%data_type == MF_DT_SP_CMPLX ) then
            write(unit,"(I0,1X,I0,1X,I0,1X,A)")                         &
                       A%shape, TRUE, "csr complex"
            allocate( wk_z(nnz) )
            call csc_transp_cmplx( nrow, ncol, A%z, A%i, A%j,           &
                                   wk_z, wk_j, wk_i )
         end if

         field_len = 2 + int(log10(real(nnz+1))+epsilon(1.0e0))
         rec_len   = 80/field_len
         num_recs  = ceiling(real(nrow)/real(rec_len)) + 1
         write(form,"(A,I0,A,I0,A,I0,A)")                               &
               "(", num_recs, "(", rec_len, "i", field_len, ",/))"
         write(unit,form) wk_i(1:nrow+1)

         if( nnz /= 0 ) then

            field_len = 2 + int(log10(real(nrow))+epsilon(1.0e0))
            rec_len   = 80/field_len
            num_recs  = ceiling(real(nnz)/real(rec_len)) + 1
            write(form,"(A,I0,A,I0,A,I0,A)")                            &
                  "(", num_recs, "(", rec_len, "i", field_len, ",/))"
            write(unit,form) wk_j(1:nnz)

            field_len = 8 + precision(1.0_MF_DOUBLE)
            rec_len   = 80/field_len
            num_recs  = ceiling(real(nnz)/real(rec_len)) + 1
            if( A%data_type == MF_DT_SP_DBLE ) then
               write(form,"(A,I0,A,I0,A,I0,A,I0,A)")                    &
                     "(", num_recs, "(", rec_len, "es", field_len,      &
                     ".", precision (1.0_MF_DOUBLE), "e2,/))"
               write(unit,form) wk_a(1:nnz)
            else if( A%data_type == MF_DT_SP_CMPLX ) then
               write(form,"(A,I0,A,I0,A,I0,A,I0,A)")                    &
                     "(", 2*num_recs, "(", rec_len, "es", field_len,    &
                     ".", precision (1.0_MF_DOUBLE), "e2,/))"
               write(unit,form) wk_z(1:nnz)
            end if

         end if

      case( "hbo" )

         title = "sparse matrix from mfArray"

         ifmt = 15 ! full double precision
         call prtmt( nrow, ncol, A%a, A%i, A%j, rhs, "  ", title,       &
                     "MMMMMMMM", "RUA", ifmt, 2, unit )

      case( "mtx", "coo" )

         ! write header
         write(unit,"(A)",advance="no") "%%MatrixMarket matrix coordinate"
         ! file length = 32

         if( A%data_type == MF_DT_SP_DBLE ) then

            write(unit,"(A)",advance="no") " real"
            ! file length = 32 + 5 = 37

            if( A%prop%symm == TRUE ) then
               write(unit,"(A14)") " symmetric    " ! keep the trailing blanks
               ! file length = 37 + 14 + <CR> = 52
               ! we reserve 9 bytes for the number of entries
               write(unit,"(I9,1X,I9,1X,A9)") A%shape, "         "
               ! bytes position = 52 + 9 + 1 + 9 + 1 = 72 = 8*9
               record = 8 + 1
               nb_entries = 0
               do j = 1, ncol
                  do k = A%j(j), A%j(j+1)-1
                     ! writing only the upper triangular part
                     i = A%i(k)
                     if( i >= j ) then
                        write(unit,"(I0,1X,I0,1X,ES23.15E3)")           &
                                   i, j, A%a(k)
                        nb_entries = nb_entries + 1
                     end if
                  end do
               end do
               close(unit)
               ! re-open file in direct access
               open( unit=unit, file=trim(adjustl(filename)),           &
                     access="direct", form="formatted", recl=9 )
               write(unit,"(I9)",rec=record) nb_entries
               close(unit)
            else
               write(unit,"(A)") " general"
               write(unit,"(I9,1X,I9,1X,I9)") A%shape, A%j(ncol+1)-1
               do j = 1, ncol
                  do k = A%j(j), A%j(j+1)-1
                     write(unit,"(I0,1X,I0,1X,ES23.15E3)")              &
                                A%i(k), j, A%a(k)
                  end do
               end do
               close(unit)
            end if

         else if( A%data_type == MF_DT_SP_CMPLX ) then

            write(unit,"(A)",advance="no") " complex"
            ! file length = 32 + 8 = 40

            if( A%prop%symm == TRUE ) then
               write(unit,"(A11)") " hermitian " ! keep the trailing blanks
               ! file length = 40 + 11 + <CR> = 52
               ! we reserve 9 bytes for the number of entries
               write(unit,"(I9,1X,I9,1X,A9)") A%shape, "         "
               ! bytes position = 52 + 9 + 1 + 9 + 1 = 72 = 8*9
               record = 8 + 1
               nb_entries = 0
               do j = 1, ncol
                  do k = A%j(j), A%j(j+1)-1
                     ! writing only the upper triangular part
                     i = A%i(k)
                     if( i >= j ) then
                        write(unit,"(I0,1X,I0,1X,ES23.15E3,1X,E23.15E3)") &
                                   i, j, A%z(k)
                        nb_entries = nb_entries + 1
                     end if
                  end do
               end do
               close(unit)
               ! re-open file in direct access
               open( unit=unit, file=trim(adjustl(filename)),           &
                     access="direct", form="formatted", recl=9 )
               write(unit,"(I9)",rec=record) nb_entries
               close(unit)
            else
               write(unit,"(A)") " general"
               write(unit,"(I9,1X,I9,1X,I9)") A%shape, A%j(ncol+1)-1
               do j = 1, ncol
                  do k = A%j(j), A%j(j+1)-1
                     write(unit,"(I0,1X,I0,1X,ES23.15E3,1X,E23.15E3)")  &
                                A%i(k), j, A%z(k)
                  end do
               end do
               close(unit)
            end if

         end if

      case default

         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "unknown requested format!" )

      end select

      close(unit)

 99   continue

      call msFreeArgs( A )

#endif
   end subroutine msSaveSparse
