! f90 include file

!_______________________________________________________________________
!
   subroutine msSaveAscii( filename, x, append, format )

      character(len=*), intent(in)           :: filename
      type(mfArray)                          :: x
      logical,          intent(in), optional :: append
      character(len=*), intent(in), optional :: format
      !------ API end ------
#ifdef _DEVLP

      integer :: i, j, unit
      character(len=12) :: j_chr

      ! the format (E23.16) is not sufficient for writing the "E" letter
      ! of the exponent for very small numbers, as 0.5E-100
      character(len=*), parameter :: fmt_default = "ES23.15E3"

      character(len=80) :: dyn_fmt
      integer :: recl
      character(len=6) :: position
      character(len=12) :: fmt
      logical :: real_format
      real(kind=MF_DOUBLE) :: xx

      character(len=*), parameter :: ROUTINE_NAME = "msSaveAscii"

   !------ end of declarations -- execution starts hereafter  ------

      if( len_trim(filename) == 0 ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "'filename' argument is an empty string!" )
         return
      end if

      call msInitArgs( x )

      if( present(append) ) then
         if( append ) then
            position ='APPEND'
         else
            position = 'ASIS'
         end if
      else
         position = 'ASIS'
      end if

      call find_unit( unit )
      ! check if the file can be created (it may be a broken link not
      ! writable, because a folder is missing...)

      if( mfIsEmpty(x) ) then
         open( unit=unit, file=trim(adjustl(filename)),                 &
               position=position, err=10 )
         go to 30 ! open is ok
 10      continue
         call PrintMessage( ROUTINE_NAME, "W",                          &
                            "file cannot be written! (broken link?)",   &
                            "file: " // trim(adjustl(filename)) )
         call msPause("As a last chance, you can try to fix the problem.")
         open( unit=unit, file=trim(adjustl(filename)),                 &
               position=position, err=20 )
         go to 30 ! open is ok
 20      continue
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "file cannot be written!",                  &
                            "file: " // trim(adjustl(filename)) )
 30      continue
         write(unit,*)
         close(unit)
         go to 99
      end if

      if( present(format) ) then
         if( format == "" ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "'format' argument cannot be empty!" )
            go to 99
         end if
         fmt = adjustl(format)
         ! detect if it is a format for integers
         if( to_upper(fmt(1:1)) == "I" ) then
            real_format = .false.
         else
            real_format = .true.
         end if
      else
         fmt = fmt_default
         real_format = .true.
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "for saving a sparse matrix,",              &
                            "please use 'msSaveSparse'" )
         go to 99
      end if

      if( x%data_type /= MF_DT_BOOL .and. x%data_type /= MF_DT_PERM_VEC ) then
         if( .not. All(mfIsFinite(x)) ) then
            call PrintMessage( ROUTINE_NAME, "W",                       &
                               "mfArray contains non finite values (Inf/NaN)",&
                               "It can be read only with 'ieee' flag of mfLoadAscii!" )
         end if
      end if

      ! define RECL (important for large number of columns).
      ! 24 is chosen because below the write format use 23 chars for
      !    the real plus 1 for a space
#if defined _INTEL_IFC
! BUG: INTEL-ifort (release 10.1 and other versions...)
      recl = (24 + 1)* x%shape(2) ! (+1 for INTEL-ifort, bug)
#else
      recl = 24 * x%shape(2)
#endif
      if( recl <= 0 ) then
         write(STDERR,*) "(MUESLI msSaveAscii:) internal error: recl <= 0"
         mf_message_displayed = .true.
         call muesli_trace( pause ="yes" )
         stop
      end if
      open( unit=unit, recl=recl, file=trim(adjustl(filename)),         &
            position=position, err=40 )
      go to 60 ! open is ok
 40   continue
      call PrintMessage( ROUTINE_NAME, "W",                             &
                         "file cannot be written! (broken link?)",      &
                         "file: " // trim(adjustl(filename)) )
      call msPause("As a last chance, you can try to fix the problem.")
      open( unit=unit, recl=recl, file=trim(adjustl(filename)),         &
            position=position, err=50 )
      go to 60 ! open is ok
 50   continue
      call PrintMessage( ROUTINE_NAME, "E",                             &
                         "file cannot be written!",                     &
                         "file: " // trim(adjustl(filename)) )
 60   continue

      ! writing with the greatest precision
      write(j_chr,"(I0)") x%shape(2)
      dyn_fmt = "(" // trim(adjustl(j_chr)) // "(" // fmt // ",1X))"
      if( x%data_type == MF_DT_DBLE ) then ! real case
         if( real_format ) then
            do i = 1, x%shape(1)
               write(unit,dyn_fmt) ( x%double(i,j), j = 1, x%shape(2) )
            end do
         else
            do i = 1, x%shape(1)
               ! Check that numbers are all integers
               do j = 1, x%shape(2)
                  xx = x%double(i,j)
                  if( dble(int(xx)) /= xx ) then
                     call PrintMessage( ROUTINE_NAME, "E",              &
                                        "integer format used for at least one real numbers" )
                     go to 99
                  end if
               end do
               write(unit,dyn_fmt) ( int(x%double(i,j)), j = 1, x%shape(2) )
            end do
         end if
      else if( x%data_type == MF_DT_CMPLX ) then ! complex case
         if( .not. real_format ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "integer format not allowed for complex numbers" )
            go to 99
         end if
         call PrintMessage( ROUTINE_NAME, "W",                          &
                            "Imaginary part of complex variable",       &
                            "not saved to an ASCII file!" )
         do i = 1, x%shape(1)
            write(unit,dyn_fmt) ( real(x%cmplx(i,j)), j = 1, x%shape(2) )
         end do
      else if( x%data_type == MF_DT_BOOL ) then ! boolean case
         call PrintMessage( ROUTINE_NAME, "W",                          &
                            "Writing a boolean mfArray to an ASCII file.", &
                            "(mfArray will be later considered as real)" )
         if( real_format ) then
            do i = 1, x%shape(1)
               write(unit,dyn_fmt) ( x%double(i,j), j = 1, x%shape(2) )
            end do
         else
            do i = 1, x%shape(1)
               ! (No need to check that numbers are integers ;-)
               write(unit,dyn_fmt) ( int(x%double(i,j)), j = 1, x%shape(2) )
            end do
         end if
      else if( x%data_type == MF_DT_PERM_VEC ) then ! permutation vector
         call PrintMessage( ROUTINE_NAME, "W",                          &
                            "Writing a permutation vector to an ASCII file.", &
                            "(mfArray will be later considered as real)" )
         do i = 1, x%shape(1)
            write(unit,"(I0)") x%i(i)
         end do
      else
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "unknown data type" )
         go to 99
      end if

      close(unit)

 99   continue

      call msFreeArgs( x )

      call msAutoRelease( x )

#endif
   end subroutine msSaveAscii
