! f90 include file

!_______________________________________________________________________
!
   subroutine msLoadSparse( out, filename,                              &
                            format, duplicated_entries )

      character(len=*), intent(in)           :: filename
      character(len=3), intent(in), optional :: format
      character(len=*), intent(in), optional :: duplicated_entries
      type(mf_Out) :: out
      !------ API end ------
#ifdef _DEVLP

      ! import a sparse structure from a file, and possibly a RHS
      !
      ! supported format : HBO : Harwell-Boeing
      !
      ! duplicated_entries : "added"       [default] (as in Matlab)
      !                      "ignored"
      !                      "replaced"

      type(mfArray), pointer :: A, RHS

      ! stored in order : pointer, indexes, values
      integer :: nrow, ncol, nnz, col_sorted
      integer :: i, n, unit, nmax, nzmax, job, nrhs, ierr, nvec
      character(len=3) :: form
      character(len=7) :: kind
      character(len=3) :: format0
      character(len=2) :: guesol
      character(len=72) :: title
      character(len=8) :: key
      character(len=3) :: type

      ! rhs : dummy vector -- should not be referenced inside 'readmt'
      real(kind=MF_DOUBLE), pointer :: rhs_vec(:)
      logical :: exist
      character(len=132) :: line
      character(len=32) :: item
      character(len=8) :: dupl_entries
      character(len=*), parameter :: ROUTINE_NAME = "msLoadSparse"

   !------ end of declarations -- execution starts hereafter  ------

      ! 1 or 2 output args must be specified
      if( out%n /= 1 .and. out%n /= 2 ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "one or two output args required!",        &
                            "syntax is : call msLoadSparse ( mfOut(A[,RHS]), filename[, format, duplicated_entries] )" )
         go to 99
      end if

      ! internal check for all mfOut args
      if( .not. args_mfout_ok( out ) ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "output arguments cannot be tempo, or cannot share", &
                            "same memory as another input argument." )
         go to 99
      end if

      A => out%ptr1
      call msSilentRelease( A )
      if( out%n == 2 ) then
         RHS => out%ptr2
         call msSilentRelease( RHS )
      end if

      inquire( file=trim(filename), exist=exist )
      if( .not. exist ) then
         call PrintMessage( ROUTINE_NAME, "W",                          &
                            "file not found! (broken link?)",           &
                            "file: " // trim(adjustl(filename)) )
         call msPause("As a last chance, you can try to fix the problem.")
         inquire( file=trim(adjustl(filename)), exist=exist )
         if( .not. exist ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "file not found!" )
            return
         end if
      end if

      call find_unit( unit )
      open( unit=unit, file=trim(adjustl(filename)) )

      if( present(format) ) then
         format0 = to_lower(format)
         go to 25
      else
         ! trying to auto-detect the sparse format
         read(unit,"(A)") line ! 1st line

         ! MTX ?
         if( to_lower(line(1:14)) == "%%matrixmarket" ) then
            format0 = "mtx"
            go to 20
         end if

         ! CSC or CSR ?
         read(line,*,end=5,err=5) nrow, ncol, i, form, kind
         select case ( to_lower(form) )
            case( "csc" )
               format0 = "csc"
               go to 20
            case( "csr" )
               format0 = "csr"
               go to 20
         end select

 5       continue

         ! HBO ?
         ! (4th line should contain 4 formats)
         ! read line number 4
         read(unit,"(A)") line ! 2nd line
         read(unit,"(A)") line ! 3rd line
         read(unit,"(A)") line ! 4th line
         do i = 1, 4
            call fileio_get_tok( line, item ) ! ith format
            n = len_trim(item)
            if( item(1:1) /= "(" .or. item(n:n) /= ")" ) then
               ! failed
               go to 10
            end if
         end do
         format0 = "hbo"
         go to 20

 10      continue

         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "file: " // trim(filename),                 &
                            "cannot detect this sparse format!" )
         go to 99

      end if

 20   continue
      call PrintMessage( ROUTINE_NAME, "I",                             &
                         "format auto-detected: """ // to_upper(format0) // """" )

 25   continue

      if( present(duplicated_entries) ) then
         if( .not. MF_SP_AUTO_ROW_SORTED ) then
            ! user chose not to sort columns' entries, but, the row
            ! sorting in each column is always required.
            call PrintMessage( ROUTINE_NAME, "I",                       &
                               "you chose, via the 'msSetAutoRowSorted' routine,", &
                               "not to sort columns' entries. However, 'duplicated_entries'", &
                               "requires sorting; so temporarily activating 'row sorting'" )
         end if
         dupl_entries = to_lower(duplicated_entries)
         if( dupl_entries /= "ignored" .and.                            &
             dupl_entries /= "added"   .and.                            &
             dupl_entries /= "replaced" ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "duplicated_entries must one of:",       &
                               "'ignored', 'added' or 'replaced'" )
            return
         end if
      else
         dupl_entries = "added"
      end if

      rewind( unit )

      select case( format0 )
      case( "hbo" )

         ! get infos on the matrix to be read
#ifndef _OPTIM
! Whereas the following assignment is not necessary, it is used in order
! to avoid "uninitialized value" by 'valgrind'.
         call msAssign( A, mfSpAlloc( 1, 1 ) )
         allocate( rhs_vec(1) )
#endif
         job = 0
         call readmt( nmax, nzmax, job, unit, A%a, A%i, A%j, rhs_vec,   &
                      nrhs, guesol, nrow, ncol, nnz, title,             &
                      key, type, ierr )
#ifndef _OPTIM
         deallocate( rhs_vec )
#endif
         if( ierr /= 0 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "Cannot read HBO matrix." )
            go to 99
         end if

         rewind( unit )

         call msAssign( A, mfSpAlloc( nrow, ncol, nzmax=nnz ) )

         if( out%n == 2 ) then
            nvec = 1
            if( to_upper(guesol(1:1)) == 'G' ) nvec = nvec + 1
            if( to_upper(guesol(2:2)) == 'X' ) nvec = nvec + 1
            call msAssign( RHS, mfZeros( nrow, nvec*nrhs ) )
            ! for next call of readmt:
            nrhs = nvec*nrhs*nrow ! expected total nb of elements in RHS
            rhs_vec => rank_2_to_1_real8(RHS%double,nrhs)
         end if

         ! The only possibility to check if the HBO file contains also
         ! the RHS is to try to retrieve it...
         job = 3
         call readmt( ncol, nnz, job, unit, A%a, A%i, A%j, rhs_vec,     &
                      nrhs, guesol, nrow, ncol, nnz, title,             &
                      key, type, ierr )
         if( job == 2 ) then
            ! the HBO file doesn't include the RHS
            if( out%n == 2 ) then
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "Cannot read any RHS in the HBO file" )
               go to 99
            end if
         else if( job == 3 ) then
            if( out%n == 2 ) then
               ! ierr should be 0 -- see readmt from fml_fileio
               if( ierr /= 0 ) then
                  print *
                  print *, "msLoadSparse: internal error after calling 'readmt'"
                  print *, "              (line 216 of mfLoadSparse.inc)"
                  print *, "              ierr = ", ierr, " (instead of 0)"
                  pause ! for debugging purpose
                  stop
               end if
            else
               if( ierr /= 5 ) then
                  print *
                  print *, "msLoadSparse: internal error after calling 'readmt'"
                  print *, "              (line 225 of mfLoadSparse.inc)"
                  print *, "              ierr = ", ierr, " (instead of 5)"
                  pause ! for debugging purpose
                  stop
               end if
               call PrintMessage( ROUTINE_NAME, "W",                    &
                                  "The HBO file contains also a Right-Hand-Side", &
                                  "but it has been ignored." )
            end if
         else
            print *
            print *, "msLoadSparse: internal error after calling 'readmt'"
            print *, "              (line 237 of mfLoadSparse.inc)"
            print *, "              on return: job = ", job
            pause ! for debugging purpose
            stop
         end if

         call process_dupl_entries( A, dupl_entries, ROUTINE_NAME )

      case default

         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "this routine is only for HBO format." )

      end select

 99   continue

      close(unit)

#endif
   end subroutine msLoadSparse
