! f90 include file

!_______________________________________________________________________
!
   function mfLoadTriConnect( filename ) result( out )

      character(len=*), intent(in) :: filename
      type(mfTriConnect) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: i, unit, l, rec_num, itmp, tmp(4)
      integer :: nn, nt, nf, n_bnd, n_bnd_fac
      character(len=20) :: signature_20
      integer :: endianness
      character(len=4) :: endianness_char

      logical :: exist, gzipped, bytes_must_be_swapped
      type(gz_filedes) :: gz_file

      character(len=*), parameter :: ROUTINE_NAME = "mfLoadTriConnect"

   !------ end of declarations -- execution starts hereafter  ------

      inquire( file=trim(adjustl(filename)), exist=exist )
      if( .not. exist ) then
         call PrintMessage( ROUTINE_NAME, "W",                          &
                            "file not found! (broken link?)",           &
                            "file: '" // trim(adjustl(filename)) // "'" )
         call msPause("As a last chance, you can try to fix the problem.")
         inquire( file=trim(adjustl(filename)), exist=exist )
         if( .not. exist ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "file not found!" )
            return
         end if
      end if

      bytes_must_be_swapped = .false.

      l = len_trim(filename)
      if( filename(l-2:l) == ".gz" ) then
         gzipped = .true.
      else
         gzipped = .false.
      end if

      if( gzipped ) then

         gz_file = gzopen( trim(filename), "rb" )

         if( filedes_is_null( gz_file ) ) then
            return
         end if

         ! remark: in sequential-unformatted write, each record
         !         are preceeded and followed by the record size.

         ! read and check signature
         call gzread( gz_file, l )
         call gzread( gz_file, signature_20 )
         call gzread( gz_file, l )

         if( signature_20 /= MF_BIN_SIGN_25 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "wrong MF signature for binary file",    &
                               "file: '" // trim(adjustl(filename)) // "'" )
            call gzclose( gz_file )
            return
         end if

         ! read and check endianness
         call gzread( gz_file, l )
         call gzread( gz_file, endianness )
         call gzread( gz_file, l )

         if( endianness == MF_ENDIAN_NATIVE ) then

            ! read tag
            call gzread( gz_file, l )
            call gzread( gz_file, itmp )
            if( itmp /= -1 ) then
               ! for MF_BIN_SIGN_25, it means special objects.
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "file: '" // trim(adjustl(filename)) // "' has a wrong tag.", &
                                  "it appears not to be an mfTriConnect structure!", &
                                  "-> corrupted file?" )
               call gzclose( gz_file )
               return
            end if
            call gzread( gz_file, l )

            ! read init
            call gzread( gz_file, l )
            call gzread( gz_file, itmp )
            if( itmp == 1 ) then
               out%init = .true.
            else
               out%init = .false.
               ! No need to read further data.
               call gzclose( gz_file )
               return
            end if
            call gzread( gz_file, l )

            ! read tri_renumbering
            call gzread( gz_file, l )
            call gzread( gz_file, itmp )
            if( itmp == 1 ) then
               out%tri_renumbering = .true.
            else
               out%tri_renumbering = .false.
            end if
            call gzread( gz_file, l )

            ! read face_oriented
            call gzread( gz_file, l )
            call gzread( gz_file, itmp )
            if( itmp == 1 ) then
               out%face_oriented = .true.
            else
               out%face_oriented = .false.
            end if
            call gzread( gz_file, l )

            ! read convex_domain
            call gzread( gz_file, l )
            call gzread( gz_file, out%convex_domain )
            call gzread( gz_file, l )

            ! read arrays sizes
            call gzread( gz_file, l )
            call gzread( gz_file, tmp(1:4) )
            nn = tmp(1)
            nt = tmp(2)
            nf = tmp(3)
            call gzread( gz_file, l )

            allocate( out%n_xy(nn,2) )
            call gzread( gz_file, l )
            call gzread( gz_file, out%n_xy )
            call gzread( gz_file, l )

            allocate( out%tri_n(nt,3) )
            call gzread( gz_file, l )
            call gzread( gz_file, out%tri_n )
            call gzread( gz_file, l )

            allocate( out%face_n(nf,2) )
            call gzread( gz_file, l )
            call gzread( gz_file, out%face_n )
            call gzread( gz_file, l )

            allocate( out%face_tri(nf,2) )
            call gzread( gz_file, l )
            call gzread( gz_file, out%face_tri )
            call gzread( gz_file, l )

            allocate( out%tri_f(nt,3) )
            call gzread( gz_file, l )
            call gzread( gz_file, out%tri_f )
            call gzread( gz_file, l )

            allocate( out%n_tri(nn) )
            call gzread( gz_file, l )
            call gzread( gz_file, out%n_tri )
            call gzread( gz_file, l )

            if( out%convex_domain /= -1 ) then

               ! Convexity is known and boundary faces have to be loaded.

               ! read arrays sizes
               call gzread( gz_file, l )
               call gzread( gz_file, tmp(1:2) )
               n_bnd = tmp(1)
               n_bnd_fac = tmp(2)
               call gzread( gz_file, l )

               allocate( out%faces_boundary(n_bnd_fac) )
               call gzread( gz_file, l )
               call gzread( gz_file, out%faces_boundary )
               call gzread( gz_file, l )

               allocate( out%faces_boundary_ptr(n_bnd,2) )
               call gzread( gz_file, l )
               call gzread( gz_file, out%faces_boundary_ptr )
               call gzread( gz_file, l )

            end if

            call gzclose( gz_file )

         else if( endianness == MF_ENDIAN_SWAP ) then
            ! bytes must be swapped
print *, "mfLoadTriConnect:.inc: line 196:"
print *, "  bytes must be swapped: Not yet ready!"
pause "for debugging purpose only..."
stop

         else
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "unknown value for endianness",          &
                               "file: '" // trim(adjustl(filename)) // "'" )
            call gzclose( gz_file )
            return
         end if

      else ! not gzipped

         call find_unit( unit )

         ! signature and the ENDIAN type must be detected before any
         ! sequential read.
         ! (with direct access, one byte is read at a time, then
         !  it is not dependent of the endianness)
         open( unit=unit, file=trim(adjustl(filename)),                 &
               access="direct", recl=1, status="old" )

         do i = 1, 20
            rec_num = i + 4
            read(unit,rec=rec_num) signature_20(i:i)
         end do

         if( signature_20 /= MF_BIN_SIGN_25 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "wrong MF signature for binary file",    &
                               "file: '" // trim(adjustl(filename)) // "'" )
            close(unit)
            return
         end if

         ! endianness
         do i = 1, 4
            rec_num = i + 32
            read(unit,rec=rec_num) endianness_char(i:i)
         end do
         endianness = transfer(endianness_char,0)
         if( endianness == MF_ENDIAN_SWAP ) then
            ! different endianness
            bytes_must_be_swapped = .true.
         else if( endianness == MF_ENDIAN_NATIVE ) then
            ! nothing to do: just to verify
         else
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "unknown value for endianness",          &
                               "file: '" // trim(adjustl(filename)) // "'" )
            close(unit)
            return
         end if

         close(unit)

         if( bytes_must_be_swapped ) then

            ! direct access
print *, "mfLoadTriConnect:.inc: line 257:"
print *, "  bytes must be swapped: Not yet ready!"
pause "for debugging purpose only..."
stop

         else

            ! sequential access
            open( unit=unit, file=trim(adjustl(filename)),              &
                  form="unformatted", status="old" )

            ! no need to verify read
            read(unit) signature_20

            ! no need to verify read
            read(unit) endianness

            read(unit) itmp
            if( itmp /= -1 ) then
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "file: '" // trim(adjustl(filename)) // "' doesn't contain an mfTriConnect structure", &
                                  "-> perhaps it contains an mfArray... in this latter case, you must load it", &
                                  "using the 'mfLoad' routine." )
               close(unit)
               return
            end if

            read(unit) out%init
            if( .not. out%init ) then
               ! No need to read further data.
               close(unit)
               return
            end if

            read(unit) out%tri_renumbering

            read(unit) out%face_oriented

            read(unit) out%convex_domain

            read(unit) nn, nt, nf, itmp

            allocate( out%n_xy(nn,2) )
            read(unit) out%n_xy

            allocate( out%tri_n(nt,3) )
            read(unit) out%tri_n

            allocate( out%face_n(nf,2) )
            read(unit) out%face_n

            allocate( out%face_tri(nf,2) )
            read(unit) out%face_tri

            allocate( out%tri_f(nt,3) )
            read(unit) out%tri_f

            allocate( out%n_tri(nn) )
            read(unit) out%n_tri

            if( out%convex_domain /= -1 ) then

               read(unit) n_bnd, n_bnd_fac

               allocate( out%faces_boundary(n_bnd_fac) )
               read(unit) out%faces_boundary

               allocate( out%faces_boundary_ptr(n_bnd,2) )
               read(unit) out%faces_boundary_ptr

            end if

            close(unit)

         end if

      end if

      out%status_temporary = .true.

#endif
   end function mfLoadTriConnect

