! f90 include file

!_______________________________________________________________________
!
   function mfLoadHDF5( filename, name ) result( out )

      character(len=*), intent(in) :: filename
      character(len=*), intent(in), optional :: name
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! Reads from an HDF5 file and tries to find an mfArray named
      ! from the optional arg 'name'. If this latter in not present,
      ! it tries to get the first group which has an attribute
      ! named "MF_MUESLI_VERSION".
      ! It doesn't enter in any group: the searched mfArray must be
      ! located just under the root "/" structure of the HDF5 file.

      integer :: hdferr
      integer(hid_t) :: file_id   ! HDF5 file identifier
      integer(hid_t) :: group_id  ! HDF5 group identifier
      integer(hid_t) :: attr_id   ! HDF5 attribute identifier
      integer(hid_t) :: type_id   ! HDF5 attribute type identifier
      integer(hid_t) :: dset_id   ! HDF5 dataset identifier
      integer :: class ! HDF5 datatype class
      integer :: i, nmembers, attr_num, n
      character(len=20) :: obj_name, obj2_name
      integer :: obj_type ! Type of the object
      integer(hsize_t), dimension(2) :: data_dims ! HDF5 dataset dims
      character(len=32) :: groupname ! group name
      character(len=5) :: muesli_version

      real(kind=MF_DOUBLE), allocatable :: tmp_real_1(:),   tmp_imag_1(:), &
                                           tmp_real_2(:,:), tmp_imag_2(:,:)
      integer :: nnz, nrow, ncol
      logical :: exist, valid
      real(kind=MF_DOUBLE) :: r_units(num_base_units)
      integer :: itmp
      integer(kind=kind_1) :: itmp_1
      character(len=*), parameter :: ROUTINE_NAME = "mfLoadHDF5"

   !------ end of declarations -- execution starts hereafter  ------

      inquire( file=trim(filename), exist=exist )
      if( .not. exist ) then
         call PrintMessage( ROUTINE_NAME, "W",                          &
                            "file not found! (broken link?)",           &
                            "file: '" // trim(adjustl(filename)) // "'" )
         call msPause("As a last chance, you can try to fix the problem.")
         inquire( file=trim(adjustl(filename)), exist=exist )
         if( .not. exist ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "file not found!" )
            return
         end if
      end if

      ! initialize the HDF5 F90 interface
      call h5open_f(hdferr)
      if( hdferr /= 0 ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "cannot initialize the HDF5 F90 interface!" )
         return
      end if

      ! Open an existing HDF5 file (read only mode)
      call h5fopen_f( filename, H5F_ACC_RDONLY_F, file_id, hdferr )
      if( hdferr /= 0 ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "cannot open HDF5 file: '" // trim(filename) // "'", &
                            "[Not an HDF5 file or corrupted file?]" )
         go to 89
      end if

      if( present(name) ) then

         groupname = name

      else

         ! get number of members in the root group.
         call h5gn_members_f( file_id, "/", nmembers, hdferr )

         valid = .false.
         ! idx begins at 0 !
         do i = 0, nmembers-1
            call h5gget_obj_info_idx_f( file_id, "/", i, obj_name,      &
                                        obj_type, hdferr )
            if( obj_type == H5G_GROUP_F ) then
               call h5gopen_f( file_id, obj_name, group_id, hdferr )
               call h5aget_num_attrs_f( group_id, attr_num, hdferr )
               ! a group containing an mfArray has at least 6 attributes
               if( attr_num >= 6 ) then
                  ! examines only the first attribute
                  call h5aopen_idx_f( group_id, 0, attr_id, hdferr )
                  call h5aget_name_f( attr_id, 20, obj2_name, hdferr )
                  if( trim(obj2_name) == "MF_MUESLI_VERSION" ) then
                     valid = .true.
                     exit
                  end if
               end if
            end if
         end do

         if( .not. valid ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "HDF5 file doesn't contain any mfArray!", &
                               "file: '" // trim(filename) // "'" )
            go to 89
         end if

         groupname = obj_name

      end if

      ! opens the group containing the mfArray
      call h5gopen_f( file_id, groupname, group_id, hdferr )
!### TODO 2: insert here a check for an error...

      ! reads its attributes

      ! "MF_MUESLI_VERSION"
      call h5aopen_name_f( group_id, "MF_MUESLI_VERSION", attr_id, hdferr )
      call h5aget_type_f( attr_id, type_id, hdferr )
      call h5tget_class_f( type_id, class, hdferr )
      if( class /= H5T_STRING_F ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "the MF_MUESLI_VERSION attribute must contain", &
                            "data of type character!" )
         go to 89
      end if
      call h5aread_f( attr_id, type_id,  muesli_version, data_dims, hdferr )
      if( llt(muesli_version,"2.6.1") ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "the MF_MUESLI_VERSION stored in the HDF5 file", &
                            "is too old ! It should be at least 2.6.1" )
         go to 89
      end if

      ! "DATA_TYPE"
      call h5aopen_name_f( group_id, "DATA_TYPE", attr_id, hdferr )
      call h5aget_type_f( attr_id, type_id, hdferr )
      call h5tget_class_f( type_id, class, hdferr )
      if( class /= H5T_INTEGER_F ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "the DATA_TYPE attribute must contain",     &
                            "data of type integer!" )
         go to 89
      end if
      call h5aread_f( attr_id, type_id, itmp, data_dims, hdferr )
      itmp_1 = itmp
      if( itmp_1 < MF_DT_EMPTY .or. MF_DT_PERM_VEC < itmp_1 ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "the DATA_TYPE used in the HDF5 file",      &
                            "is out of range!" )
         go to 89
      end if
      out%data_type = itmp_1

      ! "NROW"
      call h5aopen_name_f( group_id, "NROW", attr_id, hdferr )
      call h5aget_type_f( attr_id, type_id, hdferr )
      call h5tget_class_f( type_id, class, hdferr )
      if( class /= H5T_INTEGER_F ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "the NROW attribute must contain",          &
                            "data of type integer!" )
         go to 89
      end if
      call h5aread_f( attr_id, type_id,  n, data_dims, hdferr )
      if( n < 0 ) then
         call PrintMessage( ROUTINE_NAME, "E",                          &
                            "the NROW value must be positive!" )
         go to 89
      end if
      out%shape(1) = n

      if( out%data_type /= MF_DT_PERM_VEC ) then

         ! "NCOL"
         call h5aopen_name_f( group_id, "NCOL", attr_id, hdferr )
         call h5aget_type_f( attr_id, type_id, hdferr )
         call h5tget_class_f( type_id, class, hdferr )
         if( class /= H5T_INTEGER_F ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "the NCOL attribute must contain",        &
                              "data of type integer!" )
            go to 89
         end if
         call h5aread_f( attr_id, type_id,  n, data_dims, hdferr )
         if( n < 0 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "the NCOL value must be positive!" )
            go to 89
         end if
         out%shape(2) = n

         ! "TRIL"
         call h5aopen_name_f( group_id, "TRIL", attr_id, hdferr )
         call h5aget_type_f( attr_id, type_id, hdferr )
         call h5tget_class_f( type_id, class, hdferr )
         if( class /= H5T_INTEGER_F ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "the TRIL attribute must contain",        &
                              "data of type integer!" )
            go to 89
         end if
         call h5aread_f( attr_id, type_id, itmp, data_dims, hdferr )
         itmp_1 = itmp
         if( itmp_1 /= TRUE .and. itmp_1 /= FALSE .and. itmp_1 /= UNKNOWN ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "the TRIL value is not valid!" )
            go to 89
         end if
         out%prop%tril = itmp_1

         ! "TRIU"
         call h5aopen_name_f( group_id, "TRIU", attr_id, hdferr )
         call h5aget_type_f( attr_id, type_id, hdferr )
         call h5tget_class_f( type_id, class, hdferr )
         if( class /= H5T_INTEGER_F ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "the TRIU attribute must contain",        &
                              "data of type integer!" )
            go to 89
         end if
         call h5aread_f( attr_id, type_id, itmp, data_dims, hdferr )
         itmp_1 = itmp
         if( itmp_1 /= TRUE .and. itmp_1 /= FALSE .and. itmp_1 /= UNKNOWN ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "the TRIU value is not valid!" )
            go to 89
         end if
         out%prop%triu = itmp_1

         ! "SYMM"
         call h5aopen_name_f( group_id, "SYMM", attr_id, hdferr )
         call h5aget_type_f( attr_id, type_id, hdferr )
         call h5tget_class_f( type_id, class, hdferr )
         if( class /= H5T_INTEGER_F ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "the SYMM attribute must contain",        &
                              "data of type integer!" )
            go to 89
         end if
         call h5aread_f( attr_id, type_id, itmp, data_dims, hdferr )
         itmp_1 = itmp
         if( itmp_1 /= TRUE .and. itmp_1 /= FALSE .and. itmp_1 /= UNKNOWN ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "the SYMM value is not valid!" )
            go to 89
         end if
         out%prop%symm = itmp_1

         ! "POS_DEF"
         call h5aopen_name_f( group_id, "POS_DEF", attr_id, hdferr )
         call h5aget_type_f( attr_id, type_id, hdferr )
         call h5tget_class_f( type_id, class, hdferr )
         if( class /= H5T_INTEGER_F ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "the POS_DEF attribute must contain",     &
                              "data of type integer!" )
            go to 89
         end if
         call h5aread_f( attr_id, type_id, itmp, data_dims, hdferr )
         itmp_1 = itmp
         if( itmp_1 /= TRUE .and. itmp_1 /= FALSE .and. itmp_1 /= UNKNOWN ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                              "the POS_DEF value is not valid!" )
            go to 89
         end if
         out%prop%posd = itmp_1

      end if

      if( out%data_type == MF_DT_SP_DBLE .or.                           &
          out%data_type == MF_DT_SP_CMPLX     ) then

         ! "ROW_SORTED"
         call h5aopen_name_f( group_id, "ROW_SORTED", attr_id, hdferr )
         call h5aget_type_f( attr_id, type_id, hdferr )
         call h5tget_class_f( type_id, class, hdferr )
         if( class /= H5T_INTEGER_F ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "the ROW_SORTED attribute must contain", &
                               "data of type integer!" )
            go to 89
         end if
         call h5aread_f( attr_id, type_id, itmp, data_dims, hdferr )
         itmp_1 = itmp
         if( itmp_1 /= TRUE .and. itmp_1 /= FALSE .and. itmp_1 /= UNKNOWN ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "the ROW_SORTED value is not valid!" )
            go to 89
         end if
         out%row_sorted = itmp_1

         ! "NNZ"
         call h5aopen_name_f( group_id, "NNZ", attr_id, hdferr )
         call h5aget_type_f( attr_id, type_id, hdferr )
         call h5tget_class_f( type_id, class, hdferr )
         if( class /= H5T_INTEGER_F ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "the NNZ attribute must contain",        &
                               "data of type integer!" )
            go to 89
         end if
         call h5aread_f( attr_id, type_id,  n, data_dims, hdferr )
         if( n < 0 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "the NNZ value must be positive!" )
            go to 89
         end if
         nnz = n

      end if

      nrow = out%shape(1)
      ncol = out%shape(2)
      data_dims(1) = nrow
      data_dims(2) = ncol

      select case( out%data_type )
         case( MF_DT_EMPTY )
         case( MF_DT_DBLE )
            allocate( out%double(out%shape(1),out%shape(2)) )

            call h5dopen_f( group_id, "double", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            call h5dread_f( dset_id, type_id, out%double(1,1), data_dims, hdferr )
         case( MF_DT_CMPLX )
            allocate( out%cmplx(out%shape(1),out%shape(2)) )

            call h5dopen_f( group_id, "real", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            allocate( tmp_real_2(out%shape(1),out%shape(2)) )
!### TODO ?: recopie détectée par _g95_contiguous_array
            call h5dread_f( dset_id, type_id, tmp_real_2, data_dims, hdferr )
            call h5dopen_f( group_id, "imag", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            allocate( tmp_imag_2(out%shape(1),out%shape(2)) )
!### TODO ?: recopie détectée par _g95_contiguous_array
            call h5dread_f( dset_id, type_id, tmp_imag_2, data_dims, hdferr )
            out%cmplx(:,:) = cmplx( tmp_real_2(:,:), tmp_imag_2(:,:),kind=MF_DOUBLE )
         case( MF_DT_SP_DBLE )
            allocate( out%a(nnz) )

            call h5dopen_f( group_id, "a", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            call h5dread_f( dset_id, type_id, out%a(1), data_dims, hdferr )
            allocate( out%i(nnz) )

            call h5dopen_f( group_id, "i", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            call h5dread_f( dset_id, type_id, out%i(1), data_dims, hdferr )
            allocate( out%j(ncol+1) )

            call h5dopen_f( group_id, "j", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            call h5dread_f( dset_id, type_id, out%j(1), data_dims, hdferr )
         case( MF_DT_SP_CMPLX )
            allocate( out%z(nnz) )

            call h5dopen_f( group_id, "real", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            allocate( tmp_real_1(nnz) )
!### TODO ?: recopie détectée par _g95_contiguous_array
            call h5dread_f( dset_id, type_id, tmp_real_1, data_dims, hdferr )
            call h5dopen_f( group_id, "imag", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            allocate( tmp_imag_1(nnz) )
!### TODO ?: recopie détectée par _g95_contiguous_array
            call h5dread_f( dset_id, type_id, tmp_imag_1, data_dims, hdferr )
            out%z = cmplx( tmp_real_1(:), tmp_imag_1(:),kind=MF_DOUBLE )
            allocate( out%i(nnz) )

            call h5dopen_f( group_id, "i", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            call h5dread_f( dset_id, type_id, out%i(1), data_dims, hdferr )
            allocate( out%j(ncol+1) )

            call h5dopen_f( group_id, "j", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            call h5dread_f( dset_id, type_id, out%j(1), data_dims, hdferr )
         case( MF_DT_PERM_VEC )
            allocate( out%i(nrow) )

            call h5dopen_f( group_id, "i", dset_id, hdferr )
            call h5dget_type_f( dset_id, type_id, hdferr )
            call h5dread_f( dset_id, type_id, out%i(1), data_dims, hdferr )
      end select

      ! physical units
      if( mf_phys_units ) then
         ! testing if the dataset "units" exist
         call h5dopen_f( group_id, "units", dset_id, hdferr )
         if( hdferr == 0 ) then
            call h5dget_type_f( dset_id, type_id, hdferr )
            call h5dread_f( dset_id, type_id, r_units(1), data_dims, hdferr )
            do i = 1, num_base_units
               out%units(i) = r_units(i)
            end do
         end if
      end if

      ! close the file
      call h5fclose_f( file_id, hdferr )

      ! close the HDF5's F90 interface
 89   call h5close_f(hdferr)
      if( hdferr /= 0 ) then
         call PrintMessage( ROUTINE_NAME, "W",                          &
                            "cannot close the HDF5 F90 interface!" )
         return
      end if

      out%status_temporary = .true.

#endif
   end function mfLoadHDF5
