! f90 include file

!_______________________________________________________________________
!
   function mfLoad( filename ) result( out )

      character(len=*), intent(in) :: filename
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: i, j, k, unit, l, rec_num, iostat, bytes_read
      integer :: nrow, ncol, nnz
      character(len=20) :: signature_20
      integer :: endianness
      character(len=4) :: endianness_char
      character(len=12) :: iostat_char

      logical :: exist, gzipped, bytes_must_be_swapped
      type(gz_filedes) :: gz_file

      real(kind=MF_DOUBLE) :: tmp_re, tmp_im
      integer :: itmp
      integer(kind=kind_1) :: byte(4)
      character(len=*), parameter :: ROUTINE_NAME = "mfLoad"

#if defined _GNU_GFC
#include "../misc/rational_numbers/rational_config.inc"
#elif defined _INTEL_IFC
#include "misc/rational_numbers/rational_config.inc"
#else
- '(MUESLI mfLoad:) line 32: compiler not defined!'
#endif

   !------ end of declarations -- execution starts hereafter  ------

      inquire( file=trim(adjustl(filename)), exist=exist )
      if( .not. exist ) then
         call PrintMessage( ROUTINE_NAME, "W",                          &
                            "file not found! (broken link?)",           &
                            "file: '" // trim(adjustl(filename)) // "'" )
         call msPause("As a last chance, you can try to fix the problem.")
         inquire( file=trim(adjustl(filename)), exist=exist )
         if( .not. exist ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "file not found!" )
            return
         end if
      end if

      bytes_must_be_swapped = .false.

      l = len_trim(filename)
      if( filename(l-2:l) == ".gz" ) then
         gzipped = .true.
      else
         gzipped = .false.
      end if

      if( gzipped ) then

         gz_file = gzopen( trim(filename), "rb" )

         if( filedes_is_null( gz_file ) ) then
            return
         end if

         ! remark: in sequential-unformatted write, each record
         !         are preceeded and followed by the record size.

         ! read and check signature
         call gzread( gz_file, l )
         call gzread( gz_file, signature_20 )
         call gzread( gz_file, l )

         if( signature_20 /= MF_BIN_SIGN_23 .and.                       &
             signature_20 /= MF_BIN_SIGN_24 .and.                       &
             signature_20 /= MF_BIN_SIGN_25 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "wrong MF signature for binary file",    &
                               "file: '" // trim(adjustl(filename)) // "'" )
            call gzclose( gz_file )
            return
         end if

         ! read and check endianness
         call gzread( gz_file, l )
         call gzread( gz_file, endianness )
         call gzread( gz_file, l )

         if( endianness == MF_ENDIAN_NATIVE ) then

            ! read data_type
            call gzread( gz_file, l )
            call gzread( gz_file, itmp )
            out%data_type = itmp
            call gzread( gz_file, l )
            if( out%data_type < 0 ) then
               ! for MF_BIN_SIGN_25, it means special objects.
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "file: '" // trim(adjustl(filename)) // "' doesn't contain an mfArray", &
                                  "-> you must load it using the 'mfLoadTriConnect' routine." )
               out%data_type = MF_DT_EMPTY
            end if
            if( out%data_type == MF_DT_EMPTY ) then ! MF_EMPTY
               call gzclose( gz_file )
               return
            end if

            ! read array shape
            call gzread( gz_file, l )
            call gzread( gz_file, out%shape )
            call gzread( gz_file, l )

            nrow = out%shape(1)
            ncol = out%shape(2)
            if( nrow < 0 .or. ncol < 0 ) then
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "array shape cannot contain negative values!", &
                                  "file: '" // trim(adjustl(filename)) // "'" )
               call gzclose( gz_file )
               out = MF_EMPTY
               return
            end if
            if( nrow == 0 .and. ncol == 0 ) then
               call gzclose( gz_file )
               out = MF_EMPTY
               return
            end if

            ! read array data (column-wise)
            if( out%data_type == MF_DT_DBLE .or. out%data_type == MF_DT_BOOL ) then ! real or boolean case
               allocate( out%double(nrow,ncol) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%double )
               call gzread( gz_file, l )
            else if( out%data_type == MF_DT_CMPLX ) then
               allocate( out%cmplx(nrow,ncol) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%cmplx )
               call gzread( gz_file, l )
            else if( out%data_type == MF_DT_SP_DBLE ) then
               call gzread( gz_file, l )
               call gzread( gz_file, nnz )
               call gzread( gz_file, l )
               allocate( out%j(ncol+1) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%j )
               call gzread( gz_file, l )
               ! consistency check
               if( nnz /= out%j(ncol+1)-1 ) then
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "inconsistency found: nnz doesn't match col data!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
               end if
               allocate( out%i(nnz) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%i )
               call gzread( gz_file, l )
               if( l == 0 ) then
                  call gzread( gz_file, l )
               end if
               allocate( out%a(nnz) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%a )
               call gzread( gz_file, l )
            else if( out%data_type == MF_DT_SP_CMPLX ) then
               call gzread( gz_file, l )
               call gzread( gz_file, nnz )
               call gzread( gz_file, l )
               allocate( out%j(ncol+1) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%j )
               call gzread( gz_file, l )
               ! consistency check
               if( nnz /= out%j(ncol+1)-1 ) then
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "inconsistency found: nnz doesn't match col data!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
               end if
               allocate( out%i(nnz) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%i )
               call gzread( gz_file, l )
               if( l == 0 ) then
                  call gzread( gz_file, l )
               end if
               allocate( out%z(nnz) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%z )
               call gzread( gz_file, l )
            else if( out%data_type == MF_DT_PERM_VEC ) then
               allocate( out%i(nrow) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%i )
               call gzread( gz_file, l )
            else
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "unknown data type" )
               call gzclose( gz_file )
               return
            end if

            ! read matrix properties
            if( signature_20 == MF_BIN_SIGN_23 ) then

               call gzread( gz_file, l )
               call gzread( gz_file, itmp, iostat )
               out%prop%symm = itmp
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%prop%symm" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               if( out%prop%symm /= TRUE .and. out%prop%symm /= FALSE .and. out%prop%symm /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the SYMM value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if
               call gzread( gz_file, l )

               call gzread( gz_file, l )
               call gzread( gz_file, itmp, iostat )
               out%prop%posd = itmp
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%prop%posd" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               if( out%prop%posd /= TRUE .and. out%prop%posd /= FALSE .and. out%prop%posd /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the POS_DEF value is not valid!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if
               call gzread( gz_file, l )

            else ! signature_20 == MF_BIN_SIGN_24 or MF_BIN_SIGN_25

               call gzread( gz_file, l )
               call gzread( gz_file, out%prop%tril, iostat )
               if( out%prop%tril /= TRUE .and. out%prop%tril /= FALSE .and. out%prop%tril /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the TRIL value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if
               call gzread( gz_file, out%prop%triu, iostat )
               if( out%prop%triu /= TRUE .and. out%prop%triu /= FALSE .and. out%prop%triu /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the TRIU value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if
               call gzread( gz_file, out%prop%symm, iostat )
               if( out%prop%symm /= TRUE .and. out%prop%symm /= FALSE .and. out%prop%symm /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the SYMM value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if
               call gzread( gz_file, out%prop%posd, iostat )
               if( out%prop%posd /= TRUE .and. out%prop%posd /= FALSE .and. out%prop%posd /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the POS_DEF value is not valid!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if
               call gzread( gz_file, l )

            end if

            call gzread( gz_file, l )
            call gzread( gz_file, out%units, iostat )
            call gzread( gz_file, l )

            call gzclose( gz_file )

         else if( endianness == MF_ENDIAN_SWAP ) then
            ! bytes must be swapped

            ! read data_type
            call gzread( gz_file, l )
            call gzread( gz_file, itmp )
            call swap_4bytes( itmp )
            out%data_type = itmp
            call gzread( gz_file, l )
            if( out%data_type < 0 ) then
               ! for MF_BIN_SIGN_25, it means special objects.
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "file: '" // trim(adjustl(filename)) // "' doesn't contain an mfArray", &
                                  "-> you must load it using the 'mfLoadTriConnect' routine." )
               out%data_type = MF_DT_EMPTY
            end if
            if( out%data_type == MF_DT_EMPTY ) then ! MF_EMPTY
               call gzclose( gz_file )
               return
            end if

            ! read array shape
            call gzread( gz_file, l )
            call gzread( gz_file, out%shape(1) )
            call swap_4bytes( out%shape(1) )
            call gzread( gz_file, out%shape(2) )
            call swap_4bytes( out%shape(2) )
            call gzread( gz_file, l )

            nrow = out%shape(1)
            ncol = out%shape(2)
            if( nrow < 0 .or. ncol < 0 ) then
               call PrintMessage( ROUTINE_NAME, "E",                        &
                                  "array shape cannot contain negative values!", &
                                  "file: '" // trim(adjustl(filename)) // "'" )
               call gzclose( gz_file )
               out = MF_EMPTY
               return
            end if
            if( nrow == 0 .and. ncol == 0 ) then
               call gzclose( gz_file )
               out = MF_EMPTY
               return
            end if

            ! read array data (column-wise)
            if( out%data_type == MF_DT_DBLE .or. out%data_type == MF_DT_BOOL ) then ! real or boolean case
               allocate( out%double(nrow,ncol) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%double )
               do j = 1, out%shape(2)
                  do i = 1, out%shape(1)
                     call swap_8bytes( out%double(i,j) )
                  end do
               end do
               call gzread( gz_file, l )
            else if( out%data_type == MF_DT_CMPLX ) then
               allocate( out%cmplx(nrow,ncol) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%cmplx )
               do j = 1, out%shape(2)
                  do i = 1, out%shape(1)
                     tmp_re = real(out%cmplx(i,j))
                     call swap_8bytes( tmp_re )
                     tmp_im = aimag(out%cmplx(i,j))
                     call swap_8bytes( tmp_im )
                     out%cmplx(i,j) = cmplx( tmp_re, tmp_im, kind=MF_DOUBLE )
                  end do
               end do
               call gzread( gz_file, l )
            else if( out%data_type == MF_DT_SP_DBLE ) then
               call gzread( gz_file, l )
               call gzread( gz_file, nnz )
               call swap_4bytes( nnz )
               call gzread( gz_file, l )
               allocate( out%j(ncol+1) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%j )
               do k = 1, ncol+1
                  call swap_4bytes( out%j(k) )
               end do
               call gzread( gz_file, l )
               ! consistency check
               if( nnz /= out%j(ncol+1)-1 ) then
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "inconsistency found: nnz doesn't match col data!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
               end if
               allocate( out%i(nnz) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%i )
               do k = 1, nnz
                  call swap_4bytes( out%i(k) )
               end do
               call gzread( gz_file, l )
               if( l == 0 ) then
                  call gzread( gz_file, l )
               end if
               allocate( out%a(nnz) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%a )
               do k = 1, nnz
                  call swap_8bytes( out%a(k) )
               end do
               call gzread( gz_file, l )
            else if( out%data_type == MF_DT_SP_CMPLX ) then
               call gzread( gz_file, l )
               call gzread( gz_file, nnz )
               call swap_4bytes( nnz )
               call gzread( gz_file, l )
               allocate( out%j(ncol+1) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%j )
               do k = 1, ncol+1
                  call swap_4bytes( out%j(k) )
               end do
               call gzread( gz_file, l )
               ! consistency check
               if( nnz /= out%j(ncol+1)-1 ) then
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "inconsistency found: nnz doesn't match col data!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
               end if
               allocate( out%i(nnz) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%i )
               do k = 1, nnz
                  call swap_4bytes( out%i(k) )
               end do
               call gzread( gz_file, l )
               if( l == 0 ) then
                  call gzread( gz_file, l )
               end if
               allocate( out%z(nnz) )

               call gzread( gz_file, l )
               call gzread( gz_file, out%z )
               do k = 1, nnz
                  tmp_re = real(out%z(k))
                  call swap_8bytes( tmp_re )
                  tmp_im = aimag(out%z(k))
                  call swap_8bytes( tmp_im )
                  out%z(k) = cmplx( tmp_re, tmp_im, kind=MF_DOUBLE )
               end do
               call gzread( gz_file, l )
            else
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "unknown data type" )
               call gzclose( gz_file )
            end if

            if( signature_20 == MF_BIN_SIGN_23 ) then

               call gzread( gz_file, l )
               call gzread( gz_file, itmp )
               call swap_4bytes( itmp )
               out%prop%symm = itmp
               call gzread( gz_file, l )

               call gzread( gz_file, l )
               call gzread( gz_file, itmp )
               call swap_4bytes( itmp )
               out%prop%posd = itmp
               call gzread( gz_file, l )

            else ! signature_20 == MF_BIN_SIGN_24 or MF_BIN_SIGN_25

               call gzread( gz_file, l )
               call gzread( gz_file, itmp )
               call gzread( gz_file, l )

               call swap_4bytes( itmp )
               byte(1:4) = transfer(itmp,byte)
               out%prop%tril = byte(1)
               out%prop%triu = byte(2)
               out%prop%symm = byte(3)
               out%prop%posd = byte(4)

            end if

            call gzread( gz_file, l )
            call gzread( gz_file, out%units )
            do k = 1, size(out%units)
               call swap_4bytes_rat( out%units(k) )
            end do
            call gzread( gz_file, l )

            call gzclose( gz_file )

         else
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "unknown value for endianness",          &
                               "file: '" // trim(adjustl(filename)) // "'" )
            call gzclose( gz_file )
            return
         end if

      else ! not gzipped

         call find_unit( unit )

         ! signature and the ENDIAN type must be detected before any
         ! sequential read.
         ! (with direct access, one byte is read at a time, then
         !  it is not dependent of the endianness)
         open( unit=unit, file=trim(adjustl(filename)),                 &
               access="direct", recl=1, status="old" )

         do i = 1, 20
            rec_num = i + 4
            read(unit,rec=rec_num) signature_20(i:i)
         end do

         if( signature_20 /= MF_BIN_SIGN_23 .and.                       &
             signature_20 /= MF_BIN_SIGN_24 .and.                       &
             signature_20 /= MF_BIN_SIGN_25 ) then
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "wrong MF signature for binary file",    &
                               "file: '" // trim(adjustl(filename)) // "'" )
            close(unit)
            return
         end if

         ! endianness
         do i = 1, 4
            rec_num = i + 32
            read(unit,rec=rec_num) endianness_char(i:i)
         end do
         endianness = transfer(endianness_char,0)
         if( endianness == MF_ENDIAN_SWAP ) then
            ! different endianness
            bytes_must_be_swapped = .true.
         else if( endianness == MF_ENDIAN_NATIVE ) then
            ! nothing to do: just to verify
         else
            call PrintMessage( ROUTINE_NAME, "E",                       &
                               "unknown value for endianness",          &
                               "file: '" // trim(adjustl(filename)) // "'" )
            close(unit)
            return
         end if

         close(unit)

         if( bytes_must_be_swapped ) then

            ! direct access
            ! (if the endianness of the file was different, it
            ! should be not possible to read with sequential access:
            ! an EOF would be obtained)
            open( unit=unit, file=trim(adjustl(filename)),              &
                  access="direct", recl=4, status="old" )

            rec_num = 12
            read(unit,rec=rec_num) itmp
            call swap_4bytes( itmp )
            out%data_type = itmp
            if( out%data_type < 0 ) then
               ! for MF_BIN_SIGN_25, it means special objects.
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "file: '" // trim(adjustl(filename)) // "' doesn't contain an mfArray", &
                                  "-> you must load it using the 'mfLoadTriConnect' routine." )
               close(unit)
               return
            end if

            if( out%data_type == MF_DT_EMPTY ) then
               close(unit)
               return
            end if

            rec_num = 15
            read(unit,rec=rec_num) out%shape(1)
            call swap_4bytes( out%shape(1) )

            rec_num = 16
            read(unit,rec=rec_num) out%shape(2)
            call swap_4bytes( out%shape(2) )

            nrow = out%shape(1)
            ncol = out%shape(2)
            if( nrow < 0 .or. ncol < 0 ) then
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "array shape cannot contain negative values!", &
                                  "file: '" // trim(adjustl(filename)) // "'" )
               out = MF_EMPTY
               close(unit)
               return
            end if
            if( nrow == 0 .and. ncol == 0 ) then
               out = MF_EMPTY
               close(unit)
               return
            end if

            if( out%data_type == MF_DT_DBLE .or. out%data_type == MF_DT_BOOL ) then ! real or boolean case
               close(unit)
               open( unit=unit, file=trim(adjustl(filename)),           &
                     access="direct", recl=8, status="old" )
               allocate( out%double(nrow,ncol) )

               rec_num = 10
outer2:        do j = 1, ncol
                  do i = 1, nrow
                     read(unit,rec=rec_num,iostat=iostat) out%double(i,j)
                     if( iostat /= 0 ) exit outer2
                     call swap_8bytes( out%double(i,j) )
                     rec_num = rec_num + 1
                  end do
               end do outer2
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%double" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               bytes_read = (rec_num-1)*8 + 4 + 4
            else if( out%data_type == MF_DT_CMPLX ) then
               close(unit)
               open( unit=unit, file=trim(adjustl(filename)),           &
                     access="direct", recl=8, status="old" )
               allocate( out%cmplx(nrow,ncol) )

               rec_num = 10
outer3:        do j = 1, ncol
                  do i = 1, nrow
                     read(unit,rec=rec_num,iostat=iostat) tmp_re
                     if( iostat /= 0 ) exit outer3
                     call swap_8bytes( tmp_re )
                     rec_num = rec_num + 1
                     read(unit,rec=rec_num,iostat=iostat) tmp_im
                     if( iostat /= 0 ) exit outer3
                     call swap_8bytes( tmp_im )
                     rec_num = rec_num + 1
                     out%cmplx(i,j) = cmplx( tmp_re, tmp_im, kind=MF_DOUBLE )
                  end do
               end do outer3
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%cmplx" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               bytes_read = (rec_num-1)*8 + 4 + 4
            else if( out%data_type == MF_DT_SP_DBLE ) then
               rec_num = 19
               read(unit,rec=rec_num,iostat=iostat) nnz
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: nnz" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               call swap_4bytes( nnz )
               ncol = out%shape(2)
               allocate( out%j(ncol+1) )

               rec_num = 22
               do k = 1, ncol+1
                  read(unit,rec=rec_num,iostat=iostat) out%j(k)
                  if( iostat /= 0 ) exit
                  call swap_4bytes( out%j(k) )
                  rec_num = rec_num + 1
               end do
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%j" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               ! consistency check
               if( nnz /= out%j(ncol+1)-1 ) then
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "inconsistency found: nnz doesn't match col data!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
               end if
               allocate( out%i(nnz) )

               rec_num = rec_num + 2
               do k = 1, nnz
                  read(unit,rec=rec_num,iostat=iostat) out%i(k)
                  if( iostat /= 0 ) exit
                  call swap_4bytes( out%i(k) )
                  rec_num = rec_num + 1
               end do
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%i" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               allocate( out%a(nnz) )

               close(unit)
               open( unit=unit, file=trim(adjustl(filename)),           &
                     access="direct", recl=8, status="old" )
               if( mod(rec_num+1,2) /= 0 ) then
                  ! fixing rec_num: cf. 'msSave'
                  rec_num = rec_num + 1
               end if
               rec_num = (rec_num+1)/2 + 1
               do k = 1, nnz
                  read(unit,rec=rec_num,iostat=iostat) out%a(k)
                  if( iostat /= 0 ) exit
                  call swap_8bytes( out%a(k) )
                  rec_num = rec_num + 1
               end do
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%a" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               bytes_read = (rec_num-1)*8 + 4 + 4
            else if( out%data_type == MF_DT_SP_CMPLX ) then
               rec_num = 19
               read(unit,rec=rec_num,iostat=iostat) nnz
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: nnz" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               call swap_4bytes( nnz )
               ncol = out%shape(2)
               allocate( out%j(ncol+1) )

               rec_num = 22
               do k = 1, ncol+1
                  read(unit,rec=rec_num,iostat=iostat) out%j(k)
                  if( iostat /= 0 ) exit
                  call swap_4bytes( out%j(k) )
                  rec_num = rec_num + 1
               end do
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%j" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               ! consistency check
               if( nnz /= out%j(ncol+1)-1 ) then
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "inconsistency found: nnz doesn't match col data!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
               end if
               allocate( out%i(nnz) )

               rec_num = rec_num + 2
               do k = 1, nnz
                  read(unit,rec=rec_num,iostat=iostat) out%i(k)
                  if( iostat /= 0 ) exit
                  call swap_4bytes( out%i(k) )
                  rec_num = rec_num + 1
               end do
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%i" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               allocate( out%z(nnz) )

               close(unit)
               open( unit=unit, file=trim(adjustl(filename)),           &
                     access="direct", recl=8, status="old" )
               if( mod(rec_num+1,2) /= 0 ) then
                  ! fixing rec_num: cf. 'msSave'
                  rec_num = rec_num + 1
               end if
               rec_num = (rec_num+1)/2 + 1
               do k = 1, nnz
                  read(unit,rec=rec_num,iostat=iostat) tmp_re
                  if( iostat /= 0 ) exit
                  call swap_8bytes( tmp_re )
                  rec_num = rec_num + 1
                  read(unit,rec=rec_num,iostat=iostat) tmp_im
                  if( iostat /= 0 ) exit
                  call swap_8bytes( tmp_im )
                  rec_num = rec_num + 1
                  out%z(k) = cmplx( tmp_re, tmp_im, kind=MF_DOUBLE )
               end do
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%z" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               bytes_read = (rec_num-1)*8 + 4 + 4
            end if

            close(unit)

            if( signature_20 == MF_BIN_SIGN_23 ) then

               ! multiply the position (record number) by two
               ! because we must read 4 bytes at a time

               open( unit=unit, file=trim(adjustl(filename)),           &
                     access="direct", recl=4, status="old" )

               rec_num = bytes_read/4 + 1
               read(unit,rec=rec_num,iostat=iostat) itmp
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%prop%symm" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               call swap_4bytes( itmp )
               out%prop%symm = itmp
               if( out%prop%symm /= TRUE .and. out%prop%symm /= FALSE .and. out%prop%symm /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the SYMM value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if

               rec_num = rec_num + 3
               read(unit,rec=rec_num,iostat=iostat) itmp
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%prop%posd" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               call swap_4bytes( itmp )
               out%prop%posd = itmp
               if( out%prop%posd /= TRUE .and. out%prop%posd /= FALSE .and. out%prop%posd /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the POS_DEF value is not valid!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if

               close(unit)

            else ! signature_20 == MF_BIN_SIGN_24 or MF_BIN_SIGN_25

               ! matrix properties: we now read three times 4-bytes:
               !  4-bytes: size of next data chunk
               !  4-bytes: 4 integer properties (each on 1 byte)
               !  4-bytes: size of previous data chunk

               ! change the position (record number)
               ! because we must read a different number of bytes
               ! at a time

               ! multiply the position (record number) by two
               ! because we must read 4 bytes at a time

               open( unit=unit, file=trim(adjustl(filename)),           &
                     access="direct", recl=4, status="old" )

               rec_num = bytes_read/4 + 1
               read(unit,rec=rec_num,iostat=iostat) itmp
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%prop" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               call swap_4bytes( itmp )
               byte(1:4) = transfer(itmp,byte)
               out%prop%tril = byte(1)
               if( out%prop%tril /= TRUE .and. out%prop%tril /= FALSE .and. out%prop%tril /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the TRIL value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if
               out%prop%triu = byte(2)
               if( out%prop%triu /= TRUE .and. out%prop%triu /= FALSE .and. out%prop%triu /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the TRIU value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if
               out%prop%symm = byte(3)
               if( out%prop%symm /= TRUE .and. out%prop%symm /= FALSE .and. out%prop%symm /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the SYMM value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if
               out%prop%posd = byte(4)
               if( out%prop%posd /= TRUE .and. out%prop%posd /= FALSE .and. out%prop%posd /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the POS_DEF value is not valid!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if

               close(unit)

            end if

            ! change the position (record number)
            ! because we must read a different number of bytes
            ! at a time

            open( unit=unit, file=trim(adjustl(filename)),              &
                  access="direct", recl=rat_byte_nb, status="old" )

            rec_num = (rec_num+2)*(4/rat_byte_nb) + 1

#ifdef _RAT_1_BYTE
            ! need to swap the bytes ?
print *, 'mfLoad not yet finished for reading SPARSE matrices : _RAT_1_BYTE not ready'
#endif

#ifdef _RAT_2_BYTES
            do i = 1, num_base_units
               read(unit,rec=rec_num,iostat=iostat) out%units(i)
               if( iostat /= 0 ) exit
               call swap_4bytes_rat( out%units(i) )
               rec_num = rec_num + 1
            end do
            if( iostat /= 0 ) then
               call PrintMessage( ROUTINE_NAME, "I",                    &
                                  "reading: out%units" )
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "incomplete data!",                   &
                                  "file: '" // trim(adjustl(filename)) // "'" )
               out = MF_EMPTY
               close(unit)
               return
            end if
#endif

#ifdef _RAT_4_BYTES
print *, 'mfLoad not yet finished for reading SPARSE matrices : _RAT_4_BYTES not ready'
#endif

            close(unit)

         else ! bytes must not be swapped

            ! sequential access
            open( unit=unit, file=trim(adjustl(filename)),              &
                  form="unformatted", status="old" )

            ! no need to verify read
            read(unit) signature_20

            ! no need to verify read
            read(unit) endianness

            read(unit) itmp
            out%data_type = itmp
            if( out%data_type < 0 ) then
               ! for MF_BIN_SIGN_25, it means special objects.
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "file: '" // trim(adjustl(filename)) // "' doesn't contain an mfArray", &
                                  "-> you must load it using the 'mfLoadTriConnect' routine." )
               close(unit)
               return
            end if

            if( out%data_type == MF_DT_EMPTY ) then
               close(unit)
               return
            end if

            read(unit) nrow, ncol
            if( nrow < 0 .or. ncol < 0 ) then
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "array shape cannot contain negative values!", &
                                  "file: '" // trim(adjustl(filename)) // "'" )
               out = MF_EMPTY
               close(unit)
               return
            end if
            if( nrow == 0 .and. ncol == 0 ) then
               out = MF_EMPTY
               close(unit)
               return
            end if
            out%shape(:) = [ nrow, ncol ]

            ! read by column (faster memory access)
            if( out%data_type == MF_DT_DBLE .or. out%data_type == MF_DT_BOOL ) then ! real or boolean case
               allocate( out%double(nrow,ncol) )

               read(unit,iostat=iostat) out%double(:,:)
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%double" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
            else if( out%data_type == MF_DT_CMPLX ) then
               allocate( out%cmplx(nrow,ncol) )

               read(unit,iostat=iostat) out%cmplx(:,:)
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%cmplx" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
            else if( out%data_type == MF_DT_SP_DBLE ) then
               read(unit,iostat=iostat) nnz
               if( iostat /= 0 ) then
                  write(iostat_char,"(I0)") iostat
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: nnz",                    &
                                     "iostat = " // trim(adjustl(iostat_char)) )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               allocate( out%j(ncol+1) )

               read(unit,iostat=iostat) out%j
               if( iostat /= 0 ) then
                  write(iostat_char,"(I0)") iostat
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%j",                  &
                                     "iostat = " // trim(adjustl(iostat_char)) )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               ! consistency check
               if( nnz /= out%j(ncol+1)-1 ) then
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "inconsistency found: nnz doesn't match col data!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
               end if
               allocate( out%i(nnz) )

               read(unit,iostat=iostat) out%i
               if( iostat /= 0 ) then
                  write(iostat_char,"(I0)") iostat
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%i",                  &
                                     "iostat = " // trim(adjustl(iostat_char)) )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               allocate( out%a(nnz) )

               read(unit,iostat=iostat) out%a
               if( iostat /= 0 ) then
                  write(iostat_char,"(I0)") iostat
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%a",                  &
                                     "iostat = " // trim(adjustl(iostat_char)) )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
            else if( out%data_type == MF_DT_SP_CMPLX ) then
               read(unit,iostat=iostat) nnz
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: nnz" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               allocate( out%j(ncol+1) )

               read(unit,iostat=iostat) out%j
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%j" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               ! consistency check
               if( nnz /= out%j(ncol+1)-1 ) then
                  call PrintMessage( ROUTINE_NAME, "W",                 &
                                     "inconsistency found: nnz doesn't match col data!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
               end if
               allocate( out%i(nnz) )

               read(unit,iostat=iostat) out%i
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%i" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               allocate( out%z(nnz) )

               read(unit,iostat=iostat) out%z
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%z" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
            else if( out%data_type == MF_DT_PERM_VEC ) then
               allocate( out%i(nrow) )

               read(unit,iostat=iostat) out%i
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%i" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
            else
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "unknown data type" )
               close(unit)
            end if

            if( signature_20 == MF_BIN_SIGN_23 ) then

               read(unit,iostat=iostat) itmp
               out%prop%symm = itmp
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%prop%symm" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               if( out%prop%symm /= TRUE .and. out%prop%symm /= FALSE .and. out%prop%symm /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the SYMM value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if

               read(unit,iostat=iostat) itmp
               out%prop%posd = itmp
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%prop%posd" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if
               if( out%prop%posd /= TRUE .and. out%prop%posd /= FALSE .and. out%prop%posd /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the POS_DEF value is not valid!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if

            else ! signature_20 == MF_BIN_SIGN_24 or MF_BIN_SIGN_25

               read(unit,iostat=iostat) out%prop%tril, out%prop%triu,   &
                                        out%prop%symm, out%prop%posd
               if( iostat /= 0 ) then
                  call PrintMessage( ROUTINE_NAME, "I",                 &
                                     "reading: out%prop" )
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "incomplete data!",                &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  out = MF_EMPTY
                  close(unit)
                  return
               end if

               if( out%prop%tril /= TRUE .and. out%prop%tril /= FALSE .and. out%prop%tril /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the TRIL value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if

               if( out%prop%triu /= TRUE .and. out%prop%triu /= FALSE .and. out%prop%triu /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the TRIU value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if

               if( out%prop%symm /= TRUE .and. out%prop%symm /= FALSE .and. out%prop%symm /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the SYMM value is not valid!",    &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if

               if( out%prop%posd /= TRUE .and. out%prop%posd /= FALSE .and. out%prop%posd /= UNKNOWN ) then
                  call PrintMessage( ROUTINE_NAME, "E",                 &
                                     "the POS_DEF value is not valid!", &
                                     "file: '" // trim(adjustl(filename)) // "'" )
                  return
               end if

            end if

            read(unit,iostat=iostat) out%units(:)
            if( iostat /= 0 ) then
               call PrintMessage( ROUTINE_NAME, "I",                    &
                                  "reading: out%units" )
               call PrintMessage( ROUTINE_NAME, "E",                    &
                                  "incomplete data!",                   &
                                  "file: '" // trim(adjustl(filename)) // "'" )
               out = MF_EMPTY
               close(unit)
               return
            end if

            close(unit)

         end if

      end if

      out%status_temporary = .true.

#endif
   end function mfLoad
