! f90 include file

!_______________________________________________________________________
!
   function mfMoments( a ) result( out )

      type(mfArray) :: a
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      integer :: n, status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( a )

      if( mfIsEmpty(a) ) then
         go to 99
      end if

      if( mfIsSparse(a) ) then
         call PrintMessage( "mfMoments", "E",                           &
                            "sparse matrices not handled!" )
         go to 99
      end if

      if( a%data_type /= MF_DT_DBLE ) then
         call PrintMessage( "mfMoments", "E",                           &
                            "arg must be a real mfArray!" )
         go to 99
      end if

      if( a%shape(1) == 1 ) then
         n = a%shape(2)
      else if( a%shape(2) == 1 ) then
         n = a%shape(1)
      else
         call PrintMessage( "mfMoments", "E",                           &
                            "arg must be a vector!" )
         go to 99
      end if

      if( n <= 1 ) then
         call PrintMessage( "mfMoments", "E",                           &
                            "data must contain at least 2 values!" )
         go to 99
      end if

      out%data_type = a%data_type

      out%shape = [ 1, 6 ]
      allocate( out%double(1,6) )

      if( a%shape(1) == 1 ) then
         call moments( a%double(1,:), out%double(1,:) )
      else if( a%shape(2) == 1 ) then
         call moments( a%double(:,1), out%double(1,:) )
      end if

      out%prop%symm = FALSE

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( a%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "mfMoments", "E",                        &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( a )
      call msAutoRelease( a )

#endif
   end function mfMoments
!_______________________________________________________________________
!
   subroutine moments( vec, res )

      real(kind=MF_DOUBLE) :: vec(:)
      real(kind=MF_DOUBLE) :: res(:)
      !------ API end ------
#ifdef _DEVLP

      ! computes : ave  = mean
      !            adev = average deviation
      !            sdev = standard deviation
      !            var  = variance
      !            skew = skewness
      !            kurt = kurtosis

      ! algorithm from Numerical Recipes

      integer :: i, n
      real(kind=MF_DOUBLE) :: ave, adev, sdev, var, skew, kurt
      real(kind=MF_DOUBLE) :: s, ep, p

   !------ end of declarations -- execution starts hereafter  ------

      n = size(res)
      if( n /= 6 ) then
         write(STDERR,*) "(MUESLI moments:) internal error:"
         write(STDERR,*) "                  bad dim. for arg. 'res' (should be 6)"
         mf_message_displayed = .true.
         call muesli_trace( pause="yes" )
         stop
      end if

      n = size(vec)
      ave = 0.0d0
      do i = 1, n
         ave = ave + vec(i)
      end do
      ave = ave/n

      adev = 0.0d0
      var = 0.0d0
      skew = 0.0d0
      kurt = 0.0d0
      ep = 0.0d0

      do i = 1, n
         s = vec(i) - ave
         ep = ep + s
         adev = adev + abs(s)
         p = s**2
         var = var + p
         p = p*s
         skew = skew + p
         p = p*s
         kurt = kurt + p
      end do

      adev = adev/n
      var = (var-ep**2/n)/(n-1)
      sdev = sqrt(var)
      if( var /= 0.0d0 ) then
         skew = skew/(n*sdev**3)
         kurt = kurt/(n*var**2) - 3.0d0
      else
         skew = MF_INF
         kurt = MF_INF
      end if

      res(1) = ave
      res(2) = adev
      res(3) = sdev
      res(4) = var
      res(5) = skew
      res(6) = kurt

#endif
   end subroutine moments
