! f90 include file

!_______________________________________________________________________
!
   function mfInvFFT2( A ) result( out )

      type(mfArray)                 :: A
      type(mfArray)                 :: out
      !------ API end ------
#ifdef _DEVLP

      ! Inverse Discrete Fourier Transformation
      !   input and output data are complex
      !
      ! The GFT package is used


      integer :: m, n, ier, si
      real(kind=MF_DOUBLE) :: sc
      type(GFT_CC) :: h_cc

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfInvFFT2", "E",                           &
                            "sparse matrices not handled!" )
         go to 99
      end if

      if( .not. mfIsNumeric(A) ) then
         call PrintMessage( "mfInvFFT2", "E",                           &
                            "data must be numeric!" )
         go to 99
      end if

      if( A%data_type /= MF_DT_CMPLX ) then
         call PrintMessage( "mfInvFFT2", "E",                           &
                            "data must be numeric!" )
         go to 99
      end if

      m = A%shape(1)
      n = A%shape(2)

      out%data_type = MF_DT_CMPLX
      out%shape = A%shape
      allocate( out%cmplx(out%shape(1),out%shape(2)) )

      if( mod(m,2) /= 0 .and. mod(n,2) /= 0 ) then
         call PrintMessage( "mfInvFFT2", "E",                           &
                            "m or n must be even!" )
         go to 99
      end if
      call GFT_set_fft( Nx=m, Ny=n, FFT=h_cc, code=ier )
      if( ier /= 0 ) then
         call jmerreur0("(GFT:) JMFACT",ier)
         call PrintMessage( "mfInvFFT2", "E",                           &
                            "factorizing vector length in prime numbers:", &
                            "some prime number are too large! (max is 47)" )
         go to 99
      end if
      si = -1          ! Backward FFT
      sc = 1.0d0/(m*n) ! Scale factor
      call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,                    &
                       c_in=A%cmplx(:,:), c_out=out%cmplx(:,:) )

      ! Deallocate FFT object
      call GFT_end_fft( FFT=h_cc )

      out%prop%symm = FALSE

      if( mf_phys_units ) then
         out%units(:) = A%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function mfInvFFT2
