! f90 include file

!_______________________________________________________________________
!
   function mfInvFFT( A, dim ) result( out )

      type(mfArray)                 :: A
      integer, intent(in), optional :: dim
      type(mfArray)                 :: out
      !------ API end ------
#ifdef _DEVLP

      ! Inverse Discrete Fourier Transformation
      !   input and output data are complex
      !
      ! The GFT package is used


      integer :: m, n, i, j, ier, si
      real(kind=MF_DOUBLE) :: sc
      type(GFT_CC) :: h_cc

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfInvFFT", "E",                            &
                            "sparse matrices not handled!" )
         go to 99
      end if

      if( .not. mfIsNumeric(A) ) then
         call PrintMessage( "mfInvFFT", "E",                            &
                            "data must be numeric!" )
         go to 99
      end if

      m = A%shape(1)
      n = A%shape(2)

      out%data_type = MF_DT_CMPLX
      out%shape = A%shape
      allocate( out%cmplx(out%shape(1),out%shape(2)) )

      if( present(dim) ) then
         ! A is always considered as a matrix
         if( dim == 1 ) then
            ! works on columns (as in Matlab)
            if( A%data_type == MF_DT_DBLE ) then
print *, '(MUESLI:) mfInvFFT: real case not yet handled'
stop
            else ! complex case
               if( mod(m,2) /= 0 .or. m < 1 ) then
                  call PrintMessage( "mfInvFFT", "E",                   &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=m, FFT=h_cc, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfInvFFT", "E",                   &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = -1         ! Backward FFT
               sc = 1.0d0/m    ! Scale factor
               do j = 1, n
                  call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,        &
                                   c_in=A%cmplx(:,j), c_out=out%cmplx(:,j) )
               end do
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_cc )
            end if
         else if( dim == 2 ) then
            ! works on rows
            if( A%data_type == MF_DT_DBLE ) then
print *, '(MUESLI:) mfInvFFT: real case not yet handled'
stop
            else ! complex case
               if( mod(n,2) /= 0 .or. n < 1 ) then
                  call PrintMessage( "mfInvFFT", "E",                   &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=n, FFT=h_cc, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfInvFFT", "E",                   &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = -1         ! Backward FFT
               sc = 1.0d0/n    ! Scale factor
               do i = 1, m
                  call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,        &
                                   c_in=A%cmplx(i,:), c_out=out%cmplx(i,:) )
               end do
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_cc )
            end if
         else
            call PrintMessage( "mfInvFFT", "E",                         &
                               "dim must be equal to 1 or 2!" )
            go to 99
         end if
      else ! dim is not present

         if( A%data_type == MF_DT_CMPLX ) then

            if( m == 1 ) then
               ! row vector of length n
               if( mod(n,2) /= 0 .or. n < 1 ) then
                  call PrintMessage( "mfInvFFT", "E",                   &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=n, FFT=h_cc, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfInvFFT", "E",                   &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = -1         ! Backward FFT
               sc = 1.0d0/n    ! Scale factor
               call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,           &
                                c_in=A%cmplx(1,:), c_out=out%cmplx(1,:) )
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_cc )
            else if( n == 1 ) then
               ! column vector of length m
               if( mod(m,2) /= 0 .or. m < 1 ) then
                  call PrintMessage( "mfInvFFT", "E",                   &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=m, FFT=h_cc, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfInvFFT", "E",                   &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = -1         ! Backward FFT
               sc = 1.0d0/m    ! Scale factor
               call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,           &
                                c_in=A%cmplx(:,1), c_out=out%cmplx(:,1) )
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_cc )
            else
               ! matrix case -> working on columns
               if( mod(m,2) /= 0 .or. m < 1 ) then
                  call PrintMessage( "mfInvFFT", "E",                   &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=m, FFT=h_cc, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfInvFFT", "E",                   &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = -1         ! Backward FFT
               sc = 1.0d0/m    ! Scale factor
               do j = 1, n
                  call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,        &
                                   c_in=A%cmplx(:,j), c_out=out%cmplx(:,j) )
               end do
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_cc )
            end if

         else ! real case
print *, '(MUESLI:) mfInvFFT: real case not yet handled'
stop
         end if

      end if

      out%prop%symm = FALSE

      if( mf_phys_units ) then
         out%units(:) = A%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function mfInvFFT
