! f90 include file

!_______________________________________________________________________
!
   subroutine fourier_leg( y, y_chap )

      real(kind=MF_DOUBLE), intent(in) :: y(:)
      real(kind=MF_DOUBLE) :: y_chap(:)
      !------ API end ------
#ifdef _DEVLP

      ! compute the Legendre modes of the function y
      ! known in n+1 points over [-1,1] in cos(theta) with
      ! theta equidistant over [-Pi,0]
      !
      !   procedure  :
      !      1) decompose y in cosine-serie
      !      2) decompose each cos(i theta) in Legendre polynomial
      !
      ! returns normalized coefficients

      real(kind=MF_DOUBLE), allocatable :: leg_cos(:,:)
      real(kind=MF_DOUBLE) :: h

      integer :: i, j, n

   !------ end of declarations -- execution starts hereafter  ------

      n = size(y) - 1

      ! first, applies the Fourier-cos transform
      call fourier_cos( y, y_chap )

      ! second, finds the coeff of Legendre by inverting the
      ! 'Legendre/Fourier' relation
      allocate( leg_cos(n+1,n+1) )

      call leg_in_cos( n+1, leg_cos )

      ! actually, the 'leg_cos' is a upper triangular matrix
      ! we can solve the system: leg_cos * x = y
      ! only by one backward substitution.

      ! warning: the following algorithm deal with a particular
      ! matrix structure : terms are alternatively null.

      y_chap(n+1) = y_chap(n+1)/leg_cos(n+1,n+1)
      y_chap(n) = y_chap(n)/leg_cos(n,n)
      do i = n-1, 1, -1
         do j = i+2, n+1, 2
            y_chap(i) = y_chap(i) - leg_cos(i,j)*y_chap(j)
         end do
         y_chap(i) = y_chap(i)/leg_cos(i,i)
      end do

#endif
   end subroutine fourier_leg
!_______________________________________________________________________
!
   subroutine inv_fourier_leg( y_chap, y )

      real(kind=MF_DOUBLE), intent(in) :: y_chap(:)
      real(kind=MF_DOUBLE) :: y(:)
      !------ API end ------
#ifdef _DEVLP

      ! compute the function from the Legendre modes obtained
      ! by 'fourier_leg'

      ! low level 'lep' function (computes Legendre polyn.) is
      ! located in 'mf_core' module file, because it is also used in
      ! the 'mod_datafun' module.

      integer :: i, k, n

      real(kind=MF_DOUBLE), allocatable :: x(:)

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      n = size(y) - 1

      allocate( x(n+1) )

      ! build x = cos(theta), with theta in [-Pi,0]
      x(1) = -1.0d0
      do i = 2, n
         x(i) = cos( -MF_PI + (i-1)*MF_PI/n )
      end do
      x(n+1) = 1.0d0

      !-- Fourier-Legendre inverse transformation.

      do i = 1, n+1
         y(i) = 0.0d0
         do k = 1, n+1
            y(i) = y(i) + y_chap(k)*lep(k-1,x(i))
         end do
      end do

      call mf_restore_fpe( )

#endif
   end subroutine inv_fourier_leg
