! f90 include file

!_______________________________________________________________________
!
   function mfFFT2( A ) result( out )

      type(mfArray) :: A
      type(mfArray) :: out
      !------ API end ------
#ifdef _DEVLP

      ! 2D Discrete Fourier Transformation
      !   input data may be real or complex
      !     (but real data are converted in complex)
      !   output data is always complex
      !
      ! The GFT package is used

      integer :: m, n, ier, si
      real(kind=MF_DOUBLE) :: sc
      type(GFT_CC) :: h_cc
      complex(kind=MF_DOUBLE), pointer :: temp(:,:)

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfFFT2", "E",                              &
                            "sparse matrices not handled!" )
         go to 99
      end if

      if( .not. mfIsNumeric(A) ) then
         call PrintMessage( "mfFFT2", "E",                              &
                            "data must be numeric!" )
         go to 99
      end if

      if( mfIsVector(A) ) then
         call PrintMessage( "mfFFT2", "W",                              &
                            "A is a vector: you should use mfFFT instead!" )
         go to 99
      end if

      m = A%shape(1)
      n = A%shape(2)

      out%data_type = MF_DT_CMPLX
      out%shape = A%shape
      allocate( out%cmplx(out%shape(1),out%shape(2)) )

      if( A%data_type == MF_DT_DBLE ) then
         allocate( temp(m,n) )

         temp(:,:) = A%double(:,:)
      else ! complex data
         temp => A%cmplx
      end if

      if( mod(m,2) /= 0 .and. mod(n,2) /= 0 ) then
         call PrintMessage( "mfFFT2", "E",                              &
                            "m or n must be even!" )
         go to 99
      end if
      call GFT_set_fft( Nx=m, Ny=n, FFT=h_cc, code=ier )
      if( ier /= 0 ) then
         call jmerreur0("(GFT:) JMFACT",ier)
         call PrintMessage( "mfFFT2", "E",                              &
                            "factorizing vector length in prime numbers:", &
                            "some prime number are too large! (max is 47)" )
         go to 99
      end if
      si = +1         ! Forward FFT
      sc = 1.0d0      ! Scale factor
      call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,                    &
                       c_in=temp, c_out=out%cmplx(:,:) )
      ! Deallocate FFT object
      call GFT_end_fft( FFT=h_cc )

      if( A%data_type == MF_DT_DBLE ) then
         deallocate( temp )

      end if

      out%prop%symm = FALSE

      if( mf_phys_units ) then
         out%units(:) = A%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function mfFFT2
