! f90 include file

!_______________________________________________________________________
!
   function mfFFT( A, dim ) result( out )

      type(mfArray)                 :: A
      integer, intent(in), optional :: dim
      type(mfArray)                 :: out
      !------ API end ------
#ifdef _DEVLP

      ! Discrete Fourier Transformation
      !   input data may be real or complex
      !   output data is always complex
      !
      ! The GFT package is used

      integer :: m, n, i, j, ier, si
      real(kind=MF_DOUBLE) :: sc
      type(GFT_RCR) :: h_rcr
      type(GFT_CC) :: h_cc
#if defined _INTEL_IFC
real(kind=MF_DOUBLE), allocatable :: temp(:)
complex(kind=MF_DOUBLE), allocatable :: ztemp(:)
#endif

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( A )

      if( mfIsEmpty(A) ) then
         go to 99
      end if

      if( mfIsSparse(A) ) then
         call PrintMessage( "mfFFT", "E",                               &
                            "sparse matrices not handled!" )
         go to 99
      end if

      if( .not. mfIsNumeric(A) ) then
         call PrintMessage( "mfFFT", "E",                               &
                            "data must be numeric!" )
         go to 99
      end if

      m = A%shape(1)
      n = A%shape(2)

      out%data_type = MF_DT_CMPLX
      out%shape = A%shape
      allocate( out%cmplx(out%shape(1),out%shape(2)) )

      if( present(dim) ) then

         ! A is always considered as a matrix
         if( dim == 1 ) then
            ! works on columns (as in Matlab)
            if( A%data_type == MF_DT_DBLE ) then
               if( mod(m,2) /= 0 .or. m < 1 ) then
                  call PrintMessage( "mfFFT", "E",                      &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=m, FFT=h_rcr, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfFFT", "E",                      &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = +1         ! Forward FFT
               sc = 1.0d0      ! Scale factor
               do j = 1, n
                  call GFT_do_fft( FFT=h_rcr, isign=si, scale=sc,       &
                                   r_in=A%double(:,j), c_out=out%cmplx(:,j) )
               end do
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_rcr )
               ! Duplicate values (as in Matlab)
               out%cmplx(m/2+2:m,:) = conjg( out%cmplx(m/2:2:-1,:) )
            else ! complex case
               if( mod(m,2) /= 0 .or. m < 1 ) then
                  call PrintMessage( "mfFFT", "E",                      &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=m, FFT=h_cc, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfFFT", "E",                      &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = +1         ! Forward FFT
               sc = 1.0d0      ! Scale factor
               do j = 1, n
                  call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,        &
                                   c_in=A%cmplx(:,j), c_out=out%cmplx(:,j) )
               end do
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_cc )
            end if
         else if( dim == 2 ) then
            ! works on rows
            if( A%data_type == MF_DT_DBLE ) then
               if( mod(n,2) /= 0 .or. n < 1 ) then
                  call PrintMessage( "mfFFT", "E",                      &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=n, FFT=h_rcr, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfFFT", "E",                      &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = +1         ! Forward FFT
               sc = 1.0d0      ! Scale factor
#if defined _INTEL_IFC
               allocate( temp(n) )
#endif
               do i = 1, m
#if defined _INTEL_IFC
! bug (?) leads to a glibc corruption!
                  temp(:) = A%double(i,:)
                  call GFT_do_fft( FFT=h_rcr, isign=si, scale=sc,       &
                                   r_in=temp(:), c_out=out%cmplx(i,:) )
#else
                  call GFT_do_fft( FFT=h_rcr, isign=si, scale=sc,       &
                                   r_in=A%double(i,:), c_out=out%cmplx(i,:) )
#endif
               end do
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_rcr )
               ! Duplicate values (as in Matlab)
               out%cmplx(:,n/2+2:n) = conjg( out%cmplx(:,n/2:2:-1) )
            else ! complex case
               if( mod(n,2) /= 0 .or. n < 1 ) then
                  call PrintMessage( "mfFFT", "E",                      &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=n, FFT=h_cc, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfFFT", "E",                      &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = +1         ! Forward FFT
               sc = 1.0d0      ! Scale factor
#if defined _INTEL_IFC
               allocate( ztemp(n) )
#endif
               do i = 1, m
#if defined _INTEL_IFC
! bug (?) leads to a glibc corruption!
                  ztemp(:) = A%cmplx(i,:)
                  call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,        &
                                   c_in=ztemp(:), c_out=out%cmplx(i,:) )
#else
                  call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,        &
                                   c_in=A%cmplx(i,:), c_out=out%cmplx(i,:) )
#endif
               end do
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_cc )
            end if
         else
            call PrintMessage( "mfFFT", "E",                            &
                               "dim must be equal to 1 or 2!" )
            go to 99
         end if

      else ! dim is not present

         if( A%data_type == MF_DT_DBLE ) then

            if( m == 1 ) then
               ! row vector of length n
               if( mod(n,2) /= 0 .or. n < 1 ) then
                  call PrintMessage( "mfFFT", "E",                      &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=n, FFT=h_rcr, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfFFT", "E",                      &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = +1         ! Forward FFT
               sc = 1.0d0      ! Scale factor
               call GFT_do_fft( FFT=h_rcr, isign=si, scale=sc,          &
                                r_in=A%double(1,:), c_out=out%cmplx(1,:) )
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_rcr )
               ! Duplicate values (as in Matlab)
               out%cmplx(1,n/2+2:n) = conjg( out%cmplx(1,n/2:2:-1) )
            else if( n == 1 ) then
               ! column vector of length m
               if( mod(m,2) /= 0 .or. m < 1 ) then
                  call PrintMessage( "mfFFT", "E",                      &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=m, FFT=h_rcr, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfFFT", "E",                      &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = +1         ! Forward FFT
               sc = 1.0d0      ! Scale factor
               call GFT_do_fft( FFT=h_rcr, isign=si, scale=sc,          &
                                r_in=A%double(:,1), c_out=out%cmplx(:,1) )
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_rcr )
               ! Duplicate values (as in Matlab)
               out%cmplx(m/2+2:m,1) = conjg( out%cmplx(m/2:2:-1,1) )
            else
               ! matrix case -> working on columns
               if( mod(m,2) /= 0 .or. m < 1 ) then
                  call PrintMessage( "mfFFT", "E",                      &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=m, FFT=h_rcr, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfFFT", "E",                      &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = +1         ! Forward FFT
               sc = 1.0d0      ! Scale factor
               do j = 1, n
                  call GFT_do_fft( FFT=h_rcr, isign=si, scale=sc,       &
                                   r_in=A%double(:,j), c_out=out%cmplx(:,j) )
               end do
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_rcr )
               ! Duplicate values (as in Matlab)
               out%cmplx(m/2+2:m,:) = conjg( out%cmplx(m/2:2:-1,:) )
            end if

         else ! complex case

            if( m == 1 ) then
               ! row vector of length n
               if( mod(n,2) /= 0 .or. n < 1 ) then
                  call PrintMessage( "mfFFT", "E",                      &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=n, FFT=h_cc, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfFFT", "E",                      &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = +1         ! Forward FFT
               sc = 1.0d0      ! Scale factor
               call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,           &
                                c_in=A%cmplx(1,:), c_out=out%cmplx(1,:) )
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_cc )
            else if( n == 1 ) then
               ! column vector of length m
               if( mod(m,2) /= 0 .or. m < 1 ) then
                  call PrintMessage( "mfFFT", "E",                      &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=m, FFT=h_cc, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfFFT", "E",                      &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = +1         ! Forward FFT
               sc = 1.0d0      ! Scale factor
               call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,           &
                                c_in=A%cmplx(:,1), c_out=out%cmplx(:,1) )
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_cc )
            else
               ! matrix case -> working on columns
               if( mod(m,2) /= 0 .or. m < 1 ) then
                  call PrintMessage( "mfFFT", "E",                      &
                                     "vector length must be even and >= 1!" )
                  go to 99
               end if
               call GFT_set_fft( Nx=m, FFT=h_cc, code=ier )
               if( ier /= 0 ) then
                  call jmerreur0("(GFT:) JMFACT",ier)
                  call PrintMessage( "mfFFT", "E",                      &
                                     "factorizing vector length in prime numbers:", &
                                     "some prime number are too large! (max is 47)" )
                  go to 99
               end if
               si = +1         ! Forward FFT
               sc = 1.0d0      ! Scale factor
               do j = 1, n
                  call GFT_do_fft( FFT=h_cc, isign=si, scale=sc,        &
                                   c_in=A%cmplx(:,j), c_out=out%cmplx(:,j) )
               end do
               ! Deallocate FFT object
               call GFT_end_fft( FFT=h_cc )

            end if

         end if

      end if

      out%prop%symm = FALSE

      if( mf_phys_units ) then
         out%units(:) = A%units(:)
      end if

      out%status_temporary = .true.

 99   continue

      call msFreeArgs( A )
      call msAutoRelease( A )

#endif
   end function mfFFT
