! f90 include file

!_______________________________________________________________________
!
   function isEndIndex( a ) result( bool )

      type(mfArray), intent(in) :: a
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( a )

      if( all(a%shape == MF_END%shape) ) then
         bool = .true.
      else
         bool = .false.
      end if

      call msFreeArgs( a )

      call msAutoRelease( a )

#endif
   end function isEndIndex
!_______________________________________________________________________
!
   function seq_from_mfarray( from ) result( seq )

      type(mfArray), intent(in) :: from
      integer :: seq
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      if( .not. isEndIndex(from) ) then
         call PrintMessage( "operator(.from.)", "E",                    &
                            "only an end-index like MF_END, or an integer", &
                            "is accepted after the '.from.' operator!" )
         return
      end if

      if( from%crc > 0 ) then
         call PrintMessage( "operator(.from.)", "E",                    &
                            "out-of-range expression involving MF_END!" )
         return
      end if

      seq = from%crc

#endif
   end function seq_from_mfarray
!_______________________________________________________________________
!
   function seq_from_int_to_mfarray( from, to ) result( seq )

      integer,       intent(in) :: from
      type(mfArray), intent(in) :: to
      type(seq_def) :: seq
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      if( to%crc > 0 ) then
         call PrintMessage( "operator(.to.)", "E",                      &
                            "out-of-range expression involving MF_END!" )
         return
      end if

      seq%start_1 = from
      seq%end_1   = to%crc
      seq%end_1_EndIndex = .true.

#endif
   end function seq_from_int_to_mfarray
!_______________________________________________________________________
!
   function seq_from_mfarray_to_int( from, to ) result( seq )

      type(mfArray), intent(in) :: from
      integer,       intent(in) :: to
      type(seq_def) :: seq
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      if( from%crc > 0 ) then
         call PrintMessage( "operator(.to.)", "E",                      &
                            "out-of-range expression involving MF_END!" )
         return
      end if

      seq%start_1 = from%crc
      seq%end_1   = to
      seq%start_1_EndIndex = .true.

#endif
   end function seq_from_mfarray_to_int
!_______________________________________________________________________
!
   function seq_from_mfarray_to_mfarray( from, to ) result( seq )

      type(mfArray), intent(in) :: from, to
      type(seq_def) :: seq
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      if( from%crc > 0 ) then
         call PrintMessage( "operator(.to.)", "E",                      &
                            "out-of-range expression involving MF_END!" )
         return
      end if
      if( to%crc > 0 ) then
         call PrintMessage( "operator(.to.)", "E",                      &
                            "out-of-range expression involving MF_END!" )
         return
      end if

      seq%start_1 = from%crc
      seq%end_1   = to%crc
      seq%start_1_EndIndex = .true.
      seq%end_1_EndIndex = .true.

#endif
   end function seq_from_mfarray_to_mfarray
!_______________________________________________________________________
!
   function seq_range_to_mfarray( range, to ) result( seq )

      type(seq_def), intent(in) :: range
      type(mfArray), intent(in) :: to
      type(seq_def) :: seq
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      if( to%crc > 0 ) then
         call PrintMessage( "operator(.to.)", "E",                      &
                            "out-of-range expression involving MF_END!" )
         return
      end if

      seq       = range
      seq%end_1 = to%crc
      seq%end_1_EndIndex = .true.

#endif
   end function seq_range_to_mfarray
!_______________________________________________________________________
!
   function seq_range_but_mfarray( range, but ) result( seq )

      type(seq_def), intent(in) :: range
      type(mfArray), intent(in) :: but
      type(seq_def) :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  range .but. i

   !------ end of declarations -- execution starts hereafter  ------

      if( but%crc > 0 ) then
         call PrintMessage( "operator(.but.)", "E",                     &
                            "out-of-range expression involving MF_END!" )
         return
      end if

      seq     = range
      seq%but = but%crc
      seq%but_present  = .true.
      seq%but_EndIndex = .true.

#endif
   end function seq_range_but_mfarray
!_______________________________________________________________________
!
   function seq_mfarray_but_int( mfall, but ) result( seq )

      type(mfArray), intent(in) :: mfall
      integer,       intent(in) :: but
      type(seq_def) :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  MF_ALL .but. i

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. mfIsEqual(mfall,MF_ALL) ) then
         call PrintMessage( "operator(.but.)", "E",                     &
                            "mfArray in sequence must be MF_ALL only!" )
         return
      end if

      seq%end_1_EndIndex = .true.

      seq%but = but
      seq%but_present  = .true.

#endif
   end function seq_mfarray_but_int
!_______________________________________________________________________
!
   function seq_mfarray_but_mfarray( mfall, but ) result( seq )

      type(mfArray), intent(in) :: mfall
      type(mfArray), intent(in) :: but
      type(seq_def) :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  MF_ALL .but. i

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. mfIsEqual(mfall,MF_ALL) ) then
         call PrintMessage( "operator(.but.)", "E",                     &
                            "mfArray in sequence must be MF_ALL only!" )
         return
      end if

      if( but%crc > 0 ) then
         call PrintMessage( "operator(.but.)", "E",                     &
                            "out-of-range expression involving MF_END!" )
         return
      end if

      seq%end_1_EndIndex = .true.

      seq%but = but%crc
      seq%but_present  = .true.
      seq%but_EndIndex = .true.

#endif
   end function seq_mfarray_but_mfarray
